/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.action.LocalProjectAction;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class IncludeProject
extends LocalProjectAction {
    private static final long serialVersionUID = -6587569406820125552L;

    public IncludeProject() {
        super(ResourceKey.PROJECT_INCLUDE);
    }

    public void actionPerformed(ActionEvent event) {
        JComponent parent = IncludeProject.getProjectManager().getMainPanel();
        Project project = IncludeProject.getProjectManager().getCurrentProject();
        if (project != null) {
            JFileChooser chooser = ComponentFactory.createFileChooser("Included Project", "pprj");
            int rval = chooser.showOpenDialog(parent);
            switch (rval) {
                case -1: {
                    break;
                }
                case 1: {
                    break;
                }
                case 0: {
                    ArrayList<URI> includedProjectURIs = new ArrayList<URI>(project.getDirectIncludedProjectURIs());
                    URI newProject = chooser.getSelectedFile().toURI();
                    String currentProjectFileName = project.getName() + ".pprj";
                    if (newProject.equals(currentProjectFileName)) {
                        String text = LocalizedText.getText(ResourceKey.INCLUDE_PROJECT_FAILED_DIALOG_RECURSIVE_INCLUDE_TEXT);
                        ModalDialog.showMessageDialog(parent, text);
                        break;
                    }
                    if (includedProjectURIs.contains(newProject)) {
                        String text = LocalizedText.getText(ResourceKey.INCLUDE_PROJECT_FILED_DIALOG_ALREADY_INCLUDED_TEXT);
                        ModalDialog.showMessageDialog(parent, text);
                        break;
                    }
                    includedProjectURIs.add(newProject);
                    IncludeProject.getProjectManager().changeIncludedProjectURIsRequest(includedProjectURIs);
                    break;
                }
                default: {
                    Log.getLogger().warning("Bad value: " + rval);
                }
            }
        }
    }
}

