/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.action.ProjectRoot;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeModel;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.Tree;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.tree.TreePath;

class ManageIncludedProjectsPanel
extends SelectableContainer
implements Validatable {
    private static final long serialVersionUID = -3853967523137933454L;
    private SelectableTree tree;
    private StandardAction addProjectAction;
    private StandardAction removeProjectAction;
    private StandardAction activateProjectAction;
    private URI activeProject;
    private Tree uriTree;
    private Tree originalUriTree;
    private Project project;

    ManageIncludedProjectsPanel(Project project) {
        this.setLayout(new BorderLayout());
        this.project = project;
        this.activeProject = project.getActiveRootURI();
        this.uriTree = project.getProjectTree();
        this.originalUriTree = this.uriTree.clone();
        this.tree = ComponentFactory.createSelectableTree(null);
        this.tree.setLargeModel(true);
        this.generateTreeModel();
        this.tree.setCellRenderer(new ProjectRenderer());
        this.setSelectable(this.tree);
        LabeledComponent c = new LabeledComponent("Project Tree", new JScrollPane(this.tree));
        c.addHeaderButton(this.createAddIncludedProjectAction());
        c.addHeaderButton(this.createRemoveIncludedProjectAction());
        c.addHeaderButton(this.createActivateIncludedProjectAction());
        this.add(c);
        this.setPreferredSize(new Dimension(400, 400));
        this.updateButtons();
    }

    private void generateTreeModel() {
        this.tree.setModel(new LazyTreeModel(new ProjectRoot(this.uriTree)));
        this.tree.setSelectionRow(0);
        ComponentUtilities.fullSelectionExpand(this.tree, 100);
    }

    private Action createAddIncludedProjectAction() {
        this.addProjectAction = new AddAction(ResourceKey.PROJECT_ADD){
            private static final long serialVersionUID = 281085250312768171L;

            public void onAdd() {
                String type = Text.getProgramName() + " Project Files";
                JFileChooser chooser = ComponentFactory.createFileChooser("Select Project", type, "pprj");
                int openDialogResult = chooser.showOpenDialog(ManageIncludedProjectsPanel.this);
                switch (openDialogResult) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        URI uri = chooser.getSelectedFile().toURI();
                        ManageIncludedProjectsPanel.this.uriTree.addChild(ManageIncludedProjectsPanel.this.uriTree.getRoot(), uri);
                        ManageIncludedProjectsPanel.this.generateTreeModel();
                        break;
                    }
                    default: {
                        Assert.fail("bad result: " + openDialogResult);
                    }
                }
            }
        };
        return this.addProjectAction;
    }

    private Action createRemoveIncludedProjectAction() {
        this.removeProjectAction = new RemoveAction(ResourceKey.PROJECT_REMOVE, null){
            private static final long serialVersionUID = -3548026495703249060L;

            public void onRemove(Collection values) {
                for (URI uri : ManageIncludedProjectsPanel.this.tree.getSelection()) {
                    ManageIncludedProjectsPanel.this.uriTree.removeChild(ManageIncludedProjectsPanel.this.uriTree.getRoot(), uri);
                }
                ManageIncludedProjectsPanel.this.generateTreeModel();
            }
        };
        return this.removeProjectAction;
    }

    private Action createActivateIncludedProjectAction() {
        this.activateProjectAction = new StandardAction("Activate Selected Project", Icons.getSelectProjectIcon()){
            private static final long serialVersionUID = 7554544212783921618L;

            public void actionPerformed(ActionEvent event) {
                URI uri = (URI)CollectionUtilities.getFirstItem(ManageIncludedProjectsPanel.this.getSelection());
                if (uri != null) {
                    ManageIncludedProjectsPanel.this.activeProject = uri;
                    ManageIncludedProjectsPanel.this.tree.repaint();
                }
            }
        };
        return this.activateProjectAction;
    }

    public void onSelectionChange() {
        super.onSelectionChange();
        this.updateButtons();
    }

    private void updateButtons() {
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            this.addProjectAction.setEnabled(false);
            this.removeProjectAction.setEnabled(false);
            this.activateProjectAction.setEnabled(false);
        } else {
            LazyTreeNode node = (LazyTreeNode)path.getLastPathComponent();
            this.addProjectAction.setEnabled(path.getPathCount() == 2);
            this.removeProjectAction.setEnabled(path.getPathCount() == 3);
            this.activateProjectAction.setEnabled(node.getUserObject() != this.activeProject);
        }
    }

    public void saveContents() {
        Set oldDirectIncludes;
        Set directIncludes = this.uriTree.getChildren(this.uriTree.getRoot());
        if (!CollectionUtilities.equalsSet(directIncludes, oldDirectIncludes = this.originalUriTree.getChildren(this.originalUriTree.getRoot()))) {
            ProjectManager.getProjectManager().changeIncludedProjectURIsRequest(directIncludes);
        } else if (this.activeProject != this.project.getActiveRootURI()) {
            ProjectManager.getProjectManager().setActiveProjectURI(this.activeProject);
        }
    }

    public boolean validateContents() {
        boolean isOK = this.confirmActiveProjectChanged();
        if (isOK) {
            // empty if block
        }
        return isOK;
    }

    private boolean confirmActiveProjectChanged() {
        boolean confirmed = true;
        URI currentActiveProject = this.project.getActiveRootURI();
        if (!this.uriTree.getRoot().equals(this.activeProject) && !currentActiveProject.equals(this.activeProject)) {
            String text = "Changing the active project will cause projects higher and at the same level in the tree to be hidden.";
            int rval = ModalDialog.showMessageDialog((Component)this, text = text + "\n\n Is this what you want to do?", 12);
            confirmed = rval == 2;
        }
        return confirmed;
    }

    private boolean isActive(URI projectName) {
        return this.activeProject != null && this.activeProject.equals(projectName);
    }

    private boolean isLoaded(URI projectURI) {
        return this.originalUriTree.isReachable(projectURI);
    }

    private boolean isHidden(URI projectURI) {
        return !this.isActive(projectURI) && !this.uriTree.getDescendents(this.activeProject).contains(projectURI);
    }

    class ProjectRenderer
    extends DefaultRenderer {
        private static final long serialVersionUID = 6327407152261236880L;

        ProjectRenderer() {
        }

        public void load(Object o) {
            URI projectURI = (URI)o;
            this.setMainText(URIUtilities.getBaseName(projectURI));
            boolean isReadonly = !ManageIncludedProjectsPanel.this.isActive(projectURI);
            boolean isHidden = ManageIncludedProjectsPanel.this.isHidden(projectURI);
            this.setMainIcon(Icons.getProjectIcon(isReadonly, isHidden));
            if (!ManageIncludedProjectsPanel.this.isLoaded(projectURI)) {
                this.appendText("    (not loaded)");
            }
        }
    }
}

