/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.action.ProjectAction;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.framestore.undo.Command;
import edu.stanford.smi.protege.resource.ResourceKey;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RedoAction
extends ProjectAction {
    private static final long serialVersionUID = -3530704885116941344L;

    public RedoAction(boolean large) {
        super(ResourceKey.REDO_ACTION, large);
        CommandManager manager = RedoAction.getCommandManager();
        if (manager == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(manager.canRedo());
            manager.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    RedoAction.this.setEnabled(ProjectAction.getCommandManager().canRedo());
                }
            });
        }
    }

    public void actionPerformed(ActionEvent event) {
        RedoAction.getKnowledgeBase().getCommandManager().redo();
    }

    public Object getValue(String key) {
        Command command;
        CommandManager commandManager;
        Object value = super.getValue(key);
        if (key.equals("Name") && (commandManager = RedoAction.getCommandManager()) != null && (command = commandManager.getRedoCommand()) != null) {
            String s = command.getDescription();
            value = value.toString() + " (" + s + ")";
        }
        return value;
    }
}

