/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.action.ProjectAction;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.undo.Command;
import edu.stanford.smi.protege.resource.ResourceKey;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UndoAction
extends ProjectAction {
    private static final long serialVersionUID = 2910477435427456525L;

    public UndoAction(boolean large) {
        super(ResourceKey.UNDO_ACTION, large);
        CommandManager manager = UndoAction.getCommandManager();
        if (manager == null || this.isUndoEnabled()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.isUndoEnabled() & manager.canUndo());
            manager.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent event) {
                    UndoAction.this.setEnabled(UndoAction.this.isUndoEnabled() & ProjectAction.getCommandManager().canUndo());
                }
            });
        }
    }

    private boolean isUndoEnabled() {
        KnowledgeBase kb = UndoAction.getKnowledgeBase();
        return kb != null && kb instanceof DefaultKnowledgeBase && ((DefaultKnowledgeBase)kb).isUndoEnabled() && kb.getProject().isUndoOptionEnabled();
    }

    public Object getValue(String key) {
        Command command;
        CommandManager commandManager;
        Object value = super.getValue(key);
        if (key.equals("Name") && (commandManager = UndoAction.getCommandManager()) != null && (command = commandManager.getUndoCommand()) != null) {
            String s = command.getDescription();
            if (s != null && s.length() > 75) {
                s = s.substring(0, 75) + "...";
            }
            value = value.toString() + " (" + s == null ? "no description" : s + ")";
        }
        return value;
    }

    public void actionPerformed(ActionEvent event) {
        UndoAction.getCommandManager().undo();
    }
}

