/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.OntologyJavaMappingUtil;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LocalizeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrappedInstance
implements Localizable,
Serializable,
Disposable {
    private static final long serialVersionUID = -5498034704463571567L;
    private Instance wrappedProtegeInstance;

    protected AbstractWrappedInstance(Instance instance) {
        this.wrappedProtegeInstance = instance;
    }

    protected AbstractWrappedInstance() {
    }

    public Instance getWrappedProtegeInstance() {
        return this.wrappedProtegeInstance;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.wrappedProtegeInstance == null ? null : this.wrappedProtegeInstance.getKnowledgeBase();
    }

    public String getName() {
        return this.wrappedProtegeInstance.getName();
    }

    protected boolean hasSlotValues(Slot slot) {
        return this.getKnowledgeBase().getOwnSlotValueCount(this.wrappedProtegeInstance, slot) > 0;
    }

    protected void addSlotValue(Slot slot, Object value) {
        this.wrappedProtegeInstance.addOwnSlotValue(slot, this.getUnwrappedObject(value));
    }

    protected void removeSlotValue(Slot slot, Object value) {
        this.wrappedProtegeInstance.removeOwnSlotValue(slot, this.getUnwrappedObject(value));
    }

    protected void setSlotValue(Slot slot, Object value) {
        this.wrappedProtegeInstance.setOwnSlotValue(slot, this.getUnwrappedObject(value));
    }

    protected void setSlotValues(Slot slot, Collection<?> values) {
        this.wrappedProtegeInstance.setOwnSlotValues(slot, this.getUnwrappedCollection(values));
    }

    public boolean canAs(Class<?> javaInterface) {
        return OntologyJavaMappingUtil.canAs(this, javaInterface);
    }

    public <X> X as(Class<? extends X> javaInterface) {
        return OntologyJavaMappingUtil.as(this, javaInterface);
    }

    public void delete() {
        this.wrappedProtegeInstance.delete();
    }

    private Collection<?> getUnwrappedCollection(Collection<?> values) {
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (Object value : values) {
            newValues.add(this.getUnwrappedObject(value));
        }
        return newValues;
    }

    private Object getUnwrappedObject(Object value) {
        if (value instanceof AbstractWrappedInstance) {
            value = ((AbstractWrappedInstance)value).getWrappedProtegeInstance();
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractWrappedInstance)) {
            return false;
        }
        Instance wrappedProtegeInstance2 = ((AbstractWrappedInstance)obj).getWrappedProtegeInstance();
        if (wrappedProtegeInstance2 == null) {
            return this.getWrappedProtegeInstance() == null;
        }
        return wrappedProtegeInstance2.equals(this.getWrappedProtegeInstance());
    }

    public int hashCode() {
        return this.getWrappedProtegeInstance().getName().length() + 42;
    }

    @Override
    public void localize(KnowledgeBase kb) {
        LocalizeUtils.localize(this.wrappedProtegeInstance, kb);
    }

    @Override
    public void dispose() {
        this.wrappedProtegeInstance = null;
    }

    public String toString() {
        return this.getName();
    }
}

