/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.SlotAtClassCode;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClsCode {
    private Cls cls;

    public ClsCode(Cls cls) {
        this.cls = cls;
    }

    public String getJavaName() {
        return ClsCode.getValidJavaName(this.cls.getName());
    }

    public List<SlotAtClassCode> getSlotCodes(boolean transitive) {
        HashSet<Slot> properties = new HashSet<Slot>();
        ArrayList<SlotAtClassCode> codes = new ArrayList<SlotAtClassCode>();
        HashSet<Slot> relevantSlots = new HashSet<Slot>(this.cls.getTemplateSlots());
        for (Slot slot : relevantSlots) {
            if (slot.isSystem()) continue;
            properties.add(slot);
            SlotAtClassCode code = new SlotAtClassCode(this.cls, slot);
            codes.add(code);
            Collection subSlots = slot.getSubslots();
            for (Slot subSlot : subSlots) {
                if (properties.contains(subSlot)) continue;
                codes.add(new SlotAtClassCode(this.cls, subSlot));
                properties.add(subSlot);
            }
        }
        Collections.sort(codes);
        return codes;
    }

    public static String getValidJavaName(String name) {
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            name = name.replace(c, '_');
        }
        return name;
    }
}

