/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.JavaCodeGeneratorAction;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.plugin.ProjectPluginAdapter;
import edu.stanford.smi.protege.ui.ProjectMenuBar;
import edu.stanford.smi.protege.ui.ProjectToolBar;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class CodeGeneratorProjectPlugin
extends ProjectPluginAdapter {
    public static final String CODE_MENU = "Code";

    public void afterShow(ProjectView view, ProjectToolBar toolBar, ProjectMenuBar menuBar) {
        KnowledgeBase kb = view.getProject().getKnowledgeBase();
        if (kb.getKnowledgeBaseFactory().getClass().getName().contains(".owl.")) {
            return;
        }
        this.insertCodeMenu(kb, menuBar);
    }

    private void insertCodeMenu(KnowledgeBase kb, ProjectMenuBar menuBar) {
        JMenu codeMenu = ComponentUtilities.getMenu(menuBar, CODE_MENU, true, menuBar.getComponentCount() - 2);
        JMenuItem codeGen = ComponentFactory.createMenuItem("Generate Java Code...");
        codeGen.addActionListener(new JavaCodeGeneratorAction(kb));
        codeMenu.add(codeGen);
    }

    public void beforeHide(ProjectView view, ProjectToolBar toolBar, ProjectMenuBar menuBar) {
        JMenu codeMenu = ComponentUtilities.getMenu(menuBar, CODE_MENU);
        if (codeMenu == null) {
            return;
        }
        ComponentUtilities.removeMenuItem(codeMenu, "Generate Java Code...");
    }
}

