/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.ClsCode;
import edu.stanford.smi.protege.code.generator.wrapping.JavaCodeGeneratorOptions;
import edu.stanford.smi.protege.code.generator.wrapping.SlotAtClassCode;
import edu.stanford.smi.protege.code.generator.wrapping.SlotCode;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;

public class JavaCodeGenerator {
    private KnowledgeBase kb;
    private JavaCodeGeneratorOptions options;
    private static final boolean TRANSITIVE = true;
    private static final boolean ALL_PROPERTIES = true;
    private static final boolean ONLY_LOCAL_PROPERTIES = false;

    public JavaCodeGenerator(KnowledgeBase kb, JavaCodeGeneratorOptions options) {
        String pack;
        this.kb = kb;
        this.options = options;
        File folder = options.getOutputFolder();
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
        if ((pack = options.getPackage()) != null) {
            pack = pack.replace('.', '/');
            File file = folder == null ? new File(pack) : new File(folder, pack);
            file.mkdirs();
            File f = new File(file, "impl");
            f.mkdirs();
        } else {
            File file = folder == null ? new File("impl") : new File(folder, "impl");
            file.mkdirs();
        }
    }

    public void createAll() throws IOException {
        for (Cls element : this.options.getClses()) {
            Cls aClass = element;
            if (aClass.isSystem()) continue;
            this.createInterface(aClass);
            this.createImplementation(aClass);
        }
        this.createFactoryClass();
        this.createOntologyJavaMappingClass();
    }

    private void createOntologyJavaMappingClass() throws IOException {
        File file = this.getInterfaceFile("OntologyJavaMapping");
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("import " + this.options.getPackage() + ".impl.*;");
        printWriter.println("import edu.stanford.smi.protege.code.generator.wrapping.OntologyJavaMappingUtil;");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege (http://protege.stanford.edu).");
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public class OntologyJavaMapping {");
        printWriter.println();
        printWriter.println("    public static void initMap() {");
        for (Cls cls : this.options.getClses()) {
            if (cls.isSystem()) continue;
            printWriter.println("        OntologyJavaMappingUtil.add(\"" + cls.getName() + "\", " + this.getInterfaceName(cls) + ".class, " + this.getImplementationName(cls) + ".class);");
        }
        printWriter.println("    }");
        printWriter.println("}");
        fileWriter.close();
    }

    public void createFactoryClass() throws IOException {
        String localName = this.options.getFactoryClassName();
        if (localName != null && localName.length() > 0) {
            File file = this.getInterfaceFile(localName);
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printFactoryClass(printWriter);
            fileWriter.close();
        }
    }

    private void printFactoryClass(PrintWriter printWriter) {
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("import java.util.*;");
        printWriter.println("import " + this.options.getPackage() + ".impl.*;");
        printWriter.println("import " + this.options.getPackage() + ".OntologyJavaMapping;");
        printWriter.println("import edu.stanford.smi.protege.model.*;");
        printWriter.println("import edu.stanford.smi.protege.code.generator.wrapping.OntologyJavaMappingUtil;");
        printWriter.println();
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege (http://protege.stanford.edu).");
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public class " + this.options.getFactoryClassName() + " {");
        printWriter.println("    static { OntologyJavaMapping.initMap(); }");
        printWriter.println();
        printWriter.println("    private KnowledgeBase kb;");
        printWriter.println();
        printWriter.println("    public " + this.options.getFactoryClassName() + "(KnowledgeBase kb) {");
        printWriter.println("        this.kb = kb;");
        printWriter.println("    }");
        for (Cls cls : this.options.getClses()) {
            if (cls.isSystem()) continue;
            String interfaceName = this.getInterfaceName(cls);
            printWriter.println();
            printWriter.println();
            printWriter.println("    // ***** Class " + cls.getName() + " *****");
            printWriter.println();
            printWriter.println("    public Cls get" + interfaceName + "Class() {");
            printWriter.println("        final String name = \"" + cls.getName() + "\";");
            printWriter.println("        return kb.getCls(name);");
            printWriter.println("    }");
            printWriter.println();
            if (!cls.isAbstract()) {
                printWriter.println("    public " + interfaceName + " create" + interfaceName + "(String name) {");
                printWriter.println("        Cls cls = get" + interfaceName + "Class();");
                printWriter.println("        Instance inst = cls.createDirectInstance(name);");
                printWriter.println("        return new " + this.getImplementationName(cls) + "(inst);");
                printWriter.println("    }");
                printWriter.println();
            }
            printWriter.println("    public " + interfaceName + " get" + interfaceName + "(String name) {");
            printWriter.println("        return OntologyJavaMappingUtil.getSpecificObject(kb, kb.getInstance(name), " + interfaceName + ".class);");
            printWriter.println("    }");
            String collectionType = this.options.getSetMode() ? "Set" : "Collection";
            String collectionClass = this.options.getSetMode() ? "HashSet" : "ArrayList";
            printWriter.println();
            printWriter.println("    public " + collectionType + "<" + interfaceName + "> getAll" + interfaceName + "Objects() {");
            printWriter.println("        return getAll" + interfaceName + "Objects(false);");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println("    public " + collectionType + "<" + interfaceName + "> getAll" + interfaceName + "Objects(boolean transitive) {");
            printWriter.println("        " + collectionType + "<" + interfaceName + "> result = new " + collectionClass + "<" + interfaceName + ">();");
            printWriter.println("        final Cls cls = get" + interfaceName + "Class();");
            printWriter.println("        for (Object element : transitive ? cls.getInstances() : cls.getDirectInstances()) {");
            printWriter.println("            Instance inst = (Instance) element;");
            printWriter.println("            result.add(OntologyJavaMappingUtil.getSpecificObject(kb, inst, " + interfaceName + ".class));");
            printWriter.println("        }");
            printWriter.println("        return result;");
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("    // ***** Getter methods for slots *****");
        for (Slot slot : this.kb.getSlots()) {
            if (slot.isSystem()) continue;
            SlotCode slotCode = new SlotCode(slot, false);
            String name = slotCode.getUpperCaseJavaName();
            printWriter.println();
            printWriter.println("    public Slot get" + name + "Slot() {");
            printWriter.println("        final String name = \"" + slot.getName() + "\";");
            printWriter.println("        return kb.getSlot(name);");
            printWriter.println("    }");
        }
        printWriter.println("}");
    }

    private void printAdditionalFactoryMehods(PrintWriter printWriter) throws IOException {
        String strLine;
        InputStream ins = JavaCodeGenerator.class.getResourceAsStream("resources/FactoryAdditionalMethods.template");
        DataInputStream in = new DataInputStream(ins);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((strLine = br.readLine()) != null) {
            printWriter.println(strLine);
        }
        in.close();
    }

    public void createImplementation(Cls cls) throws IOException {
        File file = this.getImplementationFile(cls);
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printImplementationCode(printWriter, cls);
        fileWriter.close();
    }

    public void printImplementationCode(PrintWriter printWriter, Cls aClass) {
        boolean considerAllProperties;
        ClsCode code = new ClsCode(aClass);
        boolean bl = considerAllProperties = this.hasMultipleSuperclasses(aClass);
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ".impl;");
        } else {
            printWriter.println("package impl;");
        }
        printWriter.println();
        printWriter.println("import edu.stanford.smi.protege.code.generator.wrapping.AbstractWrappedInstance;");
        printWriter.println("import edu.stanford.smi.protege.model.*;");
        this.perhapsAddImportJavaUtil(code, printWriter, considerAllProperties);
        String pack = this.options.getPackage();
        if (pack != null) {
            printWriter.println("import " + pack + "." + this.getInterfaceNamePossiblyAbstract(aClass) + ";");
            printWriter.println("import " + pack + ".*;");
            printWriter.println();
        }
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege (http://protege.stanford.edu).");
        printWriter.println(" * Source Class: " + aClass.getName());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        String implementationName = this.getImplementationNamePossiblyAbstract(aClass);
        printWriter.println("public class " + implementationName + this.getImplementationExtendsCode(aClass));
        printWriter.println("         implements " + this.getInterfaceNamePossiblyAbstract(aClass) + " {");
        this.printConstructors(printWriter, implementationName);
        Iterator<SlotAtClassCode> i$ = code.getSlotCodes(considerAllProperties).iterator();
        while (i$.hasNext()) {
            SlotAtClassCode element;
            SlotAtClassCode slotCode = element = i$.next();
            this.printImplementationSlotCode(printWriter, slotCode);
        }
        printWriter.println("}");
    }

    private void printConstructors(PrintWriter printWriter, String implementationName) {
        printWriter.println();
        printWriter.println("    public " + implementationName + "(Instance instance) {");
        printWriter.println("        super(instance);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public " + implementationName + "() {");
        printWriter.println("    }");
    }

    private String getImplementationExtendsCode(Cls aClass) {
        String str = " extends ";
        String base = this.getBaseImplementation(aClass);
        if (base == null) {
            return str + "AbstractWrappedInstance";
        }
        return str + base;
    }

    public void createInterface(Cls aClass) throws IOException {
        File baseFile = this.getInterfaceFile(aClass);
        FileWriter fileWriter = new FileWriter(baseFile);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.printInterfaceCode(printWriter, aClass);
        fileWriter.close();
    }

    private void createUserInterface(Cls aClass) throws IOException {
        String localName = this.getInterfaceName(aClass);
        File file = this.getInterfaceFile(localName);
        if (!file.exists()) {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            this.printUserInterfaceCode(printWriter, aClass);
            fileWriter.close();
        }
    }

    public void printInterfaceCode(PrintWriter printWriter, Cls aClass) {
        ClsCode code = new ClsCode(aClass);
        this.printInterfacePackageStatement(printWriter);
        this.perhapsAddImportJavaUtil(code, printWriter, false);
        printWriter.println("/**");
        printWriter.println(" * Generated by Protege (http://protege.stanford.edu).");
        printWriter.println(" * Source Class: " + aClass.getName());
        printWriter.println(" *");
        printWriter.println(" * @version generated on " + new Date());
        printWriter.println(" */");
        printWriter.println("public interface " + this.getInterfaceNamePossiblyAbstract(aClass) + this.getInterfaceExtendsCode(aClass) + " {");
        Iterator<SlotAtClassCode> it = code.getSlotCodes(false).iterator();
        while (it.hasNext()) {
            SlotAtClassCode slotCode = it.next();
            this.createInterfaceSlotCode(printWriter, slotCode);
            if (!it.hasNext()) continue;
            printWriter.println();
        }
        printWriter.println();
        printWriter.println("    void delete();");
        printWriter.println("}");
    }

    private void printInterfacePackageStatement(PrintWriter printWriter) {
        if (this.options.getPackage() != null) {
            printWriter.println("package " + this.options.getPackage() + ";");
            printWriter.println();
        }
    }

    public void printUserInterfaceCode(PrintWriter printWriter, Cls cls) {
        this.printInterfacePackageStatement(printWriter);
        printWriter.println("public interface " + this.getInterfaceName(cls) + " extends " + this.getInterfaceNamePossiblyAbstract(cls) + " {");
        printWriter.println("}");
    }

    private String getInterfaceExtendsCode(Cls aClass) {
        String str = " extends ";
        String base = this.getBaseInterface(aClass);
        if (base == null) {
            return "";
        }
        return str + base;
    }

    public void printImplementationSlotCode(PrintWriter printWriter, SlotAtClassCode slotCode) {
        Slot slot = slotCode.getSlot();
        String name = slotCode.getUpperCaseJavaName();
        String javaGetTypeName = this.getJavaTypeName(slotCode, false, slotCode.isMultiple());
        String javaSetTypeName = this.getJavaTypeName(slotCode, true, slotCode.isMultiple());
        String simpleJavaTypeName = slotCode.getJavaType();
        boolean multiple = slotCode.isMultiple();
        String getSlotCall = "get" + name + "Slot()";
        printWriter.println();
        printWriter.println("    // Slot " + slot.getName());
        printWriter.println();
        printWriter.println("    public " + javaGetTypeName + " get" + name + "() {");
        if (multiple) {
            printWriter.println("        Collection protegeValues = getWrappedProtegeInstance().getOwnSlotValues(" + getSlotCall + ");");
            printWriter.println("        " + javaGetTypeName + " values = new " + (this.options.getSetMode() ? "HashSet" : "ArrayList") + "<" + slotCode.getJavaType(true) + ">();");
            if (slotCode.isCustomType()) {
                printWriter.println("        Cls cls = getKnowledgeBase().getCls(\"" + slotCode.getRangeClsName() + "\");");
            }
            printWriter.println("        for (Object object : protegeValues) {");
            if (slotCode.isCustomType()) {
                printWriter.println("            if (object instanceof Instance && ((Instance)object).hasType(cls)) {");
                printWriter.println("                values.add(new " + this.getImplementationName(slotCode.getRangeCls()) + "((Instance)object));");
            } else {
                printWriter.println("            if (object instanceof " + javaGetTypeName + ") {");
                printWriter.println("                values.add((" + javaGetTypeName + ") object);");
            }
            printWriter.println("            }");
            printWriter.println("        }");
            printWriter.println("        return values;");
        } else if (slotCode.isCustomType()) {
            printWriter.println("        Object object = getWrappedProtegeInstance().getOwnSlotValue(" + getSlotCall + ");");
            printWriter.println("        Cls cls = getKnowledgeBase().getCls(\"" + slotCode.getRangeClsName() + "\");");
            printWriter.println("        if (object instanceof Instance && ((Instance)object).hasType(cls)) {");
            printWriter.println("            return new " + this.getImplementationName(slotCode.getRangeCls()) + "((Instance)object);");
            printWriter.println("        }");
            printWriter.println("        return null;");
        } else if (slotCode.needsPrimitiveMethod()) {
            String javaType = slotCode.getJavaType(true);
            printWriter.println("        " + javaType + " value = (" + javaType + ") getWrappedProtegeInstance().getOwnSlotValue(" + getSlotCall + ");");
            printWriter.println("        return value == null ? null :");
            printWriter.println("            (" + javaType + ") value." + slotCode.getPrimitiveMethod() + ";");
        } else {
            printWriter.println("        return (" + javaGetTypeName + ") getWrappedProtegeInstance().getOwnSlotValue(" + getSlotCall + ");");
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public Slot get" + name + "Slot() {");
        printWriter.println("        final String name = \"" + slot.getName() + "\";");
        printWriter.println("        return getKnowledgeBase().getSlot(name);");
        printWriter.println("    }");
        printWriter.println();
        printWriter.println();
        printWriter.println("    public boolean has" + name + "() {");
        printWriter.println("        return hasSlotValues(" + getSlotCall + ");");
        printWriter.println("    }");
        String varName = "new" + name;
        if (multiple) {
            printWriter.println();
            printWriter.println();
            printWriter.println("    public void add" + name + "(" + simpleJavaTypeName + " " + varName + ") {");
            printWriter.println("        addSlotValue(" + getSlotCall + ", " + varName + ");");
            printWriter.println("    }");
            printWriter.println();
            printWriter.println();
            String oldVarName = "old" + name;
            printWriter.println("    public void remove" + name + "(" + simpleJavaTypeName + " " + oldVarName + ") {");
            printWriter.println("        removeSlotValue(" + getSlotCall + ", " + oldVarName + ");");
            printWriter.println("    }");
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("    public void set" + name + "(" + javaSetTypeName + " " + varName + ") {");
        if (multiple) {
            printWriter.println("        setSlotValues(" + getSlotCall + ", " + varName + ");");
        } else if (slotCode.isPrimitive()) {
            String t = null;
            t = "int".equals(javaGetTypeName) ? "java.lang.Integer" : ("boolean".equals(javaGetTypeName) ? "java.lang.Boolean" : "java.lang.Float");
            printWriter.println("        setSlotValue(" + getSlotCall + ", new " + t + "(" + varName + "));");
        } else {
            printWriter.println("        setSlotValue(" + getSlotCall + ", " + varName + ");");
        }
        printWriter.println("    }");
    }

    public void createInterfaceSlotCode(PrintWriter printWriter, SlotAtClassCode slotCode) {
        Slot property = slotCode.getSlot();
        String name = slotCode.getUpperCaseJavaName();
        printWriter.println();
        printWriter.println("    // Slot " + property.getName());
        printWriter.println();
        printWriter.println("    " + this.getJavaTypeName(slotCode, false, slotCode.isMultiple()) + " get" + name + "();");
        printWriter.println();
        printWriter.println("    boolean has" + name + "();");
        if (slotCode.isMultiple()) {
            String simpleJavaTypeName = slotCode.getJavaType();
            printWriter.println();
            printWriter.println("    void add" + name + "(" + simpleJavaTypeName + " new" + name + ");");
            printWriter.println();
            printWriter.println("    void remove" + name + "(" + simpleJavaTypeName + " old" + name + ");");
        }
        printWriter.println();
        printWriter.println("    void set" + name + "(" + this.getJavaTypeName(slotCode, true, slotCode.isMultiple()) + " new" + name + ");");
    }

    private String getJavaTypeName(SlotAtClassCode slotCode, boolean useExtends, boolean onlyNonPrimitiveTypes) {
        String simpleJavaTypeName = slotCode.getJavaType(slotCode.isMultiple());
        if (slotCode.isMultiple()) {
            if (!slotCode.isCustomType()) {
                useExtends = false;
            }
            String genericsString = simpleJavaTypeName.equals("Object") ? "<?>" : (useExtends ? "<? extends " + simpleJavaTypeName + ">" : "<" + simpleJavaTypeName + ">");
            return this.options.getSetMode() ? "Set" + genericsString : "Collection" + genericsString;
        }
        return simpleJavaTypeName;
    }

    public String getBaseImplementation(Cls aClass) {
        String resultString = "";
        for (Cls element : aClass.getDirectSuperclasses()) {
            Cls superclass = element;
            String name = this.getSystemJavaClass(superclass);
            if (name != null) {
                return "Default" + name;
            }
            if (!(superclass instanceof Cls) || this.kb.getRootCls().equals(superclass)) continue;
            if (resultString.equals("")) {
                resultString = this.getImplementationName(superclass);
                continue;
            }
            return null;
        }
        if (resultString.equals("")) {
            return null;
        }
        return resultString;
    }

    public String getBaseInterface(Cls cls) {
        String resultString = "";
        for (Cls element : cls.getDirectSuperclasses()) {
            Cls superclass = element;
            String name = this.getSystemJavaClass(superclass);
            if (name != null) {
                return name;
            }
            if (!(superclass instanceof Cls) || this.kb.getRootCls().equals(superclass)) continue;
            resultString = resultString + (resultString.equals("") ? "" : ", ") + this.getInterfaceName(superclass);
        }
        if (resultString.equals("")) {
            return null;
        }
        return resultString;
    }

    public File getImplementationFile(Cls aClass) {
        String localName = this.getImplementationNamePossiblyAbstract(aClass);
        return this.getImplementationFile(localName);
    }

    private File getImplementationFile(String localName) {
        String pack = this.options.getPackage();
        pack = pack != null ? pack.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), pack + "impl/" + localName + ".java");
    }

    public String getImplementationName(Cls aClass) {
        return "Default" + this.getInterfaceName(aClass);
    }

    public String getImplementationNamePossiblyAbstract(Cls aClass) {
        return "Default" + this.getInterfaceNamePossiblyAbstract(aClass);
    }

    public File getInterfaceFile(Cls aClass) {
        String localName = this.getInterfaceNamePossiblyAbstract(aClass);
        return this.getInterfaceFile(localName);
    }

    private File getInterfaceFile(String localName) {
        String pack = this.options.getPackage();
        pack = pack != null ? pack.replace('.', '/') + "/" : "";
        return new File(this.options.getOutputFolder(), pack + localName + ".java");
    }

    public String getInterfaceNamePossiblyAbstract(Cls aClass) {
        String str = new ClsCode(aClass).getJavaName();
        return str;
    }

    public String getInterfaceName(Cls aClass) {
        return new ClsCode(aClass).getJavaName();
    }

    private String getSystemJavaClass(Cls superclass) {
        if (superclass.equals(this.kb.getSystemFrames().getStandardSlotMetaCls())) {
            return "Slot";
        }
        if (superclass.equals(this.kb.getSystemFrames().getStandardClsMetaCls())) {
            return "Cls";
        }
        return null;
    }

    public static String getValidJavaName(String name) {
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            name = name.replace(c, '_');
        }
        return name;
    }

    private void perhapsAddImportJavaUtil(ClsCode code, PrintWriter printWriter, boolean transitive) {
        for (SlotAtClassCode element : code.getSlotCodes(transitive)) {
            SlotAtClassCode propertyAtClassCode = element;
            if (!propertyAtClassCode.isMultiple()) continue;
            printWriter.println("import java.util.*;");
            printWriter.println();
            return;
        }
    }

    public boolean hasMultipleSuperclasses(Cls aClass) {
        boolean superclassFound = false;
        for (Cls element : aClass.getDirectSuperclasses()) {
            Cls superclass = element;
            String name = this.getSystemJavaClass(superclass);
            if (name != null) {
                return false;
            }
            if (!(superclass instanceof Cls) || this.kb.getRootCls().equals(superclass)) continue;
            if (!superclassFound) {
                superclassFound = true;
                continue;
            }
            return true;
        }
        return false;
    }
}

