/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.EditableJavaCodeGeneratorOptions;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.DisplayUtilities;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCodeGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = 5748488164231723521L;
    private static final Color DISABLED_COLOR = new Color(240, 240, 240);
    private KnowledgeBase kb;
    private Collection<Cls> clses = new HashSet<Cls>();
    private JTextField factoryClassNameTextField;
    private JFileChooser fileChooser = new JFileChooser(".");
    private EditableJavaCodeGeneratorOptions options;
    private JTextField packageTextField;
    private JTextField rootFolderTextField;
    private JCheckBox setCheckBox;
    private LabeledComponent lcClasses;
    private SelectableList clsesList;
    private JRadioButton generateAllClses;
    private JRadioButton generateSelectedClses;
    private JCheckBox generateDependentClasses;

    public JavaCodeGeneratorPanel(KnowledgeBase kb, EditableJavaCodeGeneratorOptions options) {
        this.kb = kb;
        this.options = options;
        this.packageTextField = new JTextField();
        if (options.getPackage() != null) {
            this.packageTextField.setText(options.getPackage());
        }
        this.rootFolderTextField = new JTextField();
        if (options.getOutputFolder() != null) {
            this.rootFolderTextField.setText(options.getOutputFolder().getAbsolutePath());
        }
        this.fileChooser.setDialogTitle("Select output folder");
        this.fileChooser.setFileSelectionMode(1);
        this.factoryClassNameTextField = new JTextField();
        if (options.getFactoryClassName() != null) {
            this.factoryClassNameTextField.setText(options.getFactoryClassName());
        }
        this.setCheckBox = new JCheckBox("Return Set instead of Collection");
        this.setCheckBox.setSelected(options.getSetMode());
        this.setLayout(new BoxLayout(this, 1));
        LabeledComponent lc = new LabeledComponent("Root output folder", this.rootFolderTextField);
        lc.addHeaderButton(new AbstractAction("Select folder...", Icons.getAddIcon()){
            private static final long serialVersionUID = -7074953592586843696L;

            public void actionPerformed(ActionEvent e) {
                JavaCodeGeneratorPanel.this.selectFolder();
            }
        });
        this.add(lc);
        this.add(Box.createVerticalStrut(8));
        this.add(new LabeledComponent("Java package", this.packageTextField));
        this.add(Box.createVerticalStrut(8));
        this.add(new LabeledComponent("Factory class name", this.factoryClassNameTextField));
        this.add(Box.createVerticalStrut(8));
        this.add(Box.createVerticalStrut(8));
        this.add(this.createCheckBoxPanel(this.setCheckBox));
        this.add(Box.createVerticalStrut(8));
        this.lcClasses = this.createClsesPanel();
        this.add(this.lcClasses);
        this.generateAllClses.setSelected(true);
        this.clsesList.setBackground(DISABLED_COLOR);
        this.generateAllClses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JavaCodeGeneratorPanel.this.updateClassRadioButtons();
            }
        });
        this.generateSelectedClses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JavaCodeGeneratorPanel.this.updateClassRadioButtons();
            }
        });
        this.add(Box.createVerticalStrut(8));
    }

    private void updateClassRadioButtons() {
        this.clsesList.setBackground(this.generateAllClses.isSelected() ? DISABLED_COLOR : Color.WHITE);
        this.generateDependentClasses.setEnabled(!this.generateAllClses.isSelected());
        this.generateDependentClasses.setSelected(!this.generateAllClses.isSelected());
    }

    private LabeledComponent createClsesPanel() {
        this.clsesList = ComponentFactory.createSelectableList(null);
        this.clsesList.setCellRenderer(FrameRenderer.createInstance());
        ComponentUtilities.addListValues(this.clsesList, this.clses);
        LabeledComponent labeledComp = new LabeledComponent("", new JScrollPane(this.clsesList), true);
        labeledComp.addHeaderButton(new AllowableAction("Add classes", Icons.getAddClsIcon(), null){
            private static final long serialVersionUID = 1863680327673994283L;

            @Override
            public void actionPerformed(ActionEvent e) {
                HashSet<Cls> allClses = new HashSet<Cls>();
                for (Cls s : JavaCodeGeneratorPanel.this.kb.getClses()) {
                    if (s.isSystem()) continue;
                    allClses.add(s);
                }
                allClses.add(JavaCodeGeneratorPanel.this.kb.getRootCls());
                Collection newClses = DisplayUtilities.pickClses((Component)JavaCodeGeneratorPanel.this, JavaCodeGeneratorPanel.this.kb, "Select classes (multiple selection)");
                this.addClsesIfNotExists(newClses);
                ComponentUtilities.clearListValues(JavaCodeGeneratorPanel.this.clsesList);
                ComponentUtilities.addListValues(JavaCodeGeneratorPanel.this.clsesList, JavaCodeGeneratorPanel.this.clses);
                if (newClses.size() > 0) {
                    JavaCodeGeneratorPanel.this.generateSelectedClses.setSelected(true);
                    JavaCodeGeneratorPanel.this.clsesList.setBackground(Color.WHITE);
                }
            }

            private void addClsesIfNotExists(Collection<Cls> newClses) {
                for (Cls c : newClses) {
                    if (JavaCodeGeneratorPanel.this.clses.contains(c)) continue;
                    JavaCodeGeneratorPanel.this.clses.add(c);
                }
            }
        });
        labeledComp.addHeaderButton(new AllowableAction("Remove class", Icons.getRemoveClsIcon(), (Selectable)this.clsesList){
            private static final long serialVersionUID = -4988386528512321334L;

            public void actionPerformed(ActionEvent arg0) {
                Collection selection = this.getSelection();
                if (selection != null) {
                    JavaCodeGeneratorPanel.this.clses.removeAll(selection);
                }
                ComponentUtilities.clearListValues(JavaCodeGeneratorPanel.this.clsesList);
                ComponentUtilities.addListValues(JavaCodeGeneratorPanel.this.clsesList, JavaCodeGeneratorPanel.this.clses);
                if (JavaCodeGeneratorPanel.this.clses.size() == 0) {
                    JavaCodeGeneratorPanel.this.generateAllClses.setSelected(true);
                    JavaCodeGeneratorPanel.this.clsesList.setBackground(Color.LIGHT_GRAY);
                }
            }
        });
        JPanel p = new JPanel(new GridLayout(1, 2));
        this.generateAllClses = new JRadioButton("all classes");
        this.generateSelectedClses = new JRadioButton("selected classes");
        ButtonGroup group = new ButtonGroup();
        group.add(this.generateAllClses);
        group.add(this.generateSelectedClses);
        p.add(this.generateAllClses);
        p.add(this.generateSelectedClses);
        JPanel headerComp = new JPanel(new GridLayout(2, 1));
        JLabel _label = ComponentFactory.createLabel();
        ComponentUtilities.setSmallLabelFont(_label);
        _label.setText("Generate classes for:");
        headerComp.add(_label);
        headerComp.add(p);
        this.generateDependentClasses = new JCheckBox("Generate dependent classes");
        this.generateDependentClasses.setEnabled(false);
        labeledComp.setHeaderComponent(headerComp);
        labeledComp.setFooterComponent(this.generateDependentClasses);
        return labeledComp;
    }

    private JPanel createCheckBoxPanel(Component comp) {
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add("West", comp);
        southPanel.add("Center", new JPanel());
        southPanel.setPreferredSize(new Dimension(300, 24));
        return southPanel;
    }

    public void ok() {
        File newFile = null;
        String rootFolder = this.rootFolderTextField.getText().trim();
        if (rootFolder.length() > 0) {
            newFile = new File(rootFolder);
        }
        this.options.setOutputFolder(newFile);
        this.options.setSetMode(this.setCheckBox.isSelected());
        this.options.setFactoryClassName(this.factoryClassNameTextField.getText());
        String pack = this.packageTextField.getText().trim();
        this.options.setPackage(pack.length() > 0 ? pack : null);
        this.options.setClses(this.getClses());
    }

    private void selectFolder() {
        if (this.fileChooser.showDialog(this, "Select") == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.rootFolderTextField.setText(file.toString());
        }
    }

    public Collection<Cls> getClses() {
        HashSet<Cls> c = new HashSet<Cls>();
        c.addAll(this.clses);
        if (this.clses.size() == 0) {
            for (Cls cls : this.kb.getClses()) {
                if (cls.isSystem()) continue;
                c.add(cls);
            }
        }
        if (this.generateDependentClasses.isSelected()) {
            HashSet<Cls> results = new HashSet<Cls>();
            this.getDependentClasses(this.clses, results);
            c.addAll(results);
        }
        ArrayList<Cls> clsesList = new ArrayList<Cls>(c);
        Collections.sort(clsesList, new FrameComparator());
        return clsesList;
    }

    private void getDependentClasses(Collection<Cls> clses, Collection<Cls> dependingClses) {
        for (Cls cls : clses) {
            Collection<Slot> templateSlots = cls.getTemplateSlots();
            for (Slot slot : templateSlots) {
                ValueType type = slot.getValueType();
                HashSet<Cls> dependents = new HashSet<Cls>();
                if (type == ValueType.INSTANCE) {
                    dependents.addAll(cls.getTemplateSlotAllowedClses(slot));
                } else if (type == ValueType.CLS) {
                    dependents.addAll(cls.getTemplateSlotAllowedParents(slot));
                }
                dependents.removeAll(dependingClses);
                dependingClses.addAll(dependents);
                this.getDependentClasses(dependents, dependingClses);
            }
        }
    }
}

