/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.AbstractWrappedInstance;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyJavaMappingUtil {
    private static final Class<?>[] CONSTRUCTOR_PARAMETERS = new Class[]{Instance.class};
    private static Map<String, Entry> ontologyClassNameMap = new HashMap<String, Entry>();
    private static Map<Class<?>, Entry> interfaceMap = new HashMap();
    private static Map<Class<?>, Entry> implementationMap = new HashMap();

    public static void add(String protegeClassName, Class<?> javaInterface, Class<?> javaImplementation) {
        Entry entry = new Entry(protegeClassName, javaInterface, javaImplementation);
        ontologyClassNameMap.put(protegeClassName, entry);
        interfaceMap.put(javaInterface, entry);
        implementationMap.put(javaImplementation, entry);
    }

    public static <X> X createObjectAs(KnowledgeBase kb, String name, Class<? extends X> javaInterface) {
        if (name != null && kb.getInstance(name) != null) {
            return null;
        }
        Entry entry = interfaceMap.get(javaInterface);
        if (entry == null) {
            return null;
        }
        String clsName = entry.getOntologyClassName();
        Cls cls = kb.getCls(clsName);
        Instance inst = cls.createDirectInstance(name);
        return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(entry.getJavaImplementation(), javaInterface), inst);
    }

    public static <X> X createObject(KnowledgeBase kb, String name, String protegeClsName, Class<? extends X> javaReturnInterface) {
        if (name != null && kb.getFrame(name) != null) {
            return null;
        }
        Cls cls = kb.getCls(protegeClsName);
        if (cls == null) {
            return null;
        }
        String returnClsName = javaReturnInterface.getSimpleName();
        Cls returnCls = kb.getCls(returnClsName);
        if (returnClsName == null) {
            return null;
        }
        if (!cls.equals(returnClsName) && !cls.hasSuperclass(returnCls)) {
            return null;
        }
        Entry entry = ontologyClassNameMap.get(protegeClsName);
        if (entry != null) {
            return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(entry.getJavaImplementation(), javaReturnInterface), cls.createDirectInstance(name));
        }
        for (Cls supercls : cls.getSuperclasses()) {
            Entry e = ontologyClassNameMap.get(supercls.getName());
            if (e == null) continue;
            Instance wrappedInst = cls.createDirectInstance(name);
            return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(e.getJavaImplementation(), javaReturnInterface), wrappedInst);
        }
        return null;
    }

    private static <X> X createJavaObject(Class<? extends X> javaImplementationClass, Instance instance) {
        if (javaImplementationClass == null || instance == null) {
            return null;
        }
        X obj = null;
        try {
            Constructor<X> constructor = javaImplementationClass.getConstructor(CONSTRUCTOR_PARAMETERS);
            obj = constructor.newInstance(instance);
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "Creating Java Object failed. (Java Impl Class: " + javaImplementationClass + ", Wrapped Protege instance: " + instance + ")", e);
        }
        return obj;
    }

    public static <X> X getJavaObjectAs(KnowledgeBase kb, String name, Class<? extends X> javaInterface) {
        Instance instance = kb.getInstance(name);
        if (instance == null) {
            return null;
        }
        Entry e = interfaceMap.get(javaInterface);
        if (e == null) {
            return null;
        }
        return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(e.getJavaImplementation(), javaInterface), instance);
    }

    public static <X> X getSpecificObject(KnowledgeBase kb, Instance wrappedInst, Class<? extends X> javaReturnInterface) {
        if (wrappedInst == null) {
            return null;
        }
        Class<?> implClass = OntologyJavaMappingUtil.getJavaImplementation(wrappedInst.getDirectType());
        if (implClass == null) {
            return null;
        }
        return OntologyJavaMappingUtil.createJavaObject(OntologyJavaMappingUtil.getJavaImplementation(implClass, javaReturnInterface), wrappedInst);
    }

    public static boolean canAs(Object impl, Class<?> javaInterface) {
        if (javaInterface.isAssignableFrom(impl.getClass())) {
            return true;
        }
        if (!(impl instanceof AbstractWrappedInstance)) {
            return false;
        }
        Instance inst = ((AbstractWrappedInstance)impl).getWrappedProtegeInstance();
        Class<?> implClass = OntologyJavaMappingUtil.getJavaImplementation(inst.getDirectType());
        if (implClass == null) {
            return false;
        }
        return javaInterface.isAssignableFrom(implClass);
    }

    public static <X> X as(Object impl, Class<? extends X> javaInterface) {
        if (javaInterface.isAssignableFrom(impl.getClass())) {
            return javaInterface.cast(impl);
        }
        if (!(impl instanceof AbstractWrappedInstance)) {
            return null;
        }
        Instance inst = ((AbstractWrappedInstance)impl).getWrappedProtegeInstance();
        return OntologyJavaMappingUtil.getSpecificObject(inst.getKnowledgeBase(), inst, javaInterface);
    }

    private static Class<?> getJavaImplementation(Cls cls) {
        if (cls == null) {
            return null;
        }
        Entry entry = ontologyClassNameMap.get(cls.getName());
        if (entry != null) {
            return entry.getJavaImplementation();
        }
        for (Cls supercls : cls.getSuperclasses()) {
            Entry e = ontologyClassNameMap.get(supercls.getName());
            if (e == null) continue;
            return e.getJavaImplementation();
        }
        return null;
    }

    private static <X> Class<X> getJavaImplementation(Class<?> implClass, Class<? extends X> javaInterface) {
        return javaInterface.isAssignableFrom(implClass) ? implClass : null;
    }

    public static void dispose() {
        implementationMap.clear();
        interfaceMap.clear();
        ontologyClassNameMap.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry {
        private String ontologyClassName;
        private Class<?> javaInterface;
        private Class<?> javaImplementation;

        public Entry(String protegeClass, Class<?> javaInterface, Class<?> javaImplementation) {
            this.ontologyClassName = protegeClass;
            this.javaInterface = javaInterface;
            this.javaImplementation = javaImplementation;
        }

        public String getOntologyClassName() {
            return this.ontologyClassName;
        }

        public Class<?> getJavaInterface() {
            return this.javaInterface;
        }

        public Class<?> getJavaImplementation() {
            return this.javaImplementation;
        }
    }
}

