/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.EditableJavaCodeGeneratorOptions;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.ApplicationProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBasedJavaCodeGeneratorOptions
implements EditableJavaCodeGeneratorOptions {
    public static final String ABSTRACT_MODE = "JavaCodeAbstract";
    public static final String FACTORY_CLASS_NAME = "JavaCodeFactoryClassName";
    public static final String FILE_NAME = "JavaCodeFileName";
    public static final String PACKAGE = "JavaCodePackage";
    public static final String SET_MODE = "JavaCodeSet";
    public static final String PREFIX_MODE = "JavaCodeUsePrefix";
    private Collection<Cls> clses = new ArrayList<Cls>();

    public boolean getAbstractMode() {
        return ApplicationProperties.getBooleanProperty(ABSTRACT_MODE, false);
    }

    @Override
    public String getFactoryClassName() {
        return ApplicationProperties.getString(FACTORY_CLASS_NAME, "MyFactory");
    }

    @Override
    public File getOutputFolder() {
        String fileName = ApplicationProperties.getString(FILE_NAME, "");
        return new File(fileName);
    }

    @Override
    public String getPackage() {
        return ApplicationProperties.getString(PACKAGE);
    }

    @Override
    public boolean getSetMode() {
        return ApplicationProperties.getBooleanProperty(SET_MODE, false);
    }

    @Override
    public void setAbstractMode(boolean value) {
        ApplicationProperties.setBoolean(ABSTRACT_MODE, value);
    }

    @Override
    public void setOutputFolder(File file) {
        ApplicationProperties.setString(FILE_NAME, file == null ? null : file.getAbsolutePath());
    }

    @Override
    public void setFactoryClassName(String value) {
        ApplicationProperties.setString(FACTORY_CLASS_NAME, value);
    }

    @Override
    public void setPackage(String value) {
        ApplicationProperties.setString(PACKAGE, value);
    }

    @Override
    public void setSetMode(boolean value) {
        ApplicationProperties.setBoolean(SET_MODE, value);
    }

    @Override
    public void setClses(Collection<Cls> clses) {
        this.clses = clses;
    }

    @Override
    public Collection<Cls> getClses() {
        return this.clses;
    }
}

