/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.code.generator.wrapping;

import edu.stanford.smi.protege.code.generator.wrapping.ClsCode;
import edu.stanford.smi.protege.model.Slot;

public class SlotCode
implements Comparable {
    private Slot property;
    private boolean usePrefix;

    public SlotCode(Slot property, boolean usePrefixInNames) {
        this.property = property;
        this.usePrefix = usePrefixInNames;
    }

    public int compareTo(Object o) {
        if (o instanceof SlotCode) {
            SlotCode other = (SlotCode)o;
            return this.getJavaName().compareTo(other.getJavaName());
        }
        return 0;
    }

    public String getJavaName() {
        return ClsCode.getValidJavaName(this.property.getName());
    }

    public Slot getRDFProperty() {
        return this.property;
    }

    public String getUpperCaseJavaName() {
        String name = this.getJavaName();
        if (name.length() > 1) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name.toUpperCase();
    }
}

