/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserSlotPattern {
    private List elements;

    public BrowserSlotPattern(Slot slot) {
        this.elements = new ArrayList();
        this.elements.add(slot);
    }

    public BrowserSlotPattern(List elements) {
        this.elements = new ArrayList(elements);
    }

    public boolean isSimple() {
        return this.elements.size() == 1 && this.getFirstSlot() != null;
    }

    public Slot getFirstSlot() {
        Slot slot = null;
        for (Object o : this.elements) {
            if (!(o instanceof Slot)) continue;
            slot = (Slot)o;
            break;
        }
        return slot;
    }

    public String getSerialization() {
        Object previous = null;
        StringBuffer buffer = new StringBuffer();
        for (Object o : this.elements) {
            if (o instanceof String) {
                buffer.append("{" + BrowserSlotPattern.toSafeText((String)o) + "}");
            }
            if (o instanceof Slot) {
                if (previous instanceof Slot) {
                    buffer.append("{}");
                }
                Slot slot = (Slot)o;
                buffer.append(BrowserSlotPattern.toSafeText(slot.getName()));
            }
            previous = o;
        }
        return buffer.toString();
    }

    private static String toSafeText(String s) {
        return FileUtilities.urlEncode(s);
    }

    private static String fromSafeText(String s) {
        return FileUtilities.urlDecode(s);
    }

    public static BrowserSlotPattern createFromSerialization(KnowledgeBase kb, String s) {
        boolean inText = false;
        ArrayList<Object> elements = new ArrayList<Object>();
        if (s != null) {
            StringTokenizer tokenizer = new StringTokenizer(s, "{}", true);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("{")) {
                    inText = true;
                    continue;
                }
                if (token.equals("}")) {
                    inText = false;
                    continue;
                }
                if (inText) {
                    String text = BrowserSlotPattern.fromSafeText(token);
                    elements.add(text);
                    continue;
                }
                String name = BrowserSlotPattern.fromSafeText(token);
                Slot slot = kb.getSlot(name);
                if (slot == null) continue;
                elements.add(slot);
            }
        }
        return elements.isEmpty() ? null : new BrowserSlotPattern(elements);
    }

    public boolean contains(Slot slot) {
        return this.elements.contains(slot);
    }

    public List getElements() {
        return new ArrayList(this.elements);
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof BrowserSlotPattern) {
            BrowserSlotPattern rhs = (BrowserSlotPattern)o;
            equals = CollectionUtilities.equalsList(this.elements, rhs.elements);
        }
        return equals;
    }

    public int hashCode() {
        return this.elements.get(0).hashCode();
    }

    public List<Slot> getSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (Object o : this.elements) {
            if (!(o instanceof Slot)) continue;
            slots.add((Slot)o);
        }
        return slots;
    }

    public void replaceSlot(Slot oldSlot, Slot newSlot) {
        if (this.elements.contains(oldSlot)) {
            ArrayList<Slot> newElements = new ArrayList<Slot>();
            for (Object o : this.elements) {
                if (oldSlot.equals(o)) {
                    newElements.add(newSlot);
                    continue;
                }
                newElements.add((Slot)o);
            }
            this.elements = newElements;
        }
    }

    public String getBrowserText(Instance instance) {
        StringBuffer buffer = new StringBuffer();
        for (Object o : this.elements) {
            if (o instanceof Slot) {
                buffer.append(BrowserSlotPattern.getText((Slot)o, instance));
                continue;
            }
            buffer.append(o);
        }
        return buffer.length() == 0 ? null : buffer.toString();
    }

    private static String getText(Slot slot, Instance instance) {
        String text;
        List values = instance.getDirectOwnSlotValues(slot);
        if (values.size() > 1) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            boolean isFirst = true;
            Iterator i = values.iterator();
            while (i.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buffer.append(", ");
                }
                Object o = i.next();
                buffer.append(BrowserSlotPattern.getText(o, instance));
            }
            buffer.append("}");
            text = buffer.toString();
        } else {
            Object o = CollectionUtilities.getFirstItem(values);
            text = BrowserSlotPattern.getText(o, instance);
        }
        return text;
    }

    private static String getText(Object o, Instance instance) {
        String text = o == null ? "" : (o instanceof Frame ? (o.equals(instance) ? "<recursive call>" : ((Frame)o).getBrowserText()) : o.toString());
        return text;
    }

    public String toString() {
        return "BrowserSlotPattern(" + this.getSerialization() + ")";
    }
}

