/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.FacetListener;
import edu.stanford.smi.protege.model.DefaultInstance;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FacetConstraint;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.Icon;

public class DefaultFacet
extends DefaultInstance
implements Facet {
    private static final long serialVersionUID = 1557703868805025229L;
    private FacetConstraint _constraint;

    public DefaultFacet(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultFacet() {
    }

    public void addFacetListener(FacetListener listener) {
        this.getDefaultKnowledgeBase().addFacetListener(this, listener);
    }

    public boolean areValidValues(Frame frame, Slot slot, Collection slotValues) {
        boolean result = true;
        if (this._constraint != null) {
            Collection facetValues = frame.getOwnSlotFacetValues(slot, this);
            result = this._constraint.areValidValues(frame, slot, slotValues, facetValues);
        }
        return result;
    }

    public Slot getAssociatedSlot() {
        return this.getDefaultKnowledgeBase().getAssociatedSlot(this);
    }

    public FacetConstraint getConstraint() {
        return this._constraint;
    }

    public String getInvalidValuesText(Frame frame, Slot slot, Collection slotValues) {
        String result = null;
        if (this._constraint != null) {
            Collection facetValues = frame.getOwnSlotFacetValues(slot, this);
            result = this._constraint.getInvalidValuesText(frame, slot, slotValues, facetValues);
        }
        return result;
    }

    public String getInvalidValueText(Frame frame, Slot slot, Object item) {
        String result = null;
        if (this._constraint != null) {
            Collection facetValues = frame.getOwnSlotFacetValues(slot, this);
            result = this._constraint.getInvalidValueText(frame, slot, item, facetValues);
        }
        return result;
    }

    public ValueType getValueType() {
        Slot associatedSlot = this.getAssociatedSlot();
        if (associatedSlot == null) {
            Log.getLogger().warning("Cannot find associated slot of " + this + ". Assuming value type is " + ValueType.ANY);
            return ValueType.ANY;
        }
        return associatedSlot.getValueType();
    }

    public boolean getAllowsMultipleValues() {
        Slot associatedSlot = this.getAssociatedSlot();
        if (associatedSlot == null) {
            Log.getLogger().warning("Cannot find associated slot of " + this + ". Assuming cardinality is multiple");
            return true;
        }
        return this.getAssociatedSlot().getAllowsMultipleValues();
    }

    public boolean isValidValue(Frame frame, Slot slot, Object value) {
        boolean result = true;
        if (this._constraint != null) {
            Collection facetValues = frame.getOwnSlotFacetValues(slot, this);
            result = this._constraint.isValidValue(frame, slot, value, facetValues);
        }
        return result;
    }

    public void removeFacetListener(FacetListener listener) {
        this.getDefaultKnowledgeBase().removeFacetListener(this, listener);
    }

    public void setAssociatedSlot(Slot slot) {
        this.getDefaultKnowledgeBase().setAssociatedSlot(this, slot);
    }

    public void setConstraint(FacetConstraint c) {
        this._constraint = c;
    }

    public Collection resolveValues(Collection existingValues, Collection newValues) {
        LinkedHashSet values;
        if (CollectionUtilities.equalsList(existingValues, newValues)) {
            values = existingValues;
        } else if (this._constraint == null) {
            if (this.getAllowsMultipleValues()) {
                values = new LinkedHashSet();
                values.addAll(existingValues);
                values.addAll(newValues);
            } else {
                values = existingValues;
            }
        } else {
            values = this._constraint.resolve(existingValues, newValues);
        }
        return values;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Facet(");
        buffer.append(this.getName());
        buffer.append(")");
        return buffer.toString();
    }

    public Icon getIcon() {
        return Icons.getFacetIcon(!this.isEditable(), !this.isVisible());
    }

    public Facet rename(String name) {
        return (Facet)super.rename(name);
    }
}

