/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultFrame
implements Frame,
Localizable,
Serializable {
    private static final long serialVersionUID = -894053746814542694L;
    private static final char SPECIAL_NAME_CHAR = ':';
    private transient KnowledgeBase knowledgeBase;
    private FrameID id;
    private static final int READONLY_MASK = 1;
    private static final int INCLUDED_MASK = 2;
    private static final int DELETING_MASK = 4;
    private static final int DELETED_MASK = 8;
    private int state;

    protected DefaultFrame() {
    }

    DefaultFrame(KnowledgeBase kb, FrameID id) {
        if (id == null) {
            Log.getLogger().severe("null frame id");
        }
        this.knowledgeBase = kb;
        this.id = id;
    }

    public URI getDefiningProjectURI() {
        return null;
    }

    @Override
    public FrameID getFrameID() {
        return this.id;
    }

    @Override
    public boolean isDeleted() {
        return this.getState(8);
    }

    @Override
    public void markDeleted(boolean deleted) {
        this.setState(8, deleted);
    }

    private void setState(int mask, boolean value) {
        this.state = value ? (this.state |= mask) : (this.state &= ~mask);
    }

    private boolean getState(int mask) {
        return (this.state & mask) != 0;
    }

    @Override
    public boolean isBeingDeleted() {
        return this.getState(4);
    }

    @Override
    public void markDeleting() {
        this.setState(4, true);
    }

    @Override
    public boolean isValid() {
        return !this.isDeleted();
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof DefaultFrame) {
            DefaultFrame rhs = (DefaultFrame)o;
            equals = DefaultFrame.equals(this.id, rhs.id) && this.knowledgeBase == rhs.knowledgeBase;
        }
        return equals;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void addFrameListener(FrameListener listener) {
        this.getDefaultKnowledgeBase().addFrameListener(this, listener);
    }

    @Override
    public boolean addOwnFacetValue(Slot slot, Facet facet, Object value) {
        Assert.fail("not implemented");
        return false;
    }

    @Override
    public void addOwnSlotValue(Slot slot, Object value) {
        this.getDefaultKnowledgeBase().addOwnSlotValue(this, slot, value);
    }

    @Override
    public boolean areValidOwnSlotValues(Slot slot, Collection c) {
        return this.getDefaultKnowledgeBase().areValidOwnSlotValues(this, slot, c);
    }

    private static int compareStrings(String s1, String s2) {
        int result;
        if (s1 != null && s1.length() != 0 && s1.charAt(0) == '\'') {
            s1 = s1.substring(1);
        }
        if (s2 != null && s2.length() != 0 && s2.charAt(0) == '\'') {
            s2 = s2.substring(1);
        }
        if ((result = s1.compareToIgnoreCase(s2)) == 0) {
            result = s1.compareTo(s2);
        }
        return result;
    }

    @Override
    public int compareTo(Frame f2) {
        String t1 = this.getBrowserText();
        String t2 = f2.getBrowserText();
        int result = DefaultFrame.isSpecialName(t1) ? (DefaultFrame.isSpecialName(t2) ? DefaultFrame.compareStrings(t1, t2) : 1) : (DefaultFrame.isSpecialName(t2) ? -1 : DefaultFrame.compareStrings(t1, t2));
        if (result == 0) {
            result = DefaultFrame.compareStrings(this.getName(), f2.getName());
        }
        return result;
    }

    private static boolean isSpecialName(String s) {
        return s.length() > 0 && s.charAt(0) == ':';
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    private static void deepCopyFrameBindingValues(Collection values, Frame copyFrame, Slot copySlot, Map valueMap) {
        KnowledgeBase copyKB = copyFrame.getKnowledgeBase();
        ArrayList<Frame> copyValues = new ArrayList<Frame>();
        for (Frame origFrame : values) {
            Frame copyValue = (Frame)valueMap.get(origFrame);
            if (copyValue == null) {
                copyValue = origFrame.deepCopy(copyKB, valueMap);
            }
            copyValues.add(copyValue);
        }
        copyFrame.setOwnSlotValues(copySlot, copyValues);
    }

    private void copyOwnSlot(DefaultFrame copyFrame, Slot origSlot, Map valueMap, boolean isDeep) {
        Slot copySlot = (Slot)valueMap.get(origSlot);
        Assert.assertNotNull("copy slot", copySlot);
        this.copyOwnSlotValues(copyFrame, copySlot, origSlot, valueMap, isDeep);
    }

    private void copyOwnSlots(DefaultFrame copyFrame, Map valueMap, boolean isDeep) {
        for (Slot origSlot : this.getDefaultKnowledgeBase().getOwnSlots(this)) {
            if (origSlot.isSystem()) continue;
            this.copyOwnSlot(copyFrame, origSlot, valueMap, isDeep);
        }
    }

    private void copyOwnSlotValues(Frame copyFrame, Slot copySlot, Slot origSlot, Map valueMap, boolean isDeep) {
        ValueType type = this.getOwnSlotValueType(origSlot);
        List origValues = this.getDirectOwnSlotValues(origSlot);
        if (isDeep && (type == ValueType.INSTANCE || type == ValueType.CLS)) {
            DefaultFrame.deepCopyFrameBindingValues(origValues, copyFrame, copySlot, valueMap);
        } else {
            copyFrame.setOwnSlotValues(copySlot, origValues);
        }
    }

    @Override
    public Frame copy(KnowledgeBase kb, Map valueMap, boolean isDeep) {
        Assert.assertNotNull("knowledge base", kb);
        Assert.assertNotNull("value map", valueMap);
        DefaultFrame copy = (DefaultFrame)valueMap.get(this);
        Assert.assertNotNull(null, copy);
        this.copyOwnSlots(copy, valueMap, isDeep);
        return copy;
    }

    @Override
    public void delete() {
        this.getDefaultKnowledgeBase().deleteFrame(this);
    }

    protected KnowledgeBase getDefaultKnowledgeBase() {
        return this.knowledgeBase;
    }

    @Override
    public Collection getDocumentation() {
        return this.getDefaultKnowledgeBase().getDocumentation(this);
    }

    @Override
    public String getInvalidOwnSlotValuesText(Slot slot, Collection c) {
        return this.getDefaultKnowledgeBase().getInvalidOwnSlotValuesText(this, slot, c);
    }

    @Override
    public String getInvalidOwnSlotValueText(Slot slot, Object o) {
        return this.getDefaultKnowledgeBase().getInvalidOwnSlotValueText(this, slot, o);
    }

    @Override
    public final KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    @Override
    public void localize(KnowledgeBase kb) {
        this.knowledgeBase = kb;
        this.id.localize(kb);
    }

    @Override
    public String getName() {
        return this.getFrameID().getName();
    }

    @Override
    public boolean getOwnSlotAllowsMultipleValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotAllowsMultipleValues(this, slot);
    }

    @Override
    public Collection getOwnSlotAndSubslotValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotAndSubslotValues(this, slot);
    }

    @Override
    public Collection getOwnSlotDefaultValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotDefaultValues(this, slot);
    }

    @Override
    public Collection getOwnSlotFacets(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotFacets(this, slot);
    }

    @Override
    public Collection getOwnSlotFacetValues(Slot slot, Facet facet) {
        return this.getDefaultKnowledgeBase().getOwnSlotFacetValues(this, slot, facet);
    }

    @Override
    public Collection<Slot> getOwnSlots() {
        return this.getDefaultKnowledgeBase().getOwnSlots(this);
    }

    @Override
    public Object getDirectOwnSlotValue(Slot slot) {
        return this.getDefaultKnowledgeBase().getDirectOwnSlotValue(this, slot);
    }

    @Override
    public List getDirectOwnSlotValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getDirectOwnSlotValues(this, slot);
    }

    @Override
    public Object getOwnSlotValue(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotValue(this, slot);
    }

    @Override
    public int getOwnSlotValueCount(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotValueCount(this, slot);
    }

    @Override
    public Collection getOwnSlotValues(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotValues(this, slot);
    }

    @Override
    public ValueType getOwnSlotValueType(Slot slot) {
        return this.getDefaultKnowledgeBase().getOwnSlotValueType(this, slot);
    }

    @Override
    public Project getProject() {
        return this.knowledgeBase.getProject();
    }

    @Override
    public Collection<Reference> getReferences() {
        return this.getReferences(0);
    }

    @Override
    public Collection<Reference> getReferences(int maxReferences) {
        return this.getDefaultKnowledgeBase().getReferences(this, maxReferences);
    }

    @Override
    public boolean hasOwnSlot(Slot slot) {
        return this.getDefaultKnowledgeBase().hasOwnSlot(this, slot);
    }

    @Override
    public boolean isEditable() {
        return !this.getState(1) && !this.isIncluded() && !this.isInReadonlyProject();
    }

    private boolean isInReadonlyProject() {
        return this.getProject() != null && this.getProject().isReadonly();
    }

    @Override
    public boolean isIncluded() {
        return this.getState(2) || this.isSystem();
    }

    @Override
    public boolean isSystem() {
        return this.knowledgeBase.getSystemFrames().isSystem(this);
    }

    @Override
    public boolean isValidOwnSlotValue(Slot slot, Object o) {
        return this.getDefaultKnowledgeBase().isValidOwnSlotValue(this, slot, o);
    }

    @Override
    public boolean isVisible() {
        return !this.getProject().isHidden(this);
    }

    @Override
    public void moveDirectOwnSlotValue(Slot slot, int fromIndex, int toIndex) {
        this.getDefaultKnowledgeBase().moveDirectOwnSlotValue(this, slot, fromIndex, toIndex);
    }

    @Override
    public void removeFrameListener(FrameListener listener) {
        this.getDefaultKnowledgeBase().removeFrameListener(this, listener);
    }

    @Override
    public void removeOwnSlotValue(Slot slot, Object value) {
        this.getDefaultKnowledgeBase().removeOwnSlotValue(this, slot, value);
    }

    @Override
    public void setDocumentation(String documentation) {
        this.getDefaultKnowledgeBase().setDocumentation((Frame)this, documentation);
    }

    @Override
    public void setDocumentation(Collection documentation) {
        this.getDefaultKnowledgeBase().setDocumentation((Frame)this, documentation);
    }

    @Override
    public void setEditable(boolean b) {
        this.setState(1, !b);
    }

    @Override
    public void setIncluded(boolean b) {
        this.setState(2, b);
    }

    @Override
    public void setOwnFacetValue(Slot slot, Facet facet, Object value) {
        Assert.fail("not implemented");
    }

    @Override
    public void setOwnFacetValues(Slot slot, Facet facet, Collection values) {
        Assert.fail("not implemented");
    }

    @Override
    public void setOwnSlotValue(Slot slot, Object value) {
        this.setOwnSlotValues(slot, CollectionUtilities.createCollection(value));
    }

    @Override
    public void setDirectOwnSlotValue(Slot slot, Object value) {
        this.setDirectOwnSlotValues(slot, CollectionUtilities.createCollection(value));
    }

    @Override
    public void setDirectOwnSlotValues(Slot slot, Collection values) {
        this.getDefaultKnowledgeBase().setDirectOwnSlotValues(this, slot, values);
    }

    @Override
    public void setOwnSlotValues(Slot slot, Collection values) {
        this.getDefaultKnowledgeBase().setOwnSlotValues(this, slot, values);
    }

    public void setSystem(boolean b) {
    }

    @Override
    public void setVisible(boolean v) {
        this.getProject().setHidden(this, !v);
        this.getDefaultKnowledgeBase().notifyVisibilityChanged(this);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Frame rename(String name) {
        return this.getKnowledgeBase().rename(this, name);
    }

    @Override
    public void assertFrameName() {
        this.getKnowledgeBase().assertFrameName(this);
    }
}

