/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultFrame;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public abstract class DefaultInstance
extends DefaultFrame
implements Instance {
    private static final long serialVersionUID = -3715893121091083687L;

    DefaultInstance(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    protected DefaultInstance() {
    }

    public void addInstanceListener(InstanceListener listener) {
        this.getDefaultKnowledgeBase().addInstanceListener(this, listener);
    }

    public Frame deepCopy(KnowledgeBase targetKB, Map valueMap) {
        return this.copy(targetKB, valueMap, true);
    }

    public Frame shallowCopy(KnowledgeBase targetKB, Map valueMap) {
        return this.copy(targetKB, valueMap, false);
    }

    public Frame copy(KnowledgeBase targetKB, Map valueMap, boolean isDeep) {
        Instance copy;
        KnowledgeBase sourceKB = this.getKnowledgeBase();
        if (targetKB == null) {
            targetKB = sourceKB;
        }
        if (valueMap == null) {
            valueMap = ModelUtilities.createValueMap(sourceKB, targetKB);
        }
        if ((copy = (Instance)valueMap.get(this)) == null) {
            String name = null;
            Collection copyTypes = this.getCopyTypes(valueMap);
            copy = targetKB.createInstance(name, copyTypes);
            valueMap.put(this, copy);
        }
        return super.copy(targetKB, valueMap, isDeep);
    }

    private Collection getCopyTypes(Map valueMap) {
        ArrayList<Cls> copyTypes = new ArrayList<Cls>();
        for (Cls type : this.getDirectTypes()) {
            Cls copyType = (Cls)valueMap.get(type);
            copyTypes.add(copyType);
        }
        return copyTypes;
    }

    public String getBrowserText() {
        return this.getDefaultKnowledgeBase().getBrowserText(this);
    }

    public Cls getDirectType() {
        KnowledgeBase kb = this.getDefaultKnowledgeBase();
        return kb == null ? null : kb.getDirectType(this);
    }

    public Collection getDirectTypes() {
        KnowledgeBase kb = this.getDefaultKnowledgeBase();
        return kb == null ? null : kb.getDirectTypes(this);
    }

    public Object getOwnFacetValue(Slot slot, Facet facet) {
        return this.getDirectType().getTemplateFacetValue(slot, facet);
    }

    public Collection getOwnFacetValues(Slot slot, Facet facet) {
        return this.getDirectType().getTemplateFacetValues(slot, facet);
    }

    public Collection getReachableSimpleInstances() {
        Collection<DefaultInstance> roots = CollectionUtilities.createCollection(this);
        return this.getDefaultKnowledgeBase().getReachableSimpleInstances(roots);
    }

    public boolean hasDirectType(Cls cls) {
        return this.getDefaultKnowledgeBase().hasDirectType(this, cls);
    }

    public boolean hasType(Cls cls) {
        return this.getDefaultKnowledgeBase().hasType(this, cls);
    }

    public void removeInstanceListener(InstanceListener listener) {
        this.getDefaultKnowledgeBase().removeInstanceListener(this, listener);
    }

    public Instance setDirectType(Cls type) {
        return this.getDefaultKnowledgeBase().setDirectType(this, type);
    }

    public Instance setDirectTypes(Collection types) {
        return this.getDefaultKnowledgeBase().setDirectTypes(this, types);
    }

    public void addDirectType(Cls type) {
        this.getDefaultKnowledgeBase().addDirectType(this, type);
    }

    public void removeDirectType(Cls type) {
        this.getDefaultKnowledgeBase().removeDirectType(this, type);
    }

    public void moveDirectType(Cls type, int index) {
        this.getDefaultKnowledgeBase().moveDirectType(this, type, index);
    }
}

