/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FacetListener;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.ServerProjectListener;
import edu.stanford.smi.protege.event.SlotListener;
import edu.stanford.smi.protege.event.TransactionListener;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameCounts;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.FrameNameValidator;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.MaximumCardinalityConstraint;
import edu.stanford.smi.protege.model.MinimumCardinalityConstraint;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.RoleConstraint;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.model.framestore.DefaultFrameFactory;
import edu.stanford.smi.protege.model.framestore.DeleteSimplificationFrameStore;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.undo.UndoFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.ServerCacheStateMachine;
import edu.stanford.smi.protege.server.job.GetServerProjectName;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultKnowledgeBase
implements KnowledgeBase {
    private static transient Logger log = Log.getLogger(DefaultKnowledgeBase.class);
    private static final int GENERATED_NAME_LENGTH = 8;
    private FrameStoreManager _frameStoreManager;
    private SystemFrames _systemFrames;
    private FrameFactory _frameFactory;
    private Cls _defaultClsMetaCls;
    private Cls _defaultSlotMetaCls;
    private Cls _defaultFacetMetaCls;
    private String _buildString;
    private String _frameNamePrefix;
    private Map _clientInformation = new HashMap();
    private KnowledgeBaseFactory _knowledgeBaseFactory;
    private Project _project;
    private String _name;
    private String _versionString;
    private FrameNameValidator _frameNameValidator;
    private ServerCacheStateMachine cacheMachine;
    private String _userName;
    public static final String SERVER_PROCESS_USER = "**Server Process UserId**";
    private boolean clientServerAdjusted;

    private void initializeKBName() {
        String randomString = String.valueOf(Math.random());
        int len = Math.min(randomString.length(), 8);
        this._name = "KB_" + randomString.substring(2, len);
    }

    protected SystemFrames createSystemFrames() {
        return new SystemFrames(this);
    }

    protected FrameFactory createFrameFactory() {
        return new DefaultFrameFactory(this);
    }

    protected FrameStoreManager createFrameStoreManager() {
        return new FrameStoreManager(this);
    }

    @Override
    public FrameStoreManager getFrameStoreManager() {
        return this._frameStoreManager;
    }

    public FrameStore getHeadFrameStore() {
        if (this._frameStoreManager == null) {
            throw new RuntimeException("Method called on closed knowledgeBase: " + this.getName());
        }
        return this._frameStoreManager.getHeadFrameStore();
    }

    public DefaultKnowledgeBase(KnowledgeBaseFactory factory) {
        this.initializeKBName();
        this._systemFrames = this.createSystemFrames();
        this._defaultClsMetaCls = this._systemFrames.getStandardClsMetaCls();
        this._defaultSlotMetaCls = this._systemFrames.getStandardSlotMetaCls();
        this._defaultFacetMetaCls = this._systemFrames.getStandardFacetMetaCls();
        this._frameFactory = this.createFrameFactory();
        this._frameStoreManager = this.createFrameStoreManager();
        this.clientServerAdjusted = false;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Phase 1 Initialization of Model starts");
        }
        this._knowledgeBaseFactory = factory;
    }

    public DefaultKnowledgeBase() {
        this.initializeKBName();
        this._systemFrames = this.createSystemFrames();
        this._defaultClsMetaCls = this._systemFrames.getStandardClsMetaCls();
        this._defaultSlotMetaCls = this._systemFrames.getStandardSlotMetaCls();
        this._defaultFacetMetaCls = this._systemFrames.getStandardFacetMetaCls();
        this._frameFactory = this.createFrameFactory();
        this._frameStoreManager = this.createFrameStoreManager();
        this.clientServerAdjusted = false;
    }

    @Override
    public synchronized SystemFrames getSystemFrames() {
        return this._systemFrames;
    }

    @Override
    public synchronized FrameFactory getFrameFactory() {
        return this._frameFactory;
    }

    public synchronized void close() {
        this._frameStoreManager.close();
    }

    @Override
    public synchronized boolean setCleanDispatchEnabled(boolean b) {
        return this._frameStoreManager.setCleanDispatchEnabled(b);
    }

    @Override
    public synchronized boolean setArgumentCheckingEnabled(boolean b) {
        return this._frameStoreManager.setArgumentCheckingEnabled(b);
    }

    @Override
    public synchronized boolean isJournalingEnabled() {
        return this._frameStoreManager.isJournalingEnabled();
    }

    @Override
    public synchronized boolean isCallCachingEnabled() {
        return this._frameStoreManager.isCallCachingEnabled();
    }

    @Override
    public synchronized boolean setJournalingEnabled(boolean b) {
        return this._frameStoreManager.setJournalingEnabled(b);
    }

    @Override
    public synchronized boolean setUndoEnabled(boolean b) {
        return this._frameStoreManager.setUndoEnabled(b);
    }

    public synchronized boolean setEventDispatchEnabled(boolean b) {
        return this._frameStoreManager.setEventDispatchEnabled(b);
    }

    @Override
    public synchronized boolean setCallCachingEnabled(boolean b) {
        return this._frameStoreManager.setCallCachingEnabled(b);
    }

    @Override
    public synchronized boolean setGenerateEventsEnabled(boolean b) {
        return this._frameStoreManager.setGenerateEventsEnabled(b);
    }

    private UndoFrameStore getUndoFrameStore() {
        return this._frameStoreManager.getUndoFrameStore();
    }

    @Override
    public synchronized boolean isUndoEnabled() {
        return this._frameStoreManager.isUndoEnabled();
    }

    @Override
    public void flushEvents() throws ProtegeException {
        this._frameStoreManager.flushEvents();
    }

    @Override
    public synchronized List getDirectOwnSlotValues(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getDirectOwnSlotValues(frame, slot);
    }

    public synchronized Cls createCls(String name, Collection directSuperclasses, Collection directTypes, boolean loadDefaults) {
        return this.createCls(new FrameID(name), directSuperclasses, directTypes, loadDefaults);
    }

    @Override
    public synchronized Cls createCls(FrameID id, Collection directSuperclasses, Collection directTypes, boolean loadDefaults) {
        return this.getHeadFrameStore().createCls(id, directTypes, directSuperclasses, loadDefaults);
    }

    @Override
    public synchronized Slot createSlot(String name, Cls directType, Collection superslots, boolean loadDefaults) {
        return this.createSlot(new FrameID(name), CollectionUtilities.createCollection(directType), superslots, loadDefaults);
    }

    public synchronized Slot createSlot(FrameID id, Collection directTypes, Collection superslots, boolean loadDefaults) {
        return this.getHeadFrameStore().createSlot(id, directTypes, superslots, loadDefaults);
    }

    public synchronized SimpleInstance createSimpleInstance(String name, Cls directType, boolean loadDefaults) {
        return this.createSimpleInstance(new FrameID(name), directType, loadDefaults);
    }

    @Override
    public synchronized SimpleInstance createSimpleInstance(FrameID id, Collection types, boolean loadDefaults) {
        return this.getHeadFrameStore().createSimpleInstance(id, types, loadDefaults);
    }

    public synchronized SimpleInstance createSimpleInstance(FrameID id, Cls directType, boolean loadDefaults) {
        Collection<Cls> types = CollectionUtilities.createCollection(directType);
        return this.createSimpleInstance(id, types, loadDefaults);
    }

    @Override
    public synchronized void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        if (frame instanceof Slot && slot.equals(this._systemFrames.getValueTypeSlot())) {
            ValueType type = ValueTypeConstraint.getType(values);
            values = CollectionUtilities.removeFirst(values);
            this.setValueTypeValues((Slot)frame, type, values);
        } else {
            this.getHeadFrameStore().setDirectOwnSlotValues(frame, slot, values);
        }
    }

    @Override
    public synchronized Frame getFrame(FrameID id) {
        return this.getHeadFrameStore().getFrame(id);
    }

    @Override
    public synchronized Frame getFrame(String name) {
        return this.getHeadFrameStore().getFrame(name);
    }

    @Override
    public synchronized Collection getOwnSlotValues(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        List values = this.getDirectOwnSlotValues(frame, slot);
        return CollectionUtilities.getFirstItem(values);
    }

    @Override
    public synchronized Collection<Slot> getOwnSlots(Frame frame) {
        return this.getHeadFrameStore().getOwnSlots(frame);
    }

    @Override
    public synchronized Collection getTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getTemplateSlots(cls);
    }

    public synchronized Collection<Reference> getReferences(Frame frame) {
        return this.getHeadFrameStore().getReferences(frame);
    }

    @Override
    public synchronized void deleteFrame(Frame frame) {
        if (frame instanceof Cls) {
            this.deleteCls((Cls)frame);
        } else if (frame instanceof Slot) {
            this.deleteSlot((Slot)frame);
        } else if (frame instanceof Facet) {
            this.deleteFacet((Facet)frame);
        } else {
            this.deleteSimpleInstance((SimpleInstance)frame);
        }
    }

    @Override
    @Deprecated
    public synchronized boolean setEventsEnabled(boolean b) {
        return this.setGenerateEventsEnabled(b);
    }

    @Override
    @Deprecated
    public synchronized boolean getEventsEnabled() {
        return this.getGenerateEventsEnabled();
    }

    @Override
    public synchronized boolean getGenerateEventsEnabled() {
        return this._frameStoreManager.getGenerateEventsEnabled();
    }

    @Override
    public synchronized boolean getDispatchEventsEnabled() {
        return this._frameStoreManager.getDispatchEventsEnabled();
    }

    @Override
    public synchronized boolean setDispatchEventsEnabled(boolean b) {
        return this._frameStoreManager.setEventDispatchEnabled(b);
    }

    @Override
    public synchronized boolean setChangeMonitorEnabled(boolean b) {
        return this._frameStoreManager.setChangeMonitorEnabled(b);
    }

    @Override
    public synchronized Cls getDirectType(Instance instance) {
        Collection types = this.getDirectTypes(instance);
        return (Cls)CollectionUtilities.getFirstItem(types);
    }

    @Override
    public synchronized Collection<Cls> getDirectSuperclasses(Cls cls) {
        return this.getHeadFrameStore().getDirectSuperclasses(cls);
    }

    @Override
    public synchronized String getName(Frame frame) {
        return this.getHeadFrameStore().getFrameName(frame);
    }

    @Override
    public synchronized void addJavaLoadPackage(String packageName) {
        this._frameFactory.addJavaPackage(packageName);
    }

    @Override
    public synchronized boolean areValidOwnSlotValues(Frame frame, Slot slot, Collection values) {
        boolean result = true;
        Iterator i = this.getOwnSlotFacets(frame, slot).iterator();
        while (result && i.hasNext()) {
            Facet facet = (Facet)i.next();
            result = facet.areValidValues(frame, slot, values);
        }
        return result;
    }

    @Override
    public synchronized boolean containsFrame(String name) {
        return this.getFrame(name) != null;
    }

    @Override
    public synchronized Cls createCls(String name, Collection superclasses) {
        return this.createCls(name, superclasses, this.getDefaultClsMetaCls(superclasses));
    }

    private Cls getDefaultClsMetaCls(Collection superclasses) {
        Cls leadingSuperclass = (Cls)CollectionUtilities.getFirstItem(superclasses);
        Cls clsMetaCls = leadingSuperclass == null || DefaultKnowledgeBase.equals(leadingSuperclass, this._systemFrames.getRootCls()) ? this._defaultClsMetaCls : leadingSuperclass.getDirectType();
        return clsMetaCls;
    }

    @Override
    public synchronized Cls createCls(String name, Collection superclasses, Cls directType) {
        return this.createCls(name, superclasses, directType, true);
    }

    @Override
    public synchronized Cls createCls(String name, Collection superclasses, Cls directType, boolean initializeDefaults) {
        Collection<Cls> directTypes = CollectionUtilities.createCollection(directType);
        return this.createCls(name, superclasses, directTypes, initializeDefaults);
    }

    @Override
    public synchronized Facet createFacet(String name) {
        return this.createFacet(name, this._defaultFacetMetaCls);
    }

    @Override
    public synchronized Facet createFacet(String name, Cls directType) {
        return this.createFacet(name, directType, true);
    }

    @Override
    public synchronized Facet createFacet(String name, Cls directType, boolean initializeDefaults) {
        Collection<Cls> types = CollectionUtilities.createCollection(directType);
        return this.createFacet(new FrameID(name), types, initializeDefaults);
    }

    public synchronized Facet createFacet(FrameID id, Collection directTypes, boolean initializeDefaults) {
        if (directTypes.isEmpty()) {
            directTypes = new ArrayList<Cls>();
            directTypes.add(this._defaultFacetMetaCls);
        }
        return this.getHeadFrameStore().createFacet(id, directTypes, initializeDefaults);
    }

    @Override
    public synchronized Instance createInstance(String name, Cls directType) {
        return this.createInstance(name, directType, true);
    }

    @Override
    public synchronized Instance createInstance(String name, Collection directTypes) {
        return this.createInstance(new FrameID(name), directTypes, true);
    }

    @Override
    public synchronized Instance createInstance(String name, Cls directType, boolean initializeDefaults) {
        return this.createInstance(new FrameID(name), directType, initializeDefaults);
    }

    @Override
    public synchronized Instance createInstance(FrameID id, Cls directType, boolean initializeDefaults) {
        Collection<Cls> types = CollectionUtilities.createCollection(directType);
        return this.createInstance(id, types, initializeDefaults);
    }

    @Override
    public synchronized Instance createInstance(FrameID id, Collection directTypes, boolean initializeDefaults) {
        Cls directType = (Cls)CollectionUtilities.getFirstItem(directTypes);
        Instance instance = directType == null ? this.createSimpleInstance(id, directType, initializeDefaults) : (this.isClsMetaCls(directType) ? this.createCls(id, (Collection)Collections.EMPTY_LIST, directTypes, initializeDefaults) : (this.isSlotMetaCls(directType) ? this.createSlot(id, directTypes, (Collection)Collections.EMPTY_LIST, initializeDefaults) : (this.isFacetMetaCls(directType) ? this.createFacet(id, directTypes, initializeDefaults) : this.createSimpleInstance(id, directTypes, initializeDefaults))));
        return instance;
    }

    @Override
    public synchronized Slot createSlot(String name) {
        return this.createSlot(name, this._defaultSlotMetaCls);
    }

    @Override
    public synchronized Slot createSlot(String name, Cls directType) {
        return this.createSlot(name, directType, true);
    }

    @Override
    public synchronized Slot createSlot(String name, Cls directType, boolean loadDefaults) {
        return this.createSlot(name, directType, (Collection)Collections.EMPTY_LIST, loadDefaults);
    }

    @Override
    @Deprecated
    public String createUniqueFrameName(String name) {
        return null;
    }

    @Override
    public synchronized void deleteCls(Cls cls) {
        if (!this.getInstances(cls).isEmpty()) {
            throw new RuntimeException("Delete of class with instances.");
        }
        this.getHeadFrameStore().deleteCls(cls);
        DefaultKnowledgeBase.markAsDeleted(cls);
    }

    private void moveSubclassesToParents(Cls cls, Collection parents) {
        for (Cls subclass : new ArrayList(this.getDirectSubclasses(cls))) {
            this.moveSubclassToParents(subclass, cls, parents);
        }
    }

    private void moveSubclassToParents(Cls subclass, Cls cls, Collection parents) {
        for (Cls parent : parents) {
            this.addDirectSuperclass(subclass, parent);
            this.removeDirectSuperclass(subclass, cls);
        }
    }

    private void moveInstancesToParents(Cls cls, Collection parents) {
        for (Instance instance : new ArrayList<Instance>(this.getDirectInstances(cls))) {
            this.moveInstanceToParents(instance, cls, parents);
        }
    }

    private void moveInstanceToParents(Instance instance, Cls cls, Collection parents) {
        for (Cls parent : parents) {
            this.addDirectType(instance, parent);
            this.removeDirectType(instance, cls);
        }
    }

    @Override
    public synchronized void deleteFacet(Facet facet) {
        this.getHeadFrameStore().deleteFacet(facet);
        DefaultKnowledgeBase.markAsDeleted(facet);
    }

    @Override
    public synchronized void deleteInstance(Instance instance) {
        this.deleteFrame(instance);
    }

    public synchronized void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.getHeadFrameStore().deleteSimpleInstance(simpleInstance);
        DefaultKnowledgeBase.markAsDeleted(simpleInstance);
    }

    @Override
    public synchronized void deleteSlot(Slot slot) {
        this.getHeadFrameStore().deleteSlot(slot);
        DefaultKnowledgeBase.markAsDeleted(slot);
    }

    private static void markAsDeleted(Frame frame) {
        frame.markDeleted(true);
    }

    @Override
    public synchronized String getBuildString() {
        return this._buildString;
    }

    @Override
    public synchronized Object getClientInformation(Object key) {
        return this._clientInformation.get(key);
    }

    @Override
    public synchronized Cls getCls(String name) {
        return (Cls)this.getFrameOfType(name, Cls.class);
    }

    private Frame getFrameOfType(String name, Class type) {
        Frame frame = this.getFrame(name);
        if (frame != null && !type.isInstance(frame)) {
            this.getFrame(name);
            Log.getLogger().warning("Wrong type: " + frame);
            frame = null;
        }
        return frame;
    }

    @Override
    public synchronized int getClsCount() {
        return this.getHeadFrameStore().getClsCount();
    }

    @Override
    public synchronized int getSimpleInstanceCount() {
        return this.getHeadFrameStore().getSimpleInstanceCount();
    }

    @Override
    public synchronized Collection<Cls> getClses() {
        return this.getHeadFrameStore().getClses();
    }

    @Override
    public synchronized Collection getClsNameMatches(String name, int maxMatches) {
        Collection<Frame> frames = this.getFrameNameMatches(name, maxMatches);
        Iterator<Frame> i = frames.iterator();
        while (i.hasNext()) {
            Frame o = i.next();
            if (o instanceof Cls) continue;
            i.remove();
        }
        return frames;
    }

    @Override
    public synchronized Cls getDefaultClsMetaCls() {
        return this._defaultClsMetaCls;
    }

    @Override
    public synchronized Cls getDefaultFacetMetaCls() {
        return this._defaultFacetMetaCls;
    }

    @Override
    public synchronized Cls getDefaultSlotMetaCls() {
        return this._defaultSlotMetaCls;
    }

    @Override
    public synchronized Facet getFacet(String name) {
        return (Facet)this.getFrameOfType(name, Facet.class);
    }

    @Override
    public synchronized int getFacetCount() {
        return this.getHeadFrameStore().getFacetCount();
    }

    @Override
    public synchronized Collection getFacets() {
        return this.getHeadFrameStore().getFacets();
    }

    @Override
    public synchronized int getFrameCount() {
        return this.getHeadFrameStore().getFrameCount();
    }

    @Override
    public synchronized String getFrameCreationTimestamp(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getCreationTimestampSlot());
    }

    @Override
    public synchronized String getFrameCreator(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getCreatorSlot());
    }

    @Override
    public synchronized String getFrameLastModificationTimestamp(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getModificationTimestampSlot());
    }

    @Override
    public synchronized String getFrameLastModifier(Frame frame) {
        return (String)this.getOwnSlotValue(frame, this._systemFrames.getModifierSlot());
    }

    @Override
    public synchronized Collection<Frame> getFrameNameMatches(String name, int maxMatches) {
        return this.getFramesWithMatchingDirectOwnSlotValue(this._systemFrames.getNameSlot(), name, maxMatches);
    }

    @Override
    public synchronized Collection getFramesWithValue(Slot slot, Facet facet, boolean isTemplate, Object value) {
        Set<Object> frames = facet == null ? (isTemplate ? this.getHeadFrameStore().getClsesWithDirectTemplateSlotValue(slot, value) : this.getHeadFrameStore().getFramesWithDirectOwnSlotValue(slot, value)) : this.getHeadFrameStore().getClsesWithDirectTemplateFacetValue(slot, facet, value);
        return frames;
    }

    public synchronized Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String value, int maxMatches) {
        return this.getHeadFrameStore().getFramesWithMatchingDirectOwnSlotValue(slot, value, maxMatches);
    }

    @Override
    public synchronized String getFrameNamePrefix() {
        return this._frameNamePrefix;
    }

    public synchronized Collection getFrames() {
        return this.getHeadFrameStore().getFrames();
    }

    @Override
    public synchronized Instance getInstance(String name) {
        return (Instance)this.getFrame(name);
    }

    @Override
    public synchronized SimpleInstance getSimpleInstance(String name) {
        return (SimpleInstance)this.getFrame(name);
    }

    @Override
    public synchronized Collection<Instance> getInstances() {
        return this.getFrames();
    }

    @Override
    @Deprecated
    public synchronized Collection<Instance> getInstances(Cls cls) {
        return this.getHeadFrameStore().getInstances(cls);
    }

    @Override
    public synchronized String getInvalidOwnSlotValuesText(Frame frame, Slot slot, Collection values) {
        String result = null;
        Iterator i = this.getOwnSlotFacets(frame, slot).iterator();
        while (result == null && i.hasNext()) {
            Facet facet = (Facet)i.next();
            result = facet.getInvalidValuesText(frame, slot, values);
        }
        return result;
    }

    @Override
    public synchronized String getInvalidOwnSlotValueText(Frame frame, Slot slot, Object value) {
        String result = null;
        Iterator i = this.getOwnSlotFacets(frame, slot).iterator();
        while (result == null && i.hasNext()) {
            Facet facet = (Facet)i.next();
            result = facet.getInvalidValueText(frame, slot, value);
        }
        return result;
    }

    @Override
    public synchronized KnowledgeBaseFactory getKnowledgeBaseFactory() {
        return this._knowledgeBaseFactory;
    }

    public synchronized Collection getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) {
        Set<Object> frames = facet == null ? (isTemplate ? this.getHeadFrameStore().getClsesWithMatchingDirectTemplateSlotValue(slot, value, maxMatches) : this.getHeadFrameStore().getFramesWithMatchingDirectOwnSlotValue(slot, value, maxMatches)) : this.getHeadFrameStore().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, value, maxMatches);
        return frames;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    @Deprecated
    public synchronized int getNextFrameNumber() {
        return 0;
    }

    @Override
    public synchronized Project getProject() {
        return this._project;
    }

    @Override
    public synchronized Collection getReachableSimpleInstances(Collection rootInstances) {
        HashSet reachableInstances = new HashSet();
        for (Instance instance : rootInstances) {
            this.addReachableSimpleInstances(instance, reachableInstances);
        }
        return reachableInstances;
    }

    private void addReachableSimpleInstances(Instance instance, Collection reachableInstances) {
        if (!reachableInstances.contains(instance)) {
            reachableInstances.add(instance);
            for (Slot slot : this.getOwnSlots(instance)) {
                this.addInstances(instance, slot, reachableInstances);
            }
        }
    }

    private synchronized void addInstances(Instance instance, Slot slot, Collection reachableInstances) {
        if (instance.getOwnSlotValueType(slot) == ValueType.INSTANCE) {
            for (Instance value : instance.getOwnSlotValues(slot)) {
                if (!(value instanceof SimpleInstance)) continue;
                this.addReachableSimpleInstances(value, reachableInstances);
            }
        }
    }

    public synchronized Collection getReferences(Object object, int maxRefs) {
        return this.getHeadFrameStore().getReferences(object);
    }

    @Override
    public synchronized Collection<Reference> getMatchingReferences(String s, int maxRefs) {
        return this.getHeadFrameStore().getMatchingReferences(s, maxRefs);
    }

    @Override
    public synchronized Collection<Cls> getClsesWithMatchingBrowserText(String s, Collection superclasses, int maxMatches) {
        return this.getHeadFrameStore().getClsesWithMatchingBrowserText(s, superclasses, maxMatches);
    }

    @Override
    public synchronized Cls getRootCls() {
        return this._systemFrames.getRootCls();
    }

    @Override
    public synchronized Collection getRootClses() {
        return CollectionUtilities.createCollection(this.getRootCls());
    }

    @Override
    public synchronized Cls getRootClsMetaCls() {
        return this._systemFrames.getRootClsMetaCls();
    }

    @Override
    public synchronized Cls getRootFacetMetaCls() {
        return this._systemFrames.getRootFacetMetaCls();
    }

    @Override
    public synchronized Cls getRootSlotMetaCls() {
        return this._systemFrames.getRootSlotMetaCls();
    }

    @Override
    public synchronized Collection getRootSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>(this.getSlots());
        Iterator i = slots.iterator();
        while (i.hasNext()) {
            Slot slot = (Slot)i.next();
            if (this.getDirectSuperslotCount(slot) <= 0) continue;
            i.remove();
        }
        return slots;
    }

    @Override
    public synchronized Slot getSlot(String name) {
        return (Slot)this.getFrameOfType(name, Slot.class);
    }

    @Override
    public synchronized int getSlotCount() {
        return this.getHeadFrameStore().getSlotCount();
    }

    @Override
    public synchronized Collection<Slot> getSlots() {
        return this.getHeadFrameStore().getSlots();
    }

    @Override
    @Deprecated
    public synchronized String getSlotValueLastModificationTimestamp(Frame frame, Slot slot, boolean isTemplate) {
        return null;
    }

    @Override
    @Deprecated
    public synchronized String getSlotValueLastModifier(Frame frame, Slot slot, boolean isTemplate) {
        return null;
    }

    @Override
    public synchronized Collection getSubclasses(Cls cls) {
        return this.getHeadFrameStore().getSubclasses(cls);
    }

    @Override
    public synchronized Collection getUnreachableSimpleInstances(Collection rootInstances) {
        HashSet instances = new HashSet(this.getFrames());
        instances.removeAll(this.getClses());
        instances.removeAll(this.getSlots());
        instances.removeAll(this.getFacets());
        instances.removeAll(this.getReachableSimpleInstances(rootInstances));
        return instances;
    }

    @Override
    public synchronized String getUserName() {
        if (this._userName != null) {
            return this._userName;
        }
        Project p = this.getProject();
        if (p != null && p.isMultiUserClient()) {
            FrameStoreManager fsm = this.getFrameStoreManager();
            RemoteClientFrameStore fs = fsm.getFrameStoreFromClass(RemoteClientFrameStore.class);
            this._userName = fs.getSession().getUserName();
            return this._userName;
        }
        if (p != null && p.isMultiUserServer()) {
            RemoteSession session = ServerFrameStore.getCurrentSession();
            if (session != null) {
                return session.getUserName();
            }
            return SERVER_PROCESS_USER;
        }
        this._userName = ApplicationProperties.getUserName();
        return this._userName;
    }

    @Override
    public synchronized String getVersionString() {
        return this._versionString;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this._frameStoreManager.hasChanged();
    }

    @Override
    public synchronized boolean isAutoUpdatingFacetValues() {
        return false;
    }

    @Override
    public synchronized boolean isClsMetaCls(Cls cls) {
        Cls rootMetaCls = this.getRootClsMetaCls();
        return DefaultKnowledgeBase.equals(cls, rootMetaCls) || this.hasSuperclass(cls, rootMetaCls);
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    @Override
    public synchronized boolean isDefaultClsMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultClsMetaCls);
    }

    @Override
    public synchronized boolean isDefaultFacetMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultFacetMetaCls);
    }

    @Override
    public synchronized boolean isDefaultSlotMetaCls(Cls cls) {
        return DefaultKnowledgeBase.equals(cls, this._defaultSlotMetaCls);
    }

    @Override
    public synchronized boolean isFacetMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this.getRootFacetMetaCls());
    }

    @Override
    public synchronized boolean isLoading() {
        return false;
    }

    @Override
    public synchronized boolean isSlotMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this.getRootSlotMetaCls());
    }

    @Override
    public synchronized boolean isValidOwnSlotValue(Frame frame, Slot slot, Object value) {
        boolean result = true;
        Iterator i = this.getOwnSlotFacets(frame, slot).iterator();
        while (result && i.hasNext()) {
            Facet facet = (Facet)i.next();
            result = facet.isValidValue(frame, slot, value);
        }
        return result;
    }

    @Override
    public synchronized void removeJavaLoadPackage(String packageName) {
        this._frameFactory.removeJavaPackage(packageName);
    }

    @Override
    @Deprecated
    public synchronized void setAutoUpdateFacetValues(boolean autoUpdate) {
        this.setModificationRecordUpdatingEnabled(autoUpdate);
    }

    @Override
    public synchronized boolean setModificationRecordUpdatingEnabled(boolean enabled) {
        return this._frameStoreManager.setModificationRecordUpdatingEnabled(enabled);
    }

    @Override
    public synchronized void setBuildString(String buildString) {
        this._buildString = buildString;
    }

    @Override
    public synchronized void setChanged(boolean changed) {
        this._frameStoreManager.setChanged(changed);
    }

    @Override
    public synchronized Object setClientInformation(Object key, Object value) {
        Object oldValue = this._clientInformation.get(key);
        this._clientInformation.put(key, value);
        return oldValue;
    }

    @Override
    public synchronized void setDefaultClsMetaCls(Cls cls) {
        if (cls == null || this.isClsMetaCls(cls)) {
            this._defaultClsMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a class meta class: " + cls);
        }
    }

    @Override
    public synchronized void setDefaultFacetMetaCls(Cls cls) {
        if (cls == null || this.isFacetMetaCls(cls)) {
            this._defaultFacetMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a facet meta class: " + cls);
        }
    }

    @Override
    public synchronized void setDefaultSlotMetaCls(Cls cls) {
        if (cls == null || this.isSlotMetaCls(cls)) {
            this._defaultSlotMetaCls = cls;
        } else {
            Log.getLogger().warning("Not a slot meta class: " + cls);
        }
    }

    @Override
    public synchronized void setFrameNamePrefix(String prefix) {
        this._frameNamePrefix = prefix;
    }

    public synchronized void setLoading(boolean loading) {
        this.setEventsEnabled(!loading);
    }

    @Override
    public synchronized void setName(String name) {
        this._name = name;
    }

    @Override
    @Deprecated
    public synchronized void setNextFrameNumber(int number) {
    }

    @Override
    public synchronized void setProject(Project project) {
        this._project = project;
        if (!this.clientServerAdjusted) {
            if (project.isMultiUserClient()) {
                this.adjustForClient();
            }
            if (project.isMultiUserServer()) {
                this.adjustForServer();
            }
            this.clientServerAdjusted = true;
        }
    }

    protected void adjustForClient() {
        DeleteSimplificationFrameStore dsfs = this._frameStoreManager.getFrameStoreFromClass(DeleteSimplificationFrameStore.class);
        this._frameStoreManager.setEnabled(dsfs, false);
        EventGeneratorFrameStore egfs = this._frameStoreManager.getFrameStoreFromClass(EventGeneratorFrameStore.class);
        if (egfs != null) {
            this._frameStoreManager.setEnabled(egfs, false);
        }
    }

    protected void adjustForServer() {
    }

    @Override
    @Deprecated
    public synchronized void setValueChecking(boolean checking) {
        this.setFacetCheckingEnabled(checking);
    }

    @Override
    public synchronized boolean setFacetCheckingEnabled(boolean enabled) {
        return this._frameStoreManager.setFacetCheckingEnabled(enabled);
    }

    @Override
    public synchronized void setVersionString(String versionString) {
        this._versionString = versionString;
    }

    @Override
    public synchronized void dispose() {
        if (this._frameStoreManager != null) {
            this._frameStoreManager.close();
        }
        this._frameStoreManager = null;
        this._project = null;
    }

    @Override
    public synchronized boolean isClosed() {
        return this._frameStoreManager != null;
    }

    public synchronized Collection getReachableSimpleInstances(Frame frame) {
        return this.getReachableSimpleInstances(CollectionUtilities.createCollection(frame));
    }

    @Override
    @Deprecated
    public synchronized void addOwnSlotValue(Frame frame, Slot slot, Object value) {
        ArrayList<Object> values = new ArrayList<Object>(this.getDirectOwnSlotValues(frame, slot));
        values.add(value);
        this.setDirectOwnSlotValues(frame, slot, values);
    }

    @Override
    public synchronized Collection getDocumentation(Frame frame) {
        return this.getOwnSlotValues(frame, this._systemFrames.getDocumentationSlot());
    }

    @Override
    public synchronized boolean getOwnSlotAllowsMultipleValues(Frame frame, Slot slot) {
        Cls type = ((Instance)frame).getDirectType();
        return this.getTemplateSlotAllowsMultipleValues(type, slot);
    }

    @Override
    @Deprecated
    public synchronized Collection getOwnSlotAndSubslotValues(Frame frame, Slot slot) {
        return this.getOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized Collection getOwnSlotDefaultValues(Frame frame, Slot slot) {
        LinkedHashSet values = new LinkedHashSet();
        for (Cls type : ((Instance)frame).getDirectTypes()) {
            values.addAll(this.getTemplateSlotDefaultValues(type, slot));
        }
        return values;
    }

    @Override
    @Deprecated
    public synchronized Collection getOwnSlotFacets(Frame frame, Slot slot) {
        return this.getOwnFacets(frame, slot);
    }

    @Override
    @Deprecated
    public synchronized Collection getOwnSlotFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getOwnFacetValues(frame, slot, facet);
    }

    public synchronized Collection getOwnFacets(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getOwnFacets(frame, slot);
    }

    public synchronized Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getOwnFacetValues(frame, slot, facet);
    }

    @Override
    public synchronized Object getOwnSlotValue(Frame frame, Slot slot) {
        Collection c = this.getOwnSlotValues(frame, slot);
        return c.isEmpty() ? null : c.iterator().next();
    }

    @Override
    public synchronized int getOwnSlotValueCount(Frame frame, Slot slot) {
        return this.getOwnSlotValues(frame, slot).size();
    }

    @Override
    public synchronized ValueType getOwnSlotValueType(Frame frame, Slot slot) {
        Collection values = this.getOwnFacetValues(frame, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getType(values);
    }

    @Override
    public synchronized boolean hasOwnSlot(Frame frame, Slot slot) {
        return this.getOwnSlots(frame).contains(slot);
    }

    @Override
    public synchronized void moveDirectOwnSlotValue(Frame frame, Slot slot, int from, int to) {
        this.getHeadFrameStore().moveDirectOwnSlotValue(frame, slot, from, to);
    }

    @Override
    @Deprecated
    public synchronized void removeOwnSlotValue(Frame frame, Slot slot, Object value) {
        ArrayList values = new ArrayList(this.getDirectOwnSlotValues(frame, slot));
        values.remove(value);
        this.setDirectOwnSlotValues(frame, slot, values);
    }

    @Override
    public synchronized void setDocumentation(Frame frame, String text) {
        this.setDirectOwnSlotValue(frame, this._systemFrames.getDocumentationSlot(), text);
    }

    @Override
    public synchronized void setDocumentation(Frame frame, Collection text) {
        this.setDirectOwnSlotValues(frame, this._systemFrames.getDocumentationSlot(), text);
    }

    @Deprecated
    public synchronized void setOwnSlotValue(Frame frame, Slot slot, Object value) {
        this.setDirectOwnSlotValue(frame, slot, value);
    }

    public synchronized void setDirectOwnSlotValue(Frame frame, Slot slot, Object value) {
        Collection<Object> values = CollectionUtilities.createCollection(value);
        this.setDirectOwnSlotValues(frame, slot, values);
    }

    @Override
    @Deprecated
    public synchronized void setOwnSlotValues(Frame frame, Slot slot, Collection values) {
        this.setDirectOwnSlotValues(frame, slot, values);
    }

    @Override
    public synchronized void notifyVisibilityChanged(Frame frame) {
    }

    @Override
    public synchronized Slot getAssociatedSlot(Facet facet) {
        return (Slot)this.getOwnSlotValue(facet, this._systemFrames.getAssociatedSlotSlot());
    }

    @Override
    public synchronized void setAssociatedSlot(Facet facet, Slot slot) {
        this.setDirectOwnSlotValue(facet, this._systemFrames.getAssociatedSlotSlot(), slot);
    }

    @Override
    public synchronized void addDirectSuperclass(Cls cls, Cls superclass) {
        this.getHeadFrameStore().addDirectSuperclass(cls, superclass);
    }

    @Override
    public synchronized void removeDirectSuperclass(Cls cls, Cls superclass) {
        this.getHeadFrameStore().removeDirectSuperclass(cls, superclass);
    }

    @Override
    public synchronized void addDirectType(Instance instance, Cls directType) {
        this.getHeadFrameStore().addDirectType(instance, directType);
    }

    @Override
    public synchronized void removeDirectType(Instance instance, Cls directType) {
        this.getHeadFrameStore().removeDirectType(instance, directType);
    }

    @Override
    public synchronized void moveDirectType(Instance instance, Cls directType, int index) {
        this.getHeadFrameStore().moveDirectType(instance, directType, index);
    }

    @Override
    public synchronized void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.getHeadFrameStore().addDirectTemplateSlot(cls, slot);
    }

    @Override
    public synchronized void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.getHeadFrameStore().removeDirectTemplateSlot(cls, slot);
    }

    @Override
    @Deprecated
    public synchronized void addTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object value) {
        ArrayList<Object> values = new ArrayList<Object>(this.getDirectTemplateFacetValues(cls, slot, facet));
        values.add(value);
        this.setDirectTemplateFacetValues(cls, slot, facet, values);
    }

    @Override
    @Deprecated
    public synchronized void addTemplateSlotValue(Cls cls, Slot slot, Object value) {
        ArrayList<Object> values = new ArrayList<Object>(this.getHeadFrameStore().getDirectTemplateSlotValues(cls, slot));
        values.add(value);
        this.setDirectTemplateSlotValues(cls, slot, values);
    }

    @Override
    public synchronized Slot getNameSlot() {
        return this._systemFrames.getNameSlot();
    }

    @Override
    public synchronized int getDirectInstanceCount(Cls cls) {
        return this.getDirectInstances(cls).size();
    }

    @Override
    public synchronized Collection<Instance> getDirectInstances(Cls cls) {
        return this.getHeadFrameStore().getDirectInstances(cls);
    }

    @Override
    public synchronized int getDirectSubclassCount(Cls cls) {
        return this.getHeadFrameStore().getDirectOwnSlotValuesCount(cls, this._systemFrames.getDirectSubclassesSlot());
    }

    @Override
    public synchronized Collection getDirectSubclasses(Cls cls) {
        return this.getHeadFrameStore().getDirectSubclasses(cls);
    }

    @Override
    public synchronized int getDirectSuperclassCount(Cls cls) {
        return this.getDirectSuperclasses(cls).size();
    }

    @Override
    public synchronized List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getDirectTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized Collection getDirectTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getDirectTemplateSlots(cls);
    }

    @Override
    public synchronized List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getDirectTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized int getInstanceCount(Cls cls) {
        return this.getInstances(cls).size();
    }

    @Override
    public synchronized Collection getSuperclasses(Cls cls) {
        return this.getHeadFrameStore().getSuperclasses(cls);
    }

    @Override
    public synchronized Collection getTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getTemplateFacets(cls, slot);
    }

    @Override
    public synchronized Object getTemplateFacetValue(Cls cls, Slot slot, Facet facet) {
        Collection values = this.getTemplateFacetValues(cls, slot, facet);
        return CollectionUtilities.getFirstItem(values);
    }

    @Override
    public synchronized Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getHeadFrameStore().getTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized Collection getTemplateSlotAllowedClses(Cls cls, Slot slot) {
        Collection values = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedClses(values);
    }

    @Override
    public synchronized Collection getTemplateSlotAllowedParents(Cls cls, Slot slot) {
        Collection values = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedParents(values);
    }

    @Override
    public synchronized Collection getTemplateSlotAllowedValues(Cls cls, Slot slot) {
        Collection values = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getAllowedValues(values);
    }

    @Override
    public synchronized boolean getTemplateSlotAllowsMultipleValues(Cls cls, Slot slot) {
        Integer value = this.getTemplateSlotMaximumCardinality2(cls, slot);
        return MaximumCardinalityConstraint.allowsMultipleValues(value);
    }

    @Override
    public synchronized Collection getTemplateSlotDefaultValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this._systemFrames.getDefaultValuesFacet());
    }

    @Override
    public synchronized Collection getTemplateSlotDocumentation(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this._systemFrames.getDocumentationFacet());
    }

    @Override
    public synchronized int getTemplateSlotMaximumCardinality(Cls cls, Slot slot) {
        Integer i = this.getTemplateSlotMaximumCardinality2(cls, slot);
        return MaximumCardinalityConstraint.getValue(i);
    }

    public synchronized Integer getTemplateSlotMaximumCardinality2(Cls cls, Slot slot) {
        return (Integer)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet());
    }

    public synchronized Integer getTemplateSlotMinimumCardinality2(Cls cls, Slot slot) {
        return (Integer)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMinimumCardinalityFacet());
    }

    @Override
    public synchronized Number getTemplateSlotMaximumValue(Cls cls, Slot slot) {
        return (Number)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMaximumValueFacet());
    }

    @Override
    public synchronized int getTemplateSlotMinimumCardinality(Cls cls, Slot slot) {
        Integer i = this.getTemplateSlotMinimumCardinality2(cls, slot);
        return MinimumCardinalityConstraint.getValue(i);
    }

    @Override
    public synchronized Number getTemplateSlotMinimumValue(Cls cls, Slot slot) {
        return (Number)this.getTemplateFacetValue(cls, slot, this._systemFrames.getMinimumValueFacet());
    }

    @Override
    public synchronized Object getTemplateSlotValue(Cls cls, Slot slot) {
        Collection values = this.getTemplateSlotValues(cls, slot);
        return CollectionUtilities.getFirstItem(values);
    }

    @Override
    public synchronized Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized ValueType getTemplateSlotValueType(Cls cls, Slot slot) {
        Collection values = this.getTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet());
        return ValueTypeConstraint.getType(values);
    }

    @Override
    public synchronized boolean hasDirectlyOverriddenTemplateFacet(Cls cls, Slot slot, Facet facet) {
        List values = this.getDirectTemplateFacetValues(cls, slot, facet);
        return !values.isEmpty();
    }

    @Override
    public synchronized boolean hasDirectlyOverriddenTemplateSlot(Cls cls, Slot slot) {
        return this.getDirectlyOverriddenTemplateSlots(cls).contains(slot);
    }

    @Override
    public synchronized Collection getDirectlyOverriddenTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getDirectlyOverriddenTemplateSlots(cls);
    }

    @Override
    public synchronized Collection getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getDirectlyOverriddenTemplateFacets(cls, slot);
    }

    @Override
    public synchronized boolean hasDirectSuperslot(Slot slot, Slot superslot) {
        return this.getDirectSuperslots(slot).contains(superslot);
    }

    @Override
    public synchronized boolean hasSuperslot(Slot slot, Slot superslot) {
        return this.getSuperslots(slot).contains(superslot);
    }

    @Override
    public synchronized boolean hasDirectSuperclass(Cls cls, Cls superclass) {
        return this.getDirectSuperclasses(cls).contains(superclass);
    }

    @Override
    public synchronized boolean hasDirectTemplateSlot(Cls cls, Slot slot) {
        return this.getDirectTemplateSlots(cls).contains(slot);
    }

    @Override
    public synchronized boolean hasInheritedTemplateSlot(Cls cls, Slot slot) {
        return this.getInheritedTemplateSlots(cls).contains(slot);
    }

    public synchronized Collection getInheritedTemplateSlots(Cls cls) {
        HashSet slots = new HashSet(this.getTemplateSlots(cls));
        slots.removeAll(this.getDirectTemplateSlots(cls));
        return slots;
    }

    @Override
    public synchronized boolean hasOverriddenTemplateSlot(Cls cls, Slot slot) {
        return this.getOverriddenTemplateSlots(cls).contains(slot);
    }

    public synchronized Collection getOverriddenTemplateSlots(Cls cls) {
        return this.getHeadFrameStore().getOverriddenTemplateSlots(cls);
    }

    @Override
    public synchronized boolean hasOverriddenTemplateFacet(Cls cls, Slot slot, Facet facet) {
        return this.getOverriddenTemplateFacets(cls, slot).contains(facet);
    }

    @Override
    public synchronized Collection getOverriddenTemplateFacets(Cls cls, Slot slot) {
        return this.getHeadFrameStore().getOverriddenTemplateFacets(cls, slot);
    }

    @Override
    @Deprecated
    public synchronized void removeTemplateFacetOverrides(Cls cls, Slot slot) {
        this.removeDirectTemplateFacetOverrides(cls, slot);
    }

    public synchronized void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.getHeadFrameStore().removeDirectTemplateFacetOverrides(cls, slot);
    }

    @Override
    public synchronized boolean hasSuperclass(Cls cls, Cls superclass) {
        return this.getSuperclasses(cls).contains(superclass);
    }

    @Override
    public synchronized boolean hasTemplateSlot(Cls cls, Slot slot) {
        return this.getTemplateSlots(cls).contains(slot);
    }

    @Override
    public synchronized boolean isAbstract(Cls cls) {
        String s = (String)this.getOwnSlotValue(cls, this._systemFrames.getRoleSlot());
        return RoleConstraint.isAbstract(s);
    }

    @Override
    public synchronized boolean isMetaCls(Cls cls) {
        return this.hasSuperclass(cls, this._systemFrames.getRootMetaCls());
    }

    @Override
    public synchronized void moveDirectSubclass(Cls cls, Cls subclass, Cls afterclass) {
        int index;
        ArrayList subclasses = new ArrayList(this.getDirectSubclasses(cls));
        int currentIndex = subclasses.indexOf(subclass);
        int n = index = afterclass == null ? 0 : subclasses.indexOf(afterclass);
        if (currentIndex > index) {
            ++index;
        }
        this.moveDirectSubclass(cls, subclass, index);
    }

    public synchronized void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        this.getHeadFrameStore().moveDirectSubclass(cls, subclass, index);
    }

    @Override
    public synchronized void moveDirectSubslot(Slot slot, Slot subslot, Slot afterslot) {
        int index;
        ArrayList subclasses = new ArrayList(this.getDirectSubslots(slot));
        int currentIndex = subclasses.indexOf(subslot);
        int n = index = afterslot == null ? 0 : subclasses.indexOf(afterslot);
        if (currentIndex > index) {
            ++index;
        }
        this.moveDirectSubslot(slot, subslot, index);
    }

    public synchronized void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        this.getHeadFrameStore().moveDirectSubslot(slot, subslot, index);
    }

    @Override
    public synchronized void moveDirectTemplateSlot(Cls cls, Slot slot, int toIndex) {
        this.getHeadFrameStore().moveDirectTemplateSlot(cls, slot, toIndex);
    }

    @Override
    public synchronized void setAbstract(Cls cls, boolean isAbstract) {
        String value = isAbstract ? "Abstract" : "Concrete";
        this.setDirectOwnSlotValue(cls, this._systemFrames.getRoleSlot(), value);
    }

    @Override
    public synchronized void setDirectTypeOfSubclasses(Cls cls, Cls type) {
        for (Cls subclass : this.getSubclasses(cls)) {
            this.setDirectType(subclass, type);
        }
    }

    @Override
    @Deprecated
    public synchronized void setTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object value) {
        this.setDirectTemplateFacetValue(cls, slot, facet, value);
    }

    public synchronized void setDirectTemplateFacetValue(Cls cls, Slot slot, Facet facet, Object value) {
        Collection<Object> values = CollectionUtilities.createCollection(value);
        this.setDirectTemplateFacetValues(cls, slot, facet, values);
    }

    @Override
    @Deprecated
    public synchronized void setTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        this.setDirectTemplateFacetValues(cls, slot, facet, values);
    }

    public synchronized void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        if (facet.equals(this._systemFrames.getValueTypeFacet())) {
            this.setTemplateSlotValueTypeValues(cls, slot, values);
        } else {
            this.getHeadFrameStore().setDirectTemplateFacetValues(cls, slot, facet, values);
        }
    }

    private void setTemplateSlotValueTypeValues(Cls cls, Slot slot, ValueType type, Collection otherValues) {
        List values = ValueTypeConstraint.getValues(type, otherValues);
        this.setTemplateSlotValueTypeValues(cls, slot, values);
    }

    @Override
    public synchronized void setTemplateSlotAllowedClses(Cls cls, Slot slot, Collection values) {
        if (!values.isEmpty()) {
            values = ValueTypeConstraint.getValues(ValueType.INSTANCE, values);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, values);
    }

    @Override
    public synchronized void setTemplateSlotAllowedParents(Cls cls, Slot slot, Collection values) {
        if (!values.isEmpty()) {
            values = ValueTypeConstraint.getValues(ValueType.CLS, values);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, values);
    }

    @Override
    public synchronized void setTemplateSlotAllowedValues(Cls cls, Slot slot, Collection values) {
        if (!values.isEmpty()) {
            values = ValueTypeConstraint.getValues(ValueType.SYMBOL, values);
        }
        this.setTemplateSlotValueTypeValues(cls, slot, values);
    }

    @Override
    public synchronized void setTemplateSlotAllowsMultipleValues(Cls cls, Slot slot, boolean allowsMultiple) {
        Integer value = MaximumCardinalityConstraint.getValue(allowsMultiple);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet(), value);
    }

    @Override
    public synchronized void setTemplateSlotDefaultValues(Cls cls, Slot slot, Collection values) {
        this.setDirectTemplateFacetValues(cls, slot, this._systemFrames.getDefaultValuesFacet(), values);
    }

    @Override
    public synchronized void setTemplateSlotDocumentation(Cls cls, Slot slot, String doc) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getDocumentationFacet(), doc);
    }

    @Override
    public synchronized void setTemplateSlotDocumentation(Cls cls, Slot slot, Collection docs) {
        this.setDirectTemplateFacetValues(cls, slot, this._systemFrames.getDocumentationFacet(), docs);
    }

    @Override
    public synchronized void setTemplateSlotMaximumCardinality(Cls cls, Slot slot, int value) {
        Integer facetValue = MaximumCardinalityConstraint.getValue(value);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumCardinalityFacet(), facetValue);
    }

    @Override
    public synchronized void setTemplateSlotMaximumValue(Cls cls, Slot slot, Number value) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMaximumValueFacet(), value);
    }

    @Override
    public synchronized void setTemplateSlotMinimumCardinality(Cls cls, Slot slot, int value) {
        Integer facetValue = MinimumCardinalityConstraint.getValue(value);
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMinimumCardinalityFacet(), facetValue);
    }

    @Override
    public synchronized void setTemplateSlotMinimumValue(Cls cls, Slot slot, Number value) {
        this.setDirectTemplateFacetValue(cls, slot, this._systemFrames.getMinimumValueFacet(), value);
    }

    @Override
    public synchronized void setTemplateSlotValue(Cls cls, Slot slot, Object value) {
        Collection<Object> values = CollectionUtilities.createCollection(value);
        this.setDirectTemplateSlotValues(cls, slot, values);
    }

    @Override
    @Deprecated
    public synchronized void setTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        this.setDirectTemplateSlotValues(cls, slot, values);
    }

    public synchronized void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        this.getHeadFrameStore().setDirectTemplateSlotValues(cls, slot, values);
    }

    @Override
    public synchronized void setTemplateSlotValueType(Cls cls, Slot slot, ValueType type) {
        if (!this.getTemplateSlotValueType(cls, slot).equals(type)) {
            this.setTemplateSlotValueTypeValues(cls, slot, type, Collections.EMPTY_LIST);
        }
    }

    @Override
    public synchronized void addInstance(Instance instance, String name, Cls type, boolean isNew) {
    }

    @Override
    public synchronized String getBrowserText(Instance instance) {
        String value;
        if (instance.isDeleted()) {
            value = "<<deleted>>";
        } else {
            Cls directType = instance.getDirectType();
            if (this._project == null) {
                value = this.getName(instance);
            } else if (directType == null) {
                value = this.getMissingTypeString(instance);
            } else {
                BrowserSlotPattern slotPattern = this._project.getBrowserSlotPattern(directType);
                if (slotPattern == null) {
                    value = this.getDisplaySlotNotSetString(instance);
                } else {
                    value = slotPattern.getBrowserText(instance);
                    if (value == null) {
                        value = this.getDisplaySlotPatternValueNotSetString(instance, slotPattern);
                    }
                }
            }
        }
        return value;
    }

    protected String getMissingTypeString(Instance instance) {
        return instance.getName();
    }

    protected String getDisplaySlotNotSetString(Instance instance) {
        return instance.getName();
    }

    protected String getDisplaySlotPatternValueNotSetString(Instance instance, BrowserSlotPattern slotPattern) {
        return instance.getName();
    }

    protected String toString(BrowserSlotPattern pattern) {
        return this.getBrowserText(pattern.getFirstSlot());
    }

    protected String toString(Object o) {
        return o instanceof Frame ? this.toStringForFrame((Frame)o) : this.toStringForObject(o);
    }

    protected String toStringForFrame(Frame frame) {
        return frame.getBrowserText();
    }

    protected String toStringForObject(Object o) {
        return o.toString();
    }

    @Override
    public synchronized Collection getDirectTypes(Instance instance) {
        return this.getHeadFrameStore().getDirectTypes(instance);
    }

    @Override
    public synchronized boolean hasDirectType(Instance instance, Cls cls) {
        return this.getDirectTypes(instance).contains(cls);
    }

    @Override
    public synchronized boolean hasType(Instance instance, Cls cls) {
        return this.getTypes(instance).contains(cls);
    }

    public synchronized Collection getTypes(Instance instance) {
        return this.getHeadFrameStore().getTypes(instance);
    }

    @Override
    public synchronized Instance setDirectType(Instance instance, Cls type) {
        Collection<Cls> types = CollectionUtilities.createCollection(type);
        return this.setDirectTypes(instance, types);
    }

    @Override
    public synchronized Instance setDirectTypes(Instance instance, Collection newTypes) {
        ArrayList oldTypes = new ArrayList(this.getDirectTypes(instance));
        ArrayList typesToRemove = new ArrayList(oldTypes);
        typesToRemove.removeAll(newTypes);
        ArrayList typesToAdd = new ArrayList(newTypes);
        typesToAdd.removeAll(oldTypes);
        this.addDirectTypes(instance, typesToAdd);
        this.removeDirectTypes(instance, typesToRemove);
        return instance;
    }

    public synchronized void addDirectTypes(Instance instance, Collection types) {
        for (Cls type : types) {
            this.getHeadFrameStore().addDirectType(instance, type);
        }
    }

    public synchronized void removeDirectTypes(Instance instance, Collection types) {
        for (Cls type : types) {
            this.getHeadFrameStore().removeDirectType(instance, type);
        }
    }

    @Override
    public synchronized void addDirectSuperslot(Slot slot, Slot superslot) {
        this.getHeadFrameStore().addDirectSuperslot(slot, superslot);
    }

    @Override
    public synchronized Collection getAllowedClses(Slot slot) {
        Collection values = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedClses(values);
    }

    @Override
    public synchronized Collection getAllowedParents(Slot slot) {
        Collection values = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedParents(values);
    }

    @Override
    public synchronized Collection getAllowedValues(Slot slot) {
        Collection values = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getAllowedValues(values);
    }

    private Object getStandardSlotValue(Slot slot, Slot associatedSlot) {
        Collection values = this.getStandardSlotValues(slot, associatedSlot);
        return CollectionUtilities.getFirstItem(values);
    }

    private Collection getStandardSlotValues(Slot slot, Slot associatedSlot) {
        Collection values = this.getDirectOwnSlotValues(slot, associatedSlot);
        if (values.isEmpty()) {
            values = this.getOwnSlotValues(slot, associatedSlot);
        }
        return values;
    }

    @Override
    public synchronized boolean getAllowsMultipleValues(Slot slot) {
        Integer value = this.getMaximumCardinality2(slot);
        return MaximumCardinalityConstraint.allowsMultipleValues(value);
    }

    @Override
    public synchronized Facet getAssociatedFacet(Slot slot) {
        Facet facet = null;
        Object o = this.getOwnSlotValue(slot, this._systemFrames.getAssociatedFacetSlot());
        if (o instanceof Facet) {
            facet = (Facet)o;
        } else if (o != null) {
            Log.getLogger().warning("Invalid facet: " + o);
        }
        return facet;
    }

    @Override
    public synchronized Collection getDefaultValues(Slot slot) {
        return this.getOwnSlotValues(slot, this._systemFrames.getDefaultValuesSlot());
    }

    @Override
    public synchronized int getDirectSubslotCount(Slot slot) {
        return this.getDirectSubslots(slot).size();
    }

    @Override
    public synchronized Collection getDirectSubslots(Slot slot) {
        return this.getHeadFrameStore().getDirectSubslots(slot);
    }

    @Override
    public synchronized Collection getDirectSuperslots(Slot slot) {
        return this.getHeadFrameStore().getDirectSuperslots(slot);
    }

    @Override
    public synchronized int getDirectSuperslotCount(Slot slot) {
        return this.getDirectSuperslots(slot).size();
    }

    @Override
    public synchronized Slot getInverseSlot(Slot slot) {
        return (Slot)this.getOwnSlotValue(slot, this._systemFrames.getInverseSlotSlot());
    }

    public synchronized Integer getMaximumCardinality2(Slot slot) {
        return (Integer)this.getStandardSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot());
    }

    @Override
    public synchronized int getMaximumCardinality(Slot slot) {
        Integer value = this.getMaximumCardinality2(slot);
        return MaximumCardinalityConstraint.getValue(value);
    }

    @Override
    public synchronized Number getMaximumValue(Slot slot) {
        return (Number)this.getStandardSlotValue(slot, this._systemFrames.getMaximumValueSlot());
    }

    @Override
    public synchronized int getMinimumCardinality(Slot slot) {
        Integer value = (Integer)this.getOwnSlotValue(slot, this._systemFrames.getMinimumCardinalitySlot());
        return MinimumCardinalityConstraint.getValue(value);
    }

    @Override
    public synchronized Number getMinimumValue(Slot slot) {
        return (Number)this.getOwnSlotValue(slot, this._systemFrames.getMinimumValueSlot());
    }

    @Override
    public synchronized Collection getSubslots(Slot slot) {
        return this.getHeadFrameStore().getSubslots(slot);
    }

    @Override
    public synchronized Collection getSuperslots(Slot slot) {
        return this.getHeadFrameStore().getSuperslots(slot);
    }

    @Override
    public synchronized Collection getDirectDomain(Slot slot) {
        return this.getHeadFrameStore().getDirectDomain(slot);
    }

    @Override
    public synchronized Collection getDomain(Slot slot) {
        return this.getHeadFrameStore().getDomain(slot);
    }

    @Override
    public synchronized Collection getValues(Slot slot) {
        return this.getOwnSlotValues(slot, this._systemFrames.getValuesSlot());
    }

    @Override
    public synchronized ValueType getValueType(Slot slot) {
        Collection values = this.getStandardSlotValues(slot, this._systemFrames.getValueTypeSlot());
        return ValueTypeConstraint.getType(values);
    }

    @Override
    public synchronized boolean hasSlotValueAtSomeFrame(Slot slot) {
        return false;
    }

    @Override
    public synchronized void removeDirectSuperslot(Slot slot, Slot superslot) {
        this.getHeadFrameStore().removeDirectSuperslot(slot, superslot);
    }

    private void setValueTypeValues(Slot slot, ValueType newValueType, Collection otherValues) {
        ValueType oldValueType = this.getValueType(slot);
        List values = ValueTypeConstraint.getValues(newValueType, otherValues);
        this.getHeadFrameStore().setDirectOwnSlotValues(slot, this._systemFrames.getValueTypeSlot(), values);
        if (!DefaultKnowledgeBase.areComparableTypes(oldValueType, newValueType)) {
            this.setDefaultValues(slot, Collections.EMPTY_LIST);
            this.setValues(slot, Collections.EMPTY_LIST);
            this.clearValues(null, slot);
        }
    }

    private static boolean areComparableTypes(ValueType type1, ValueType type2) {
        return DefaultKnowledgeBase.equals(type1, type2) || DefaultKnowledgeBase.isFrameType(type1) && DefaultKnowledgeBase.isFrameType(type2) || DefaultKnowledgeBase.isStringType(type1) && DefaultKnowledgeBase.isStringType(type2) || type1.equals(ValueType.ANY) || type2 == null || type2.equals(ValueType.ANY);
    }

    private static boolean isFrameType(ValueType type) {
        return DefaultKnowledgeBase.equals(type, ValueType.CLS) || DefaultKnowledgeBase.equals(type, ValueType.INSTANCE);
    }

    private static boolean isStringType(ValueType type) {
        return DefaultKnowledgeBase.equals(type, ValueType.STRING) || DefaultKnowledgeBase.equals(type, ValueType.SYMBOL);
    }

    private void clearValues(Cls cls, Slot slot) {
        this.clearOwnSlotValues(cls, slot);
        this.clearTemplateSlotValues(cls, slot);
    }

    private void clearOwnSlotValues(Cls cls, Slot slot) {
        for (Frame frame : new ArrayList<Frame>(this.getFramesWithAnyOwnSlotValue(slot))) {
            if (cls != null && !this.hasType((Instance)frame, cls)) continue;
            this.setOwnSlotValues(frame, slot, Collections.EMPTY_SET);
        }
    }

    private Collection<Frame> getFramesWithAnyOwnSlotValue(Slot slot) {
        return this.getHeadFrameStore().getFramesWithAnyDirectOwnSlotValue(slot);
    }

    private Collection<Cls> getClsesWithAnyTemplateSlotValue(Slot slot) {
        return this.getHeadFrameStore().getClsesWithAnyDirectTemplateSlotValue(slot);
    }

    private void clearTemplateSlotValues(Cls slotCls, Slot slot) {
        for (Cls cls : new ArrayList<Cls>(this.getClsesWithAnyTemplateSlotValue(slot))) {
            if (slotCls != null && !this.hasSuperclass(cls, slotCls)) continue;
            this.setTemplateSlotValues(cls, slot, Collections.EMPTY_SET);
        }
    }

    private void setTemplateSlotValueTypeValues(Cls cls, Slot slot, Collection values) {
        ValueType oldValueType = this.getTemplateSlotValueType(cls, slot);
        ValueType newValueType = values.isEmpty() ? null : ValueTypeConstraint.getType(values);
        this.getHeadFrameStore().setDirectTemplateFacetValues(cls, slot, this._systemFrames.getValueTypeFacet(), values);
        if (!DefaultKnowledgeBase.areComparableTypes(oldValueType, newValueType)) {
            this.setTemplateSlotDefaultValues(cls, slot, Collections.EMPTY_LIST);
            this.setTemplateSlotValues(cls, slot, Collections.EMPTY_LIST);
            this.clearValues(cls, slot);
        }
    }

    @Override
    public synchronized void setAllowedClses(Slot slot, Collection clses) {
        this.setValueTypeValues(slot, ValueType.INSTANCE, clses);
    }

    @Override
    public synchronized void setAllowedParents(Slot slot, Collection parents) {
        this.setValueTypeValues(slot, ValueType.CLS, parents);
    }

    @Override
    public synchronized void setAllowedValues(Slot slot, Collection values) {
        this.setValueTypeValues(slot, ValueType.SYMBOL, values);
    }

    @Override
    public synchronized void setAllowsMultipleValues(Slot slot, boolean allowsMultiple) {
        Integer value = MaximumCardinalityConstraint.getValue(allowsMultiple);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot(), value);
    }

    @Override
    public synchronized void setAssociatedFacet(Slot slot, Facet facet) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getAssociatedFacetSlot(), facet);
    }

    @Override
    public synchronized void setDefaultValues(Slot slot, Collection values) {
        this.setDirectOwnSlotValues(slot, this._systemFrames.getDefaultValuesSlot(), values);
    }

    @Override
    public synchronized void setDirectTypeOfSubslots(Slot slot, Cls type) {
        for (Slot subslot : this.getSubslots(slot)) {
            this.setDirectType(subslot, type);
        }
    }

    @Override
    public synchronized void setInverseSlot(Slot slot, Slot inverseSlot) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getInverseSlotSlot(), inverseSlot);
    }

    @Override
    public synchronized void setMaximumCardinality(Slot slot, int max) {
        Integer value = MaximumCardinalityConstraint.getValue(max);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot(), value);
    }

    @Override
    public synchronized void setMaximumValue(Slot slot, Number max) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMaximumValueSlot(), max);
    }

    @Override
    public synchronized void setMinimumCardinality(Slot slot, int min) {
        Integer value = MinimumCardinalityConstraint.getValue(min);
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMinimumCardinalitySlot(), value);
    }

    @Override
    public synchronized void setMinimumValue(Slot slot, Number min) {
        this.setDirectOwnSlotValue(slot, this._systemFrames.getMinimumValueSlot(), min);
    }

    @Override
    public synchronized void setValues(Slot slot, Collection values) {
        this.setDirectOwnSlotValues(slot, this._systemFrames.getValuesSlot(), values);
    }

    @Override
    public synchronized void setValueType(Slot slot, ValueType newType) {
        if (!this.getValueType(slot).equals(newType)) {
            this.setValueTypeValues(slot, newType, Collections.EMPTY_LIST);
        }
    }

    public synchronized void setUserName(String userName) {
        this._userName = userName;
    }

    @Override
    public synchronized void addFrameListener(Frame frame, FrameListener listener) {
        this.addListener(FrameListener.class, frame, listener);
    }

    @Override
    public synchronized void addFrameListener(FrameListener listener) {
        this.addFrameListener(null, listener);
    }

    @Override
    public synchronized void removeFrameListener(Frame frame, FrameListener listener) {
        this.removeListener(FrameListener.class, frame, listener);
    }

    @Override
    public synchronized void removeFrameListener(FrameListener listener) {
        this.removeFrameListener(null, listener);
    }

    @Override
    public synchronized void addSlotListener(Slot slot, SlotListener listener) {
        this.addListener(SlotListener.class, slot, listener);
    }

    @Override
    public synchronized void addSlotListener(SlotListener listener) {
        this.addSlotListener(null, listener);
    }

    @Override
    public synchronized void removeSlotListener(Slot slot, SlotListener listener) {
        this.removeListener(SlotListener.class, slot, listener);
    }

    @Override
    public synchronized void removeSlotListener(SlotListener listener) {
        this.removeSlotListener(null, listener);
    }

    @Override
    public synchronized void addInstanceListener(Instance instance, InstanceListener listener) {
        this.addListener(InstanceListener.class, instance, listener);
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener listener) {
        this.addInstanceListener(null, listener);
    }

    @Override
    public synchronized void removeInstanceListener(Instance instance, InstanceListener listener) {
        this.removeListener(InstanceListener.class, instance, listener);
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener listener) {
        this.removeInstanceListener(null, listener);
    }

    @Override
    public synchronized void addClsListener(ClsListener listener) {
        this.addClsListener(null, listener);
    }

    @Override
    public synchronized void addClsListener(Cls cls, ClsListener listener) {
        this.addListener(ClsListener.class, cls, listener);
    }

    @Override
    public synchronized void removeClsListener(Cls cls, ClsListener listener) {
        this.removeListener(ClsListener.class, cls, listener);
    }

    @Override
    public synchronized void removeClsListener(ClsListener listener) {
        this.removeClsListener(null, listener);
    }

    @Override
    public synchronized void addKnowledgeBaseListener(KnowledgeBaseListener listener) {
        this.addListener(KnowledgeBaseListener.class, this, listener);
    }

    @Override
    public synchronized void removeKnowledgeBaseListener(KnowledgeBaseListener listener) {
        this.removeListener(KnowledgeBaseListener.class, this, listener);
    }

    @Override
    public synchronized void addFacetListener(Facet facet, FacetListener listener) {
        this.addListener(FacetListener.class, this, listener);
    }

    @Override
    public synchronized void addFacetListener(FacetListener listener) {
        this.addFacetListener(null, listener);
    }

    @Override
    public synchronized void removeFacetListener(Facet facet, FacetListener listener) {
        this.removeListener(FacetListener.class, facet, listener);
    }

    @Override
    public synchronized void removeFacetListener(FacetListener listener) {
        this.removeFacetListener(null, listener);
    }

    @Override
    public synchronized void addServerProjectListener(ServerProjectListener listener) {
        String projectName = (String)new GetServerProjectName(this).execute();
        this.addListener(ServerProjectListener.class, projectName, listener);
    }

    @Override
    public synchronized void removeServerProjectListener(ServerProjectListener listener) {
        String projectName = (String)new GetServerProjectName(this).execute();
        this.removeListener(ServerProjectListener.class, projectName, listener);
    }

    private void addListener(Class c, Object o, EventListener listener) {
        this._frameStoreManager.addListener(c, o, listener);
    }

    private void removeListener(Class c, Object o, EventListener listener) {
        this._frameStoreManager.removeListener(c, o, listener);
    }

    public String toString() {
        return StringUtilities.getClassName(this) + "(" + this.getName() + ")";
    }

    @Override
    public synchronized Collection getCurrentUsers() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public synchronized boolean beginTransaction(String name) {
        return this.getHeadFrameStore().beginTransaction(name);
    }

    @Override
    public synchronized boolean beginTransaction(String name, String appliedToFrameName) {
        if (appliedToFrameName == null) {
            return this.beginTransaction(name);
        }
        return this.beginTransaction(name + " -- Apply to: " + appliedToFrameName);
    }

    @Override
    public synchronized boolean commitTransaction() {
        return this.getHeadFrameStore().commitTransaction();
    }

    @Override
    public synchronized boolean rollbackTransaction() {
        return this.getHeadFrameStore().rollbackTransaction();
    }

    @Override
    @Deprecated
    public synchronized boolean endTransaction(boolean doCommit) {
        boolean committed = doCommit ? this.commitTransaction() : !this.rollbackTransaction();
        return committed;
    }

    @Override
    @Deprecated
    public synchronized boolean endTransaction() {
        return this.commitTransaction();
    }

    @Override
    public synchronized void setFrameFactory(FrameFactory factory) {
        this._frameFactory = factory;
    }

    @Override
    public CommandManager getCommandManager() {
        return this.getUndoFrameStore();
    }

    @Override
    public synchronized void setFrameNameValidator(FrameNameValidator validator) {
        this._frameNameValidator = validator;
    }

    @Override
    public synchronized boolean isValidFrameName(String name, Frame frame) {
        return this._frameNameValidator == null ? true : this._frameNameValidator.isValid(name, frame);
    }

    @Override
    public synchronized String getInvalidFrameNameDescription(String name, Frame frame) {
        String description = null;
        if (this._frameNameValidator != null) {
            description = this._frameNameValidator.getErrorMessage(name, frame);
        }
        return description;
    }

    @Override
    public synchronized void setPollForEvents(boolean b) {
        this._frameStoreManager.setPollForEvents(b);
    }

    @Override
    @Deprecated
    public synchronized void setDirectBrowserSlot(Cls cls, Slot slot) {
        this.setDirectBrowserSlotPattern(cls, new BrowserSlotPattern(slot));
    }

    @Override
    public synchronized void setDirectBrowserSlotPattern(Cls cls, BrowserSlotPattern slotPattern) {
        this.getProject().setDirectBrowserSlotPattern(cls, slotPattern);
        this._frameStoreManager.notifyInstancesOfBrowserTextChange(cls);
    }

    @Override
    public synchronized void removeFrameStore(FrameStore frameStore) {
        this._frameStoreManager.removeFrameStore(frameStore);
    }

    @Override
    public synchronized void insertFrameStore(FrameStore newFrameStore) {
        this._frameStoreManager.insertFrameStore(newFrameStore);
    }

    @Override
    public synchronized void insertFrameStore(FrameStore newFrameStore, int position) {
        this._frameStoreManager.insertFrameStore(newFrameStore, position);
    }

    @Override
    public synchronized List<FrameStore> getFrameStores() {
        return this._frameStoreManager.getFrameStores();
    }

    public synchronized void setTerminalFrameStore(FrameStore store) {
        this._frameStoreManager.setTerminalFrameStore(store);
    }

    public synchronized FrameStore getTerminalFrameStore() {
        return this._frameStoreManager.getTerminalFrameStore();
    }

    @Override
    public synchronized void clearAllListeners() {
        this._frameStoreManager.clearAllListeners();
    }

    @Override
    public synchronized FrameCounts getFrameCounts() {
        return this.getProject().getFrameCounts();
    }

    @Override
    public BrowserSlotPattern getDirectBrowserSlotPattern(Cls cls) {
        return this.getProject().getDirectBrowserSlotPattern(cls);
    }

    public void setDirectBrowserTextPattern(Cls cls, BrowserSlotPattern pattern) {
        this.getProject().setDirectBrowserSlotPattern(cls, pattern);
    }

    @Override
    public synchronized Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        return this.getHeadFrameStore().getDirectOwnSlotValuesClosure(frame, slot);
    }

    @Override
    @Deprecated
    public boolean getValueChecking() {
        return this.getFacetCheckingEnabled();
    }

    public synchronized boolean getFacetCheckingEnabled() {
        return this._frameStoreManager.getFacetCheckingEnabled();
    }

    @Override
    public void startJournaling(URI journal) {
        this._frameStoreManager.startJournaling(journal);
    }

    @Override
    public void stopJournaling() {
        this._frameStoreManager.stopJournaling();
    }

    @Override
    public synchronized boolean setGenerateDeletingFrameEventsEnabled(boolean enabled) {
        return this._frameStoreManager.setGenerateDeletingFrameEventsEnabled(enabled);
    }

    @Override
    public synchronized void flushCache() {
        this.getFrameStoreManager().reinitialize();
    }

    @Override
    public synchronized Cls getReifiedRelationCls() {
        return this._systemFrames.getRelationCls();
    }

    @Override
    public synchronized Slot getReifedRelationFromSlot() {
        return this._systemFrames.getFromSlot();
    }

    @Override
    public synchronized Slot getReifedRelationToSlot() {
        return this._systemFrames.getToSlot();
    }

    @Override
    public synchronized void addTransactionListener(TransactionListener listener) {
        this.addListener(TransactionListener.class, this, listener);
    }

    @Override
    public synchronized void removeTransactionListener(TransactionListener listener) {
        this.removeListener(TransactionListener.class, this, listener);
    }

    @Override
    public Collection<Frame> executeQuery(Query q) {
        SynchronizeQueryCallback callback = new SynchronizeQueryCallback(this);
        this.getHeadFrameStore().executeQuery(q, callback);
        return callback.waitForResults();
    }

    public ServerCacheStateMachine getCacheMachine() {
        return this.cacheMachine;
    }

    public void setCacheMachine(ServerCacheStateMachine machine) {
        this.cacheMachine = machine;
    }

    @Override
    public Frame rename(Frame frame, String name) {
        FrameFactory ff = this.getFrameFactory();
        return ff.rename(frame, name);
    }

    @Override
    public void assertFrameName(Frame frame) {
        this.setDirectOwnSlotValue(frame, this._systemFrames.getNameSlot(), frame.getName());
    }
}

