/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameCounts;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;

public class FrameCountsImpl
implements FrameCounts {
    private KnowledgeBase _kb;
    private CountRecord _systemCountRecord = new CountRecord();
    private CountRecord _includedCountRecord = new CountRecord();

    public void updateSystemFrameCounts(KnowledgeBase kb) {
        for (Frame frame : kb.getFrames()) {
            if (!frame.isSystem()) continue;
            FrameCountsImpl.updateRecord(this._systemCountRecord, frame);
        }
    }

    private static void updateRecord(CountRecord record, Frame frame) {
        if (frame instanceof Cls) {
            ++record.clsCount;
        } else if (frame instanceof Slot) {
            ++record.slotCount;
        } else if (frame instanceof Facet) {
            ++record.facetCount;
        } else {
            ++record.simpleInstanceCount;
        }
    }

    public void updateIncludedFrameCounts(KnowledgeBase kb) {
        for (Frame frame : kb.getFrames()) {
            if (!frame.isIncluded() || frame.isSystem()) continue;
            FrameCountsImpl.updateRecord(this._includedCountRecord, frame);
        }
    }

    public void updateDirectFrameCounts(KnowledgeBase kb) {
        this._kb = kb;
    }

    public int getSystemClsCount() {
        return this._systemCountRecord.clsCount;
    }

    public int getSystemSlotCount() {
        return this._systemCountRecord.slotCount;
    }

    public int getSystemFacetCount() {
        return this._systemCountRecord.facetCount;
    }

    public int getSystemSimpleInstanceCount() {
        return this._systemCountRecord.simpleInstanceCount;
    }

    public int getSystemFrameCount() {
        return this.getSystemClsCount() + this.getSystemSlotCount() + this.getSystemFacetCount() + this.getSystemSimpleInstanceCount();
    }

    public int getIncludedClsCount() {
        return this._includedCountRecord.clsCount;
    }

    public int getIncludedSlotCount() {
        return this._includedCountRecord.slotCount;
    }

    public int getIncludedFacetCount() {
        return this._includedCountRecord.facetCount;
    }

    public int getIncludedSimpleInstanceCount() {
        return this._includedCountRecord.simpleInstanceCount;
    }

    public int getIncludedFrameCount() {
        return this.getIncludedClsCount() + this.getIncludedSlotCount() + this.getIncludedFacetCount() + this.getIncludedSimpleInstanceCount();
    }

    public int getDirectClsCount() {
        return this._kb.getClsCount() - (this.getSystemClsCount() + this.getIncludedClsCount());
    }

    public int getDirectSlotCount() {
        return this._kb.getSlotCount() - (this.getSystemSlotCount() + this.getIncludedSlotCount());
    }

    public int getDirectFacetCount() {
        return this._kb.getFacetCount() - (this.getSystemFacetCount() + this.getIncludedFacetCount());
    }

    public int getDirectSimpleInstanceCount() {
        return this._kb.getSimpleInstanceCount() - (this.getSystemSimpleInstanceCount() + this.getIncludedSimpleInstanceCount());
    }

    public int getDirectFrameCount() {
        return this._kb.getFrameCount() - (this.getSystemFrameCount() + this.getIncludedFrameCount());
    }

    public int getTotalClsCount() {
        return this.getSystemClsCount() + this.getIncludedClsCount() + this.getDirectClsCount();
    }

    public int getTotalSlotCount() {
        return this.getSystemSlotCount() + this.getIncludedSlotCount() + this.getDirectSlotCount();
    }

    public int getTotalFacetCount() {
        return this.getSystemFacetCount() + this.getIncludedFacetCount() + this.getDirectFacetCount();
    }

    public int getTotalSimpleInstanceCount() {
        return this.getSystemSimpleInstanceCount() + this.getIncludedSimpleInstanceCount() + this.getDirectSimpleInstanceCount();
    }

    public int getTotalFrameCount() {
        return this.getSystemFrameCount() + this.getIncludedFrameCount() + this.getDirectFrameCount();
    }

    private static class CountRecord {
        int clsCount;
        int slotCount;
        int facetCount;
        int simpleInstanceCount;

        private CountRecord() {
        }
    }
}

