/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIField;
import edu.stanford.smi.protege.util.URIList;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class KnowledgeBaseSourcesEditor
extends JComponent
implements Validatable {
    private static final long serialVersionUID = 3820797792113838686L;
    private PropertyList _sources;
    private FileField _projectPathField;
    private URIList _includedProjectsList;
    private String _oldProjectPath;
    private boolean _showingProject;

    protected KnowledgeBaseSourcesEditor(String projectPath, PropertyList sources) {
        this._sources = sources;
        if (projectPath != null) {
            try {
                this._oldProjectPath = new File(URI.create(projectPath)).getAbsolutePath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.createProjectPathField(), "North");
        this.createIncludedProjectsList();
    }

    public void setShowIncludedProjects(boolean b) {
        if (this._includedProjectsList != null) {
            this._includedProjectsList.setVisible(b);
        }
    }

    public JComponent createIncludedProjectsList() {
        this._includedProjectsList = new URIList("Included Projects", null, ".pprj", "Project Files");
        return this._includedProjectsList;
    }

    public JComponent createProjectPathField() {
        this._projectPathField = new FileField("Project", this._oldProjectPath, ".pprj", "Project Files");
        this._projectPathField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                String newProjectPath = KnowledgeBaseSourcesEditor.this.getProjectPath();
                KnowledgeBaseSourcesEditor.this.onProjectPathChange(KnowledgeBaseSourcesEditor.this._oldProjectPath, newProjectPath);
                KnowledgeBaseSourcesEditor.this._oldProjectPath = newProjectPath;
            }
        });
        this._projectPathField.setDialogType(1);
        return this._projectPathField;
    }

    public Collection getIncludedProjects() {
        return this._includedProjectsList == null ? Collections.EMPTY_LIST : this._includedProjectsList.getURIs();
    }

    public String getProjectPath() {
        return this.getProjectPathFromProjectField();
    }

    private String getProjectPathFromProjectField() {
        String path = null;
        if (this._showingProject && (path = this._projectPathField.getPath()) != null) {
            path = FileUtilities.ensureExtension(path, ".pprj");
        }
        return path;
    }

    public PropertyList getSources() {
        return this._sources;
    }

    public void setShowProject(boolean showProject) {
        this._showingProject = showProject;
        this.remove(this._projectPathField);
        if (this._includedProjectsList != null) {
            this.remove(this._includedProjectsList);
        }
        if (showProject) {
            this.add((Component)this._projectPathField, "North");
        } else if (this._includedProjectsList != null) {
            this.add((Component)this._includedProjectsList, "North");
        }
        this.revalidate();
    }

    public boolean isShowingProject() {
        return this._showingProject;
    }

    protected boolean hasValidValue(URIField field) {
        URI value = field.getRelativeURI();
        boolean hasValidValue = value != null;
        return hasValidValue;
    }

    protected void onProjectPathChange(String oldPath, String newPath) {
    }

    protected void updatePath(FileField field, String newBasePath, String ext) {
        String name = new File(newBasePath).getName();
        String fieldText = FileUtilities.replaceExtension(name, ext);
        field.setPath(fieldText);
    }

    protected String getBaseFile(FileField field) {
        String s = field.getPath();
        if (this._showingProject) {
            int index = s.lastIndexOf(File.separatorChar);
            s = s.substring(index + 1);
        }
        return s;
    }
}

