/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.AbstractFacetConstraint;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.Collection;
import java.util.Collections;

public class MaximumCardinalityConstraint
extends AbstractFacetConstraint {
    private static final long serialVersionUID = 1151034475072958857L;
    private static final Integer CARDINALITY_SINGLE = new Integer(1);

    public String getInvalidValuesText(Frame frame, Slot slot, Collection slotValues, Collection facetValues) {
        String result = null;
        Integer i = (Integer)CollectionUtilities.getFirstItem(facetValues);
        if (i != null) {
            int max = i;
            if (slotValues.size() > max) {
                result = "Only " + max + " value" + (max == 1 ? " is" : "s are") + " allowed";
                result = result + " - " + CollectionUtilities.toString(slotValues);
            }
        }
        return result;
    }

    public String getInvalidValueText(Frame frame, Slot slot, Object o, Collection facetValues) {
        return null;
    }

    public static boolean allowsMultipleValues(Integer i) {
        return i == null ? true : i > 1;
    }

    public static int getValue(Integer i) {
        return i == null ? -1 : i;
    }

    public static Integer getValue(int i) {
        return i < 0 ? null : new Integer(i);
    }

    public static Integer getValue(boolean allowsMultiple) {
        return allowsMultiple ? null : CARDINALITY_SINGLE;
    }

    public static Collection getValues(boolean allowsMultiple) {
        return allowsMultiple ? Collections.EMPTY_SET : Collections.singleton(CARDINALITY_SINGLE);
    }

    public Collection resolve(Collection existingValues, Collection newValues) {
        int i2;
        int i1 = MaximumCardinalityConstraint.getValue(existingValues);
        return i1 <= (i2 = MaximumCardinalityConstraint.getValue(newValues)) ? existingValues : newValues;
    }

    private static int getValue(Collection values) {
        Integer i = (Integer)CollectionUtilities.getFirstItem(values);
        return i == null ? Integer.MAX_VALUE : i;
    }
}

