/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtilities {
    public static void addOwnSlotValue(Frame frame, String slotName, Object value) {
        Assert.assertNotNull("value", value);
        frame.addOwnSlotValue(ModelUtilities.getSlot(frame, slotName), value);
    }

    public static Map createValueMap(KnowledgeBase sourceKB, KnowledgeBase targetKB) {
        HashMap<Object, Object> valueMap = new HashMap<Object, Object>();
        for (Frame sourceFrame : sourceKB.getFrames()) {
            if (ModelUtilities.isCopyable(sourceFrame)) continue;
            Frame targetFrame = targetKB.getFrame(sourceFrame.getName());
            valueMap.put(sourceFrame, targetFrame);
        }
        valueMap.put(sourceKB, targetKB);
        return valueMap;
    }

    private static Facet getFacet(Frame frame, String facetName) {
        Facet facet = frame.getKnowledgeBase().getFacet(facetName);
        if (facet == null) {
            Log.getLogger().warning("missing facet: " + facetName);
        }
        return facet;
    }

    public static Object getOwnSlotValue(Frame frame, String name) {
        Object value;
        Slot slot = ModelUtilities.getSlot(frame, name);
        if (slot == null) {
            value = null;
            Log.getLogger().warning("unknown slot: " + name);
        } else {
            value = frame.getOwnSlotValue(slot);
        }
        return value;
    }

    public static Object getDirectOwnSlotValue(Frame frame, String name) {
        Object value;
        Slot slot = ModelUtilities.getSlot(frame, name);
        if (slot == null) {
            value = null;
            Log.getLogger().warning("unknown slot: " + name);
        } else {
            value = frame.getDirectOwnSlotValue(slot);
        }
        return value;
    }

    public static Collection getOwnSlotValues(Frame frame, String name) {
        Collection values;
        Slot slot = ModelUtilities.getSlot(frame, name);
        if (slot == null) {
            values = Collections.EMPTY_LIST;
            Log.getLogger().warning("unknown slot: " + name);
        } else {
            values = frame.getOwnSlotValues(slot);
        }
        return values;
    }

    public static List getDirectOwnSlotValues(Frame frame, String name) {
        List values;
        Slot slot = ModelUtilities.getSlot(frame, name);
        if (slot == null) {
            values = Collections.EMPTY_LIST;
            Log.getLogger().warning("unknown slot: " + name);
        } else {
            values = frame.getDirectOwnSlotValues(slot);
        }
        return values;
    }

    public List<Cls> getPath(Cls cls, List<Cls> list) {
        list.add(0, cls);
        Cls superclass = CollectionUtilities.getFirstItem(cls.getDirectSuperclasses());
        if (superclass != null) {
            this.getPath(superclass, list);
        }
        return list;
    }

    public static void getPropertyClosureToRoot(Instance resource, Slot parentSlot, Instance rootResource, List<Instance> path, Collection<List<Instance>> pathLists) {
        path.add(0, resource);
        Collection parents = resource.getOwnSlotValues(parentSlot);
        for (Object parentObject : parents) {
            if (!(parentObject instanceof Instance)) continue;
            Instance parentResource = (Instance)parentObject;
            if (parentResource.equals(rootResource)) {
                ArrayList<Instance> copyPathList = new ArrayList<Instance>(path);
                copyPathList.add(0, parentResource);
                pathLists.add(copyPathList);
                continue;
            }
            if (path.contains(parentResource)) continue;
            ArrayList<Instance> copyPath = new ArrayList<Instance>(path);
            ModelUtilities.getPropertyClosureToRoot(parentResource, parentSlot, rootResource, copyPath, pathLists);
        }
    }

    public static Collection<List<Instance>> getPropertyClosureToRoot(Instance resource, Slot parentSlot, Instance rootResource) {
        ArrayList<List<Instance>> results = new ArrayList<List<Instance>>();
        if (resource.equals(rootResource)) {
            results.add(Collections.singletonList(rootResource));
            return results;
        }
        ModelUtilities.getPropertyClosureToRoot(resource, parentSlot, rootResource, new LinkedList<Instance>(), results);
        return results;
    }

    public static Map<Object, List<Instance>> getPropertyValuesOnPropertyClosureToRoot(Instance resource, Slot parentSlot, Instance rootResource, Slot slot) {
        HashMap<Object, List<Instance>> result = new HashMap<Object, List<Instance>>();
        Collection<List<Instance>> propertyClosureToRoot = ModelUtilities.getPropertyClosureToRoot(resource, parentSlot, rootResource);
        HashSet<Instance> allNodes = new HashSet<Instance>();
        for (List<Instance> path : propertyClosureToRoot) {
            allNodes.addAll(path);
        }
        for (Instance node : allNodes) {
            Collection values = node.getOwnSlotValues(slot);
            for (Object value : values) {
                if (value == null) continue;
                ArrayList<Instance> nodeList = (ArrayList<Instance>)result.get(value);
                if (nodeList == null) {
                    nodeList = new ArrayList<Instance>();
                    result.put(value, nodeList);
                }
                nodeList.add(node);
            }
        }
        return result;
    }

    public static Map<Object, List<Instance>> getPropertyValuesOnAllSuperclasses(Cls cls, Slot slot) {
        KnowledgeBase kb = cls.getKnowledgeBase();
        Cls rootCls = kb.getRootCls();
        Slot parentSlot = kb.getSystemFrames().getDirectSuperclassesSlot();
        return ModelUtilities.getPropertyValuesOnPropertyClosureToRoot(cls, parentSlot, rootCls, slot);
    }

    public static List<Cls> getPathToRoot(Cls cls) {
        return ModelUtilities.getPathToRoot(cls, new LinkedList<Cls>());
    }

    private static List<Cls> getPathToRoot(Cls cls, LinkedList<Cls> list) {
        list.add(0, cls);
        Iterator<Cls> i = cls.getDirectSuperclasses().iterator();
        Cls rootCls = cls.getKnowledgeBase().getRootCls();
        while (i.hasNext()) {
            Cls superclass = i.next();
            if (list.contains(superclass) || !cls.isVisible()) continue;
            ArrayList<Cls> copy = new ArrayList<Cls>(list);
            ModelUtilities.getPathToRoot(superclass, list);
            if (list.getFirst().equals(rootCls)) break;
            list.clear();
            list.addAll(copy);
        }
        return list;
    }

    public static Collection<List<Cls>> getPathsToRoot(Cls cls) {
        ArrayList<List<Cls>> results = new ArrayList<List<Cls>>();
        if (cls.equals(cls.getKnowledgeBase().getRootCls())) {
            results.add((List)cls.getKnowledgeBase().getRootClses());
            return results;
        }
        ModelUtilities.getPathsToRoot(cls, new LinkedList<Cls>(), results);
        return results;
    }

    private static void getPathsToRoot(Cls resource, List<Cls> path, Collection<List<Cls>> pathLists) {
        path.add(0, resource);
        Cls rootCls = resource.getKnowledgeBase().getRootCls();
        Collection<Cls> parents = resource.getDirectSuperclasses();
        for (Cls parent : parents) {
            if (parent.equals(rootCls)) {
                ArrayList<Cls> copyPathList = new ArrayList<Cls>(path);
                copyPathList.add(0, parent);
                pathLists.add(copyPathList);
                continue;
            }
            if (path.contains(parent)) continue;
            ArrayList<Cls> copyPath = new ArrayList<Cls>(path);
            ModelUtilities.getPathsToRoot(parent, copyPath, pathLists);
        }
    }

    private static Slot getSlot(Frame frame, String slotName) {
        Assert.assertNotNull("frame", frame);
        Assert.assertNotNull("slot", slotName);
        Slot slot = frame.getKnowledgeBase().getSlot(slotName);
        if (slot == null) {
            Log.getLogger().warning("missing slot: " + slotName);
        }
        return slot;
    }

    public static Object getTemplateFacetValue(Cls cls, Slot slot, String facetName) {
        Facet facet = ModelUtilities.getFacet(cls, facetName);
        Object value = facet == null ? null : cls.getTemplateFacetValue(slot, facet);
        return value;
    }

    public static Collection getTemplateFacetValues(Cls cls, Slot slot, String facetName) {
        Facet facet = ModelUtilities.getFacet(cls, facetName);
        Collection values = facet == null ? Collections.EMPTY_LIST : cls.getTemplateFacetValues(slot, facet);
        return values;
    }

    public static boolean isVisibleInGUI(Frame frame) {
        return frame.getProject().getDisplayHiddenFrames() || frame.isVisible();
    }

    private static boolean isCopyable(Frame frame) {
        return frame instanceof SimpleInstance;
    }

    public static void removeOwnSlotValue(Frame frame, String slotName, Object value) {
        frame.removeOwnSlotValue(ModelUtilities.getSlot(frame, slotName), value);
    }

    public static void setOwnSlotValue(Frame frame, String slotName, Object value) {
        Slot slot = ModelUtilities.getSlot(frame, slotName);
        if (slot != null) {
            frame.setOwnSlotValue(slot, value);
        } else {
            Log.getLogger().warning("Cannot set value of slot " + slotName + " at frame " + frame + " to " + value + " Inexistent slot.");
        }
    }

    public static void setOwnSlotValues(Frame frame, String slotName, Collection values) {
        Slot slot = ModelUtilities.getSlot(frame, slotName);
        if (slot != null) {
            frame.setOwnSlotValues(slot, values);
        } else {
            Log.getLogger().warning("Cannot set values of slot " + slotName + " at frame " + frame + " to " + values + " Inexistent slot.");
        }
    }

    public static void setTemplateFacetValue(Cls cls, Slot slot, String facetName, Object value) {
        cls.setTemplateFacetValue(slot, ModelUtilities.getFacet(cls, facetName), value);
    }

    public static void setTemplateFacetValues(Cls cls, Slot slot, String facetName, Collection values) {
        cls.setTemplateFacetValues(slot, ModelUtilities.getFacet(cls, facetName), values);
    }
}

