/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.AbstractFacetConstraint;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.Collection;
import java.util.Iterator;

public class NumericMaximumConstraint
extends AbstractFacetConstraint {
    private static final long serialVersionUID = 8433560444246377129L;

    public String getInvalidValuesText(Frame frame, Slot slot, Collection slotValues, Collection facetValues) {
        String result = null;
        Number n = (Number)CollectionUtilities.getFirstItem(facetValues);
        if (n != null) {
            double max = n.doubleValue();
            Iterator i = slotValues.iterator();
            while (result == null && i.hasNext()) {
                Object value = i.next();
                result = NumericMaximumConstraint.getInvalidValueText(max, value);
            }
        }
        return result;
    }

    private static String getInvalidValueText(double max, Object value) {
        Number n;
        String result = null;
        if (value instanceof Number && (n = (Number)value).doubleValue() > max) {
            result = "The maximum value is " + max;
        }
        return result;
    }

    public String getInvalidValueText(Frame frame, Slot slot, Object value, Collection facetValues) {
        String result = null;
        Number n = (Number)CollectionUtilities.getFirstItem(facetValues);
        if (n != null) {
            double max = n.doubleValue();
            result = NumericMaximumConstraint.getInvalidValueText(max, value);
        }
        return result;
    }

    public Collection resolve(Collection existingValues, Collection newValues) {
        double n2;
        double n1 = NumericMaximumConstraint.getValue(existingValues);
        return n1 < (n2 = NumericMaximumConstraint.getValue(newValues)) ? existingValues : newValues;
    }

    private static double getValue(Collection values) {
        Number n = (Number)CollectionUtilities.getFirstItem(values);
        return n == null ? Double.MAX_VALUE : n.doubleValue();
    }
}

