/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.AbstractFacetConstraint;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.Collection;

public class NumericMinimumConstraint
extends AbstractFacetConstraint {
    private static final long serialVersionUID = -7642501607185450946L;

    public String getInvalidValuesText(Frame frame, Slot slot, Collection slotValues, Collection facetValues) {
        String result = null;
        Number n = (Number)CollectionUtilities.getFirstItem(facetValues);
        if (n != null) {
            double min = n.doubleValue();
            for (Object value : slotValues) {
                result = NumericMinimumConstraint.getInvalidValueText(min, value);
            }
        }
        return result;
    }

    private static String getInvalidValueText(double min, Object value) {
        Number n;
        String result = null;
        if (value instanceof Number && (n = (Number)value).doubleValue() < min) {
            result = "The minimum value is " + min;
        }
        return result;
    }

    public String getInvalidValueText(Frame frame, Slot slot, Object o, Collection facetValues) {
        String result = null;
        Number n = (Number)CollectionUtilities.getFirstItem(facetValues);
        if (n != null) {
            double min = n.doubleValue();
            result = NumericMinimumConstraint.getInvalidValueText(min, o);
        }
        return result;
    }

    public Collection resolve(Collection existingValues, Collection newValues) {
        double d2;
        double d1 = NumericMinimumConstraint.getValue(existingValues);
        return d1 > (d2 = NumericMinimumConstraint.getValue(newValues)) ? existingValues : newValues;
    }

    private static double getValue(Collection values) {
        Number n = (Number)CollectionUtilities.getFirstItem(values);
        return n == null ? Double.MIN_VALUE : n.doubleValue();
    }
}

