/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.event.KnowledgeBaseAdapter;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.ProjectEventDispatcher;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.event.WidgetAdapter;
import edu.stanford.smi.protege.event.WidgetEvent;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameCounts;
import edu.stanford.smi.protege.model.FrameCountsImpl;
import edu.stanford.smi.protege.model.FrameSlotCombination;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory2;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.PropertyMapUtil;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.plugin.ProjectFixupsPluginManager;
import edu.stanford.smi.protege.resource.Files;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.ListenerCollection;
import edu.stanford.smi.protege.util.ListenerList;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Tree;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.DefaultWidgetMapper;
import edu.stanford.smi.protege.widget.UglyClsWidget;
import edu.stanford.smi.protege.widget.Widget;
import edu.stanford.smi.protege.widget.WidgetMapper;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private static Logger log = Log.getLogger(Project.class);
    private static final String CLASS_PROJECT = "Project";
    private static final String SLOT_DEFAULT_INSTANCE_WIDGET_CLASS_NAME = "default_instance_widget_class_name";
    private static final String SLOT_CUSTOMIZED_INSTANCE_WIDGETS = "customized_instance_widgets";
    private static final String SLOT_BROWSER_SLOTS = "browser_slot_names";
    private static final String SLOT_TABS = "tabs";
    private static final String SLOT_INCLUDED_PROJECTS = "included_projects";
    private static final String SLOT_ALL_KNOWLEDGE_BASE_FACTORY_NAMES = "all_knowledge_base_factory_names";
    private static final String SLOT_SOURCES = "sources";
    private static final String SLOT_JAVA_PACKAGES = "java_packages";
    private static final String SLOT_HIDDEN_FRAMES = "hidden_classes";
    private static final String SLOT_JOURNALING_ENABLED = "journaling_enabled";
    private static final String SLOT_DEFAULT_CLS_METACLASS = "default_cls_metaclass";
    private static final String SLOT_DEFAULT_SLOT_METACLASS = "default_slot_metaclass";
    private static final String SLOT_DEFAULT_FACET_METACLASS = "default_facet_metaclass";
    private static final String SLOT_NEXT_FRAME_NUMBER = "next_frame_number";
    private static final String SLOT_IS_READONLY = "is_readonly";
    private static final String SLOT_PRETTY_PRINT_SLOT_WIDGET_LABELS = "pretty_print_slot_widget_labels";
    private static final String CLASS_OPTIONS = "Options";
    private static final String SLOT_OPTIONS = "options";
    private static final String SLOT_OPTIONS_INSTANCE_NAME = "option_instance";
    private static final String SLOT_DISPLAY_HIDDEN_FRAMES = "display_hidden_classes";
    private static final String SLOT_DISPLAY_ABSTRACT_CLASS_ICON = "display_abstract_class_icon";
    private static final String SLOT_DISPLAY_MULTI_PARENT_CLASS_ICON = "display_multi_parent_class_icon";
    private static final String SLOT_DISPLAY_REMOVE_CONFIRMATION_DIALOG = "confirm_on_remove";
    private static final String SLOT_UPDATE_MODIFICATION_SLOTS = "update_modification_slots";
    private static final String SLOT_TABBED_INSTANCE_FORM_LAYOUT = "tabbed_instance_form_layout";
    private static final String SLOT_IS_UNDO_ENABLED = "undo_enabled";
    private static final String CLIENT_PROPERTY_ADD_NAME_ON_INSTANCE_FORM = "add_name_on_instance_form";
    private static final String CHANGE_TRACKING_ACTIVE = "change_tracking_active";
    private static final String SUPRESS_INSTANCE_COUNT_DISPLAY = "suppress_instance_counting";
    protected static final String CLASS_MAP = "Map";
    protected static final String SLOT_PROPERTY_MAP = "property_map";
    private static final String SLOT_PROPERTY_MAP_INSTANCE_NAME = "property_map_instance";
    private static final int WINDOW_OFFSET_PIXELS = 25;
    private URI _uri;
    private URI _loadingProjectURI;
    private KnowledgeBase _projectKB;
    private Instance _projectInstance;
    private KnowledgeBase _domainKB;
    private String _defaultClsWidgetClassName;
    private Map<Cls, WidgetDescriptor> _activeClsWidgetDescriptors = new HashMap<Cls, WidgetDescriptor>();
    private Map<Cls, ClsWidget> _cachedDesignTimeClsWidgets = new HashMap<Cls, ClsWidget>();
    private Map<Object, JFrame> _frames = new HashMap<Object, JFrame>();
    private Map<JFrame, Object> _objects = new HashMap<JFrame, Object>();
    private WidgetMapper _widgetMapper;
    private Tree<URI> projectURITree = new Tree();
    private URI activeRootURI;
    private Point _lastLocation;
    private ListenerCollection _listeners = new ListenerList(new ProjectEventDispatcher());
    private Boolean _displayHiddenClasses;
    private Boolean _displayAbstractClassIcon;
    private Boolean _displayMultiParentClassIcon;
    private Boolean _displayConfirmationOnRemove;
    private Boolean _isReadonly;
    private Boolean _updateModificationSlots;
    private Boolean prettyPrintSlotWidgetLabels;
    private Boolean _isUndoEnabled;
    private Map<Cls, BrowserSlotPattern> _includedBrowserSlotPatterns = new HashMap<Cls, BrowserSlotPattern>();
    private Map<Cls, BrowserSlotPattern> _directBrowserSlotPatterns = new HashMap<Cls, BrowserSlotPattern>();
    private Map<Cls, BrowserSlotPattern> _inheritedBrowserSlotPatterns = new HashMap<Cls, BrowserSlotPattern>();
    private Set<Frame> _hiddenFrames = new HashSet<Frame>();
    private Set<Frame> _includedHiddenFrames = new HashSet<Frame>();
    private boolean _hasChanged;
    private Collection<WidgetDescriptor> _tabWidgetDescriptors;
    private Map _clientInformation = new HashMap();
    private Map _includedClientInformation = new HashMap();
    private FrameCountsImpl _frameCounts = new FrameCountsImpl();
    private boolean isMultiUserServer;
    private Class _instanceDisplayClass;
    private Instance _includedClientInfoInstance;
    private WindowListener _closeListener = new WindowAdapter(){

        public void windowClosing(WindowEvent event) {
            JFrame frame = (JFrame)event.getWindow();
            frame.setVisible(false);
            Object o = Project.this._objects.remove(frame);
            Project.this._frames.remove(o);
            Project.this._objects.remove(frame);
            ComponentUtilities.dispose(frame);
            Application.repaint();
        }
    };
    private KnowledgeBaseListener _knowledgeBaseListener = new KnowledgeBaseAdapter(){

        public void clsDeleted(KnowledgeBaseEvent event) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("cls eleted for project " + this + " event = " + event);
            }
            Cls cls = event.getCls();
            Project.this._activeClsWidgetDescriptors.remove(cls);
            ClsWidget widget = (ClsWidget)Project.this._cachedDesignTimeClsWidgets.remove(cls);
            if (widget != null) {
                ComponentUtilities.dispose((Component)((Object)widget));
            }
            Project.this._directBrowserSlotPatterns.remove(cls);
            Project.this.removeInheritedBrowserSlotPattern(cls);
            if (!event.isReplacementEvent()) {
                Project.this.removeDisplay(cls);
            }
            Project.this._hiddenFrames.remove(cls);
        }

        public void frameReplaced(KnowledgeBaseEvent event) {
            Project.this.onFrameReplace(event.getFrame(), event.getNewFrame());
        }

        public void facetDeleted(KnowledgeBaseEvent event) {
            Frame facet = event.getFrame();
            if (!event.isReplacementEvent()) {
                Project.this.removeDisplay(facet);
            }
            Project.this._hiddenFrames.remove(facet);
        }

        public void slotDeleted(KnowledgeBaseEvent event) {
            Slot slot = (Slot)event.getFrame();
            if (!event.isReplacementEvent()) {
                Project.this.removeDisplay(slot);
            }
            Iterator i = Project.this._directBrowserSlotPatterns.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                BrowserSlotPattern pattern = (BrowserSlotPattern)entry.getValue();
                if (!pattern.contains(slot)) continue;
                i.remove();
            }
            Iterator j = Project.this._inheritedBrowserSlotPatterns.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry entry = j.next();
                BrowserSlotPattern pattern = (BrowserSlotPattern)entry.getValue();
                if (pattern == null || !pattern.contains(slot)) continue;
                j.remove();
            }
            Project.this._hiddenFrames.remove(slot);
        }

        public void instanceDeleted(KnowledgeBaseEvent event) {
            super.instanceDeleted(event);
            Frame frame = event.getFrame();
            if (!event.isReplacementEvent()) {
                Project.this.removeDisplay(frame);
            }
            Project.this._hiddenFrames.remove(frame);
        }
    };

    protected void onFrameReplace(Frame oldFrame, Frame newFrame) {
        try {
            if (oldFrame instanceof Cls) {
                BrowserSlotPattern bsp;
                ClsWidget widget;
                Cls oldCls = (Cls)oldFrame;
                WidgetDescriptor widgetDesc = this._activeClsWidgetDescriptors.get(oldCls);
                if (widgetDesc != null) {
                    widgetDesc.setName(newFrame.getName());
                }
                if ((widget = this._cachedDesignTimeClsWidgets.remove(oldCls)) != null) {
                    ComponentUtilities.dispose((Component)((Object)widget));
                }
                if ((bsp = this._directBrowserSlotPatterns.get(oldCls)) != null) {
                    this._directBrowserSlotPatterns.put((Cls)newFrame, bsp);
                }
                this._directBrowserSlotPatterns.remove(oldCls);
                BrowserSlotPattern ibsp = this._inheritedBrowserSlotPatterns.get(oldCls);
                if (ibsp != null) {
                    this._inheritedBrowserSlotPatterns.put((Cls)newFrame, ibsp);
                }
            } else if (oldFrame instanceof Slot) {
                Slot oldSlot = (Slot)oldFrame;
                for (Map.Entry<Cls, BrowserSlotPattern> entry : this._directBrowserSlotPatterns.entrySet()) {
                    BrowserSlotPattern pattern = entry.getValue();
                    if (!pattern.contains(oldSlot)) continue;
                    pattern.replaceSlot(oldSlot, (Slot)newFrame);
                }
                for (Map.Entry<Cls, BrowserSlotPattern> entry : this._inheritedBrowserSlotPatterns.entrySet()) {
                    BrowserSlotPattern pattern = entry.getValue();
                    if (pattern == null || !pattern.contains(oldSlot)) continue;
                    pattern.replaceSlot(oldSlot, (Slot)newFrame);
                }
            }
            if (this._hiddenFrames.contains(oldFrame)) {
                this._hiddenFrames.add(newFrame);
            }
            this._hiddenFrames.remove(oldFrame);
        }
        catch (Throwable t) {
            Log.getLogger().log(Level.WARNING, "Error at replacing project information (Old: " + oldFrame + " , New: " + newFrame + ")", t);
        }
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    protected Project(URI uri, KnowledgeBaseFactory factory, Collection errors, boolean createDomainKB) {
        this(uri, factory, errors, createDomainKB, false);
    }

    protected Project(URI uri, KnowledgeBaseFactory factory, Collection errors, boolean createDomainKB, boolean isMultiUserServer) {
        this.isMultiUserServer = isMultiUserServer;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Project " + uri + " multiserver = " + isMultiUserServer);
        }
        this.setProjectURI(uri);
        this._projectKB = Project.loadProjectKB(uri, factory, errors);
        if (this._projectKB != null) {
            this._projectInstance = Project.getProjectInstance(this._projectKB);
        }
        if (this._projectInstance != null && createDomainKB) {
            boolean load = uri != null;
            this.createDomainKnowledgeBase(factory, errors, load);
        }
        if (this._projectKB != null && errors.isEmpty()) {
            this.setupJournaling();
        }
        this.updateKBNames();
    }

    public Project(String projectString, Collection errors) {
        this(URIUtilities.createURI(projectString), errors);
    }

    private Project(URI uri, Collection errors) {
        this(uri, null, errors, true);
    }

    public void addJavaPackageName(String packageName) {
        this.addProjectSlotValue(SLOT_JAVA_PACKAGES, packageName);
        this._domainKB.addJavaLoadPackage(packageName);
    }

    public void addProjectListener(ProjectListener listener) {
        this._listeners.add(this, listener);
    }

    private void addProjectSlotValue(String slotName, Object value) {
        ModelUtilities.addOwnSlotValue(this._projectInstance, slotName, value);
    }

    public void clearCachedWidgets() {
        for (ClsWidget widget : this._cachedDesignTimeClsWidgets.values()) {
            ComponentUtilities.dispose((Component)((Object)widget));
        }
        this._cachedDesignTimeClsWidgets.clear();
    }

    public static Project createBuildProject(KnowledgeBaseFactory factory, Collection errors) {
        return new Project(null, factory, errors, false);
    }

    public static Project createBuildProject(KnowledgeBase kb, Collection errors) {
        Project p = new Project(null, null, errors, false);
        p._domainKB = kb;
        kb.setProject(p);
        return p;
    }

    private boolean createDomainKB(KnowledgeBaseFactory factory, Collection errors) {
        if (factory == null) {
            factory = this.getKnowledgeBaseFactory();
        }
        if (factory == null) {
            String errorMsg = "Cannot find knowledgebase factory: " + this.getSources().getString("factory_class_name") + "\nPlease check that you have the required plug-in.";
            errors.add(new MessageError(errorMsg));
            Log.getLogger().severe(errorMsg);
            return false;
        }
        this._domainKB = factory.createKnowledgeBase(errors);
        for (String name : this.getProjectSlotValues(SLOT_JAVA_PACKAGES)) {
            this._domainKB.addJavaLoadPackage(name);
        }
        this._domainKB.setProject(this);
        this._frameCounts.updateSystemFrameCounts(this._domainKB);
        this.setKnowledgeBaseFactory(factory);
        return true;
    }

    public void createDomainKnowledgeBase(KnowledgeBaseFactory factory, Collection errors, boolean load) {
        if (!this.createDomainKB(factory, errors)) {
            return;
        }
        if (load) {
            MergingNarrowFrameStore mnfs = MergingNarrowFrameStore.get(this._domainKB);
            if (mnfs != null) {
                mnfs.setQueryAllFrameStores(true);
            }
            Collection uris = this.loadIncludedProjects(this.getProjectURI(), this._projectInstance, errors);
            this.loadDomainKB(uris, errors);
            if (mnfs != null) {
                mnfs.setQueryAllFrameStores(false);
            }
        }
        this._domainKB.addKnowledgeBaseListener(this._knowledgeBaseListener);
        this.loadCachedKnowledgeBaseObjects(this._projectInstance);
        this._domainKB.setChanged(false);
        this._projectKB.setChanged(false);
    }

    protected JFrame createFrame(Cls cls, Slot slot) {
        InstanceDisplay d = this.createInstanceDisplay(this, false, false);
        d.setInstance(slot, cls);
        return this.createFrame(d, new FrameSlotCombination(cls, slot));
    }

    protected JFrame createFrame(Instance instance) {
        InstanceDisplay d = this.createInstanceDisplay(this, true, false);
        d.setInstance(instance);
        return this.createFrame(d, instance);
    }

    public void setInstanceDisplayClass(Class instanceDisplayClass) {
        this._instanceDisplayClass = instanceDisplayClass;
    }

    protected InstanceDisplay createInstanceDisplay(Project project, boolean showHeader, boolean showHeaderLabel) {
        InstanceDisplay instanceDisplay = this._instanceDisplayClass != null ? Project.createInstanceDisplaySubclass(this._instanceDisplayClass, project, showHeader, showHeaderLabel) : new InstanceDisplay(project, showHeader, showHeaderLabel);
        return instanceDisplay;
    }

    private static InstanceDisplay createInstanceDisplaySubclass(Class clas, Project project, boolean showHeader, boolean showHeaderLabel) {
        InstanceDisplay instanceDisplay = null;
        Class[] classes = new Class[]{Project.class, Boolean.TYPE, Boolean.TYPE};
        Object[] args = new Object[]{project, showHeader, showHeaderLabel};
        try {
            Constructor constructor = clas.getConstructor(classes);
            instanceDisplay = (InstanceDisplay)constructor.newInstance(args);
        }
        catch (Exception e) {
            Log.getLogger().warning(e.getMessage());
        }
        return instanceDisplay;
    }

    protected JFrame createFrame(InstanceDisplay display, Object o) {
        final JFrame frame = ComponentFactory.createFrame();
        frame.addWindowListener(this._closeListener);
        frame.getContentPane().add((Component)display, "Center");
        ComponentUtilities.pack(frame);
        display.setResizeVertically(true);
        ClsWidget widget = display.getFirstClsWidget();
        frame.setTitle(widget.getLabel());
        widget.addWidgetListener(new WidgetAdapter(){

            public void labelChanged(WidgetEvent event) {
                frame.setTitle(event.getWidget().getLabel());
            }
        });
        this.setLocation(frame);
        frame.setVisible(true);
        this._frames.put(o, frame);
        this._objects.put(frame, o);
        return frame;
    }

    public static Project createNewProject(KnowledgeBaseFactory factory, Collection errors) {
        return new Project(null, factory, errors, true);
    }

    private void createNewTabWidgetDescriptors(Collection names) {
        for (String name : names) {
            WidgetDescriptor d = WidgetDescriptor.create(this._projectKB);
            d.setWidgetClassName(name);
            d.setVisible(false);
            this._tabWidgetDescriptors.add(d);
        }
    }

    public ClsWidget createRuntimeClsWidget(Instance instance) {
        return this.createRuntimeClsWidget(instance, null);
    }

    public ClsWidget createRuntimeClsWidget(Instance instance, Cls associatedCls) {
        return this.createRuntimeClsWidget(instance.getDirectType(), instance, associatedCls);
    }

    public ClsWidget createRuntimeClsWidget(Cls type, Instance instance, Cls associatedCls) {
        ClsWidget widget;
        if (type == null) {
            Log.getLogger().severe("no direct type: " + instance.getName());
            widget = new UglyClsWidget();
        } else {
            ClsWidget designTimeWidget = this.getDesignTimeClsWidget(type);
            WidgetDescriptor d = designTimeWidget.getDescriptor();
            widget = WidgetUtilities.createClsWidget(d, false, this, type);
        }
        widget.setInstance(instance);
        if (associatedCls != null) {
            widget.setAssociatedCls(associatedCls);
        }
        this.postRuntimeClsWidgetCreatedEvent(widget);
        return widget;
    }

    @Deprecated
    public Widget createRuntimeWidget(Instance instance) {
        return this.createRuntimeClsWidget(instance);
    }

    public WidgetDescriptor createWidgetDescriptor() {
        return WidgetDescriptor.create(this._projectKB);
    }

    public WidgetDescriptor createWidgetDescriptor(Cls cls, Slot slot, Facet facet) {
        return this._widgetMapper.createWidgetDescriptor(cls, slot, facet);
    }

    public void dispose() {
        this.postProjectEvent(3);
        this.clearWidgets();
        if (this._domainKB != null) {
            try {
                this._domainKB.dispose();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Errors at disposing domain KB", t);
            }
        }
        if (this._projectKB != null) {
            try {
                this._projectKB.dispose();
            }
            catch (Throwable t) {
                log.log(Level.WARNING, "Errors at disposing project KB", t);
            }
        }
        this._domainKB = null;
        this._projectKB = null;
        this._projectInstance = null;
        this._activeClsWidgetDescriptors = null;
        this._cachedDesignTimeClsWidgets = null;
        this._frames = null;
        this._objects = null;
        this._directBrowserSlotPatterns = null;
        this._inheritedBrowserSlotPatterns = null;
        this._includedBrowserSlotPatterns = null;
        this._clientInformation = null;
        this._includedClientInformation = null;
        PropertyMapUtil.dispose();
    }

    private void clearWidgets() {
        if (this._cachedDesignTimeClsWidgets != null) {
            for (JComponent jComponent : this._cachedDesignTimeClsWidgets.values()) {
                ComponentUtilities.dispose(jComponent);
            }
            this._cachedDesignTimeClsWidgets.clear();
        }
    }

    private void flushProjectKBCache() {
        this.saveBrowserSlots();
        this.saveCustomizedWidgets();
        this.saveDefaultMetaclasses();
        this.saveHiddenFrameFlags();
        this.saveNextFrameNumber();
        this.saveClientInformation();
    }

    public Collection getAllKnowledgeBaseFactories() {
        ArrayList<Object> factories = new ArrayList<Object>();
        for (String name : this.getProjectSlotValues(SLOT_ALL_KNOWLEDGE_BASE_FACTORY_NAMES)) {
            factories.add(SystemUtilities.newInstance(name));
        }
        return factories;
    }

    @Deprecated
    public Slot getBrowserSlot(Cls cls) {
        return Project.getPatternSlot(this.getBrowserSlotPattern(cls));
    }

    public Collection getBrowserSlots(Cls cls) {
        return this.getBrowserSlotPattern(cls).getSlots();
    }

    public Collection<Cls> getClsesWithDirectBrowserSlots() {
        return this._directBrowserSlotPatterns.keySet();
    }

    public Collection<Cls> getClsesWithCustomizedForms() {
        return this._activeClsWidgetDescriptors.keySet();
    }

    public Collection<Frame> getHiddenFrames() {
        return new HashSet<Frame>(this._hiddenFrames);
    }

    public BrowserSlotPattern getBrowserSlotPattern(Cls cls) {
        BrowserSlotPattern slotPattern = this.getDirectBrowserSlotPattern(cls);
        if (slotPattern == null) {
            slotPattern = this.getInheritedBrowserSlotPattern(cls);
        }
        return slotPattern;
    }

    @Deprecated
    public Slot getInheritedBrowserSlot(Cls cls) {
        return Project.getPatternSlot(this.getInheritedBrowserSlotPattern(cls));
    }

    @Deprecated
    private static Slot getPatternSlot(BrowserSlotPattern pattern) {
        return pattern == null ? null : pattern.getFirstSlot();
    }

    public BrowserSlotPattern getInheritedBrowserSlotPattern(Cls cls) {
        BrowserSlotPattern slotPattern = this._inheritedBrowserSlotPatterns.get(cls);
        if (this._inheritedBrowserSlotPatterns.containsKey(cls)) {
            return slotPattern;
        }
        Iterator i = cls.getSuperclasses().iterator();
        while (i.hasNext() && slotPattern == null) {
            Cls superclass = (Cls)i.next();
            slotPattern = this.getDirectBrowserSlotPattern(superclass);
        }
        this._inheritedBrowserSlotPatterns.put(cls, slotPattern);
        return slotPattern;
    }

    public PropertyList getClsWidgetPropertyList(Cls cls) {
        ClsWidget widget = this.getDesignTimeClsWidget(cls);
        PropertyList list = widget.getDescriptor().getPropertyList();
        return list;
    }

    public String getDefaultWidgetClassName(Cls cls, Slot slot, Facet facet) {
        return this._widgetMapper.getDefaultWidgetClassName(cls, slot, facet);
    }

    public ClsWidget getDesignTimeClsWidget(Cls cls) {
        ClsWidget widget = this._cachedDesignTimeClsWidgets.get(cls);
        if (widget == null) {
            WidgetDescriptor d = this.getClsWidgetDescriptor(cls);
            widget = WidgetUtilities.createClsWidget(d, true, this, cls);
            this._cachedDesignTimeClsWidgets.put(cls, widget);
        }
        return widget;
    }

    @Deprecated
    public Slot getDirectBrowserSlot(Cls cls) {
        return Project.getPatternSlot(this.getDirectBrowserSlotPattern(cls));
    }

    public BrowserSlotPattern getDirectBrowserSlotPattern(Cls cls) {
        return this._directBrowserSlotPatterns.get(cls);
    }

    public boolean getDisplayAbstractClassIcon() {
        if (this._displayAbstractClassIcon == null) {
            this._displayAbstractClassIcon = this.loadOption(SLOT_DISPLAY_ABSTRACT_CLASS_ICON, true);
        }
        return this._displayAbstractClassIcon;
    }

    public boolean getDisplayConfirmationOnRemove() {
        if (this._displayConfirmationOnRemove == null) {
            this._displayConfirmationOnRemove = this.loadOption(SLOT_DISPLAY_REMOVE_CONFIRMATION_DIALOG, false);
        }
        return this._displayConfirmationOnRemove;
    }

    public boolean getDisplayHiddenClasses() {
        return this.getDisplayHiddenFrames();
    }

    public boolean getDisplayHiddenFrames() {
        if (this._displayHiddenClasses == null) {
            this._displayHiddenClasses = this.loadOption(SLOT_DISPLAY_HIDDEN_FRAMES, true);
        }
        return this._displayHiddenClasses;
    }

    public boolean getDisplayMultiParentClassIcon() {
        if (this._displayMultiParentClassIcon == null) {
            this._displayMultiParentClassIcon = this.loadOption(SLOT_DISPLAY_MULTI_PARENT_CLASS_ICON, true);
        }
        return this._displayMultiParentClassIcon;
    }

    private static void setIconImage(JFrame frame, Instance instance) {
        Icon icon = instance.getIcon();
        if (icon instanceof ImageIcon) {
            ImageIcon iconImage = (ImageIcon)icon;
            Image image = iconImage.getImage();
            frame.setIconImage(image);
        }
    }

    public Collection<URI> getIncludedProjects() {
        return this.projectURITree.getDescendents(this.projectURITree.getRoot());
    }

    public Tree<URI> getProjectTree() {
        return this.projectURITree.clone();
    }

    public void setDirectIncludedProjectURIs(Collection projectURIs) {
        ArrayList<String> uriStrings = new ArrayList<String>();
        for (URI includedURI : projectURIs) {
            URI relativeURI = URIUtilities.relativize(this._uri, includedURI);
            uriStrings.add(relativeURI.toString());
        }
        this.setProjectSlotValues(SLOT_INCLUDED_PROJECTS, uriStrings);
    }

    @Deprecated
    public Collection getDirectIncludedProjects() {
        ArrayList<String> paths = new ArrayList<String>();
        for (URI uri : this.getDirectIncludedProjectURIs()) {
            File file = new File(uri);
            paths.add(file.getPath());
        }
        return paths;
    }

    public Collection<URI> getDirectIncludedProjectURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String s : this.getProjectSlotValues(SLOT_INCLUDED_PROJECTS)) {
            URI uri = null;
            uri = URIUtilities.isURI(s) ? URIUtilities.createURI(s) : URIUtilities.resolve(this.getProjectURI(), s);
            uris.add(uri);
        }
        return uris;
    }

    public KnowledgeBase getInternalProjectKnowledgeBase() {
        return this._projectKB;
    }

    public URI getJournalURI() {
        URI uri = URIUtilities.replaceExtension(this._uri, ".pjrn");
        if (uri == null) {
            File dir = ApplicationProperties.getApplicationDirectory();
            File journal = new File(dir, "remote_project.pjrn");
            uri = journal.toURI();
        }
        return uri;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._domainKB;
    }

    public KnowledgeBaseFactory getKnowledgeBaseFactory() {
        String name = this.getSources().getString("factory_class_name");
        KnowledgeBaseFactory factory = name == null ? new ClipsKnowledgeBaseFactory() : (KnowledgeBaseFactory)SystemUtilities.newInstance(name);
        return factory;
    }

    public String getName() {
        return this.getProjectName();
    }

    public String getProjectName() {
        return URIUtilities.getBaseName(this._uri);
    }

    public Collection<JFrame> getOpenWindows() {
        return Collections.unmodifiableCollection(this._frames.values());
    }

    private boolean getOption(String slotName, boolean defaultValue) {
        Object b = Project.getOwnSlotValue(this.getOptionsInstance(), slotName);
        if (b != null && b instanceof Boolean) {
            return (Boolean)b;
        }
        return defaultValue;
    }

    private Instance getOptionsInstance() {
        Instance instance = (Instance)this.getProjectSlotValue(SLOT_OPTIONS);
        if (instance == null) {
            Cls optionsCls = this._projectKB.getCls(CLASS_OPTIONS);
            instance = this._projectKB.createInstance(SLOT_OPTIONS_INSTANCE_NAME, optionsCls);
            this.setProjectSlotValue(SLOT_OPTIONS, instance);
        }
        return instance;
    }

    protected static Object getOwnSlotValue(Frame frame, String slotName) {
        return ModelUtilities.getDirectOwnSlotValue(frame, slotName);
    }

    protected static Reader getProjectClsesReader() {
        Reader reader = Files.getSystemClsesReader();
        if (reader == null) {
            Log.getLogger().severe("Unable to read system ontology");
        }
        return reader;
    }

    public URI getProjectURI() {
        return this._uri;
    }

    public URI getProjectDirectoryURI() {
        return URIUtilities.getParentURI(this._uri);
    }

    @Deprecated
    public File getProjectDirectoryFile() {
        File projectFile = this.getProjectFile();
        return projectFile == null ? null : projectFile.getParentFile();
    }

    @Deprecated
    public File getProjectFile() {
        return this._uri == null ? null : new File(this._uri);
    }

    @Deprecated
    public String getProjectFilePath() {
        File file = this.getProjectFile();
        return file == null ? null : file.getPath();
    }

    public Instance getProjectInstance() {
        return this._projectInstance;
    }

    protected static Instance getProjectInstance(KnowledgeBase kb) {
        Instance result = null;
        Cls cls = kb.getCls(CLASS_PROJECT);
        if (cls == null) {
            Log.getLogger().severe("no project class");
        } else {
            Collection<Instance> instances = cls.getDirectInstances();
            result = CollectionUtilities.getFirstItem(instances);
        }
        if (result == null) {
            Log.getLogger().severe("no project instance");
        }
        return result;
    }

    protected static Reader getProjectInstancesReader(URI uri, KnowledgeBaseFactory factory, Collection errors) {
        String path;
        Reader reader = null;
        if (uri != null && (reader = URIUtilities.createBufferedReader(uri)) == null) {
            String message = "Unable to load project from: " + uri;
            errors.add(new MessageError(message));
            Log.getLogger().severe(message);
        }
        if (reader == null && factory != null && (path = factory.getProjectFilePath()) != null && (reader = FileUtilities.getResourceReader(factory.getClass(), path)) == null) {
            Log.getLogger().severe("Unable to read factory project: " + path);
        }
        if (reader == null && (reader = Files.getSystemInstancesReader()) == null) {
            Log.getLogger().severe("Unable to read system instances");
        }
        return reader;
    }

    private static Object getProjectSlotValue(Instance projectInstance, String slotName) {
        return ModelUtilities.getDirectOwnSlotValue(projectInstance, slotName);
    }

    private Object getProjectSlotValue(String slotName) {
        return Project.getProjectSlotValue(this._projectInstance, slotName);
    }

    private static Collection getProjectSlotValues(Instance projectInstance, String slotName) {
        return ModelUtilities.getDirectOwnSlotValues(projectInstance, slotName);
    }

    private Collection getProjectSlotValues(String slotName) {
        return Project.getProjectSlotValues(this._projectInstance, slotName);
    }

    private static PropertyList getPropertyList(Instance instance, String slotName) {
        PropertyList propertyList;
        Instance plInstance = (Instance)Project.getOwnSlotValue(instance, slotName);
        if (plInstance == null) {
            propertyList = PropertyList.create(instance.getKnowledgeBase());
            Project.setOwnSlotValue(instance, slotName, propertyList.getWrappedInstance());
        } else {
            propertyList = new PropertyList(plInstance);
        }
        return propertyList;
    }

    private PropertyList getPropertyList(String name) {
        return Project.getPropertyList(this._projectInstance, name);
    }

    public PropertyList getSources() {
        return new PropertyList((Instance)this.getProjectSlotValue(SLOT_SOURCES));
    }

    private static PropertyList getSources(Instance projectInstance) {
        return new PropertyList((Instance)Project.getProjectSlotValue(projectInstance, SLOT_SOURCES));
    }

    public Collection getSuitableWidgetClassNames(Cls cls, Slot slot, Facet facet) {
        return this._widgetMapper.getSuitableWidgetClassNames(cls, slot, facet);
    }

    public WidgetDescriptor getTabWidgetDescriptor(String widgetName) {
        WidgetDescriptor descriptor = null;
        for (WidgetDescriptor testDescriptor : this.getTabWidgetDescriptors()) {
            if (!testDescriptor.getWidgetClassName().equals(widgetName)) continue;
            descriptor = testDescriptor;
            break;
        }
        return descriptor;
    }

    public Collection<WidgetDescriptor> getTabWidgetDescriptors() {
        if (this._tabWidgetDescriptors == null) {
            HashSet<String> availableTabNames = new HashSet<String>(PluginUtilities.getAvailableTabWidgetClassNames());
            this._tabWidgetDescriptors = new ArrayList<WidgetDescriptor>();
            for (Instance instance : this.getProjectSlotValues(SLOT_TABS)) {
                boolean removed;
                WidgetDescriptor d = WidgetDescriptor.create(instance);
                String name = d.getWidgetClassName();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Project found tab plugin called " + name);
                }
                if (PluginUtilities.isLoadableClass(name)) {
                    this._tabWidgetDescriptors.add(d);
                }
                if ((removed = availableTabNames.remove(name)) || !log.isLoggable(Level.FINE)) continue;
                log.fine("tab " + name + " not in manifest");
            }
            this.createNewTabWidgetDescriptors(availableTabNames);
        }
        return this._tabWidgetDescriptors;
    }

    public boolean getUpdateModificationSlots() {
        if (this._updateModificationSlots == null) {
            this._updateModificationSlots = this.loadOption(SLOT_UPDATE_MODIFICATION_SLOTS, false);
        }
        return this._updateModificationSlots;
    }

    private boolean hasChanged() {
        return this._hasChanged;
    }

    public boolean hasCompleteSources() {
        boolean hasCompleteSources;
        KnowledgeBaseFactory factory = this.getKnowledgeBaseFactory();
        boolean bl = hasCompleteSources = this._uri != null && factory != null;
        if (hasCompleteSources) {
            hasCompleteSources = factory.isComplete(this.getSources());
        }
        return hasCompleteSources;
    }

    public boolean hasCustomizedDescriptor(Cls cls) {
        WidgetDescriptor d = this._activeClsWidgetDescriptors.get(cls);
        if (d != null && !d.isDirectlyCustomizedByUser()) {
            d = null;
        }
        return d != null;
    }

    public boolean hasIncludedProjects() {
        return !this.getIncludedProjects().isEmpty();
    }

    private void includeDomainKB(Instance projectInstance, String name, Collection uris, Collection errors) {
        String factoryName = Project.getSources(projectInstance).getString("factory_class_name");
        if (factoryName == null) {
            Log.getLogger().warning("Unable to load prj:" + name);
            return;
        }
        KnowledgeBaseFactory factory = (KnowledgeBaseFactory)SystemUtilities.newInstance(factoryName);
        PropertyList sources = Project.getSources(projectInstance);
        if (factory instanceof KnowledgeBaseFactory2) {
            NarrowFrameStore nfs = ((KnowledgeBaseFactory2)factory).createNarrowFrameStore(name);
            MergingNarrowFrameStore mergingFrameStore = this.getMergingFrameStore();
            mergingFrameStore.addActiveFrameStore(nfs, uris);
        }
        factory.includeKnowledgeBase(this._domainKB, sources, errors);
    }

    public void includeProject(String path, Collection errors) {
        this.includeProject(URIUtilities.createURI(path), errors);
    }

    public void includeProject(URI uri, Collection errors) {
        this.includeProject(uri, true, errors);
    }

    public void includeProject(URI uri, boolean doLoad, Collection errors) {
        if (doLoad) {
            this.loadIncludedProject(this.getProjectURI(), uri, errors);
        }
        this.recordIncludedProject(uri);
    }

    public boolean isDirty() {
        return Project.hasChanged(this._domainKB) || Project.hasChanged(this._projectKB) || this.hasChanged();
    }

    private static boolean hasChanged(KnowledgeBase kb) {
        return kb != null && kb.hasChanged();
    }

    public boolean isHidden(Frame frame) {
        return this._hiddenFrames.contains(frame);
    }

    private boolean isAlreadyIncluded(URI uri) {
        return this.projectURITree.isReachable(uri);
    }

    private boolean isIncludedBrowserSlotPattern(Cls cls, BrowserSlotPattern slotPattern) {
        return Project.equals(this._includedBrowserSlotPatterns.get(cls), slotPattern);
    }

    public boolean isJournalingEnabled() {
        Boolean b = (Boolean)this.getProjectSlotValue(SLOT_JOURNALING_ENABLED);
        return b == null ? false : b;
    }

    public boolean isReadonly() {
        if (this._isReadonly == null) {
            this._isReadonly = this.isMultiUserClient() ? Boolean.valueOf(!RemoteClientFrameStore.isOperationAllowed(this.getKnowledgeBase(), MetaProjectConstants.OPERATION_WRITE)) : this.loadOption(SLOT_IS_READONLY, false);
        }
        return this._isReadonly;
    }

    public boolean isSuitableWidget(Cls cls, Slot slot, Facet facet, WidgetDescriptor d) {
        return this._widgetMapper.isSuitableWidget(cls, slot, facet, d);
    }

    public void loadBrowserSlots(Instance projectInstance) {
        PropertyList browserSlots = Project.getPropertyList(projectInstance, SLOT_BROWSER_SLOTS);
        for (String clsName : browserSlots.getNames()) {
            if (clsName == null) {
                Log.getLogger().warning("null class name");
                continue;
            }
            Cls cls = this._domainKB.getCls(clsName);
            String patternText = browserSlots.getString(clsName);
            BrowserSlotPattern slotPattern = BrowserSlotPattern.createFromSerialization(this._domainKB, patternText);
            if (cls != null && slotPattern != null) {
                this.recordDirectBrowserSlotPattern(cls, slotPattern);
                if (!this.isIncluded(projectInstance)) continue;
                this._includedBrowserSlotPatterns.put(cls, slotPattern);
                if (!this.isMultiUserServer()) continue;
                this.copyIncludedBrowserSlot(projectInstance, clsName, patternText);
                continue;
            }
            browserSlots.remove(clsName);
        }
        Slot nameSlot = this._domainKB.getSlot(":NAME");
        Cls rootMetaCls = this._domainKB.getCls(":META-CLASS");
        if (rootMetaCls == null) {
            Cls classCls = this._domainKB.getCls(":CLASS");
            this.recordDirectBrowserSlotPattern(classCls, new BrowserSlotPattern(nameSlot));
            Cls slotCls = this._domainKB.getCls(":SLOT");
            this.recordDirectBrowserSlotPattern(slotCls, new BrowserSlotPattern(nameSlot));
        } else {
            this.recordDirectBrowserSlotPattern(rootMetaCls, new BrowserSlotPattern(nameSlot));
        }
    }

    private void copyIncludedBrowserSlot(Instance projectInstance, String clsName, String patternText) {
        PropertyList browserSlots = Project.getPropertyList(this._projectInstance, SLOT_BROWSER_SLOTS);
        browserSlots.setString(clsName, patternText);
    }

    private void loadCachedKnowledgeBaseObjects(Instance projectInstance) {
        this.loadClientInformation(projectInstance);
        this.loadNextFrameNumber(projectInstance);
        this.loadWidgetMapper(projectInstance);
        this.loadWidgetDescriptors(projectInstance);
        this.loadBrowserSlots(projectInstance);
        this.loadDefaultMetaclasses(projectInstance);
        this.loadHiddenFrameFlags(projectInstance);
        this._defaultClsWidgetClassName = (String)Project.getProjectSlotValue(projectInstance, SLOT_DEFAULT_INSTANCE_WIDGET_CLASS_NAME);
        this._domainKB.setModificationRecordUpdatingEnabled(this.getUpdateModificationSlots());
    }

    public void setDefaultClsWidgetClassName(String s) {
        this._defaultClsWidgetClassName = s;
        this.setProjectSlotValue(SLOT_DEFAULT_INSTANCE_WIDGET_CLASS_NAME, s);
    }

    private void loadDefaultMetaclasses(Instance projectInstance) {
        Cls facetMetaCls;
        String facetClsName;
        Cls slotMetaCls;
        String slotClsName;
        Cls clsMetaCls;
        String clsClsName = (String)Project.getProjectSlotValue(projectInstance, SLOT_DEFAULT_CLS_METACLASS);
        if (clsClsName != null && !clsClsName.equals(":STANDARD-CLASS") && (clsMetaCls = this._domainKB.getCls(clsClsName)) != null) {
            this._domainKB.setDefaultClsMetaCls(clsMetaCls);
        }
        if ((slotClsName = (String)Project.getProjectSlotValue(projectInstance, SLOT_DEFAULT_SLOT_METACLASS)) != null && !slotClsName.equals(":STANDARD-SLOT") && (slotMetaCls = this._domainKB.getCls(slotClsName)) != null) {
            this._domainKB.setDefaultSlotMetaCls(slotMetaCls);
        }
        if ((facetClsName = (String)Project.getProjectSlotValue(projectInstance, SLOT_DEFAULT_FACET_METACLASS)) != null && !facetClsName.equals(":STANDARD-FACET") && (facetMetaCls = this._domainKB.getCls(facetClsName)) != null) {
            this._domainKB.setDefaultFacetMetaCls(facetMetaCls);
        }
    }

    private void loadDomainKB(Collection uris, Collection errors) {
        KnowledgeBaseFactory factory = this.getKnowledgeBaseFactory();
        if (factory != null) {
            this._frameCounts.updateIncludedFrameCounts(this._domainKB);
            boolean enabled = this._domainKB.setGenerateEventsEnabled(false);
            if (factory instanceof KnowledgeBaseFactory2) {
                URI uri = this.getProjectURI();
                String name = uri == null ? "<new>" : uri.toString();
                NarrowFrameStore nfs = ((KnowledgeBaseFactory2)factory).createNarrowFrameStore(name);
                MergingNarrowFrameStore mergingFrameStore = this.getMergingFrameStore();
                mergingFrameStore.addActiveFrameStore(nfs, uris);
            }
            factory.loadKnowledgeBase(this._domainKB, this.getSources(), errors);
            this._domainKB.setGenerateEventsEnabled(enabled);
        }
    }

    private void loadHiddenFrameFlags(Instance projectInstance) {
        for (String name : Project.getProjectSlotValues(projectInstance, SLOT_HIDDEN_FRAMES)) {
            Frame frame = this._domainKB.getFrame(name);
            if (frame == null) continue;
            this.recordHidden(frame, true);
            if (!this.isIncluded(projectInstance)) continue;
            this._includedHiddenFrames.add(frame);
            if (!this.isMultiUserServer()) continue;
            this.copyIncludedHiddenFrameFlag(projectInstance, name);
        }
    }

    private void copyIncludedHiddenFrameFlag(Instance projectInstance, String includedFrameName) {
        this.addProjectSlotValue(SLOT_HIDDEN_FRAMES, includedFrameName);
    }

    private boolean isIncluded(Instance projectInstance) {
        return this._projectInstance != projectInstance;
    }

    public URI getLoadingURI() {
        return this._loadingProjectURI == null ? this.getProjectURI() : this._loadingProjectURI;
    }

    private void loadIncludedProject(URI includingURI, URI includedURI, Collection errors) {
        KnowledgeBase kb;
        includedURI = URIUtilities.normalize(includedURI);
        boolean alreadyIncluded = this.isAlreadyIncluded(includedURI);
        this.projectURITree.addChild(includingURI, includedURI);
        if (!alreadyIncluded && (kb = Project.loadProjectKB(includedURI, null, errors)) != null) {
            URI oldLoadingProjectURI = this._loadingProjectURI;
            this._loadingProjectURI = includedURI;
            kb.setName(URIUtilities.getName(includedURI));
            Instance projectInstance = Project.getProjectInstance(kb);
            Collection includedProjectURIs = this.loadIncludedProjects(includedURI, projectInstance, errors);
            this.includeDomainKB(projectInstance, includedURI.toString(), includedProjectURIs, errors);
            this.loadCachedKnowledgeBaseObjects(projectInstance);
            this._loadingProjectURI = oldLoadingProjectURI;
        }
    }

    public Collection loadIncludedProjects(URI projectURI, Instance projectInstance, Collection errors) {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        for (String name : Project.getProjectSlotValues(projectInstance, SLOT_INCLUDED_PROJECTS)) {
            URI uri = this._uri == null ? URIUtilities.createURI(name) : (URIUtilities.isURI(name) ? URIUtilities.createURI(name) : URIUtilities.resolve(projectURI, name));
            this.loadIncludedProject(projectURI, uri, errors);
            uris.add(uri);
        }
        return uris;
    }

    private void loadNextFrameNumber(Instance projectInstance) {
        Integer i = (Integer)this.getProjectSlotValue(SLOT_NEXT_FRAME_NUMBER);
        int number = i == null ? ApplicationProperties.getOldNextFrameNumber() : i;
        int nextFrameNumber = Math.max(this._domainKB.getNextFrameNumber(), number);
        this._domainKB.setNextFrameNumber(nextFrameNumber);
    }

    private Boolean loadOption(String name, boolean defaultValue) {
        boolean b = this.getOption(name, defaultValue);
        return b;
    }

    public static Project loadProjectFromURI(URI uri, Collection errors) {
        return new Project(uri, null, errors, true);
    }

    public static Project loadProjectFromURI(URI uri, Collection errors, boolean isMultiUserServer) {
        return new Project(uri, null, errors, true, isMultiUserServer);
    }

    public static Project loadProjectFromFile(String fileName, Collection errors) {
        return Project.loadProjectFromURI(new File(fileName).toURI(), errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static KnowledgeBase loadProjectKB(URI uri, KnowledgeBaseFactory factory, Collection errors) {
        Reader instancesReader;
        Reader clsesReader;
        KnowledgeBase kb;
        block6: {
            kb = null;
            clsesReader = null;
            instancesReader = null;
            try {
                clsesReader = Project.getProjectClsesReader();
                instancesReader = Project.getProjectInstancesReader(uri, factory, errors);
                if (instancesReader == null) {
                    String message = "Unable to open project file: " + uri;
                    errors.add(new MessageError(message));
                    Log.getLogger().severe(message);
                    break block6;
                }
                ClipsKnowledgeBaseFactory clipsFactory = new ClipsKnowledgeBaseFactory();
                kb = clipsFactory.createKnowledgeBase(errors);
                kb.setGenerateEventsEnabled(false);
                clipsFactory.loadKnowledgeBase(kb, clsesReader, instancesReader, false, errors);
                if (errors.size() == 0) {
                    ProjectFixupsPluginManager.fixProject(kb);
                }
                Project.removeUnreferencedInstances(kb);
                kb.setGenerateEventsEnabled(false);
                kb.setDispatchEventsEnabled(false);
            }
            catch (Exception e) {
                try {
                    errors.add(new MessageError(e));
                    Log.getLogger().log(Level.SEVERE, "Error loading project kb", e);
                }
                catch (Throwable throwable) {
                    FileUtilities.close(clsesReader);
                    FileUtilities.close(instancesReader);
                    throw throwable;
                }
                FileUtilities.close(clsesReader);
                FileUtilities.close(instancesReader);
            }
        }
        FileUtilities.close(clsesReader);
        FileUtilities.close(instancesReader);
        return kb;
    }

    private void loadClientInformation(Instance projectInstance) {
        Map clientInfoMap = this.getClientInfoMap(projectInstance);
        if (this.isIncluded(projectInstance)) {
            this._includedClientInformation.putAll(clientInfoMap);
        }
        this._clientInformation.putAll(clientInfoMap);
        if (!this.isIncluded(projectInstance)) {
            PropertyMapUtil.store(this._clientInformation, this.getClientInfoInstance(projectInstance));
            Cls cls = projectInstance.getKnowledgeBase().getCls(CLASS_MAP);
            this._includedClientInfoInstance = projectInstance.getKnowledgeBase().createInstance(null, cls);
            PropertyMapUtil.store(this._includedClientInformation, this._includedClientInfoInstance);
        }
    }

    private Instance getClientInfoInstance(Instance projectInstance) {
        Instance clientInfoInstance = (Instance)Project.getOwnSlotValue(projectInstance, SLOT_PROPERTY_MAP);
        if (clientInfoInstance == null) {
            Cls cls = projectInstance.getKnowledgeBase().getCls(CLASS_MAP);
            clientInfoInstance = projectInstance.getKnowledgeBase().createInstance(null, cls);
            ModelUtilities.addOwnSlotValue(projectInstance, SLOT_PROPERTY_MAP, clientInfoInstance);
        }
        return clientInfoInstance;
    }

    private Map getClientInfoMap(Instance projectInstance) {
        Instance clientInfoInstance = (Instance)Project.getOwnSlotValue(projectInstance, SLOT_PROPERTY_MAP);
        if (clientInfoInstance == null) {
            return new HashMap();
        }
        return PropertyMapUtil.load(clientInfoInstance, this._domainKB);
    }

    protected static void copyClientInformation(KnowledgeBase sourceKb, KnowledgeBase targetKb, KnowledgeBase domainKb, boolean appendInfo) {
        Instance sourceProjectInstance = Project.getProjectInstance(sourceKb);
        Instance sourceClientInfoInstance = (Instance)Project.getOwnSlotValue(sourceProjectInstance, SLOT_PROPERTY_MAP);
        Map clientInformation = PropertyMapUtil.load(sourceClientInfoInstance, domainKb);
        Instance targetProjectInstance = Project.getProjectInstance(targetKb);
        Instance targetClientInfoInstance = (Instance)Project.getOwnSlotValue(targetProjectInstance, SLOT_PROPERTY_MAP);
        if (targetClientInfoInstance != null) {
            if (appendInfo) {
                Map targetClientInformation = PropertyMapUtil.load(targetClientInfoInstance, domainKb);
                clientInformation.putAll(targetClientInformation);
            }
            targetClientInfoInstance.delete();
        }
        Cls cls = targetKb.getCls(CLASS_MAP);
        targetClientInfoInstance = targetKb.createInstance(null, cls);
        ModelUtilities.addOwnSlotValue(targetProjectInstance, SLOT_PROPERTY_MAP, targetClientInfoInstance);
        PropertyMapUtil.store(clientInformation, targetClientInfoInstance);
    }

    private void loadWidgetDescriptors(Instance projectInstance) {
        for (Instance instance : new ArrayList(Project.getProjectSlotValues(projectInstance, SLOT_CUSTOMIZED_INSTANCE_WIDGETS))) {
            WidgetDescriptor d;
            if (this.isIncluded(projectInstance)) {
                Instance includingInstance = (Instance)instance.deepCopy(this._projectKB, null);
                if (this.isMultiUserServer()) {
                    this._projectInstance.addOwnSlotValue(this._projectKB.getSlot(SLOT_CUSTOMIZED_INSTANCE_WIDGETS), includingInstance);
                }
                instance = includingInstance;
            }
            if ((d = WidgetDescriptor.create(instance)) == null) {
                Log.getLogger().severe("Invalid widget instance: " + instance);
                this.removeProjectSlotValue(SLOT_CUSTOMIZED_INSTANCE_WIDGETS, instance);
                continue;
            }
            Cls cls = this._domainKB.getCls(d.getName());
            if (cls == null) {
                Log.getLogger().warning("Unknown class: " + d.getName());
                this.removeProjectSlotValue(SLOT_CUSTOMIZED_INSTANCE_WIDGETS, instance);
                continue;
            }
            if (this.isIncluded(projectInstance)) {
                d.setIncluded(true);
            }
            d.setDirectlyCustomizedByUser(true);
            WidgetDescriptor existingDescriptor = this._activeClsWidgetDescriptors.get(cls);
            if (existingDescriptor != null && !existingDescriptor.isIncluded()) continue;
            this._activeClsWidgetDescriptors.put(cls, d);
        }
    }

    private void loadWidgetMapper(Instance projectInstance) {
        if (this._widgetMapper == null) {
            this._widgetMapper = new DefaultWidgetMapper(this._projectKB);
        }
    }

    public void setWidgetMapper(WidgetMapper mapper) {
        this._widgetMapper = mapper;
    }

    public WidgetMapper getWidgetMapper() {
        return this._widgetMapper;
    }

    private void makeTemporaryWidgetsIncluded(boolean b) {
        for (WidgetDescriptor d : this._activeClsWidgetDescriptors.values()) {
            if (!d.isTemporary()) continue;
            d.setIncluded(b);
        }
    }

    private void mergeIncludedFrames() {
        for (Frame frame : this._domainKB.getFrames()) {
            if (frame.isSystem()) continue;
            frame.setIncluded(false);
        }
    }

    public void mergeIncludedProjects() {
        this.mergeIncludedFrames();
        this.removeIncludedProjectReferences();
    }

    private void postRuntimeClsWidgetCreatedEvent(ClsWidget widget) {
        this.postProjectEvent(4, widget);
    }

    public void postFormChangeEvent(Cls cls) {
        ClsWidget widget = this.getDesignTimeClsWidget(cls);
        this.postProjectEvent(1, widget);
    }

    public void postFormChangeEvent(WidgetDescriptor d) {
        Cls cls = this.getKnowledgeBase().getCls(d.getName());
        this.postFormChangeEvent(cls);
    }

    public void postProjectEvent(int type) {
        this.postProjectEvent(type, null);
    }

    public void postProjectEvent(int type, ClsWidget widget) {
        this._listeners.postEvent(this, type, widget);
    }

    private void removeInheritedBrowserSlotPattern(Cls cls) {
        this._inheritedBrowserSlotPatterns.remove(cls);
        Iterator<Cls> iterator = this._inheritedBrowserSlotPatterns.keySet().iterator();
        while (iterator.hasNext()) {
            Cls scls = iterator.next();
            if (!scls.hasSuperclass(cls)) continue;
            iterator.remove();
        }
    }

    private void recordDirectBrowserSlotPattern(Cls cls, BrowserSlotPattern slotPattern) {
        Assert.assertNotNull("class", cls);
        if (slotPattern == null) {
            this._directBrowserSlotPatterns.remove(cls);
        } else {
            this._directBrowserSlotPatterns.put(cls, slotPattern);
        }
        this.removeInheritedBrowserSlotPattern(cls);
    }

    private void recordHidden(Frame frame, boolean hidden) {
        if (hidden) {
            this._hiddenFrames.add(frame);
        } else if (this._includedHiddenFrames.contains(frame)) {
            Log.getLogger().warning("Cannot 'unhide' an included hidden frame");
        } else {
            this._hiddenFrames.remove(frame);
        }
    }

    private void recordIncludedProject(URI name) {
        if (this._uri != null) {
            name = URIUtilities.relativize(this._uri, name);
        }
        this.addProjectSlotValue(SLOT_INCLUDED_PROJECTS, name.toString());
    }

    private void removeDisplay(Frame frame) {
        JFrame jframe = this._frames.get(frame);
        if (jframe != null) {
            ComponentUtilities.closeWindow(jframe);
        }
    }

    public void removeIncludedProjectReferences() {
        HashMap<Cls, BrowserSlotPattern> browserSlots = new HashMap<Cls, BrowserSlotPattern>();
        browserSlots.putAll(this._includedBrowserSlotPatterns);
        browserSlots.putAll(this._directBrowserSlotPatterns);
        this._directBrowserSlotPatterns = browserSlots;
        this._includedBrowserSlotPatterns.clear();
        for (WidgetDescriptor d : this._activeClsWidgetDescriptors.values()) {
            if (!d.isIncluded()) continue;
            d.setIncluded(false);
        }
        this.projectURITree = new Tree<URI>(this.getProjectURI());
        this.setProjectSlotValue(SLOT_INCLUDED_PROJECTS, null);
        this._hiddenFrames.addAll(this._includedHiddenFrames);
        this._includedHiddenFrames.clear();
    }

    public void removeJavaPackageName(String packageName) {
        this.removeProjectSlotValue(SLOT_JAVA_PACKAGES, packageName);
        this._domainKB.removeJavaLoadPackage(packageName);
    }

    public void removeProjectListener(ProjectListener listener) {
        this._listeners.remove(this, listener);
    }

    private void removeProjectSlotValue(String slotName, Object value) {
        ModelUtilities.removeOwnSlotValue(this._projectInstance, slotName, value);
    }

    protected static void removeUnreferencedInstances(KnowledgeBase kb) {
        if (!Project.isNewProject(kb)) {
            Instance projectInstance = Project.getProjectInstance(kb);
            Collection<Instance> roots = CollectionUtilities.createCollection(projectInstance);
            for (Instance instance : kb.getUnreachableSimpleInstances(roots)) {
                if (!instance.isEditable()) continue;
                kb.deleteInstance(instance);
            }
        }
    }

    public static boolean isNewProject(KnowledgeBase kb) {
        return kb.getBuildString() == null;
    }

    public void save(Collection errors) {
        this.saveDomainKB(errors);
        if (errors.isEmpty()) {
            this.flushProjectKBCache();
            this.makeTemporaryWidgetsIncluded(true);
            this.saveProjectKB(errors);
            this.makeTemporaryWidgetsIncluded(false);
        }
        if (errors.isEmpty()) {
            this.clearIsDirty();
            this.postProjectEvent(2);
        }
    }

    public void clearIsDirty() {
        this._projectKB.setChanged(false);
        this._domainKB.setChanged(false);
        this.setChanged(false);
    }

    private void saveBrowserSlots() {
        PropertyList browserSlots = this.getPropertyList(SLOT_BROWSER_SLOTS);
        browserSlots.clear();
        for (Map.Entry<Cls, BrowserSlotPattern> entry : this._directBrowserSlotPatterns.entrySet()) {
            BrowserSlotPattern slotPattern;
            Cls cls = entry.getKey();
            if (this.isIncludedBrowserSlotPattern(cls, slotPattern = entry.getValue())) continue;
            browserSlots.setString(cls.getName(), slotPattern.getSerialization());
        }
    }

    private void saveCustomizedWidgets() {
        this.setProjectSlotValue(SLOT_CUSTOMIZED_INSTANCE_WIDGETS, null);
        for (WidgetDescriptor d : this._activeClsWidgetDescriptors.values()) {
            if (d.isTemporary() || d.isIncluded()) continue;
            this.addProjectSlotValue(SLOT_CUSTOMIZED_INSTANCE_WIDGETS, d.getInstance());
        }
    }

    private void saveDefaultMetaclasses() {
        this.setProjectSlotValue(SLOT_DEFAULT_CLS_METACLASS, Project.getName(this._domainKB.getDefaultClsMetaCls()));
        this.setProjectSlotValue(SLOT_DEFAULT_SLOT_METACLASS, Project.getName(this._domainKB.getDefaultSlotMetaCls()));
        this.setProjectSlotValue(SLOT_DEFAULT_FACET_METACLASS, Project.getName(this._domainKB.getDefaultFacetMetaCls()));
    }

    private static String getName(Cls cls) {
        return cls == null ? null : cls.getName();
    }

    private void saveDomainKB(Collection errors) {
        KnowledgeBaseFactory factory = this.getKnowledgeBaseFactory();
        if (factory != null) {
            factory.saveKnowledgeBase(this._domainKB, this.getSources(), errors);
        }
    }

    private void saveHiddenFrameFlags() {
        ArrayList<String> hiddenFrames = new ArrayList<String>();
        for (Frame frame : this._hiddenFrames) {
            if (this._includedHiddenFrames.contains(frame)) continue;
            String name = frame.getName();
            if (name == null) {
                Log.getLogger().warning("Ignoring nameless frame: " + frame);
                continue;
            }
            hiddenFrames.add(name);
        }
        this.setProjectSlotValues(SLOT_HIDDEN_FRAMES, hiddenFrames);
    }

    private void saveNextFrameNumber() {
        int number = this._domainKB.getNextFrameNumber();
        this.setProjectSlotValue(SLOT_NEXT_FRAME_NUMBER, new Integer(number));
    }

    private void saveProjectKB(Collection errors) {
        if (this._uri == null) {
            return;
        }
        String s = new File(this._uri).toString();
        new ClipsKnowledgeBaseFactory().saveKnowledgeBase(this._projectKB, null, s, errors);
    }

    private void saveClientInformation() {
        if (!this._clientInformation.isEmpty()) {
            Instance propertyMapInstance = (Instance)Project.getOwnSlotValue(this._projectInstance, SLOT_PROPERTY_MAP);
            if (propertyMapInstance == null) {
                Cls cls = this._projectKB.getCls(CLASS_MAP);
                propertyMapInstance = this._projectKB.createInstance(SLOT_PROPERTY_MAP_INSTANCE_NAME, cls);
                ModelUtilities.addOwnSlotValue(this._projectInstance, SLOT_PROPERTY_MAP, propertyMapInstance);
            }
            HashMap copyClientInfo = new HashMap();
            copyClientInfo.putAll(this._clientInformation);
            this._includedClientInformation = PropertyMapUtil.load(this._includedClientInfoInstance, this._domainKB);
            Iterator iterator = copyClientInfo.keySet().iterator();
            while (iterator.hasNext()) {
                Object includedValue;
                Object key = iterator.next();
                Object value = copyClientInfo.get(key);
                if (value == null || (includedValue = this._includedClientInformation.get(key)) == null || !value.equals(includedValue)) continue;
                iterator.remove();
            }
            PropertyMapUtil.store(copyClientInfo, propertyMapInstance);
        }
    }

    private void saveTabWidgetInstances() {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (WidgetDescriptor d : this._tabWidgetDescriptors) {
            String clsName = d.getWidgetClassName();
            if (SystemUtilities.forName(clsName) == null) continue;
            instances.add(d.getInstance());
        }
        this.setProjectSlotValues(SLOT_TABS, instances);
    }

    private void setChanged(boolean b) {
        this._hasChanged = b;
    }

    void setDirectBrowserSlotPattern(Cls cls, BrowserSlotPattern slotPattern) {
        this.recordDirectBrowserSlotPattern(cls, slotPattern);
        this.setChanged(true);
    }

    public void setDisplayAbstractClassIcon(boolean b) {
        this._displayAbstractClassIcon = b;
        this.setOption(SLOT_DISPLAY_ABSTRACT_CLASS_ICON, b);
    }

    public void setDisplayConfirmationOnRemove(boolean b) {
        this._displayConfirmationOnRemove = b;
        this.setOption(SLOT_DISPLAY_REMOVE_CONFIRMATION_DIALOG, b);
    }

    public void setDisplayHiddenFrames(boolean b) {
        this._displayHiddenClasses = b;
        this.setOption(SLOT_DISPLAY_HIDDEN_FRAMES, b);
    }

    public void setDisplayHiddenClasses(boolean b) {
        this.setDisplayHiddenFrames(b);
    }

    public void setDisplayMultiParentClassIcon(boolean b) {
        this._displayMultiParentClassIcon = b;
        this.setOption(SLOT_DISPLAY_MULTI_PARENT_CLASS_ICON, b);
    }

    public void setHidden(Frame frame, boolean hidden) {
        this.recordHidden(frame, hidden);
        this.setChanged(true);
    }

    public void setIsReadonly(boolean b) {
        this._isReadonly = b;
        this.setOption(SLOT_IS_READONLY, b);
    }

    public void setJournalingEnabled(boolean enable) {
        this.setProjectSlotValue(SLOT_JOURNALING_ENABLED, enable);
        if (enable) {
            this._domainKB.startJournaling(this.getJournalURI());
        } else {
            this._domainKB.stopJournaling();
        }
    }

    public void setKnowledgeBaseFactory(KnowledgeBaseFactory factory) {
        Assert.assertNotNull("factory", factory);
        this.getSources().setString("factory_class_name", factory.getClass().getName());
    }

    private void setLocation(Window window) {
        if (this._lastLocation == null) {
            ComponentUtilities.center(window);
            this._lastLocation = window.getLocation();
        } else {
            this._lastLocation.x += 25;
            this._lastLocation.y += 25;
            Dimension screenSize = window.getToolkit().getScreenSize();
            if (this._lastLocation.x + window.getWidth() > screenSize.width || this._lastLocation.y + window.getHeight() > screenSize.height) {
                this._lastLocation = new Point();
            }
            window.setLocation(this._lastLocation);
        }
    }

    private void setOption(String slotName, boolean value) {
        ModelUtilities.setOwnSlotValue(this.getOptionsInstance(), slotName, value);
    }

    private static void setOwnSlotValue(Frame frame, String slotName, Object value) {
        ModelUtilities.setOwnSlotValue(frame, slotName, value);
    }

    public void setProjectFilePath(String s) {
        this.setProjectURI(URIUtilities.createURI(s));
    }

    public void setProjectURI(URI uri) {
        if (this._uri != null) {
            this.updateDirectIncludedProjectURIs(uri);
        }
        this._uri = URIUtilities.normalize(uri);
        this.updateKBNames();
        this.updateJournaling();
        this.projectURITree.swapNode(this.projectURITree.getRoot(), uri);
        if (uri != null) {
            this.setActiveFrameStoreName(uri);
        }
        this.activeRootURI = uri;
    }

    private MergingNarrowFrameStore getMergingFrameStore() {
        return MergingNarrowFrameStore.get(this._domainKB);
    }

    private void setActiveFrameStoreName(URI uri) {
        MergingNarrowFrameStore nfs;
        if (uri != null && (nfs = this.getMergingFrameStore()) != null) {
            nfs.getActiveFrameStore().setName(uri.toString());
        }
    }

    private void setActiveFrameStore(URI uri) {
        MergingNarrowFrameStore nfs;
        if (uri != null && (nfs = this.getMergingFrameStore()) != null) {
            nfs.setActiveFrameStore(uri.toString());
        }
    }

    public URI getActiveRootURI() {
        return this.activeRootURI;
    }

    public void setActiveRootURI(URI uri) {
        this.activeRootURI = uri = URIUtilities.normalize(uri);
        this.setActiveFrameStore(uri);
        this._domainKB.flushCache();
    }

    private void updateDirectIncludedProjectURIs(URI newBaseURI) {
        ArrayList<String> relativeURIs = new ArrayList<String>();
        for (URI includedURI : this.getDirectIncludedProjectURIs()) {
            URI relativeURI = URIUtilities.relativize(newBaseURI, includedURI);
            relativeURIs.add(relativeURI.toString());
        }
        this.setProjectSlotValues(SLOT_INCLUDED_PROJECTS, relativeURIs);
    }

    private void setProjectSlotValue(String slotName, Object value) {
        ModelUtilities.setOwnSlotValue(this._projectInstance, slotName, value);
    }

    private void setProjectSlotValues(String slotName, Collection values) {
        ModelUtilities.setOwnSlotValues(this._projectInstance, slotName, values);
    }

    public void setTabWidgetDescriptorOrder(Collection c) {
        this._tabWidgetDescriptors = new ArrayList<WidgetDescriptor>(c);
        this.saveTabWidgetInstances();
    }

    public void setUpdateModificationSlots(boolean b) {
        this._updateModificationSlots = b;
        this.setOption(SLOT_UPDATE_MODIFICATION_SLOTS, b);
        this._domainKB.setModificationRecordUpdatingEnabled(b);
    }

    private void setupJournaling() {
        if (this.isJournalingEnabled()) {
            URI journalURI = this.getJournalURI();
            this._domainKB.startJournaling(journalURI);
        }
    }

    public JFrame show(Cls cls, Slot slot) {
        FrameSlotCombination combination = new FrameSlotCombination(cls, slot);
        JFrame frame = this._frames.get(combination);
        if (frame == null) {
            frame = this.createFrame(cls, slot);
            Project.setIconImage(frame, slot);
        } else {
            frame.toFront();
            frame.requestFocus();
        }
        return frame;
    }

    public JFrame show(Instance instance) {
        Assert.assertNotNull("instance", instance);
        JFrame frame = this._frames.get(instance);
        if (frame == null) {
            frame = this.createFrame(instance);
            Project.setIconImage(frame, instance);
        } else {
            frame.toFront();
            frame.requestFocus();
        }
        return frame;
    }

    public JFrame show(String instanceName) {
        Assert.assertNotNull("instance name", instanceName);
        Instance instance = this._domainKB.getInstance(instanceName);
        return this.show(instance);
    }

    public JInternalFrame showInInternalFrame(Instance instance) {
        Assert.assertNotNull("instance", instance);
        InstanceDisplay display = this.createInstanceDisplay(this, false, false);
        display.setInstance(instance);
        display.setResizeVertically(true);
        ClsWidget widget = display.getFirstClsWidget();
        String title = widget.getLabel();
        JInternalFrame frame = new JInternalFrame(title, true);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add(display);
        frame.pack();
        return frame;
    }

    public String toString() {
        return "Project(" + this.getProjectName() + ")";
    }

    private void updateJournaling() {
        if (this._projectKB != null && this.isJournalingEnabled()) {
            this._domainKB.stopJournaling();
            this._domainKB.startJournaling(this.getJournalURI());
        }
    }

    private void updateKBNames() {
        String name = this.getProjectName();
        if (name != null) {
            if (this._domainKB != null) {
                this._domainKB.setName(name);
            }
            if (this._projectKB != null) {
                this._projectKB.setName(name + "_ProjectKB");
            }
        }
    }

    private WidgetDescriptor getClsWidgetDescriptor(Cls cls) {
        WidgetDescriptor d = this._activeClsWidgetDescriptors.get(cls);
        if (d == null) {
            d = WidgetDescriptor.create(this._projectKB);
            d.setWidgetClassName(this._defaultClsWidgetClassName);
            d.setName(cls.getName());
            d.setTemporary(true);
            this._activeClsWidgetDescriptors.put(cls, d);
        }
        return d;
    }

    public Object getClientInformation(Object key) {
        return this._clientInformation.get(key);
    }

    public void setClientInformation(Object key, Object value) {
        if (value == null) {
            this._clientInformation.remove(key);
        } else {
            this._clientInformation.put(key, value);
        }
    }

    public Collection getCurrentUsers() {
        return this._projectKB.getCurrentUsers();
    }

    public String getLocalUser() {
        return null;
    }

    protected void setKnowledgeBases(KnowledgeBase domainKb, KnowledgeBase projectKb) {
        this._domainKB = domainKb;
        this._domainKB.addKnowledgeBaseListener(this._knowledgeBaseListener);
        this._domainKB.setProject(this);
        this._projectKB = projectKb;
        this._projectInstance = Project.getProjectInstance(this._projectKB);
        this.loadCachedKnowledgeBaseObjects(this._projectInstance);
    }

    public FrameCounts getFrameCounts() {
        this._frameCounts.updateDirectFrameCounts(this._domainKB);
        return this._frameCounts;
    }

    public boolean isMultiUserClient() {
        return false;
    }

    public boolean isMultiUserServer() {
        return this.isMultiUserServer;
    }

    public String getUserName() {
        return ApplicationProperties.getUserName();
    }

    public void setPrettyPrintSlotWidgetLabels(boolean b) {
        this.prettyPrintSlotWidgetLabels = b;
    }

    public boolean getPrettyPrintSlotWidgetLabels() {
        if (this.prettyPrintSlotWidgetLabels == null) {
            boolean b = ApplicationProperties.getPrettyPrintSlotWidgetLabels();
            this.prettyPrintSlotWidgetLabels = this.loadOption(SLOT_PRETTY_PRINT_SLOT_WIDGET_LABELS, b);
        }
        return this.prettyPrintSlotWidgetLabels;
    }

    public boolean getTabbedInstanceFormLayout() {
        return this.getOption(SLOT_TABBED_INSTANCE_FORM_LAYOUT, false);
    }

    public void setTabbedInstanceFormLayout(boolean b) {
        this.setOption(SLOT_TABBED_INSTANCE_FORM_LAYOUT, b);
    }

    public boolean isUndoOptionEnabled() {
        if (this._isUndoEnabled == null) {
            this._isUndoEnabled = this.loadOption(SLOT_IS_UNDO_ENABLED, !this.isMultiUserClient());
        }
        return this._isUndoEnabled;
    }

    public void setUndoOption(boolean enabled) {
        this._isUndoEnabled = enabled;
        this.setOption(SLOT_IS_UNDO_ENABLED, enabled);
    }

    public boolean getAddNameOnInstanceForm() {
        String addNameOnInstanceForm = (String)this.getClientInformation(CLIENT_PROPERTY_ADD_NAME_ON_INSTANCE_FORM);
        return addNameOnInstanceForm != null && addNameOnInstanceForm.equals("true");
    }

    public void setAddNameOnInstanceForm(boolean b) {
        this.setClientInformation(CLIENT_PROPERTY_ADD_NAME_ON_INSTANCE_FORM, b ? "true" : "false");
    }

    public boolean getChangeTrackingActive() {
        String changeTrackingActive = (String)this.getClientInformation(CHANGE_TRACKING_ACTIVE);
        return changeTrackingActive != null && changeTrackingActive.equals("true");
    }

    public void setChangeTrackingActive(boolean b) {
        this.setClientInformation(CHANGE_TRACKING_ACTIVE, b ? "true" : "false");
    }

    public boolean getSuppressInstanceCounting() {
        String suppressInstanceCounting = (String)this.getClientInformation(SUPRESS_INSTANCE_COUNT_DISPLAY);
        return suppressInstanceCounting != null && suppressInstanceCounting.equals("true");
    }

    public void setSuppressInstanceCounting(boolean b) {
        this.setClientInformation(SUPRESS_INSTANCE_COUNT_DISPLAY, b ? "true" : "false");
    }

    static {
        SystemUtilities.initialize();
    }
}

