/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Rectangle;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyMapUtil {
    private static final String MAP_CLASS = "Map";
    private static final String ENTRIES_SLOT = "entries";
    private static final String REFERENCED_MAPS_SLOT = "referenced_maps";
    private static final String MAP_ENTRY_CLASS = "Map_Entry";
    private static final String KEY_SLOT = "key";
    private static final String KEY_CLASS_SLOT = "key_class";
    private static final String VALUE_SLOT = "value";
    private static final String VALUE_CLASS_SLOT = "value_class";
    private static KnowledgeBase _domainKB;
    private static KnowledgeBase _projectKB;
    private static Map _valuesToMaps;

    private static Instance createEntryInstance(Instance mapInstance) {
        Cls cls = _projectKB.getCls(MAP_ENTRY_CLASS);
        Instance instance = _projectKB.createInstance(null, cls);
        ModelUtilities.addOwnSlotValue(mapInstance, ENTRIES_SLOT, instance);
        return instance;
    }

    private static Instance createMapInstance() {
        Cls cls = _projectKB.getCls(MAP_CLASS);
        return _projectKB.createInstance(null, cls);
    }

    public static void emptyMapInstance(Instance mapInstance) {
    }

    private static Entry getEntry(Object value) {
        Entry result = null;
        if (value instanceof Frame) {
            Frame frame = (Frame)value;
            if (!frame.isDeleted()) {
                result = new Entry(frame.getName(), Frame.class);
            }
        } else {
            result = value instanceof Rectangle ? new Entry(PropertyMapUtil.rectToString((Rectangle)value), Rectangle.class) : (value instanceof Map ? new Entry(PropertyMapUtil.mapToString((Map)value), Map.class) : (value instanceof Class ? new Entry(((Class)value).getName(), Class.class) : new Entry(value.toString(), value.getClass())));
        }
        return result;
    }

    private static Object getFrame(String value) {
        Frame frame = _domainKB.getFrame(value);
        if (frame == null) {
            Log.getLogger().warning("unable to load frame: " + value);
        }
        return frame;
    }

    private static Object getJavaClass(String className) {
        Class clas = SystemUtilities.forName(className);
        if (clas == null) {
            Log.getLogger().warning("unable to load class: " + className);
        }
        return clas;
    }

    private static Object getJavaClassObject(String className, String value) {
        Object result = null;
        Class c = SystemUtilities.forName(className, true);
        if (c == null) {
            Log.getLogger().warning("Unable to load class: " + className);
        } else {
            try {
                Constructor constructor = c.getConstructor(String.class);
                if (constructor == null) {
                    Log.getLogger().warning("Class has no string constructor" + className);
                } else {
                    result = constructor.newInstance(value);
                }
            }
            catch (Exception e) {
                Log.getLogger().warning(e.getMessage());
            }
        }
        return result;
    }

    private static Object getMap(String value) {
        HashMap map = (HashMap)_valuesToMaps.get(value);
        if (map == null) {
            map = new HashMap();
            _valuesToMaps.put(value, map);
            Instance mapInstance = _projectKB.getInstance(value);
            if (mapInstance == null) {
                Log.getLogger().warning("Missing map instance: " + value);
            } else {
                PropertyMapUtil.load(map, mapInstance);
            }
        }
        return map;
    }

    private static Object getRectangle(String value) {
        Rectangle result;
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(value));
            tokenizer.nextToken();
            int x = (int)tokenizer.nval;
            tokenizer.nextToken();
            int y = (int)tokenizer.nval;
            tokenizer.nextToken();
            int w = (int)tokenizer.nval;
            tokenizer.nextToken();
            int h = (int)tokenizer.nval;
            result = new Rectangle(x, y, w, h);
        }
        catch (Exception e) {
            Log.getLogger().warning(e.getMessage());
            result = null;
        }
        return result;
    }

    private static Object getSlotValue(Instance instance, String slotName) {
        return ModelUtilities.getDirectOwnSlotValue(instance, slotName);
    }

    private static void setSlotValue(Instance instance, String slotName, Object value) {
        ModelUtilities.setOwnSlotValue(instance, slotName, value);
    }

    private static Collection getSlotValues(Instance instance, String slotName) {
        return ModelUtilities.getDirectOwnSlotValues(instance, slotName);
    }

    public static Map load(Instance instance, KnowledgeBase domainKB) {
        _domainKB = domainKB;
        _projectKB = instance.getKnowledgeBase();
        _valuesToMaps.clear();
        HashMap result = new HashMap();
        PropertyMapUtil.load(result, instance);
        return result;
    }

    private static void load(Map map, Instance instance) {
        for (Instance entryInstance : new ArrayList(PropertyMapUtil.getSlotValues(instance, ENTRIES_SLOT))) {
            boolean succeeded = PropertyMapUtil.loadEntry(map, entryInstance);
            if (succeeded) continue;
            PropertyMapUtil.removeSlotValue(instance, ENTRIES_SLOT, entryInstance);
        }
    }

    private static boolean loadEntry(Map map, Instance entry) {
        boolean succeeded;
        Object key = PropertyMapUtil.loadObject(entry, KEY_SLOT, KEY_CLASS_SLOT);
        Object value = PropertyMapUtil.loadObject(entry, VALUE_SLOT, VALUE_CLASS_SLOT);
        if (key == null || value == null) {
            succeeded = false;
        } else {
            map.put(key, value);
            succeeded = true;
        }
        return succeeded;
    }

    private static Object loadObject(Instance entryInstance, String valueSlot, String valueClassSlot) {
        String value = (String)PropertyMapUtil.getSlotValue(entryInstance, valueSlot);
        String valueType = (String)PropertyMapUtil.getSlotValue(entryInstance, valueClassSlot);
        Object object = valueType.equals(Frame.class.getName()) ? PropertyMapUtil.getFrame(value) : (valueType.equals(Map.class.getName()) ? PropertyMapUtil.getMap(value) : (valueType.equals(Rectangle.class.getName()) ? PropertyMapUtil.getRectangle(value) : (valueType.equals(Class.class.getName()) ? PropertyMapUtil.getJavaClass(value) : PropertyMapUtil.getJavaClassObject(valueType, value))));
        return object;
    }

    private static String mapToString(Map map) {
        Instance mapInstance = PropertyMapUtil.createMapInstance();
        _valuesToMaps.put(mapInstance.getName(), map);
        PropertyMapUtil.storeMap(map, mapInstance);
        return mapInstance.getName();
    }

    private static String rectToString(Rectangle rect) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(rect.x);
        buffer.append(' ');
        buffer.append(rect.y);
        buffer.append(' ');
        buffer.append(rect.width);
        buffer.append(' ');
        buffer.append(rect.height);
        return buffer.toString();
    }

    private static void removeSlotValue(Instance instance, String slotName, Object value) {
        ModelUtilities.removeOwnSlotValue(instance, slotName, value);
    }

    private static void saveReferencedMaps(Instance mapInstance) {
        for (String instanceName : _valuesToMaps.keySet()) {
            Instance instance = _projectKB.getInstance(instanceName);
            ModelUtilities.addOwnSlotValue(mapInstance, REFERENCED_MAPS_SLOT, instance);
        }
    }

    public static void store(Map map, Instance mapInstance) {
        Object domainKB = null;
        _projectKB = mapInstance.getKnowledgeBase();
        _domainKB = domainKB;
        _valuesToMaps.clear();
        PropertyMapUtil.deleteMapEntries(mapInstance);
        PropertyMapUtil.storeMap(map, mapInstance);
        PropertyMapUtil.saveReferencedMaps(mapInstance);
    }

    private static void deleteMapEntries(Instance mapInstance) {
        for (Instance instance : PropertyMapUtil.getSlotValues(mapInstance, ENTRIES_SLOT)) {
            PropertyMapUtil.deleteMapEntry(instance);
        }
        PropertyMapUtil.setSlotValue(mapInstance, ENTRIES_SLOT, null);
    }

    private static void deleteMapEntry(Instance mapEntryInstance) {
        String valueClass = (String)PropertyMapUtil.getSlotValue(mapEntryInstance, VALUE_CLASS_SLOT);
        if (valueClass.equals(Map.class.getName())) {
            String value = (String)PropertyMapUtil.getSlotValue(mapEntryInstance, VALUE_SLOT);
            Instance instance = mapEntryInstance.getKnowledgeBase().getInstance(value);
            if (instance != null) {
                PropertyMapUtil.deleteMapEntries(instance);
                instance.delete();
            }
        }
        mapEntryInstance.delete();
    }

    private static void storeMap(Map map, Instance mapInstance) {
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                Log.getLogger().warning("Unable to store null");
                continue;
            }
            PropertyMapUtil.storeMapEntry(key, value, mapInstance);
        }
    }

    private static void storeMapEntry(Object key, Object value, Instance mapInstance) {
        Entry keyEntry = PropertyMapUtil.getEntry(key);
        Entry valueEntry = PropertyMapUtil.getEntry(value);
        if (keyEntry != null && valueEntry != null) {
            Instance entryInstance = PropertyMapUtil.createEntryInstance(mapInstance);
            ModelUtilities.setOwnSlotValue(entryInstance, KEY_SLOT, keyEntry.value);
            ModelUtilities.setOwnSlotValue(entryInstance, KEY_CLASS_SLOT, keyEntry.valueClass);
            ModelUtilities.setOwnSlotValue(entryInstance, VALUE_SLOT, valueEntry.value);
            ModelUtilities.setOwnSlotValue(entryInstance, VALUE_CLASS_SLOT, valueEntry.valueClass);
        }
    }

    public static void dispose() {
        _valuesToMaps.clear();
        _domainKB = null;
        _projectKB = null;
    }

    static {
        _valuesToMaps = new HashMap();
    }

    private static class Entry {
        private String value;
        String valueClass;

        Entry(String v, Class c) {
            this.value = v;
            this.valueClass = c.getName();
        }

        public String toString() {
            return this.value;
        }
    }
}

