/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerProjectURIUtil {
    private static final Logger logger = Log.getLogger(ServerProjectURIUtil.class);

    private ServerProjectURIUtil() {
    }

    public static URI getSingleProjectURI(Project project) throws RemoteException {
        if (project.getIncludedProjects().isEmpty()) {
            return project.getProjectURI();
        }
        ArrayList errors = new ArrayList();
        Project output = Project.createNewProject(new ClipsKnowledgeBaseFactory(), errors);
        if (!errors.isEmpty()) {
            return ServerProjectURIUtil.failed(project, errors);
        }
        project.loadIncludedProjects(project.getProjectURI(), project.getProjectInstance(), errors);
        if (!errors.isEmpty()) {
            return ServerProjectURIUtil.failed(project, errors);
        }
        ServerProjectURIUtil.copy(project, output);
        try {
            return ServerProjectURIUtil.save(project, output);
        }
        catch (IOException e) {
            RemoteException re = new RemoteException("Failed to save project kb");
            re.initCause(e);
            throw re;
        }
    }

    private static void copy(Project project, Project output) {
        MergingNarrowFrameStore sourceMFS = MergingNarrowFrameStore.get(project.getInternalProjectKnowledgeBase());
        MergingNarrowFrameStore targetMFS = MergingNarrowFrameStore.get(output.getInternalProjectKnowledgeBase());
        ServerProjectURIUtil.copy(sourceMFS, targetMFS);
    }

    private static void copy(MergingNarrowFrameStore sourceMFS, MergingNarrowFrameStore targetMFS) {
        for (Object o : sourceMFS.getFrames()) {
            Frame frame = (Frame)o;
            ServerProjectURIUtil.copyDirectOwnSlotValues(frame, sourceMFS, targetMFS);
            if (!(frame instanceof Cls)) continue;
            Cls cls = (Cls)frame;
            ServerProjectURIUtil.copyDirectTemplateSlotInformation(cls, sourceMFS, targetMFS);
        }
    }

    private static void copyDirectOwnSlotValues(Frame frame, MergingNarrowFrameStore sourceMFS, MergingNarrowFrameStore targetMFS) {
        Iterator<Slot> i$ = frame.getOwnSlots().iterator();
        while (i$.hasNext()) {
            Slot o;
            Slot slot = o = i$.next();
            List values = sourceMFS.getValues(frame, slot, null, false);
            targetMFS.setValues(frame, slot, null, false, values);
        }
    }

    private static void copyDirectTemplateSlotInformation(Cls cls, MergingNarrowFrameStore sourceMFS, MergingNarrowFrameStore targetMFS) {
        Iterator<Slot> i$ = cls.getTemplateSlots().iterator();
        while (i$.hasNext()) {
            Slot o;
            Slot slot = o = i$.next();
            List values = sourceMFS.getValues(cls, slot, null, true);
            targetMFS.setValues(cls, slot, null, true, values);
            ServerProjectURIUtil.copyDirectTemplateFacetValues(cls, slot, sourceMFS, targetMFS);
        }
    }

    private static void copyDirectTemplateFacetValues(Cls cls, Slot slot, MergingNarrowFrameStore sourceMFS, MergingNarrowFrameStore targetMFS) {
        Iterator<Facet> i$ = cls.getTemplateFacets(slot).iterator();
        while (i$.hasNext()) {
            Facet o;
            Facet facet = o = i$.next();
            List values = sourceMFS.getValues(cls, slot, facet, true);
            targetMFS.setValues(cls, slot, facet, true, values);
        }
    }

    private static URI save(Project project, Project output) throws IOException {
        File tmpFile = File.createTempFile("ServerProject", ".pprj");
        output.setProjectURI(tmpFile.toURI());
        ArrayList errors = new ArrayList();
        output.save(errors);
        if (!errors.isEmpty()) {
            return ServerProjectURIUtil.failed(project, errors);
        }
        String newFileName = tmpFile.getAbsolutePath().replace(".pprj", ".pins");
        return new File(newFileName).toURI();
    }

    private static URI failed(Project project, List errors) {
        Log.handleErrors(logger, Level.WARNING, errors);
        return project.getProjectURI();
    }
}

