/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.DefaultFacet;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.DefaultValuesConstraint;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FacetConstraint;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.MaximumCardinalityConstraint;
import edu.stanford.smi.protege.model.MinimumCardinalityConstraint;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.NumericMaximumConstraint;
import edu.stanford.smi.protege.model.NumericMinimumConstraint;
import edu.stanford.smi.protege.model.RoleConstraint;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.model.ValueTypeConstraint;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemFrames {
    private KnowledgeBase _kb;
    private Map<FrameID, Frame> _frameIdToFrameMap = new LinkedHashMap<FrameID, Frame>();

    public SystemFrames(KnowledgeBase kb) {
        this._kb = kb;
        this.createFrames();
    }

    public Collection<Frame> getFrames() {
        return new ArrayList<Frame>(this._frameIdToFrameMap.values());
    }

    public Collection<FrameID> getFrameIDs() {
        return new ArrayList<FrameID>(this._frameIdToFrameMap.keySet());
    }

    public Collection<String> getFrameNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (FrameID id : this._frameIdToFrameMap.keySet()) {
            names.add(id.getName());
        }
        return names;
    }

    public synchronized Frame getFrame(FrameID id) {
        Frame frame = this._frameIdToFrameMap.get(id);
        if (frame == null) {
            Log.getLogger().severe("Missing system frame: " + id);
        }
        return frame;
    }

    private Cls getCls(FrameID id) {
        return (Cls)this.getFrame(id);
    }

    private Slot getSlot(FrameID id) {
        return (Slot)this.getFrame(id);
    }

    private Facet getFacet(FrameID id) {
        return (Facet)this.getFrame(id);
    }

    private void createFrames() {
        this.createClses();
        this.createSlots();
        this.createFacets();
    }

    private void createCls(FrameID id) {
        DefaultCls frame = new DefaultCls(this._kb, id);
        this.addFrame(id, frame);
    }

    private void createSlot(FrameID id) {
        DefaultSlot frame = new DefaultSlot(this._kb, id);
        this.addFrame(id, frame);
    }

    private void createFacet(FrameID id, FacetConstraint constraint) {
        DefaultFacet facet = new DefaultFacet(this._kb, id);
        if (constraint != null) {
            facet.setConstraint(constraint);
        }
        this.addFrame(id, facet);
    }

    protected void addFrame(FrameID id, Frame frame) {
        Frame value = this._frameIdToFrameMap.put(id, frame);
        if (value != null) {
            throw new IllegalStateException("duplicate add: " + id + " " + id.getName());
        }
    }

    protected void replaceFrame(FrameID id, Frame frame) {
        Frame value = this._frameIdToFrameMap.put(id, frame);
        if (value == null) {
            throw new IllegalStateException("illegal replace: " + id);
        }
    }

    protected void removeFrame(FrameID id) {
        this._frameIdToFrameMap.remove(id);
    }

    private void createClses() {
        this.createCls(Model.ClsID.THING);
        this.createCls(Model.ClsID.SYSTEM_CLASS);
        this.createCls(Model.ClsID.ROOT_META_CLASS);
        this.createCls(Model.ClsID.CLASS);
        this.createCls(Model.ClsID.SLOT);
        this.createCls(Model.ClsID.FACET);
        this.createCls(Model.ClsID.STANDARD_CLASS);
        this.createCls(Model.ClsID.STANDARD_SLOT);
        this.createCls(Model.ClsID.STANDARD_FACET);
        this.createCls(Model.ClsID.CONSTRAINT);
        this.createCls(Model.ClsID.RELATION);
        this.createCls(Model.ClsID.DIRECTED_BINARY_RELATION);
        this.createCls(Model.ClsID.PAL_CONSTRAINT);
        this.createCls(Model.ClsID.ANNOTATION);
        this.createCls(Model.ClsID.INSTANCE_ANNOTATION);
    }

    private void createSlots() {
        this.createSlot(Model.SlotID.DOCUMENTATION);
        this.createSlot(Model.SlotID.NAME);
        this.createSlot(Model.SlotID.ROLE);
        this.createSlot(Model.SlotID.DIRECT_TYPES);
        this.createSlot(Model.SlotID.DIRECT_INSTANCES);
        this.createSlot(Model.SlotID.DIRECT_SUPERCLASSES);
        this.createSlot(Model.SlotID.DIRECT_SUBCLASSES);
        this.createSlot(Model.SlotID.DIRECT_SUPERSLOTS);
        this.createSlot(Model.SlotID.DIRECT_SUBSLOTS);
        this.createSlot(Model.SlotID.ASSOCIATED_FACET);
        this.createSlot(Model.SlotID.ASSOCIATED_SLOT);
        this.createSlot(Model.SlotID.DIRECT_TEMPLATE_SLOTS);
        this.createSlot(Model.SlotID.DIRECT_DOMAIN);
        this.createSlot(Model.SlotID.INVERSE);
        this.createSlot(Model.SlotID.CONSTRAINTS);
        this.createSlot(Model.SlotID.DEFAULTS);
        this.createSlot(Model.SlotID.VALUE_TYPE);
        this.createSlot(Model.SlotID.MAXIMUM_CARDINALITY);
        this.createSlot(Model.SlotID.MINIMUM_CARDINALITY);
        this.createSlot(Model.SlotID.NUMERIC_MINIMUM);
        this.createSlot(Model.SlotID.NUMERIC_MAXIMUM);
        this.createSlot(Model.SlotID.PAL_STATEMENT);
        this.createSlot(Model.SlotID.PAL_DESCRIPTION);
        this.createSlot(Model.SlotID.PAL_NAME);
        this.createSlot(Model.SlotID.PAL_RANGE);
        this.createSlot(Model.SlotID.VALUES);
        this.createSlot(Model.SlotID.ANNOTATED_INSTANCE);
        this.createSlot(Model.SlotID.ANNOTATION_TEXT);
        this.createSlot(Model.SlotID.CREATOR);
        this.createSlot(Model.SlotID.CREATION_TIMESTAMP);
        this.createSlot(Model.SlotID.MODIFIER);
        this.createSlot(Model.SlotID.MODIFICATION_TIMESTAMP);
        this.createSlot(Model.SlotID.FROM);
        this.createSlot(Model.SlotID.TO);
    }

    private void createFacets() {
        this.createFacet(Model.FacetID.DOCUMENTATION, null);
        this.createFacet(Model.FacetID.DEFAULTS, new DefaultValuesConstraint());
        this.createFacet(Model.FacetID.CONSTRAINTS, null);
        this.createFacet(Model.FacetID.VALUE_TYPE, new ValueTypeConstraint());
        this.createFacet(Model.FacetID.INVERSE, null);
        this.createFacet(Model.FacetID.MAXIMUM_CARDINALITY, new MaximumCardinalityConstraint());
        this.createFacet(Model.FacetID.MINIMUM_CARDINALITY, new MinimumCardinalityConstraint());
        this.createFacet(Model.FacetID.NUMERIC_MINIMUM, new NumericMinimumConstraint());
        this.createFacet(Model.FacetID.NUMERIC_MAXIMUM, new NumericMaximumConstraint());
        this.createFacet(Model.FacetID.VALUES, null);
    }

    public Cls getRootCls() {
        return this.getCls(Model.ClsID.THING);
    }

    public Cls getRootMetaCls() {
        return this.getCls(Model.ClsID.ROOT_META_CLASS);
    }

    public Cls getRootClsMetaCls() {
        return this.getCls(Model.ClsID.CLASS);
    }

    public Cls getStandardClsMetaCls() {
        return this.getCls(Model.ClsID.STANDARD_CLASS);
    }

    public Cls getStandardSlotMetaCls() {
        return this.getCls(Model.ClsID.STANDARD_SLOT);
    }

    public Cls getRootSlotMetaCls() {
        return this.getCls(Model.ClsID.SLOT);
    }

    public Cls getRootFacetMetaCls() {
        return this.getCls(Model.ClsID.FACET);
    }

    public Cls getStandardFacetMetaCls() {
        return this.getCls(Model.ClsID.STANDARD_FACET);
    }

    public Cls getSystemCls() {
        return this.getCls(Model.ClsID.SYSTEM_CLASS);
    }

    public Cls getConstraintCls() {
        return this.getCls(Model.ClsID.CONSTRAINT);
    }

    public Cls getRelationCls() {
        return this.getCls(Model.ClsID.RELATION);
    }

    public Cls getDirectedBinaryRelationCls() {
        return this.getCls(Model.ClsID.DIRECTED_BINARY_RELATION);
    }

    public Cls getPalConstraintCls() {
        return this.getCls(Model.ClsID.PAL_CONSTRAINT);
    }

    public Cls getAnnotationCls() {
        return this.getCls(Model.ClsID.ANNOTATION);
    }

    public Cls getInstanceAnnotationCls() {
        return this.getCls(Model.ClsID.INSTANCE_ANNOTATION);
    }

    public Slot getDocumentationSlot() {
        return this.getSlot(Model.SlotID.DOCUMENTATION);
    }

    public Slot getDirectDomainSlot() {
        return this.getSlot(Model.SlotID.DIRECT_DOMAIN);
    }

    public Slot getNameSlot() {
        return this.getSlot(Model.SlotID.NAME);
    }

    public Slot getRoleSlot() {
        return this.getSlot(Model.SlotID.ROLE);
    }

    public Slot getDirectSuperclassesSlot() {
        return this.getSlot(Model.SlotID.DIRECT_SUPERCLASSES);
    }

    public Slot getDirectSubclassesSlot() {
        return this.getSlot(Model.SlotID.DIRECT_SUBCLASSES);
    }

    public Slot getDirectTypesSlot() {
        return this.getSlot(Model.SlotID.DIRECT_TYPES);
    }

    public Slot getDirectInstancesSlot() {
        return this.getSlot(Model.SlotID.DIRECT_INSTANCES);
    }

    public Slot getDirectTemplateSlotsSlot() {
        return this.getSlot(Model.SlotID.DIRECT_TEMPLATE_SLOTS);
    }

    public Slot getAssociatedFacetSlot() {
        return this.getSlot(Model.SlotID.ASSOCIATED_FACET);
    }

    public Slot getSlotConstraintsSlot() {
        return this.getSlot(Model.SlotID.CONSTRAINTS);
    }

    public Slot getDefaultValuesSlot() {
        return this.getSlot(Model.SlotID.DEFAULTS);
    }

    public Slot getValueTypeSlot() {
        return this.getSlot(Model.SlotID.VALUE_TYPE);
    }

    public Slot getInverseSlotSlot() {
        return this.getSlot(Model.SlotID.INVERSE);
    }

    public Slot getMaximumCardinalitySlot() {
        return this.getSlot(Model.SlotID.MAXIMUM_CARDINALITY);
    }

    public Slot getMinimumCardinalitySlot() {
        return this.getSlot(Model.SlotID.MINIMUM_CARDINALITY);
    }

    public Slot getMinimumValueSlot() {
        return this.getSlot(Model.SlotID.NUMERIC_MINIMUM);
    }

    public Slot getMaximumValueSlot() {
        return this.getSlot(Model.SlotID.NUMERIC_MAXIMUM);
    }

    public Slot getPalStatementSlot() {
        return this.getSlot(Model.SlotID.PAL_STATEMENT);
    }

    public Slot getPalNameSlot() {
        return this.getSlot(Model.SlotID.PAL_NAME);
    }

    public Slot getPalDescriptionSlot() {
        return this.getSlot(Model.SlotID.PAL_DESCRIPTION);
    }

    public Slot getPalRangeSlot() {
        return this.getSlot(Model.SlotID.PAL_RANGE);
    }

    public Slot getValuesSlot() {
        return this.getSlot(Model.SlotID.VALUES);
    }

    public Slot getDirectSubslotsSlot() {
        return this.getSlot(Model.SlotID.DIRECT_SUBSLOTS);
    }

    public Slot getDirectSuperslotsSlot() {
        return this.getSlot(Model.SlotID.DIRECT_SUPERSLOTS);
    }

    public Slot getAnnotatedInstanceSlot() {
        return this.getSlot(Model.SlotID.ANNOTATED_INSTANCE);
    }

    public Slot getAnnotationTextSlot() {
        return this.getSlot(Model.SlotID.ANNOTATION_TEXT);
    }

    public Slot getCreatorSlot() {
        return this.getSlot(Model.SlotID.CREATOR);
    }

    public Slot getCreationTimestampSlot() {
        return this.getSlot(Model.SlotID.CREATION_TIMESTAMP);
    }

    public Slot getAssociatedSlotSlot() {
        return this.getSlot(Model.SlotID.ASSOCIATED_SLOT);
    }

    public Slot getModifierSlot() {
        return this.getSlot(Model.SlotID.MODIFIER);
    }

    public Slot getModificationTimestampSlot() {
        return this.getSlot(Model.SlotID.MODIFICATION_TIMESTAMP);
    }

    public Slot getConstraintsSlot() {
        return this.getSlot(Model.SlotID.CONSTRAINTS);
    }

    public Slot getFromSlot() {
        return this.getSlot(Model.SlotID.FROM);
    }

    public Slot getToSlot() {
        return this.getSlot(Model.SlotID.TO);
    }

    public Facet getDocumentationFacet() {
        return this.getFacet(Model.FacetID.DOCUMENTATION);
    }

    public Facet getDefaultValuesFacet() {
        return this.getFacet(Model.FacetID.DEFAULTS);
    }

    public Facet getConstraintsFacet() {
        return this.getFacet(Model.FacetID.CONSTRAINTS);
    }

    public Facet getValueTypeFacet() {
        return this.getFacet(Model.FacetID.VALUE_TYPE);
    }

    public Facet getInverseFacet() {
        return this.getFacet(Model.FacetID.INVERSE);
    }

    public Facet getMaximumCardinalityFacet() {
        return this.getFacet(Model.FacetID.MAXIMUM_CARDINALITY);
    }

    public Facet getMinimumCardinalityFacet() {
        return this.getFacet(Model.FacetID.MINIMUM_CARDINALITY);
    }

    public Facet getMinimumValueFacet() {
        return this.getFacet(Model.FacetID.NUMERIC_MINIMUM);
    }

    public Facet getMaximumValueFacet() {
        return this.getFacet(Model.FacetID.NUMERIC_MAXIMUM);
    }

    public Facet getValuesFacet() {
        return this.getFacet(Model.FacetID.VALUES);
    }

    public boolean isSystem(Frame frame) {
        return this._frameIdToFrameMap.keySet().contains(frame.getFrameID());
    }

    public void addSystemFrames(FrameStore fs) {
        try {
            this.addFrames(fs);
            this.addInheritance(fs);
            this.addTemplateSlots(fs);
            this.addInverseSlots(fs);
            this.configureClses(fs);
            this.configureSlots(fs);
            this.configureFacets(fs);
            this.configureOverrides(fs);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
            throw new RuntimeException(e.toString());
        }
    }

    private void addSystemCls(FrameStore fs, Cls cls) {
        Collection<Cls> types = CollectionUtilities.createCollection(this.getStandardClsMetaCls());
        this.assertTypeAndName(fs, cls, types);
    }

    private void addSystemSlot(FrameStore fs, Slot slot) {
        Collection<Cls> types = CollectionUtilities.createCollection(this.getStandardSlotMetaCls());
        this.assertTypeAndName(fs, slot, types);
    }

    private void addSystemFacet(FrameStore fs, Facet facet, FacetConstraint constraint) {
        Collection<Cls> types = CollectionUtilities.createCollection(this.getStandardFacetMetaCls());
        this.assertTypeAndName(fs, facet, types);
        if (constraint != null) {
            facet.setConstraint(constraint);
        }
    }

    public void assertTypeAndName(FrameStore fs, Frame frame, Collection<Cls> types) {
        String name = frame.getFrameID().getName();
        fs.setDirectOwnSlotValues(frame, this.getNameSlot(), Collections.singleton(name));
        fs.setDirectOwnSlotValues(frame, this.getDirectTypesSlot(), types);
        for (Cls type : types) {
            ArrayList<Frame> framesOfType = new ArrayList<Frame>(fs.getDirectOwnSlotValues(type, this.getDirectInstancesSlot()));
            if (framesOfType.contains(frame)) continue;
            framesOfType.add(frame);
            fs.setDirectOwnSlotValues(type, this.getDirectInstancesSlot(), framesOfType);
        }
    }

    private void addInverseSlot(FrameStore fs, Slot slota, Slot slotb) {
        SystemFrames.setOwnSlotValue(fs, slota, this.getInverseSlotSlot(), slotb);
    }

    private static void addTemplateSlot(FrameStore fs, Cls cls, Slot slot) {
        fs.addDirectTemplateSlot(cls, slot);
    }

    private static void addSuperclass(FrameStore fs, Cls cls, Cls superclass) {
        fs.addDirectSuperclass(cls, superclass);
    }

    private void addFrames(FrameStore fs) {
        for (Map.Entry<FrameID, Frame> entry : this._frameIdToFrameMap.entrySet()) {
            FrameID id = entry.getKey();
            Frame frame = entry.getValue();
            if (frame instanceof Cls) {
                this.addSystemCls(fs, (Cls)frame);
                continue;
            }
            if (frame instanceof Slot) {
                this.addSystemSlot(fs, (Slot)frame);
                continue;
            }
            if (!(frame instanceof Facet)) continue;
            this.addSystemFacet(fs, (Facet)frame, ((Facet)frame).getConstraint());
        }
    }

    private void addInheritance(FrameStore fs) {
        SystemFrames.addSuperclass(fs, this.getSystemCls(), this.getRootCls());
        SystemFrames.addSuperclass(fs, this.getRootMetaCls(), this.getSystemCls());
        SystemFrames.addSuperclass(fs, this.getRootClsMetaCls(), this.getRootMetaCls());
        SystemFrames.addSuperclass(fs, this.getStandardClsMetaCls(), this.getRootClsMetaCls());
        SystemFrames.addSuperclass(fs, this.getRootSlotMetaCls(), this.getRootMetaCls());
        SystemFrames.addSuperclass(fs, this.getStandardSlotMetaCls(), this.getRootSlotMetaCls());
        SystemFrames.addSuperclass(fs, this.getRootFacetMetaCls(), this.getRootMetaCls());
        SystemFrames.addSuperclass(fs, this.getStandardFacetMetaCls(), this.getRootFacetMetaCls());
        SystemFrames.addSuperclass(fs, this.getConstraintCls(), this.getSystemCls());
        SystemFrames.addSuperclass(fs, this.getPalConstraintCls(), this.getConstraintCls());
        SystemFrames.addSuperclass(fs, this.getAnnotationCls(), this.getSystemCls());
        SystemFrames.addSuperclass(fs, this.getInstanceAnnotationCls(), this.getAnnotationCls());
        SystemFrames.addSuperclass(fs, this.getRelationCls(), this.getSystemCls());
        SystemFrames.addSuperclass(fs, this.getDirectedBinaryRelationCls(), this.getRelationCls());
    }

    private void addTemplateSlots(FrameStore fs) {
        this.addRootMetaClsTemplateSlots(fs);
        this.addRootClsMetaClsTemplateSlots(fs);
        this.addStandardClsMetaClsTemplateSlots(fs);
        this.addRootSlotMetaClsTemplateSlots(fs);
        this.addStandardSlotMetaClsTemplateSlots(fs);
        this.addRootFacetMetaClsTemplateSlots(fs);
        this.addStandardFacetMetaClsTemplateSlots(fs);
        this.addPalConstraintTemplateSlots(fs);
        this.addInstanceAnnotationTemplateSlots(fs);
        this.addDirectedBinaryRelationTemplateSlots(fs);
    }

    private void addRootMetaClsTemplateSlots(FrameStore fs) {
        Cls cls = this.getRootMetaCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getNameSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getDirectTypesSlot());
    }

    private void addRootClsMetaClsTemplateSlots(FrameStore fs) {
        Cls cls = this.getRootClsMetaCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getDirectInstancesSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getDirectSuperclassesSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getDirectSubclassesSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getDirectTemplateSlotsSlot());
    }

    private void addStandardClsMetaClsTemplateSlots(FrameStore fs) {
        Cls cls = this.getStandardClsMetaCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getRoleSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getDocumentationSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getConstraintsSlot());
    }

    private void addRootSlotMetaClsTemplateSlots(FrameStore fs) {
        Cls cls = this.getRootSlotMetaCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getDirectDomainSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getValueTypeSlot());
    }

    private void addStandardSlotMetaClsTemplateSlots(FrameStore fs) {
        Cls cls = this.getStandardSlotMetaCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getDocumentationSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getConstraintsSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getMaximumCardinalitySlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getMinimumCardinalitySlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getMaximumValueSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getMinimumValueSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getInverseSlotSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getDefaultValuesSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getValuesSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getAssociatedFacetSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getDirectSubslotsSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getDirectSuperslotsSlot());
    }

    private void addRootFacetMetaClsTemplateSlots(FrameStore fs) {
    }

    private void addStandardFacetMetaClsTemplateSlots(FrameStore fs) {
        Cls cls = this.getStandardFacetMetaCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getDocumentationSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getAssociatedSlotSlot());
    }

    private void addPalConstraintTemplateSlots(FrameStore fs) {
        Cls cls = this.getPalConstraintCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getPalNameSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getPalRangeSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getPalDescriptionSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getPalStatementSlot());
    }

    private void addInstanceAnnotationTemplateSlots(FrameStore fs) {
        Cls cls = this.getInstanceAnnotationCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getAnnotatedInstanceSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getAnnotationTextSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getCreatorSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getCreationTimestampSlot());
    }

    private void addDirectedBinaryRelationTemplateSlots(FrameStore fs) {
        Cls cls = this.getDirectedBinaryRelationCls();
        SystemFrames.addTemplateSlot(fs, cls, this.getFromSlot());
        SystemFrames.addTemplateSlot(fs, cls, this.getToSlot());
    }

    private void addInverseSlots(FrameStore fs) {
        this.addInverseSlot(fs, this.getInverseSlotSlot(), this.getInverseSlotSlot());
        this.addInverseSlot(fs, this.getAssociatedFacetSlot(), this.getAssociatedSlotSlot());
        this.addInverseSlot(fs, this.getDirectTemplateSlotsSlot(), this.getDirectDomainSlot());
        this.addInverseSlot(fs, this.getDirectSuperclassesSlot(), this.getDirectSubclassesSlot());
        this.addInverseSlot(fs, this.getDirectTypesSlot(), this.getDirectInstancesSlot());
        this.addInverseSlot(fs, this.getDirectSuperslotsSlot(), this.getDirectSubslotsSlot());
    }

    private void configureClses(FrameStore fs) {
        this.configureCls(fs, this.getRootCls(), "Abstract");
        this.configureCls(fs, this.getSystemCls(), "Abstract");
        this.configureCls(fs, this.getRootMetaCls(), "Abstract");
        this.configureCls(fs, this.getRootClsMetaCls(), "Abstract");
        this.configureCls(fs, this.getStandardClsMetaCls(), "Concrete");
        this.configureCls(fs, this.getRootSlotMetaCls(), "Abstract");
        this.configureCls(fs, this.getStandardSlotMetaCls(), "Concrete");
        this.configureCls(fs, this.getRootFacetMetaCls(), "Abstract");
        this.configureCls(fs, this.getStandardFacetMetaCls(), "Concrete");
        this.configureCls(fs, this.getConstraintCls(), "Abstract");
        this.configureCls(fs, this.getPalConstraintCls(), "Concrete");
        this.configureCls(fs, this.getAnnotationCls(), "Abstract");
        this.configureCls(fs, this.getInstanceAnnotationCls(), "Concrete");
        this.configureCls(fs, this.getRelationCls(), "Abstract");
        this.configureCls(fs, this.getDirectedBinaryRelationCls(), "Concrete");
    }

    private void configureCls(FrameStore fs, Cls cls, String role) {
        SystemFrames.setOwnSlotValue(fs, cls, this.getRoleSlot(), role);
    }

    private void configureSlots(FrameStore fs) {
        this.configureMultiStringSlot(fs, this.getDocumentationSlot());
        this.configureSingleStringSlot(fs, this.getNameSlot());
        this.configureSingleSymbolSlot(fs, this.getRoleSlot(), RoleConstraint.getValues());
        this.configureMultiClassSlot(fs, this.getDirectTypesSlot(), this.getRootCls());
        this.configureMultiInstanceSlot(fs, this.getDirectInstancesSlot(), this.getRootCls());
        this.configureMultiClassSlot(fs, this.getDirectSuperclassesSlot(), this.getRootCls());
        this.configureMultiClassSlot(fs, this.getDirectSubclassesSlot(), this.getRootCls());
        this.configureMultiInstanceSlot(fs, this.getDirectSuperslotsSlot(), this.getRootSlotMetaCls());
        this.configureMultiInstanceSlot(fs, this.getDirectSubslotsSlot(), this.getRootSlotMetaCls());
        this.configureSingleInstanceSlot(fs, this.getAssociatedFacetSlot(), this.getRootFacetMetaCls());
        this.configureSingleInstanceSlot(fs, this.getAssociatedSlotSlot(), this.getRootSlotMetaCls());
        this.configureMultiInstanceSlot(fs, this.getDirectTemplateSlotsSlot(), this.getRootSlotMetaCls());
        this.configureMultiInstanceSlot(fs, this.getDirectDomainSlot(), this.getRootClsMetaCls());
        this.configureSingleInstanceSlot(fs, this.getInverseSlotSlot(), this.getRootSlotMetaCls());
        this.configureMultiInstanceSlot(fs, this.getConstraintsSlot(), this.getConstraintCls());
        this.configureMultiAnySlot(fs, this.getDefaultValuesSlot());
        this.configureMultiAnySlot(fs, this.getValueTypeSlot());
        this.configureSingleIntSlot(fs, this.getMaximumCardinalitySlot());
        this.configureSingleIntSlot(fs, this.getMinimumCardinalitySlot());
        this.configureSingleFloatSlot(fs, this.getMinimumValueSlot());
        this.configureSingleFloatSlot(fs, this.getMaximumValueSlot());
        this.configureSingleStringSlot(fs, this.getPalStatementSlot());
        this.configureSingleStringSlot(fs, this.getPalDescriptionSlot());
        this.configureSingleStringSlot(fs, this.getPalNameSlot());
        this.configureSingleStringSlot(fs, this.getPalRangeSlot());
        this.configureMultiAnySlot(fs, this.getValuesSlot());
        this.configureSingleInstanceSlot(fs, this.getAnnotatedInstanceSlot(), this.getRootCls());
        this.configureSingleStringSlot(fs, this.getAnnotationTextSlot());
        this.configureSingleStringSlot(fs, this.getCreatorSlot());
        this.configureSingleStringSlot(fs, this.getCreationTimestampSlot());
        this.configureSingleStringSlot(fs, this.getModifierSlot());
        this.configureSingleStringSlot(fs, this.getModificationTimestampSlot());
        this.configureSingleInstanceSlot(fs, this.getFromSlot(), this.getRootCls());
        this.configureSingleInstanceSlot(fs, this.getToSlot(), this.getRootCls());
        this.setDefault(fs, this.getMaximumCardinalitySlot(), new Integer(1));
        this.setDefault(fs, this.getValueTypeSlot(), ValueType.STRING.toString());
        this.setDefault(fs, this.getRoleSlot(), "Concrete".toString());
    }

    private void configureOverrides(FrameStore fs) {
        this.setAllowedParent(fs, this.getRootMetaCls(), this.getDirectTypesSlot(), this.getRootMetaCls());
        this.setAllowedParent(fs, this.getRootClsMetaCls(), this.getDirectTypesSlot(), this.getRootClsMetaCls());
        this.setAllowedParent(fs, this.getRootSlotMetaCls(), this.getDirectTypesSlot(), this.getRootSlotMetaCls());
        this.setAllowedParent(fs, this.getRootFacetMetaCls(), this.getDirectTypesSlot(), this.getRootFacetMetaCls());
    }

    private void setAllowedParent(FrameStore fs, Cls cls, Slot slot, Cls parent) {
        List values = ValueTypeConstraint.getValues(ValueType.CLS, Collections.singleton(parent));
        fs.setDirectTemplateFacetValues(cls, slot, this.getValueTypeFacet(), values);
    }

    private void configureFacets(FrameStore fs) {
        this.configureFacet(fs, this.getDocumentationFacet(), this.getDocumentationSlot());
        this.configureFacet(fs, this.getDefaultValuesFacet(), this.getDefaultValuesSlot());
        this.configureFacet(fs, this.getConstraintsFacet(), this.getConstraintsSlot());
        this.configureFacet(fs, this.getValueTypeFacet(), this.getValueTypeSlot());
        this.configureFacet(fs, this.getMaximumCardinalityFacet(), this.getMaximumCardinalitySlot());
        this.configureFacet(fs, this.getMinimumCardinalityFacet(), this.getMinimumCardinalitySlot());
        this.configureFacet(fs, this.getMaximumValueFacet(), this.getMaximumValueSlot());
        this.configureFacet(fs, this.getMinimumValueFacet(), this.getMinimumValueSlot());
        this.configureFacet(fs, this.getValuesFacet(), this.getValuesSlot());
    }

    private void setDefault(FrameStore fs, Slot slot, Object o) {
        SystemFrames.setOwnSlotValue(fs, slot, this.getDefaultValuesSlot(), o);
    }

    private void setCardinality(FrameStore fs, Slot slot, boolean multiple) {
        Collection values = MaximumCardinalityConstraint.getValues(multiple);
        SystemFrames.setOwnSlotValues(fs, slot, this.getMaximumCardinalitySlot(), values);
    }

    private void setValueType(FrameStore fs, Slot slot, ValueType type) {
        this.setValueType(fs, slot, type, Collections.EMPTY_LIST);
    }

    private void setValueType(FrameStore fs, Slot slot, ValueType type, Collection constraints) {
        List values = ValueTypeConstraint.getValues(type, constraints);
        SystemFrames.setOwnSlotValues(fs, slot, this.getValueTypeSlot(), values);
    }

    private void configureMultiStringSlot(FrameStore fs, Slot slot) {
        this.setCardinality(fs, slot, true);
        this.setValueType(fs, slot, ValueType.STRING);
    }

    private void configureSingleStringSlot(FrameStore fs, Slot slot) {
        this.setCardinality(fs, slot, false);
        this.setValueType(fs, slot, ValueType.STRING);
    }

    private void configureSingleSymbolSlot(FrameStore fs, Slot slot, Collection allowedValues) {
        this.setCardinality(fs, slot, false);
        this.setValueType(fs, slot, ValueType.SYMBOL, allowedValues);
    }

    private void configureMultiInstanceSlot(FrameStore fs, Slot slot, Cls cls) {
        this.setCardinality(fs, slot, true);
        this.setValueType(fs, slot, ValueType.INSTANCE, CollectionUtilities.createCollection(cls));
    }

    private void configureMultiClassSlot(FrameStore fs, Slot slot, Cls cls) {
        this.setCardinality(fs, slot, true);
        this.setValueType(fs, slot, ValueType.CLS, CollectionUtilities.createCollection(cls));
    }

    private void configureSingleInstanceSlot(FrameStore fs, Slot slot, Cls cls) {
        this.setCardinality(fs, slot, false);
        this.setValueType(fs, slot, ValueType.INSTANCE, CollectionUtilities.createCollection(cls));
    }

    private void configureSingleIntSlot(FrameStore fs, Slot slot) {
        this.setCardinality(fs, slot, false);
        this.setValueType(fs, slot, ValueType.INTEGER);
    }

    private void configureSingleFloatSlot(FrameStore fs, Slot slot) {
        this.setCardinality(fs, slot, false);
        this.setValueType(fs, slot, ValueType.FLOAT);
    }

    private void configureMultiAnySlot(FrameStore fs, Slot slot) {
        this.setCardinality(fs, slot, true);
        this.setValueType(fs, slot, ValueType.ANY);
    }

    private static void setOwnSlotValue(FrameStore fs, Frame frame, Slot slot, Object value) {
        Set<Object> values = Collections.singleton(value);
        SystemFrames.setOwnSlotValues(fs, frame, slot, values);
    }

    private static void setOwnSlotValues(FrameStore fs, Frame frame, Slot slot, Collection values) {
        fs.setDirectOwnSlotValues(frame, slot, values);
    }

    private void configureFacet(FrameStore fs, Facet facet, Slot slot) {
        SystemFrames.setOwnSlotValue(fs, facet, this.getAssociatedSlotSlot(), slot);
    }
}

