/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.KnowledgeBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Transaction<X> {
    public static final String APPLY_TO_TRAILER_STRING = " -- Apply to: ";
    private final KnowledgeBase _knowledgeBase;
    private String applyTo;
    private String transactionName = "transaction";

    protected Transaction(KnowledgeBase kb) {
        this._knowledgeBase = kb;
    }

    protected Transaction(KnowledgeBase kb, String transactionName) {
        this._knowledgeBase = kb;
        this.transactionName = transactionName;
    }

    protected Transaction(KnowledgeBase kb, String transactionName, String applyTo) {
        this._knowledgeBase = kb;
        this.transactionName = transactionName;
        this.applyTo = applyTo;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._knowledgeBase;
    }

    public abstract boolean doOperations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        boolean commited = false;
        KnowledgeBase knowledgeBase = this._knowledgeBase;
        synchronized (knowledgeBase) {
            boolean transactionComplete = false;
            try {
                this._knowledgeBase.beginTransaction(this.transactionName, this.applyTo);
                boolean doCommit = this.doOperations();
                if (doCommit) {
                    commited = this._knowledgeBase.commitTransaction();
                } else {
                    this._knowledgeBase.rollbackTransaction();
                    commited = false;
                }
                transactionComplete = true;
            }
            finally {
                if (!transactionComplete) {
                    this._knowledgeBase.rollbackTransaction();
                }
            }
        }
        return commited;
    }

    public X getResult() {
        return null;
    }

    public static String getApplyTo(String beginString) {
        int index = beginString.indexOf(APPLY_TO_TRAILER_STRING);
        if (index < 0) {
            return null;
        }
        return beginString.substring(index += APPLY_TO_TRAILER_STRING.length());
    }

    public static String removeApplyTo(String beginString) {
        if (beginString == null) {
            return null;
        }
        int index = beginString.indexOf(APPLY_TO_TRAILER_STRING);
        if (index < 0) {
            return beginString;
        }
        return beginString.substring(0, index);
    }
}

