/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.AbstractFacetConstraint;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class ValueTypeConstraint
extends AbstractFacetConstraint {
    private static final long serialVersionUID = 7393345703244105398L;
    private static final Collection values = new ArrayList();

    private static Collection getAllButFirst(Collection c) {
        ArrayList remainder;
        if (c == null || c.size() < 1) {
            remainder = Collections.EMPTY_LIST;
        } else {
            ArrayList list = new ArrayList(c);
            list.remove(0);
            remainder = list;
        }
        return remainder;
    }

    public static Collection getAllowedClses(Collection bindingValue) {
        KnowledgeBase kb;
        ValueType type = ValueTypeConstraint.getType(bindingValue);
        Collection<Object> allowedClses = type.equals(ValueType.INSTANCE) ? ValueTypeConstraint.getAllButFirst(bindingValue) : (type.equals(ValueType.CLS) ? ((kb = ValueTypeConstraint.getKb(bindingValue)) == null ? Collections.EMPTY_LIST : CollectionUtilities.createCollection(kb.getRootClsMetaCls())) : Collections.EMPTY_LIST);
        allowedClses = ValueTypeConstraint.ensureClses(allowedClses);
        return allowedClses;
    }

    private static Collection ensureClses(Collection clses) {
        ArrayList copyClses = new ArrayList();
        for (Object o : clses) {
            if (!(o instanceof Cls)) {
                Log.getLogger().severe("Invalid Class: " + o + " with type = " + (o == null ? " null " : o.getClass().toString()));
                continue;
            }
            if (copyClses.contains(o)) continue;
            copyClses.add(o);
        }
        return copyClses;
    }

    private static KnowledgeBase getKb(Collection bindingValue) {
        KnowledgeBase kb = null;
        for (Object o : bindingValue) {
            if (!(o instanceof Frame)) continue;
            kb = ((Frame)o).getKnowledgeBase();
        }
        return kb;
    }

    public static Collection getAllowedParents(Collection bindingValue) {
        KnowledgeBase kb;
        ValueType type = ValueTypeConstraint.getType(bindingValue);
        Collection allowedParents = type.equals(ValueType.CLS) ? ValueTypeConstraint.getAllButFirst(bindingValue) : (type.equals(ValueType.INSTANCE) ? ((kb = ValueTypeConstraint.getKb(bindingValue)) == null ? Collections.EMPTY_LIST : kb.getRootClses()) : Collections.EMPTY_LIST);
        allowedParents = ValueTypeConstraint.ensureClses(allowedParents);
        return allowedParents;
    }

    public static Collection getAllowedValues(Collection bindingValue) {
        ValueType type = ValueTypeConstraint.getType(bindingValue);
        return type.equals(ValueType.SYMBOL) ? ValueTypeConstraint.getAllButFirst(bindingValue) : Collections.EMPTY_LIST;
    }

    private static String getInvalidAnyValueText(Object value) {
        boolean isValid = value instanceof Boolean || value instanceof Frame || value instanceof String || value instanceof Number;
        return isValid ? (String)null : "Value must by one of the allowed types";
    }

    private static String getInvalidBooleanValueText(Object value) {
        if (value instanceof String) {
            Log.getLogger().warning("String value in boolean slot: " + value);
        }
        return value instanceof Boolean ? (String)null : "Value must be a boolean";
    }

    private static String getInvalidClsValueText(Object value, Collection allowedParents) {
        String result = null;
        if (value instanceof Cls) {
            Cls cls = (Cls)value;
            if (!allowedParents.contains(cls)) {
                boolean foundParent = false;
                Iterator i = allowedParents.iterator();
                while (!foundParent && i.hasNext()) {
                    Cls parent = (Cls)i.next();
                    if (!cls.hasSuperclass(parent)) continue;
                    foundParent = true;
                }
                if (!foundParent) {
                    result = "Value must be a subclass of one of the allowed parents";
                }
            }
        } else {
            result = "Value must be a class";
        }
        return result;
    }

    private static String getInvalidFloatValueText(Object value) {
        return value instanceof Float ? (String)null : "Value must be a floating point number";
    }

    private static String getInvalidInstanceValueText(Object value, Collection allowedClses) {
        String result = null;
        if (value instanceof Instance) {
            if (!allowedClses.isEmpty()) {
                Instance instance = (Instance)value;
                boolean foundType = false;
                Iterator i = allowedClses.iterator();
                while (!foundType && i.hasNext()) {
                    Cls type = (Cls)i.next();
                    if (!instance.hasType(type)) continue;
                    foundType = true;
                }
                if (!foundType) {
                    result = "Value must be an instance of one of the allowed classes";
                }
            }
        } else {
            result = "Value must be an instance";
        }
        return result;
    }

    private static String getInvalidIntegerValueText(Object value) {
        return value instanceof Integer ? (String)null : "Value must be an integer";
    }

    private static String getInvalidStringValueText(Object value) {
        return value instanceof String ? (String)null : "Value must be a string";
    }

    private static String getInvalidSymbolValueText(Object value, Collection allowedValues) {
        return allowedValues.contains(value) ? (String)null : "'" + value + "' is not one of the allowed values";
    }

    public String getInvalidValuesText(Frame frame, Slot slot, Collection slotValues, Collection facetValues) {
        String result = null;
        ValueType type = ValueTypeConstraint.getType(facetValues);
        Iterator i = slotValues.iterator();
        while (result == null && i.hasNext()) {
            Object value = i.next();
            result = ValueTypeConstraint.getInvalidValueText(facetValues, type, value);
        }
        return result;
    }

    public String getInvalidValueText(Frame frame, Slot slot, Object value, Collection facetValues) {
        ValueType type = ValueTypeConstraint.getType(facetValues);
        return ValueTypeConstraint.getInvalidValueText(facetValues, type, value);
    }

    private static String getInvalidValueText(Collection facetValues, ValueType type, Object value) {
        String result = null;
        if (ValueTypeConstraint.equals(type, ValueType.BOOLEAN)) {
            result = ValueTypeConstraint.getInvalidBooleanValueText(value);
        } else if (ValueTypeConstraint.equals(type, ValueType.CLS)) {
            result = ValueTypeConstraint.getInvalidClsValueText(value, ValueTypeConstraint.getAllowedParents(facetValues));
        } else if (ValueTypeConstraint.equals(type, ValueType.FLOAT)) {
            result = ValueTypeConstraint.getInvalidFloatValueText(value);
        } else if (ValueTypeConstraint.equals(type, ValueType.INSTANCE)) {
            result = ValueTypeConstraint.getInvalidInstanceValueText(value, ValueTypeConstraint.getAllowedClses(facetValues));
        } else if (ValueTypeConstraint.equals(type, ValueType.INTEGER)) {
            result = ValueTypeConstraint.getInvalidIntegerValueText(value);
        } else if (ValueTypeConstraint.equals(type, ValueType.STRING)) {
            result = ValueTypeConstraint.getInvalidStringValueText(value);
        } else if (ValueTypeConstraint.equals(type, ValueType.SYMBOL)) {
            result = ValueTypeConstraint.getInvalidSymbolValueText(value, ValueTypeConstraint.getAllowedValues(facetValues));
        } else if (ValueTypeConstraint.equals(type, ValueType.ANY)) {
            result = ValueTypeConstraint.getInvalidAnyValueText(value);
        } else {
            Assert.fail("Invalid type: " + type);
            result = "failed";
        }
        return result;
    }

    public static ValueType getType(Collection bindingValue) {
        ValueType type;
        Object first = CollectionUtilities.getFirstItem(bindingValue);
        if (first == null) {
            type = ValueType.ANY;
        } else if (first instanceof String) {
            type = ValueType.valueOf((String)first);
        } else {
            Log.getLogger().severe("invalid value type: " + bindingValue);
            type = ValueType.ANY;
        }
        return type;
    }

    public static Collection getValues() {
        return Collections.unmodifiableCollection(values);
    }

    public static Collection getValues(ValueType type) {
        return ValueTypeConstraint.getValues(type, Collections.EMPTY_LIST);
    }

    public static List getValues(ValueType type, Collection secondaryValues) {
        ArrayList<String> valueTypeValues = new ArrayList<String>();
        if (!type.equals(ValueType.ANY)) {
            valueTypeValues.add(type.toString());
            if (secondaryValues != null) {
                valueTypeValues.addAll(new LinkedHashSet(secondaryValues));
            }
        }
        return valueTypeValues;
    }

    public Collection resolve(Collection existingValues, Collection newValues) {
        ValueType t1 = ValueTypeConstraint.getType(existingValues);
        ValueType t2 = ValueTypeConstraint.getType(newValues);
        Collection resolvedValues = t1.equals(ValueType.ANY) ? newValues : (t2.equals(ValueType.ANY) ? existingValues : (t1.equals(t2) ? (t1.equals(ValueType.CLS) ? ValueTypeConstraint.resolveClsValues(existingValues, newValues) : (t1.equals(ValueType.INSTANCE) ? ValueTypeConstraint.resolveInstanceValues(existingValues, newValues) : (t1.equals(ValueType.SYMBOL) ? ValueTypeConstraint.resolveSymbolValues(existingValues, newValues) : existingValues))) : existingValues));
        return resolvedValues;
    }

    private static Collection resolveClsValues(Collection existingValues, Collection newValues) {
        return existingValues.isEmpty() ? newValues : existingValues;
    }

    private static Collection resolveInstanceValues(Collection existingValues, Collection newValues) {
        return existingValues.isEmpty() ? newValues : existingValues;
    }

    private static Collection resolveSymbolValues(Collection existingValues, Collection newValues) {
        return existingValues.isEmpty() ? newValues : existingValues;
    }

    static {
        values.add(ValueType.ANY.toString());
        values.add(ValueType.BOOLEAN.toString());
        values.add(ValueType.CLS.toString());
        values.add(ValueType.FLOAT.toString());
        values.add(ValueType.INSTANCE.toString());
        values.add(ValueType.INTEGER.toString());
        values.add(ValueType.STRING.toString());
        values.add(ValueType.SYMBOL.toString());
    }
}

