/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.InstanceUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;

public class WidgetDescriptor
implements Cloneable {
    private static final String CLASS_WIDGET = "Widget";
    private static final String SLOT_WIDGET_CLASSNAME = "widget_class_name";
    private static final String SLOT_PROPERTY_LIST = "property_list";
    private static final String SLOT_LABEL = "label";
    private static final String SLOT_NAME = "name";
    private static final String SLOT_HIDDEN = "is_hidden";
    private boolean _isTemporary;
    private boolean _isDirectlyCustomizedByUser;
    private Instance _instance;

    private WidgetDescriptor(Instance instance) {
        this._instance = instance;
    }

    public Object clone() {
        WidgetDescriptor d;
        try {
            d = (WidgetDescriptor)super.clone();
            d._instance = (Instance)this._instance.deepCopy(this._instance.getKnowledgeBase(), null);
        }
        catch (CloneNotSupportedException e) {
            Log.getLogger().severe(Log.toString(e));
            d = null;
        }
        return d;
    }

    public boolean equals(Object o) {
        boolean equals;
        if (o instanceof WidgetDescriptor) {
            WidgetDescriptor other = (WidgetDescriptor)o;
            equals = this._instance.equals(other._instance);
        } else {
            equals = false;
        }
        return equals;
    }

    public int hashCode() {
        return this._instance.hashCode();
    }

    public static boolean isActiveWidget(Instance instance) {
        boolean isActive = false;
        Cls type = instance.getDirectType();
        if (type.getName().equals(CLASS_WIDGET)) {
            String className = (String)ModelUtilities.getDirectOwnSlotValue(instance, SLOT_WIDGET_CLASSNAME);
            isActive = className != null;
        }
        return isActive;
    }

    public static WidgetDescriptor create(Instance instance) {
        WidgetDescriptor d = null;
        Cls type = instance.getDirectType();
        if (type == null) {
            Log.getLogger().severe("instance has null type" + instance.getName());
        } else if (type.getName().equals(CLASS_WIDGET)) {
            d = new WidgetDescriptor(instance);
        } else {
            Log.getLogger().severe("not an instance of Widget: " + instance.getName());
        }
        return d;
    }

    public static WidgetDescriptor create(KnowledgeBase projectKB) {
        Cls widgetCls = projectKB.getCls(CLASS_WIDGET);
        Assert.assertNotNull("widgetCls", widgetCls);
        Instance instance = projectKB.createInstance(null, widgetCls);
        return WidgetDescriptor.create(instance);
    }

    private static void deletePropertyListInstance(Instance propertyInstance) {
        KnowledgeBase kb = propertyInstance.getKnowledgeBase();
        Collection<Instance> roots = CollectionUtilities.createCollection(propertyInstance);
        for (Instance instance : kb.getReachableSimpleInstances(roots)) {
            instance.delete();
        }
    }

    public Rectangle getBounds() {
        Rectangle r = InstanceUtilities.getRectangle(this._instance);
        if (r.width == 0 || r.height == 0) {
            r = null;
        }
        return r;
    }

    public Instance getInstance() {
        return this._instance;
    }

    private Instance getInstanceValue(String slotName) {
        return (Instance)this.getValue(slotName);
    }

    public String getLabel() {
        String label = this.getStringValue(SLOT_LABEL);
        return label;
    }

    public Point getLocation() {
        return this.getBounds().getLocation();
    }

    public String getName() {
        return this.getStringValue(SLOT_NAME);
    }

    public PropertyList getPropertyList() {
        Instance instance = this.getInstanceValue(SLOT_PROPERTY_LIST);
        if (instance == null) {
            KnowledgeBase kb = this._instance.getKnowledgeBase();
            Cls cls = kb.getCls("Property_List");
            instance = this._instance.getKnowledgeBase().createInstance(null, cls);
            this.setValue(SLOT_PROPERTY_LIST, instance);
        }
        return new PropertyList(instance);
    }

    private String getStringValue(String slotName) {
        return (String)this.getValue(slotName);
    }

    private Object getValue(String slotName) {
        return this._instance == null ? (Object)null : ModelUtilities.getDirectOwnSlotValue(this._instance, slotName);
    }

    public String getWidgetClassName() {
        return this.getStringValue(SLOT_WIDGET_CLASSNAME);
    }

    public boolean isDirectlyCustomizedByUser() {
        return this._isDirectlyCustomizedByUser;
    }

    public boolean isIncluded() {
        return this._instance.isIncluded();
    }

    public boolean isNull() {
        return this.getWidgetClassName() == null;
    }

    public boolean isTemporary() {
        return this._isTemporary;
    }

    public boolean isVisible() {
        Boolean isHidden = (Boolean)this.getValue(SLOT_HIDDEN);
        return isHidden == null ? true : isHidden == false;
    }

    public void setBounds(Rectangle r) {
        InstanceUtilities.setRectangle(this._instance, r);
    }

    public void setDirectlyCustomizedByUser(boolean b) {
        if (this._isDirectlyCustomizedByUser != b) {
            this._isDirectlyCustomizedByUser = b;
            this._isTemporary = !this._isDirectlyCustomizedByUser;
        }
    }

    public void setIncluded(boolean b) {
        WidgetDescriptor.setInstanceTreeIncluded(this._instance, b);
    }

    private static void setInstanceTreeIncluded(Instance instance, boolean included) {
        WidgetDescriptor.setIncluded(instance, included);
        for (Instance reachableInstance : instance.getReachableSimpleInstances()) {
            WidgetDescriptor.setIncluded(reachableInstance, included);
        }
    }

    private static void setIncluded(Instance instance, boolean included) {
        instance.setIncluded(included);
    }

    public void setLabel(String label) {
        this.setValue(SLOT_LABEL, label);
    }

    public void setName(String name) {
        this.setValue(SLOT_NAME, name);
    }

    public void setPropertyList(PropertyList list) {
        Instance instance = (Instance)this.getValue(SLOT_PROPERTY_LIST);
        if (instance != null) {
            WidgetDescriptor.deletePropertyListInstance(instance);
        }
        Instance wrappedInstance = list.getWrappedInstance();
        this.setValue(SLOT_PROPERTY_LIST, wrappedInstance);
        WidgetDescriptor.setInstanceTreeIncluded(wrappedInstance, this._instance.isIncluded());
    }

    public void setTemporary(boolean b) {
        this._isTemporary = b;
    }

    private void setValue(String slotName, Object value) {
        ModelUtilities.setOwnSlotValue(this._instance, slotName, value);
    }

    public void setVisible(boolean b) {
        this.setValue(SLOT_HIDDEN, !b);
    }

    public void setWidgetClassName(String name) {
        String oldName = this.getWidgetClassName();
        if (!SystemUtilities.equals(name, oldName)) {
            this.setValue(SLOT_WIDGET_CLASSNAME, name);
            this.getPropertyList().clear();
        }
    }

    public String toString() {
        String text = "WidgetDescriptor(name=" + this.getName();
        text = text + ", temp=" + this.isTemporary();
        text = text + ", included=" + this.isIncluded();
        text = text + ", classname=" + this.getWidgetClassName();
        text = text + ")";
        return text;
    }
}

