/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFrameStoreInvocationHandler
implements InvocationHandler {
    private static final Logger log = Log.getLogger(AbstractFrameStoreInvocationHandler.class);
    private FrameStore _delegate;
    private static final Set<Method> specialMethods = new HashSet<Method>();

    private static Method getMethod(String name) throws Exception {
        return AbstractFrameStoreInvocationHandler.getMethod(FrameStore.class, name);
    }

    private static Method getMethod(Class clas, String name) throws Exception {
        return clas.getMethod(name, null);
    }

    private static Method getMethod(String name, Class arg) throws Exception {
        return AbstractFrameStoreInvocationHandler.getMethod(FrameStore.class, name, arg);
    }

    private static Method getMethod(Class clas, String name, Class arg) throws Exception {
        return clas.getMethod(name, arg);
    }

    private static boolean isSpecial(Method method) {
        return specialMethods.contains(method);
    }

    protected FrameStore getDelegate() {
        return this._delegate;
    }

    protected void setDelegate(FrameStore delegate) {
        this._delegate = delegate;
    }

    public static FrameStore newInstance(Class handlerClass) {
        return AbstractFrameStoreInvocationHandler.newInstance(handlerClass, null);
    }

    public static Object getInstance(Class clas, KnowledgeBase kb) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object instance;
        try {
            Constructor constructor = clas.getConstructor(KnowledgeBase.class);
            instance = constructor.newInstance(kb);
        }
        catch (NoSuchMethodException ex) {
            instance = clas.newInstance();
        }
        return instance;
    }

    public static FrameStore newInstance(Class handlerClass, KnowledgeBase kb) {
        FrameStore fs = null;
        try {
            AbstractFrameStoreInvocationHandler handler = (AbstractFrameStoreInvocationHandler)AbstractFrameStoreInvocationHandler.getInstance(handlerClass, kb);
            fs = (FrameStore)Proxy.newProxyInstance(handlerClass.getClassLoader(), new Class[]{FrameStore.class}, (InvocationHandler)handler);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return fs;
    }

    protected static boolean isQuery(Method method) {
        String name = method.getName();
        return name.startsWith("get");
    }

    protected static boolean isModification(Method method) {
        return !AbstractFrameStoreInvocationHandler.isQuery(method) && !method.getName().equals("reinitialize");
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        Object o = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("invoking " + StringUtilities.getClassName(this));
        }
        if (AbstractFrameStoreInvocationHandler.isSpecial(method)) {
            o = this.invokeSpecial(proxy, method, args);
        } else if (this._delegate != null) {
            o = this.handleInvoke(method, args);
        }
        return o;
    }

    private Object invokeSpecial(Object proxy, Method method, Object[] args) {
        Object o = null;
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            o = this.toString();
        } else if (methodName.equals("equals")) {
            o = proxy == args[0];
        } else if (methodName.equals("getDelegate")) {
            o = this._delegate;
        } else if (methodName.equals("setDelegate")) {
            this.setDelegate((FrameStore)args[0]);
        } else if (methodName.equals("close")) {
            this.handleClose();
            this._delegate = null;
        } else if (methodName.equals("reinitialize")) {
            this.handleReinitialize();
        } else if (methodName.equals("executeQuery")) {
            this.executeQuery((Query)args[0], (QueryCallback)args[1]);
        }
        return o;
    }

    protected void handleReinitialize() {
    }

    protected void handleClose() {
    }

    protected abstract Object handleInvoke(Method var1, Object[] var2);

    protected abstract void executeQuery(Query var1, QueryCallback var2);

    protected Object invoke(Method m, Object[] args) {
        return AbstractFrameStoreInvocationHandler.invoke(m, args, this._delegate);
    }

    protected static Object invoke(Method m, Object[] args, FrameStore frameStore) {
        Object result = null;
        try {
            result = m.invoke((Object)frameStore, args);
        }
        catch (IllegalAccessException e) {
            Log.getLogger().warning(Log.toString(e));
        }
        catch (InvocationTargetException targetException) {
            Throwable cause = targetException.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            Log.getLogger().warning(Log.toString(cause));
        }
        return result;
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    static {
        try {
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod(Object.class, "toString"));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod(Object.class, "equals", Object.class));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod("getDelegate"));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod("setDelegate", FrameStore.class));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod("close"));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod("reinitialize"));
            specialMethods.add(FrameStore.class.getMethod("executeQuery", Query.class, QueryCallback.class));
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
        }
    }
}

