/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentCheckingFrameStore
extends AbstractFrameStore {
    private static void assertNotNull(String text, Object o) {
        if (o == null) {
            throw new IllegalArgumentException("null " + text);
        }
    }

    private static void fail(String text) {
        throw new IllegalArgumentException(text);
    }

    private static void checkFrame(Frame frame) {
        ArgumentCheckingFrameStore.assertNotNull("frame", frame);
    }

    private static void checkCls(Cls cls) {
        ArgumentCheckingFrameStore.assertNotNull("class", cls);
    }

    private static void checkSlot(Slot slot) {
        ArgumentCheckingFrameStore.assertNotNull("slot", slot);
    }

    private static void checkFacet(Facet facet) {
        ArgumentCheckingFrameStore.assertNotNull("facet", facet);
    }

    private static void checkInstance(Instance instance) {
        ArgumentCheckingFrameStore.assertNotNull("instance", instance);
    }

    private static void checkString(String string) {
        ArgumentCheckingFrameStore.assertNotNull("string", string);
    }

    private static void checkSimpleInstance(SimpleInstance simpleInstance) {
        ArgumentCheckingFrameStore.assertNotNull("simple instance", simpleInstance);
    }

    private static void checkClses(Collection c) {
        for (Object o : c) {
            if (o instanceof Cls) continue;
            ArgumentCheckingFrameStore.fail("not a class: " + o);
        }
    }

    private static void checkSlots(Collection c) {
        for (Object o : c) {
            if (o instanceof Slot) continue;
            ArgumentCheckingFrameStore.fail("not a slot: " + o);
        }
    }

    private static void checkValue(Object o) {
        ArgumentCheckingFrameStore.assertNotNull("value", o);
        if (!ArgumentCheckingFrameStore.isValidType(o)) {
            ArgumentCheckingFrameStore.fail("invalid type: " + o);
        }
    }

    private static boolean isValidType(Object o) {
        return o instanceof String || o instanceof Frame || o instanceof Boolean || o instanceof Integer || o instanceof Float;
    }

    private static void checkValues(Collection c) {
        for (Object o : c) {
            ArgumentCheckingFrameStore.checkValue(o);
        }
    }

    @Override
    public Frame getFrame(FrameID id) {
        return this.getDelegate().getFrame(id);
    }

    @Override
    public Frame getFrame(String name) {
        ArgumentCheckingFrameStore.checkString(name);
        return this.getDelegate().getFrame(name);
    }

    @Override
    public String getFrameName(Frame frame) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        return this.getDelegate().getFrameName(frame);
    }

    @Override
    public Cls createCls(FrameID id, Collection directTypes, Collection directSuperclasses, boolean loadDefaultValues) {
        ArgumentCheckingFrameStore.checkClses(directTypes);
        ArgumentCheckingFrameStore.checkClses(directSuperclasses);
        return this.getDelegate().createCls(id, directTypes, directSuperclasses, loadDefaultValues);
    }

    @Override
    public Slot createSlot(FrameID id, Collection directTypes, Collection directSuperslots, boolean loadDefaultValues) {
        ArgumentCheckingFrameStore.checkClses(directTypes);
        ArgumentCheckingFrameStore.checkSlots(directSuperslots);
        return this.getDelegate().createSlot(id, directTypes, directSuperslots, loadDefaultValues);
    }

    @Override
    public Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        ArgumentCheckingFrameStore.checkClses(directTypes);
        return this.getDelegate().createFacet(id, directTypes, loadDefaultValues);
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        ArgumentCheckingFrameStore.checkClses(directTypes);
        return this.getDelegate().createSimpleInstance(id, directTypes, loadDefaultValues);
    }

    @Override
    public void deleteCls(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        this.getDelegate().deleteCls(cls);
    }

    @Override
    public void deleteSlot(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().deleteSlot(slot);
    }

    @Override
    public void deleteFacet(Facet facet) {
        ArgumentCheckingFrameStore.checkFacet(facet);
        this.getDelegate().deleteFacet(facet);
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        ArgumentCheckingFrameStore.checkSimpleInstance(simpleInstance);
        this.getDelegate().deleteSimpleInstance(simpleInstance);
    }

    @Override
    public Set<Slot> getOwnSlots(Frame frame) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        return this.getDelegate().getOwnSlots(frame);
    }

    @Override
    public Collection getOwnSlotValues(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getOwnSlotValues(frame, slot);
    }

    @Override
    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectOwnSlotValues(frame, slot);
    }

    @Override
    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int indexFrom, int indexTo) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, indexFrom, indexTo);
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValues(values);
        this.getDelegate().setDirectOwnSlotValues(frame, slot, values);
    }

    @Override
    public Set getOwnFacets(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getOwnFacets(frame, slot);
    }

    @Override
    public Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        return this.getDelegate().getOwnFacetValues(frame, slot, facet);
    }

    @Override
    public Set getTemplateSlots(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getTemplateSlots(cls);
    }

    @Override
    public List getDirectTemplateSlots(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectTemplateSlots(cls);
    }

    @Override
    public List getDirectDomain(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectDomain(slot);
    }

    @Override
    public Set getDomain(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDomain(slot);
    }

    @Override
    public Set getOverriddenTemplateSlots(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getOverriddenTemplateSlots(cls);
    }

    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectlyOverriddenTemplateSlots(cls);
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().addDirectTemplateSlot(cls, slot);
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int index) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().moveDirectTemplateSlot(cls, slot, index);
    }

    @Override
    public Collection getTemplateSlotValues(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getTemplateSlotValues(cls, slot);
    }

    @Override
    public List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectTemplateSlotValues(cls, slot);
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValues(values);
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, values);
    }

    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getTemplateFacets(cls, slot);
    }

    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getOverriddenTemplateFacets(cls, slot);
    }

    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectlyOverriddenTemplateFacets(cls, slot);
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
    }

    @Override
    public Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        return this.getDelegate().getTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        return this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        ArgumentCheckingFrameStore.checkValues(values);
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, values);
    }

    @Override
    public List<Cls> getDirectSuperclasses(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectSuperclasses(cls);
    }

    @Override
    public Set getSuperclasses(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getSuperclasses(cls);
    }

    @Override
    public List<Cls> getDirectSubclasses(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectSubclasses(cls);
    }

    @Override
    public Set<Cls> getSubclasses(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getSubclasses(cls);
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls superclass) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkCls(superclass);
        this.getDelegate().addDirectSuperclass(cls, superclass);
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls superclass) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkCls(superclass);
        this.getDelegate().removeDirectSuperclass(cls, superclass);
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        ArgumentCheckingFrameStore.checkCls(cls);
        ArgumentCheckingFrameStore.checkCls(subclass);
        this.getDelegate().moveDirectSubclass(cls, subclass, index);
    }

    @Override
    public List getDirectSuperslots(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectSuperslots(slot);
    }

    @Override
    public Set getSuperslots(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getSuperslots(slot);
    }

    @Override
    public List getDirectSubslots(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectSubslots(slot);
    }

    @Override
    public Set getSubslots(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getSubslots(slot);
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot superslot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkSlot(superslot);
        this.getDelegate().addDirectSuperslot(slot, superslot);
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkSlot(superslot);
        this.getDelegate().removeDirectSuperslot(slot, superslot);
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkSlot(subslot);
        this.getDelegate().moveDirectSubslot(slot, subslot, index);
    }

    @Override
    public List getDirectTypes(Instance instance) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        return this.getDelegate().getDirectTypes(instance);
    }

    @Override
    public Set getTypes(Instance instance) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        return this.getDelegate().getTypes(instance);
    }

    @Override
    public List<Instance> getDirectInstances(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getDirectInstances(cls);
    }

    @Override
    public Set<Instance> getInstances(Cls cls) {
        ArgumentCheckingFrameStore.checkCls(cls);
        return this.getDelegate().getInstances(cls);
    }

    @Override
    public void addDirectType(Instance instance, Cls type) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        ArgumentCheckingFrameStore.checkCls(type);
        this.getDelegate().addDirectType(instance, type);
    }

    @Override
    public void removeDirectType(Instance instance, Cls type) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        ArgumentCheckingFrameStore.checkCls(type);
        this.getDelegate().removeDirectType(instance, type);
    }

    @Override
    public void moveDirectType(Instance instance, Cls type, int index) {
        ArgumentCheckingFrameStore.checkInstance(instance);
        ArgumentCheckingFrameStore.checkCls(type);
        this.getDelegate().moveDirectType(instance, type, index);
    }

    @Override
    public void executeQuery(Query query, QueryCallback callback) {
        this.getDelegate().executeQuery(query, callback);
    }

    @Override
    public Set<Reference> getReferences(Object object) {
        ArgumentCheckingFrameStore.checkValue(object);
        return this.getDelegate().getReferences(object);
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int maxMatches) {
        ArgumentCheckingFrameStore.checkString(string);
        return this.getDelegate().getMatchingReferences(string, maxMatches);
    }

    @Override
    public Set<Cls> getClsesWithMatchingBrowserText(String text, Collection superclasses, int maxMatches) {
        ArgumentCheckingFrameStore.checkString(text);
        ArgumentCheckingFrameStore.checkClses(superclasses);
        return this.getDelegate().getClsesWithMatchingBrowserText(text, superclasses, maxMatches);
    }

    @Override
    public Set<Frame> getFramesWithDirectOwnSlotValue(Slot slot, Object value) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValue(value);
        return this.getDelegate().getFramesWithDirectOwnSlotValue(slot, value);
    }

    @Override
    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getFramesWithAnyDirectOwnSlotValue(slot);
    }

    @Override
    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String value, int maxMatches) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValue(value);
        return this.getDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, value, maxMatches);
    }

    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object value) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkValue(value);
        return this.getDelegate().getClsesWithDirectTemplateSlotValue(slot, value);
    }

    @Override
    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot slot) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getClsesWithAnyDirectTemplateSlotValue(slot);
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String value, int maxMatches) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkString(value);
        return this.getDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, value, maxMatches);
    }

    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object value) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        ArgumentCheckingFrameStore.checkValue(value);
        return this.getDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, value);
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String value, int maxMatches) {
        ArgumentCheckingFrameStore.checkSlot(slot);
        ArgumentCheckingFrameStore.checkFacet(facet);
        ArgumentCheckingFrameStore.checkString(value);
        return this.getDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, value, maxMatches);
    }

    @Override
    public Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        ArgumentCheckingFrameStore.checkFrame(frame);
        ArgumentCheckingFrameStore.checkSlot(slot);
        return this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
    }

    @Override
    public boolean beginTransaction(String name) {
        ArgumentCheckingFrameStore.checkString(name);
        return this.getDelegate().beginTransaction(name);
    }

    @Override
    public boolean commitTransaction() {
        return this.getDelegate().commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        return this.getDelegate().rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.getDelegate().getTransactionStatusMonitor();
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public int getClsCount() {
        return this.getDelegate().getClsCount();
    }

    @Override
    public int getSlotCount() {
        return this.getDelegate().getSlotCount();
    }

    @Override
    public int getFacetCount() {
        return this.getDelegate().getFacetCount();
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.getDelegate().getSimpleInstanceCount();
    }

    @Override
    public int getFrameCount() {
        return this.getDelegate().getFrameCount();
    }

    @Override
    public Set<Cls> getClses() {
        return this.getDelegate().getClses();
    }

    @Override
    public Set<Slot> getSlots() {
        return this.getDelegate().getSlots();
    }

    @Override
    public Set<Facet> getFacets() {
        return this.getDelegate().getFacets();
    }

    @Override
    public Set<Frame> getFrames() {
        return this.getDelegate().getFrames();
    }

    @Override
    public List<AbstractEvent> getEvents() {
        return this.getDelegate().getEvents();
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        ArgumentCheckingFrameStore.checkFrame(original);
        ArgumentCheckingFrameStore.checkFrame(replacement);
        this.getDelegate().replaceFrame(original, replacement);
    }
}

