/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.MethodCall;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.lang.reflect.Method;
import java.util.Collection;

public class CallCachingFrameStore
extends AbstractFrameStoreInvocationHandler {
    private static final int MAX_SIZE = 100000;
    private CacheMap _cache = new CacheMap(100000);
    private MethodCall _lookupMethodCall = new MethodCall();
    private TransactionMonitor transactionMonitor;
    private int hit = 0;
    private int miss = 0;

    protected Object handleInvoke(Method method, Object[] args) {
        Object result;
        if (CallCachingFrameStore.isGetEvents(method)) {
            result = this.invoke(method, args);
            Collection c = (Collection)result;
            if (!c.isEmpty()) {
                this.clearCache();
            }
        } else if (CallCachingFrameStore.isQuery(method)) {
            result = this.query(method, args);
        } else {
            this._cache.clear();
            result = this.invoke(method, args);
        }
        return result;
    }

    public void executeQuery(Query q, QueryCallback qc) {
        this.getDelegate().executeQuery(q, qc);
    }

    private static boolean isGetEvents(Method m) {
        return m.getName().equals("getEvents");
    }

    private Object query(Method method, Object[] args) {
        boolean mustRead = false;
        try {
            mustRead = this.transactionMonitor != null && this.transactionMonitor.inTransaction() && this.transactionMonitor.getTransationIsolationLevel() == TransactionIsolationLevel.SERIALIZABLE;
        }
        catch (TransactionException te) {
            mustRead = true;
        }
        this._lookupMethodCall.set(method, args);
        Object o = this._cache.get(this._lookupMethodCall);
        if (o == null || mustRead) {
            ++this.miss;
            o = this.invoke(method, args);
            if (this.transactionMonitor == null || !this.transactionMonitor.existsTransaction()) {
                this._cache.put(new MethodCall(method, args), o);
            }
        } else {
            ++this.hit;
        }
        return o;
    }

    private void clearCache() {
        this._cache.clear();
    }

    public void handleClose() {
        this._cache.clear();
        this._cache = null;
    }

    protected void handleReinitialize() {
        this._cache.clear();
    }

    protected void setDelegate(FrameStore delegate) {
        super.setDelegate(delegate);
        if (delegate != null) {
            this.transactionMonitor = delegate.getTransactionStatusMonitor();
        }
    }
}

