/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import java.util.Collection;

public class ChangeMonitorFrameStore
extends ModificationFrameStore {
    private boolean changed;

    private void markChanged() {
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    public void reinitialize() {
        this.changed = false;
    }

    public Cls createCls(FrameID id, Collection directTypes, Collection directSuperclasses, boolean loadDefaultValues) {
        this.markChanged();
        return this.getDelegate().createCls(id, directTypes, directSuperclasses, loadDefaultValues);
    }

    public Slot createSlot(FrameID id, Collection directTypes, Collection directSuperslots, boolean loadDefaultValues) {
        this.markChanged();
        return this.getDelegate().createSlot(id, directTypes, directSuperslots, loadDefaultValues);
    }

    public Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        this.markChanged();
        return this.getDelegate().createFacet(id, directTypes, loadDefaultValues);
    }

    public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        this.markChanged();
        return this.getDelegate().createSimpleInstance(id, directTypes, loadDefaultValues);
    }

    public void deleteCls(Cls cls) {
        this.markChanged();
        this.getDelegate().deleteCls(cls);
    }

    public void deleteSlot(Slot slot) {
        this.markChanged();
        this.getDelegate().deleteSlot(slot);
    }

    public void deleteFacet(Facet facet) {
        this.markChanged();
        this.getDelegate().deleteFacet(facet);
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.markChanged();
        this.getDelegate().deleteSimpleInstance(simpleInstance);
    }

    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int indexFrom, int indexTo) {
        this.markChanged();
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, indexFrom, indexTo);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        this.markChanged();
        this.getDelegate().setDirectOwnSlotValues(frame, slot, values);
    }

    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.markChanged();
        this.getDelegate().addDirectTemplateSlot(cls, slot);
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.markChanged();
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
    }

    public void moveDirectTemplateSlot(Cls cls, Slot slot, int index) {
        this.markChanged();
        this.getDelegate().moveDirectTemplateSlot(cls, slot, index);
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        this.markChanged();
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, values);
    }

    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.markChanged();
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        this.markChanged();
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, values);
    }

    public void addDirectSuperclass(Cls cls, Cls superclass) {
        this.markChanged();
        this.getDelegate().addDirectSuperclass(cls, superclass);
    }

    public void removeDirectSuperclass(Cls cls, Cls superclass) {
        this.markChanged();
        this.getDelegate().removeDirectSuperclass(cls, superclass);
    }

    public void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        this.markChanged();
        this.getDelegate().moveDirectSubclass(cls, subclass, index);
    }

    public void addDirectSuperslot(Slot slot, Slot superslot) {
        this.markChanged();
        this.getDelegate().addDirectSuperslot(slot, superslot);
    }

    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        this.markChanged();
        this.getDelegate().removeDirectSuperslot(slot, superslot);
    }

    public void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        this.markChanged();
        this.getDelegate().moveDirectSubslot(slot, subslot, index);
    }

    public void addDirectType(Instance instance, Cls type) {
        this.markChanged();
        this.getDelegate().addDirectType(instance, type);
    }

    public void removeDirectType(Instance instance, Cls type) {
        this.markChanged();
        this.getDelegate().removeDirectType(instance, type);
    }

    public void moveDirectType(Instance instance, Cls type, int index) {
        this.markChanged();
        this.getDelegate().moveDirectType(instance, type, index);
    }

    public boolean beginTransaction(String name) {
        return this.getDelegate().beginTransaction(name);
    }

    public boolean commitTransaction() {
        return this.getDelegate().commitTransaction();
    }

    public boolean rollbackTransaction() {
        return this.getDelegate().rollbackTransaction();
    }

    public void replaceFrame(Frame original, Frame replacement) {
        this.markChanged();
        this.getDelegate().replaceFrame(original, replacement);
    }
}

