/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ClosureUtils;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureCachingBasicFrameStore
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(ClosureCachingBasicFrameStore.class);
    private NarrowFrameStore _delegate;
    private final CacheMap<Sft, Map<Frame, Set>> _sftToFrameToClosureMap = new CacheMap();

    public ClosureCachingBasicFrameStore(NarrowFrameStore delegate) {
        if (log.isLoggable(Level.FINEST)) {
            log.fine("Constructing NarrowFrameStore " + this + " with delegate " + delegate);
        }
        this._delegate = delegate;
    }

    @Override
    public String getName() {
        return StringUtilities.getClassName(this);
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this._delegate;
    }

    @Override
    public Frame getFrame(FrameID id) {
        return this._delegate.getFrame(id);
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this._delegate.getValues(frame, slot, facet, isTemplate);
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this._delegate.getValuesCount(frame, slot, facet, isTemplate);
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        this._delegate.setValues(frame, slot, facet, isTemplate, values);
        this.updateClosureCache(slot, facet, isTemplate);
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        this._delegate.addValues(frame, slot, facet, isTemplate, values);
        this.updateClosureCache(slot, facet, isTemplate);
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        this._delegate.removeValue(frame, slot, facet, isTemplate, value);
        this.updateClosureCache(slot, facet, isTemplate);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int from, int to) {
        this._delegate.moveValue(frame, slot, facet, isTemplate, from, to);
    }

    public Set getFrames(Slot slot, Facet facet, boolean isTemplate, Object value) {
        return this._delegate.getFrames(slot, facet, isTemplate, value);
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean isTemplate) {
        return this._delegate.getFramesWithAnyValue(slot, facet, isTemplate);
    }

    @Override
    public int getFrameCount() {
        return this._delegate.getFrameCount();
    }

    @Override
    public int getClsCount() {
        return this._delegate.getClsCount();
    }

    @Override
    public int getSlotCount() {
        return this._delegate.getSlotCount();
    }

    @Override
    public int getFacetCount() {
        return this._delegate.getFacetCount();
    }

    @Override
    public int getSimpleInstanceCount() {
        return this._delegate.getSimpleInstanceCount();
    }

    public Set getFrames() {
        return this._delegate.getFrames();
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) {
        return this._delegate.getMatchingFrames(slot, facet, isTemplate, value, maxMatches);
    }

    @Override
    public Set<Reference> getReferences(Object value) {
        return this._delegate.getReferences(value);
    }

    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches) {
        return this._delegate.getMatchingReferences(value, maxMatches);
    }

    @Override
    public void deleteFrame(Frame frame) {
        this._delegate.deleteFrame(frame);
        this.deleteFrameFromCache(frame);
    }

    @Override
    public void executeQuery(Query query, QueryCallback callback) {
        this._delegate.executeQuery(query, callback);
    }

    @Override
    public void close() {
        this._delegate.close();
        this._delegate = null;
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        Set closure = this.lookup(frame, slot, facet, isTemplate);
        if (closure == null) {
            closure = ClosureUtils.calculateClosure(this, frame, slot, facet, isTemplate);
            TransactionMonitor transactionMonitor = this.getTransactionStatusMonitor();
            if (transactionMonitor == null || !transactionMonitor.existsTransaction()) {
                this.insert(frame, slot, facet, isTemplate, closure);
            }
        } else if (log.isLoggable(Level.FINER)) {
            log.finer("closure cache hit for frame = " + frame + " slot = " + slot + "facet = " + facet + " isTemplate = " + isTemplate);
        }
        return closure;
    }

    private Map<Frame, Set> lookup(Slot slot, Facet facet, boolean isTemplate) {
        Sft lookupSft = new Sft(slot, facet, isTemplate);
        return (Map)this._sftToFrameToClosureMap.get(lookupSft);
    }

    private Set lookup(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        Set closure = null;
        Map<Frame, Set> frameToClosureMap = this.lookup(slot, facet, isTemplate);
        if (frameToClosureMap != null) {
            closure = frameToClosureMap.get(frame);
        }
        return closure;
    }

    private void insert(Frame frame, Slot slot, Facet facet, boolean isTemplate, Set closure) {
        Map<Frame, Set> frameToClosureMap = this.lookup(slot, facet, isTemplate);
        if (frameToClosureMap == null) {
            frameToClosureMap = new HashMap<Frame, Set>();
            this._sftToFrameToClosureMap.put(new Sft(slot, facet, isTemplate), frameToClosureMap);
        }
        frameToClosureMap.put(frame, closure);
    }

    private void updateClosureCache(Slot slot, Facet facet, boolean isTemplate) {
        Sft lookupSft = new Sft(slot, facet, isTemplate);
        this._sftToFrameToClosureMap.remove(lookupSft);
    }

    private void deleteFrameFromCache(Frame frame) {
        this.removeFrameFromSft(frame);
        for (Sft sft : this._sftToFrameToClosureMap.keySet()) {
            Map frameToClosureMap = (Map)this._sftToFrameToClosureMap.get(sft);
            if (frameToClosureMap == null) continue;
            frameToClosureMap.remove(frame);
            ClosureCachingBasicFrameStore.removeFrameAsValueFromMap(frame, frameToClosureMap);
        }
    }

    private static void removeFrameAsValueFromMap(Frame frame, Map frameToClosureMap) {
        Iterator i = frameToClosureMap.values().iterator();
        while (i.hasNext()) {
            Set closure = (Set)i.next();
            if (!closure.contains(frame)) continue;
            i.remove();
        }
    }

    private void removeFrameFromSft(Frame frame) {
        if (frame instanceof Slot || frame instanceof Facet) {
            boolean isSlot = frame instanceof Slot;
            for (Sft sft : this._sftToFrameToClosureMap.keySet()) {
                if (isSlot) {
                    if (!ClosureCachingBasicFrameStore.equals(frame, sft.getSlot())) continue;
                    this._sftToFrameToClosureMap.remove(sft);
                    continue;
                }
                if (!ClosureCachingBasicFrameStore.equals(frame, sft.getFacet())) continue;
                this._sftToFrameToClosureMap.remove(sft);
            }
        }
    }

    @Override
    public boolean beginTransaction(String name) {
        TransactionMonitor monitor = this.getTransactionStatusMonitor();
        try {
            if (monitor != null && !monitor.existsTransaction() && monitor.getTransationIsolationLevel() == TransactionIsolationLevel.SERIALIZABLE) {
                this.clearCache();
            }
        }
        catch (TransactionException te) {
            this.clearCache();
        }
        return this._delegate.beginTransaction(name);
    }

    @Override
    public boolean commitTransaction() {
        boolean ret = this._delegate.commitTransaction();
        if (!ret) {
            this.clearCache();
        }
        return ret;
    }

    @Override
    public boolean rollbackTransaction() {
        return this._delegate.rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this._delegate.getTransactionStatusMonitor();
    }

    private void clearCache() {
        this._sftToFrameToClosureMap.clear();
    }

    @Override
    public void replaceFrame(Frame frame) {
        this.clearCache();
        this._delegate.replaceFrame(frame);
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    @Override
    public void reinitialize() {
        this.clearCache();
        if (this.getDelegate() != null) {
            this.getDelegate().reinitialize();
        }
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        this.clearCache();
        this._delegate.replaceFrame(original, replacement);
    }

    @Override
    public boolean setCaching(RemoteSession session, boolean doCache) {
        return this._delegate.setCaching(session, doCache);
    }
}

