/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.DefaultFacet;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.DefaultSimpleInstance;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultFrameFactory
implements FrameFactory {
    public static final int DEFAULT_CLS_JAVA_CLASS_ID = 6;
    public static final int DEFAULT_SLOT_JAVA_CLASS_ID = 7;
    public static final int DEFAULT_FACET_JAVA_CLASS_ID = 8;
    public static final int DEFAULT_SIMPLE_INSTANCE_JAVA_CLASS_ID = 5;
    private static final Class[] CONSTRUCTOR_PARAMETERS = new Class[]{KnowledgeBase.class, FrameID.class};
    private KnowledgeBase _kb;
    private Collection _packages = new ArrayList();
    private Map _typesToImplementationClassMap = new HashMap();

    public DefaultFrameFactory(KnowledgeBase kb) {
        this._kb = kb;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._kb;
    }

    public void addJavaPackage(String packageName) {
        this._packages.add(packageName);
    }

    public void removeJavaPackage(String packageName) {
        this._packages.remove(packageName);
    }

    public Cls createCls(FrameID id, Collection directTypes) {
        Class implementationClass = this.getImplementationClass(directTypes, DefaultCls.class);
        return this.createCls(id, implementationClass);
    }

    protected Cls createCls(FrameID id, Class implementationClass) {
        Cls cls = implementationClass.equals(DefaultCls.class) ? new DefaultCls(this._kb, id) : (Cls)this.createInstance(id, implementationClass);
        this.configureCls(cls);
        return cls;
    }

    public Slot createSlot(FrameID id, Collection directTypes) {
        Class implementationClass = this.getImplementationClass(directTypes, DefaultSlot.class);
        return this.createSlot(id, implementationClass);
    }

    protected Slot createSlot(FrameID id, Class implementationClass) {
        Slot slot = implementationClass.equals(DefaultSlot.class) ? new DefaultSlot(this._kb, id) : (Slot)this.createInstance(id, implementationClass);
        this.configureSlot(slot);
        return slot;
    }

    public Facet createFacet(FrameID id, Collection directTypes) {
        Class implementationClass = this.getImplementationClass(directTypes, DefaultFacet.class);
        return this.createFacet(id, implementationClass);
    }

    protected Facet createFacet(FrameID id, Class implementationClass) {
        Facet facet = implementationClass.equals(DefaultFacet.class) ? new DefaultFacet(this._kb, id) : (Facet)this.createInstance(id, implementationClass);
        this.configureFacet(facet);
        return facet;
    }

    public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes) {
        Class implementationClass = this.getImplementationClass(directTypes, DefaultSimpleInstance.class);
        return this.createSimpleInstance(id, implementationClass);
    }

    protected SimpleInstance createSimpleInstance(FrameID id, Class implementationClass) {
        SimpleInstance instance = implementationClass.equals(DefaultSimpleInstance.class) ? new DefaultSimpleInstance(this._kb, id) : (SimpleInstance)this.createInstance(id, implementationClass);
        this.configureSimpleInstance(instance);
        return instance;
    }

    protected void configureFacet(Facet facet) {
        Facet cachedSystemFacet;
        if (facet.isSystem() && (cachedSystemFacet = (Facet)this.getCachedSystemFrame(facet.getFrameID())) != null) {
            facet.setConstraint(cachedSystemFacet.getConstraint());
        }
    }

    protected void configureSimpleInstance(SimpleInstance simpleInstance) {
    }

    protected void configureCls(Cls cls) {
    }

    protected void configureSlot(Slot slot) {
    }

    private Frame getCachedSystemFrame(FrameID id) {
        return this._kb.getSystemFrames().getFrame(id);
    }

    protected Class getImplementationClass(Collection directTypes, Class defaultClass) {
        Class implementationClass;
        if (this._packages.isEmpty() || directTypes.size() != 1) {
            implementationClass = defaultClass;
        } else {
            Cls directType = (Cls)CollectionUtilities.getFirstItem(directTypes);
            implementationClass = (Class)this._typesToImplementationClassMap.get(directType);
            if (implementationClass == null) {
                implementationClass = this.getJavaImplementationClass(directType, defaultClass);
            }
            this._typesToImplementationClassMap.put(directType, implementationClass);
        }
        return implementationClass;
    }

    public boolean isCorrectJavaImplementationClass(FrameID id, Collection types, Class clas) {
        return this.getImplementationClass(types, clas).equals(clas);
    }

    private Instance createInstance(FrameID id, Class type) {
        Instance instance = null;
        try {
            Constructor constructor = type.getConstructor(CONSTRUCTOR_PARAMETERS);
            instance = (Instance)constructor.newInstance(this._kb, id);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return instance;
    }

    private Class getJavaImplementationClass(Cls type, Class baseClass) {
        Class implementationClass = null;
        Iterator i = this._packages.iterator();
        while (i.hasNext() && implementationClass == null) {
            String packageName = (String)i.next();
            implementationClass = this.getJavaImplementationClass(packageName, type);
        }
        if (implementationClass == null) {
            implementationClass = baseClass;
        } else if (!DefaultFrameFactory.isValidImplementationClass(implementationClass, baseClass)) {
            Log.getLogger().warning("Java implementation class of wrong type: " + implementationClass);
            implementationClass = baseClass;
        }
        return implementationClass;
    }

    private static boolean isValidImplementationClass(Class implementationClass, Class defaultClass) {
        return defaultClass.isAssignableFrom(implementationClass);
    }

    private Class getJavaImplementationClass(String packageName, Cls type) {
        String typeName = this.getJavaClassName(type);
        String className = packageName + "." + typeName;
        return SystemUtilities.forName(className, true);
    }

    protected String getJavaClassName(Cls type) {
        StringBuffer className = new StringBuffer();
        String typeName = type.getName();
        for (int i = 0; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (!this.isValidCharacter(c, className.length())) continue;
            className.append(c);
        }
        return className.toString();
    }

    protected boolean isValidCharacter(char c, int i) {
        return i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
    }

    public int getJavaClassId(Frame frame) {
        int javaClassId = frame instanceof Cls ? 6 : (frame instanceof Slot ? 7 : (frame instanceof Facet ? 8 : 5));
        return javaClassId;
    }

    public Frame createFrameFromClassId(int javaClassId, FrameID id) {
        Instance frame;
        switch (javaClassId) {
            case 6: {
                frame = this.createCls(id, DefaultCls.class);
                break;
            }
            case 7: {
                frame = this.createSlot(id, DefaultSlot.class);
                break;
            }
            case 8: {
                frame = this.createFacet(id, DefaultFacet.class);
                break;
            }
            case 5: {
                frame = this.createSimpleInstance(id, DefaultSimpleInstance.class);
                break;
            }
            default: {
                throw new RuntimeException("Invalid java class id: " + javaClassId);
            }
        }
        return frame;
    }

    private static Collection createRange(int value) {
        ArrayList<Integer> c = new ArrayList<Integer>();
        c.add(new Integer(value));
        return c;
    }

    public Collection getClsJavaClassIds() {
        return DefaultFrameFactory.createRange(6);
    }

    public Collection getSlotJavaClassIds() {
        return DefaultFrameFactory.createRange(7);
    }

    public Collection getFacetJavaClassIds() {
        return DefaultFrameFactory.createRange(8);
    }

    public Collection getSimpleInstanceJavaClassIds() {
        return DefaultFrameFactory.createRange(5);
    }

    public Frame rename(Frame original, String name) {
        if (original.getFrameID().getName().equals(name)) {
            return original;
        }
        int javaClassId = this.getJavaClassId(original);
        Frame newFrame = this.createFrameFromClassId(javaClassId, new FrameID(name));
        DefaultKnowledgeBase kb = (DefaultKnowledgeBase)original.getKnowledgeBase();
        kb.getHeadFrameStore().replaceFrame(original, newFrame);
        return newFrame;
    }
}

