/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DeleteSimplificationFrameStore
extends FrameStoreAdapter {
    private final Set<FrameID> fixedIds = new HashSet<FrameID>();

    public DeleteSimplificationFrameStore() {
        this.fixedIds.add(Model.SlotID.NAME);
        this.fixedIds.add(Model.SlotID.DIRECT_SUPERCLASSES);
        this.fixedIds.add(Model.SlotID.DIRECT_SUBCLASSES);
        this.fixedIds.add(Model.SlotID.DIRECT_SUPERSLOTS);
        this.fixedIds.add(Model.SlotID.DIRECT_SUBSLOTS);
        this.fixedIds.add(Model.SlotID.DIRECT_TYPES);
        this.fixedIds.add(Model.SlotID.DIRECT_INSTANCES);
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            this.beginTransaction("Remove template slot " + StringUtilities.getFriendlyName(slot) + " from class " + StringUtilities.getFriendlyName(cls), cls.getName());
            this.internalRemoveDirectTemplateSlot(cls, slot);
            this.commitTransaction();
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            throw new RuntimeException(t);
        }
    }

    private void internalRemoveDirectTemplateSlot(Cls cls, Slot slot) {
        Collection instances = this.getInstancesOfClsWithSlotValue(cls, slot);
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.removeSlotValues(slot, instances);
    }

    private Collection getInstancesOfClsWithSlotValue(Cls cls, Slot slot) {
        ArrayList<Frame> instances = new ArrayList<Frame>(this.getFramesWithAnyDirectOwnSlotValue(slot));
        Iterator i = instances.iterator();
        while (i.hasNext()) {
            Instance instance = (Instance)i.next();
            if (this.hasType(instance, cls)) continue;
            i.remove();
        }
        return instances;
    }

    private void removeSlotValues(Slot slot, Collection instances) {
        for (Instance instance : instances) {
            List values = instance.getDirectOwnSlotValues(slot);
            if (values.isEmpty() || instance.hasOwnSlot(slot)) continue;
            this.setDirectOwnSlotValues(instance, slot, Collections.EMPTY_LIST);
        }
    }

    private boolean hasType(Instance instance, Cls cls) {
        return this.getTypes(instance).contains(cls);
    }

    public void removeDirectSuperclass(Cls cls, Cls superclass) {
        try {
            this.beginTransaction("Remove superclass " + StringUtilities.getFriendlyName(superclass) + " from " + StringUtilities.getFriendlyName(cls), cls.getName());
            this.internalRemoveDirectSuperclass(cls, superclass);
            this.commitTransaction();
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            throw new RuntimeException(t);
        }
    }

    private static Collection getSlotsToRemoveOnSuperclassRemove(Cls cls, Cls superclass) {
        HashSet<Slot> slotsToRemove = new HashSet<Slot>(cls.getTemplateSlots());
        slotsToRemove.removeAll(cls.getDirectTemplateSlots());
        for (Cls directSuperclass : cls.getDirectSuperclasses()) {
            if (directSuperclass.equals(superclass)) continue;
            slotsToRemove.removeAll(directSuperclass.getTemplateSlots());
        }
        return slotsToRemove;
    }

    private void internalRemoveDirectSuperclass(Cls cls, Cls superclass) {
        Collection slotToRemove = DeleteSimplificationFrameStore.getSlotsToRemoveOnSuperclassRemove(cls, superclass);
        for (Slot slot : slotToRemove) {
            this.removeDirectTemplateSlot(cls, slot);
        }
        this.getDelegate().removeDirectSuperclass(cls, superclass);
    }

    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        try {
            this.beginTransaction("Remove superslot " + StringUtilities.getFriendlyName(superslot) + " from " + StringUtilities.getFriendlyName(slot), slot.getName());
            super.removeDirectSuperslot(slot, superslot);
            this.commitTransaction();
        }
        catch (Throwable e) {
            this.rollbackTransaction();
            throw new RuntimeException(e);
        }
    }

    public void deleteCls(Cls cls) {
        try {
            this.beginTransaction("Delete class " + StringUtilities.getFriendlyName(cls), cls.getName());
            cls.markDeleting();
            this.internalDeleteCls(cls);
            this.commitTransaction();
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            throw new RuntimeException(t);
        }
    }

    public void deleteSlot(Slot slot) {
        try {
            this.beginTransaction("Delete slot " + StringUtilities.getFriendlyName(slot));
            slot.markDeleting();
            this.internalDeleteSlot(slot);
            this.commitTransaction();
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            throw new RuntimeException(t);
        }
    }

    public void deleteFacet(Facet facet) {
        try {
            this.beginTransaction("Delete facet " + StringUtilities.getFriendlyName(facet));
            facet.markDeleting();
            this.internalDeleteFacet(facet);
            this.commitTransaction();
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            throw new RuntimeException(t);
        }
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        try {
            this.beginTransaction("Delete simple instance " + StringUtilities.getFriendlyName(simpleInstance));
            simpleInstance.markDeleting();
            this.internalDeleteSimpleInstance(simpleInstance);
            this.commitTransaction();
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            throw new RuntimeException(t);
        }
    }

    public Collection getClsesToDelete(Cls cls) {
        Set<Cls> subclasses = this.getSubclasses(cls);
        HashSet<Cls> clsesToBeDeleted = new HashSet<Cls>(subclasses);
        clsesToBeDeleted.add(cls);
        for (Cls subclass : subclasses) {
            if (subclass.equals(cls) || !this.reachableByAnotherRoute(subclass, clsesToBeDeleted)) continue;
            clsesToBeDeleted.remove(subclass);
            HashSet<Cls> subsubclasses = new HashSet<Cls>(this.getSubclasses(subclass));
            subsubclasses.remove(cls);
            clsesToBeDeleted.removeAll(subsubclasses);
        }
        return clsesToBeDeleted;
    }

    private boolean reachableByAnotherRoute(Cls subclass, Collection classesToBeDeleted) {
        boolean reachable = false;
        List<Cls> superclasses = this.getDirectSuperclasses(subclass);
        if (superclasses.size() > 1) {
            for (Cls superclass : superclasses) {
                if (classesToBeDeleted.contains(superclass)) continue;
                reachable = true;
                break;
            }
        }
        return reachable;
    }

    public Collection getSlotsToDelete(Slot slot) {
        HashSet<Slot> slots = new HashSet<Slot>(this.getSubslots(slot));
        slots.add(slot);
        return slots;
    }

    private void internalDeleteCls(Cls cls) {
        for (Cls clsToDelete : this.getClsesToDelete(cls)) {
            this.deleteValuesOfTemplateSlots(cls);
            this.internalDeleteInstance(clsToDelete);
        }
    }

    private void internalDeleteSlot(Slot slot) {
        for (Slot slotToDelete : this.getSlotsToDelete(slot)) {
            this.removeSlotFromClses(slotToDelete);
            this.internalDeleteInstance(slotToDelete);
        }
    }

    private void internalDeleteSimpleInstance(Instance instance) {
        this.internalDeleteInstance(instance);
    }

    private void internalDeleteFacet(Facet facet) {
        this.deleteFacetValues(facet);
        this.internalDeleteInstance(facet);
    }

    private void internalDeleteInstance(Instance instance) {
        this.internalDeleteFrame(instance);
    }

    private void internalDeleteFrame(Frame frame) {
        this.deleteReferences(frame);
        this.deleteValuesOfOwnSlots(frame);
        this.deleteFrame(frame);
    }

    private void deleteFrame(Frame frame) {
        if (frame instanceof Cls) {
            this.getDelegate().deleteCls((Cls)frame);
        } else if (frame instanceof Slot) {
            this.getDelegate().deleteSlot((Slot)frame);
        } else if (frame instanceof Facet) {
            this.getDelegate().deleteFacet((Facet)frame);
        } else if (frame instanceof SimpleInstance) {
            this.getDelegate().deleteSimpleInstance((SimpleInstance)frame);
        }
    }

    private void deleteReferences(Frame frame) {
        for (Reference ref : new ArrayList<Reference>(this.getReferences(frame))) {
            if (ref.getFacet() == null) {
                if (ref.isTemplate()) {
                    this.removeTemplateSlotValue((Cls)ref.getFrame(), ref.getSlot(), frame);
                    continue;
                }
                this.removeOwnSlotValue(ref.getFrame(), ref.getSlot(), frame);
                continue;
            }
            this.removeTemplateFacetValue((Cls)ref.getFrame(), ref.getSlot(), ref.getFacet(), frame);
        }
    }

    private void deleteValuesOfOwnSlots(Frame frame) {
        for (Slot slot : this.getOwnSlots(frame)) {
            List values;
            if (!this.isDeletableOwnSlot(slot) || (values = this.getDirectOwnSlotValues(frame, slot)).isEmpty()) continue;
            this.setDirectOwnSlotValues(frame, slot, Collections.EMPTY_LIST);
        }
    }

    private boolean isDeletableOwnSlot(Slot slot) {
        boolean isDeletable = true;
        if (this.fixedIds.contains(slot.getFrameID())) {
            isDeletable = false;
        }
        return isDeletable;
    }

    private void deleteValuesOfTemplateSlots(Cls cls) {
        for (Slot slot : this.getTemplateSlots(cls)) {
            List values = this.getDirectTemplateSlotValues(cls, slot);
            if (!values.isEmpty()) {
                this.setDirectTemplateSlotValues(cls, slot, Collections.EMPTY_LIST);
            }
            this.deleteValuesOfFacets(cls, slot);
        }
    }

    private void deleteValuesOfFacets(Cls cls, Slot slot) {
        for (Facet facet : this.getTemplateFacets(cls, slot)) {
            List values = this.getDirectTemplateFacetValues(cls, slot, facet);
            if (values.isEmpty()) continue;
            this.setDirectTemplateFacetValues(cls, slot, facet, Collections.EMPTY_LIST);
        }
    }

    private void removeSlotFromClses(Slot slot) {
        for (Cls cls : new ArrayList(this.getDirectDomain(slot))) {
            this.removeDirectTemplateSlot(cls, slot);
        }
    }

    private void deleteFacetValues(Facet facet) {
    }

    private void removeTemplateSlotValue(Cls cls, Slot slot, Frame value) {
        ArrayList values = new ArrayList(this.getDirectTemplateSlotValues(cls, slot));
        values.remove(value);
        this.setDirectTemplateSlotValues(cls, slot, values);
    }

    private void removeOwnSlotValue(Frame frame, Slot slot, Frame value) {
        if (this.isDeletableOwnSlot(slot)) {
            ArrayList values = new ArrayList(this.getDirectOwnSlotValues(frame, slot));
            values.remove(value);
            this.setDirectOwnSlotValues(frame, slot, values);
        }
    }

    private void removeTemplateFacetValue(Cls cls, Slot slot, Facet facet, Frame value) {
        ArrayList values = new ArrayList(this.getDirectTemplateFacetValues(cls, slot, facet));
        values.remove(value);
        this.setDirectTemplateFacetValues(cls, slot, facet, values);
    }
}

