/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.util.DeletionHook;
import edu.stanford.smi.protege.util.Log;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletionHookFrameStore
extends FrameStoreAdapter {
    private Logger log = Log.getLogger(DeletionHookFrameStore.class);
    private Set<DeletionHook> hooks = new HashSet<DeletionHook>();

    public void addHook(DeletionHook hook) {
        this.hooks.add(hook);
    }

    public void removeHook(DeletionHook hook) {
        this.hooks.remove(hook);
    }

    public Set<DeletionHook> getHooks() {
        return Collections.unmodifiableSet(this.hooks);
    }

    public void handleDelete(Frame frame) {
        for (DeletionHook hook : this.hooks) {
            try {
                hook.delete(frame);
            }
            catch (Throwable t) {
                this.log.log(Level.WARNING, "hook (" + hook + ") on delete operation failed", t);
            }
        }
    }

    @Override
    public void deleteCls(Cls cls) {
        this.handleDelete(cls);
        super.deleteCls(cls);
    }

    @Override
    public void deleteSlot(Slot slot) {
        this.handleDelete(slot);
        super.deleteSlot(slot);
    }

    @Override
    public void deleteFacet(Facet facet) {
        this.handleDelete(facet);
        super.deleteFacet(facet);
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.handleDelete(simpleInstance);
        super.deleteSimpleInstance(simpleInstance);
    }
}

