/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FacetEvent;
import edu.stanford.smi.protege.event.FacetListener;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.InstanceListener;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseListener;
import edu.stanford.smi.protege.event.ServerProjectEvent;
import edu.stanford.smi.protege.event.ServerProjectListener;
import edu.stanford.smi.protege.event.ServerProjectNotificationEvent;
import edu.stanford.smi.protege.event.ServerProjectSessionClosedEvent;
import edu.stanford.smi.protege.event.ServerProjectStatusChangeEvent;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.event.SlotListener;
import edu.stanford.smi.protege.event.TransactionEvent;
import edu.stanford.smi.protege.event.TransactionListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.ArrayListMultiMap;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatchFrameStore
extends ModificationFrameStore {
    private static transient Logger log = Log.getLogger(EventDispatchFrameStore.class);
    public static final int DELAY_MSEC = 5000;
    private Map<Class<?>, Map<Object, Collection<EventListener>>> _listeners = new HashMap();
    private Thread _eventThread;
    private KnowledgeBase kb;
    private boolean passThrough = false;
    private List<AbstractEvent> savedEvents = new ArrayList<AbstractEvent>();
    private ArrayListMultiMap<RemoteSession, AbstractEvent> transactedEvents = new ArrayListMultiMap();

    public EventDispatchFrameStore(KnowledgeBase kb) {
        this.kb = kb;
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public void close() {
        super.close();
        this.stopEventThread();
        this._listeners = null;
    }

    public void setPassThrough(boolean passThrough) {
        this.passThrough = passThrough;
    }

    private List<AbstractEvent> getDispatchableEvents() {
        ArrayList<AbstractEvent> results = new ArrayList<AbstractEvent>();
        for (AbstractEvent event : this.getDelegate().getEvents()) {
            Collection deferred;
            RemoteSession session;
            if (this.passThrough) {
                this.savedEvents.add(event);
            }
            if (event.isHiddenByTransaction() && !this.isMyEvent(event)) {
                session = event.getSession();
                this.transactedEvents.addValue(session, event);
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Dispatch for " + event + " deferred until " + session + "s transaction closes.");
                continue;
            }
            if (event instanceof TransactionEvent && ((TransactionEvent)event).getEventType() == 702 && (deferred = this.transactedEvents.removeKey((Object)(session = event.getSession()))) != null && ((TransactionEvent)event).isCommitted().booleanValue()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Committing " + deferred.size() + " events for session " + session);
                }
                results.addAll(deferred);
            }
            results.add(event);
            if (!log.isLoggable(Level.FINER)) continue;
            log.finer("Event being dispatched now: " + event);
        }
        return results;
    }

    private boolean isMyEvent(AbstractEvent event) {
        RemoteSession mySession = ServerFrameStore.getCurrentSession();
        RemoteSession eventSession = event.getSession();
        if (mySession == null) {
            return eventSession == null;
        }
        return mySession.equals(eventSession);
    }

    @Override
    public List<AbstractEvent> getEvents() {
        if (this.passThrough) {
            this.dispatchEvents();
            List<AbstractEvent> results = this.savedEvents;
            this.savedEvents = new ArrayList<AbstractEvent>();
            return results;
        }
        return new ArrayList<AbstractEvent>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPollForEvents(boolean b) {
        if (b) {
            if (this._eventThread != null) throw new IllegalStateException("Already polling");
            this.startEventThread();
            return;
        } else {
            this.stopEventThread();
        }
    }

    private void startEventThread() {
        this._eventThread = new Thread("EventDispatchFrameStoreHandler.startEventThread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            KnowledgeBase knowledgeBase = EventDispatchFrameStore.this.kb;
                            synchronized (knowledgeBase) {
                                if (EventDispatchFrameStore.this._eventThread != this) {
                                    return;
                                }
                            }
                            EventDispatchFrameStore.this.flushEvents();
                            knowledgeBase = EventDispatchFrameStore.this.kb;
                            synchronized (knowledgeBase) {
                                EventDispatchFrameStore.this.kb.wait(5000L);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.getLogger().warning(e.toString());
                        log.log(Level.FINE, "Exception caught", e);
                        continue;
                    }
                    break;
                }
            }
        };
        this._eventThread.setPriority(1);
        this._eventThread.setDaemon(true);
        this._eventThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopEventThread() {
        this._eventThread = null;
        KnowledgeBase knowledgeBase = this.kb;
        synchronized (knowledgeBase) {
            this.kb.notifyAll();
        }
    }

    public void flushEvents() throws InterruptedException {
        try {
            if (EventQueue.isDispatchThread()) {
                this.dispatchEvents();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EventDispatchFrameStore.this.dispatchEvents();
                    }
                });
            }
        }
        catch (InvocationTargetException ite) {
            Log.getLogger().warning("Exception caught " + ite);
        }
    }

    private void dispatchEvents() {
        this.dispatchEvents(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvents(boolean ignoreExceptions) {
        try {
            KnowledgeBase knowledgeBase = this.kb;
            synchronized (knowledgeBase) {
                List<AbstractEvent> events = this.getDispatchableEvents();
                if (!events.isEmpty()) {
                    this.dispatchEvents(events, ignoreExceptions);
                }
            }
        }
        catch (Throwable t) {
            do {
                if (!(t instanceof ServerSessionLost) && !(t instanceof ConnectException)) continue;
                log.warning("Knowledge base has been disconnected from the server");
                this.kb.getProject().postProjectEvent(5);
                return;
            } while ((t = t.getCause()) != null);
        }
    }

    private void dispatchEvents(Collection<AbstractEvent> events, boolean ignoreExceptions) {
        for (AbstractEvent event : events) {
            try {
                this.dispatchEvent(event);
            }
            catch (Throwable e) {
                if (ignoreExceptions) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Exception caught", e);
                }
                Log.getLogger().warning("Exception caught " + e.toString());
                Log.getLogger().warning("use fine logging for more details");
            }
        }
        for (AbstractEvent event : events) {
            KnowledgeBaseEvent kbEvent;
            if (!(event instanceof KnowledgeBaseEvent) || (kbEvent = (KnowledgeBaseEvent)event).getEventType() != 101) continue;
            this.replaceListeners(kbEvent.getFrame(), kbEvent.getNewFrame());
        }
    }

    private void dispatchEvent(AbstractEvent event) {
        if (event instanceof KnowledgeBaseEvent) {
            this.dispatchKbEvent((KnowledgeBaseEvent)event);
        } else if (event instanceof ClsEvent) {
            this.dispatchClsEvent((ClsEvent)event);
            this.dispatchClsEventToSubclasses((ClsEvent)event);
        } else if (event instanceof SlotEvent) {
            this.dispatchSlotEvent((SlotEvent)event);
        } else if (event instanceof FacetEvent) {
            this.dispatchFacetEvent((FacetEvent)event);
        } else if (event instanceof InstanceEvent) {
            this.dispatchInstanceEvent((InstanceEvent)event);
        } else if (event instanceof FrameEvent) {
            this.dispatchFrameEvent((FrameEvent)event);
            this.dispatchFrameEventAsClsFacetEvent((FrameEvent)event);
        } else if (event instanceof TransactionEvent) {
            this.dispatchTransactionEvent((TransactionEvent)event);
        } else if (event instanceof ServerProjectEvent) {
            this.dispatchServerEvent((ServerProjectEvent)((Object)event));
        } else {
            throw new RuntimeException("unknown event type: " + event);
        }
    }

    private void dispatchServerEvent(ServerProjectEvent event) {
        for (EventListener l : this.getListeners(ServerProjectListener.class, event.getSource())) {
            ServerProjectListener listener = (ServerProjectListener)l;
            if (event instanceof ServerProjectNotificationEvent) {
                listener.projectNotificationReceived((ServerProjectNotificationEvent)event);
                continue;
            }
            if (event instanceof ServerProjectStatusChangeEvent) {
                listener.projectStatusChanged((ServerProjectStatusChangeEvent)event);
                continue;
            }
            if (!(event instanceof ServerProjectSessionClosedEvent)) continue;
            listener.beforeProjectSessionClosed((ServerProjectSessionClosedEvent)event);
        }
    }

    private void dispatchTransactionEvent(TransactionEvent event) {
        block4: for (TransactionListener transactionListener : this.getListeners(TransactionListener.class, event.getSource())) {
            switch (event.getEventType()) {
                case 701: {
                    transactionListener.transactionBegin(event);
                    continue block4;
                }
                case 702: {
                    transactionListener.transactionEnded(event);
                    continue block4;
                }
            }
            Log.getLogger().warning("bad event: " + event);
        }
    }

    private void dispatchKbEvent(KnowledgeBaseEvent event) {
        block14: for (KnowledgeBaseListener knowledgeBaseListener : this.getListeners(KnowledgeBaseListener.class, event.getSource())) {
            switch (event.getEventType()) {
                case 601: {
                    knowledgeBaseListener.clsCreated(event);
                    continue block14;
                }
                case 602: {
                    knowledgeBaseListener.clsDeleted(event);
                    continue block14;
                }
                case 603: {
                    knowledgeBaseListener.slotCreated(event);
                    continue block14;
                }
                case 604: {
                    knowledgeBaseListener.slotDeleted(event);
                    continue block14;
                }
                case 605: {
                    knowledgeBaseListener.facetCreated(event);
                    continue block14;
                }
                case 606: {
                    knowledgeBaseListener.facetDeleted(event);
                    continue block14;
                }
                case 607: {
                    knowledgeBaseListener.instanceCreated(event);
                    continue block14;
                }
                case 608: {
                    knowledgeBaseListener.instanceDeleted(event);
                    continue block14;
                }
                case 101: {
                    knowledgeBaseListener.frameNameChanged(event);
                    continue block14;
                }
                case 610: {
                    knowledgeBaseListener.defaultClsMetaClsChanged(event);
                    continue block14;
                }
                case 611: {
                    knowledgeBaseListener.defaultSlotMetaClsChanged(event);
                    continue block14;
                }
                case 612: {
                    knowledgeBaseListener.defaultFacetMetaClsChanged(event);
                    continue block14;
                }
            }
            Log.getLogger().warning("bad event: " + event);
        }
    }

    private void dispatchClsEvent(ClsEvent event) {
        block15: for (ClsListener clsListener : this.getListeners(ClsListener.class, event.getSource())) {
            switch (event.getEventType()) {
                case 301: {
                    clsListener.directSuperclassAdded(event);
                    continue block15;
                }
                case 302: {
                    clsListener.directSuperclassRemoved(event);
                    continue block15;
                }
                case 303: {
                    clsListener.directSubclassAdded(event);
                    continue block15;
                }
                case 304: {
                    clsListener.directSubclassRemoved(event);
                    continue block15;
                }
                case 305: {
                    clsListener.directInstanceAdded(event);
                    continue block15;
                }
                case 306: {
                    clsListener.directInstanceRemoved(event);
                    continue block15;
                }
                case 307: {
                    clsListener.directSubclassMoved(event);
                    continue block15;
                }
                case 308: {
                    clsListener.templateSlotAdded(event);
                    continue block15;
                }
                case 309: {
                    clsListener.templateSlotRemoved(event);
                    continue block15;
                }
                case 310: {
                    clsListener.templateSlotValueChanged(event);
                    continue block15;
                }
                case 311: {
                    clsListener.templateFacetAdded(event);
                    continue block15;
                }
                case 312: {
                    clsListener.templateFacetRemoved(event);
                    continue block15;
                }
                case 313: {
                    clsListener.templateFacetValueChanged(event);
                    continue block15;
                }
            }
            Log.getLogger().severe("bad event: " + event);
        }
    }

    private void dispatchClsEventToSubclasses(ClsEvent event) {
        if (EventDispatchFrameStore.doDispatchToSubclasses(event)) {
            for (Cls cls : this.getListenedToSubclasses(ClsListener.class, event.getCls())) {
                ClsEvent subclassEvent = new ClsEvent(cls, event.getEventType(), event.getArgument1(), event.getArgument2());
                this.dispatchClsEvent(subclassEvent);
            }
        }
    }

    private static boolean doDispatchToSubclasses(ClsEvent event) {
        int type = event.getEventType();
        return type == 310 || type == 313 || type == 308 || type == 309;
    }

    private void dispatchFrameEventAsClsFacetEvent(FrameEvent event) {
        Slot slot;
        Iterator i;
        Facet facet = EventDispatchFrameStore.getFacet(event);
        if (facet != null && (i = (slot = (Slot)event.getFrame()).getDirectDomain().iterator()).hasNext()) {
            Cls cls = (Cls)i.next();
            ClsEvent clsEvent = new ClsEvent(cls, 313, (Object)slot, (Object)facet);
            this.dispatchClsEvent(clsEvent);
            this.dispatchClsEventToSubclasses(clsEvent);
        }
    }

    private static Facet getFacet(FrameEvent event) {
        Facet facet = null;
        if (event.getFrame() instanceof Slot && event.getEventType() == 110) {
            Slot slot = event.getSlot();
            facet = slot.getAssociatedFacet();
        }
        return facet;
    }

    private void dispatchSlotEvent(SlotEvent event) {
        block9: for (SlotListener slotListener : this.getListeners(SlotListener.class, event.getSource())) {
            int type = event.getEventType();
            switch (type) {
                case 401: {
                    slotListener.templateSlotClsAdded(event);
                    continue block9;
                }
                case 402: {
                    slotListener.templateSlotClsRemoved(event);
                    continue block9;
                }
                case 405: {
                    slotListener.directSubslotAdded(event);
                    continue block9;
                }
                case 406: {
                    slotListener.directSubslotRemoved(event);
                    continue block9;
                }
                case 409: {
                    slotListener.directSubslotMoved(event);
                    continue block9;
                }
                case 407: {
                    slotListener.directSuperslotAdded(event);
                    continue block9;
                }
                case 408: {
                    slotListener.directSuperslotRemoved(event);
                    continue block9;
                }
            }
            Assert.fail("bad type: " + type);
        }
    }

    private void dispatchFacetEvent(FacetEvent event) {
        block4: for (FacetListener facetListener : this.getListeners(FacetListener.class, event.getSource())) {
            int type = event.getEventType();
            switch (type) {
                case 501: {
                    facetListener.frameSlotReferenceAdded(event);
                    continue block4;
                }
                case 502: {
                    facetListener.frameSlotReferenceRemoved(event);
                    continue block4;
                }
            }
            Assert.fail("bad type: " + type + " " + facetListener);
        }
    }

    private void dispatchInstanceEvent(InstanceEvent event) {
        block4: for (InstanceListener instanceListener : this.getListeners(InstanceListener.class, event.getSource())) {
            int type = event.getEventType();
            switch (type) {
                case 202: {
                    instanceListener.directTypeAdded(event);
                    continue block4;
                }
                case 203: {
                    instanceListener.directTypeRemoved(event);
                    continue block4;
                }
            }
            Assert.fail("bad type: " + type + " " + instanceListener);
        }
    }

    private void dispatchFrameEvent(FrameEvent event) {
        block12: for (FrameListener frameListener : this.getListeners(FrameListener.class, event.getSource())) {
            switch (event.getEventType()) {
                case 101: {
                    frameListener.nameChanged(event);
                    continue block12;
                }
                case 103: {
                    frameListener.visibilityChanged(event);
                    continue block12;
                }
                case 105: {
                    frameListener.browserTextChanged(event);
                    continue block12;
                }
                case 106: {
                    frameListener.ownSlotAdded(event);
                    continue block12;
                }
                case 107: {
                    frameListener.ownSlotRemoved(event);
                    continue block12;
                }
                case 108: {
                    frameListener.ownFacetAdded(event);
                    continue block12;
                }
                case 109: {
                    frameListener.ownFacetRemoved(event);
                    continue block12;
                }
                case 110: {
                    frameListener.ownSlotValueChanged(event);
                    continue block12;
                }
                case 111: {
                    frameListener.ownFacetValueChanged(event);
                    continue block12;
                }
                case 102: {
                    frameListener.deleted(event);
                    continue block12;
                }
            }
            Log.getLogger().severe("bad event: " + event);
        }
    }

    public Collection<EventListener> getListeners(Class<?> c, Object o) {
        Collection<EventListener> allListeners = null;
        Map<Object, Collection<EventListener>> listeners = this._listeners.get(c);
        if (listeners != null) {
            Collection<EventListener> objectListeners = listeners.get(o);
            allListeners = EventDispatchFrameStore.addListeners(objectListeners, allListeners);
            Collection<EventListener> globalListeners = listeners.get(null);
            allListeners = EventDispatchFrameStore.addListeners(globalListeners, allListeners);
        }
        if (allListeners == null) {
            return Collections.emptyList();
        }
        return allListeners;
    }

    private static Collection<EventListener> addListeners(Collection<EventListener> listenersToAdd, Collection<EventListener> listeners) {
        if (listenersToAdd != null) {
            if (listeners == null) {
                listeners = new ArrayList<EventListener>(listenersToAdd);
            } else {
                listeners.addAll(listenersToAdd);
            }
        }
        return listeners;
    }

    public void clearListeners() {
        this._listeners.clear();
    }

    private void removeListeners(Class<?> listenerType, Frame frame) {
        Map<Object, Collection<EventListener>> listeners = this._listeners.get(listenerType);
        if (listeners != null) {
            listeners.remove(frame);
        }
    }

    private void removeClsListeners(Cls cls) {
        this.removeListeners(ClsListener.class, cls);
        this.removeInstanceListeners(cls);
    }

    private void removeSlotListeners(Slot slot) {
        this.removeListeners(SlotListener.class, slot);
        this.removeInstanceListeners(slot);
    }

    private void removeFacetListeners(Facet facet) {
        this.removeListeners(FacetListener.class, facet);
        this.removeInstanceListeners(facet);
    }

    private void removeSimpleInstanceListeners(SimpleInstance simpleInstance) {
        this.removeInstanceListeners(simpleInstance);
    }

    private void removeInstanceListeners(Instance instance) {
        this.removeListeners(InstanceListener.class, instance);
        this.removeFrameListeners(instance);
    }

    private void removeFrameListeners(Frame frame) {
        this.removeListeners(FrameListener.class, frame);
    }

    public void notifyInstancesOfBrowserTextChange(Cls cls) {
        Collection<Instance> relevantInstances = this.getListenedToInstances(FrameListener.class, cls);
        for (Frame frame : relevantInstances) {
            FrameEvent event = new FrameEvent(frame, 105);
            this.dispatchFrameEvent(event);
        }
    }

    private Collection<Cls> getListenedToSubclasses(Class<?> c, Cls cls) {
        HashSet<Cls> listenedToSubclasses = new HashSet<Cls>();
        Map<Object, Collection<EventListener>> listeners = this._listeners.get(c);
        if (listeners != null) {
            Set<Object> listenedToObjects = listeners.keySet();
            for (Object o : listenedToObjects) {
                Cls listenedToCls;
                if (!(o instanceof Cls) || !this.getSuperclasses(listenedToCls = (Cls)o).contains(cls)) continue;
                listenedToSubclasses.add(listenedToCls);
            }
        }
        return listenedToSubclasses;
    }

    private Collection<Instance> getListenedToInstances(Class<?> c, Cls cls) {
        HashSet<Instance> listenedToInstances = new HashSet<Instance>();
        Map<Object, Collection<EventListener>> listeners = this._listeners.get(c);
        if (listeners != null) {
            Set<Object> listenedToObjects = listeners.keySet();
            for (Object o : listenedToObjects) {
                Instance instance;
                if (!(o instanceof Instance) || !(instance = (Instance)o).hasType(cls)) continue;
                listenedToInstances.add(instance);
            }
        }
        return listenedToInstances;
    }

    public void addListener(Class<?> c, Object o, EventListener listener) {
        Collection<EventListener> objectListeners;
        Map<Object, Collection<EventListener>> listeners = this._listeners.get(c);
        if (listeners == null) {
            listeners = new HashMap<Object, Collection<EventListener>>();
            this._listeners.put(c, listeners);
        }
        if ((objectListeners = listeners.get(o)) == null) {
            objectListeners = new ArrayList<EventListener>();
            listeners.put(o, objectListeners);
        }
        objectListeners.add(listener);
    }

    public void removeListener(Class<?> c, Object o, EventListener listener) {
        Collection<EventListener> objectListeners;
        Map<Object, Collection<EventListener>> listeners = this._listeners.get(c);
        if (listeners != null && (objectListeners = listeners.get(o)) != null) {
            objectListeners.remove(listener);
        }
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls superclass) {
        this.getDelegate().addDirectSuperclass(cls, superclass);
        this.dispatchEvents();
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot superslot) {
        this.getDelegate().addDirectSuperslot(slot, superslot);
        this.dispatchEvents();
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().addDirectTemplateSlot(cls, slot);
        this.dispatchEvents();
    }

    @Override
    public void addDirectType(Instance instance, Cls type) {
        this.getDelegate().addDirectType(instance, type);
        this.dispatchEvents();
    }

    @Override
    public boolean beginTransaction(String name) {
        boolean succeeded = this.getDelegate().beginTransaction(name);
        this.dispatchEvents();
        return succeeded;
    }

    @Override
    public boolean commitTransaction() {
        boolean succeeded = this.getDelegate().commitTransaction();
        this.dispatchEvents();
        return succeeded;
    }

    @Override
    public Cls createCls(FrameID id, Collection types, Collection superclasses, boolean loadDefaults) {
        Cls cls = this.getDelegate().createCls(id, types, superclasses, loadDefaults);
        this.dispatchEvents();
        return cls;
    }

    @Override
    public Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        Facet facet = this.getDelegate().createFacet(id, directTypes, loadDefaultValues);
        this.dispatchEvents();
        return facet;
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID id, Collection types, boolean loadDefaultValues) {
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(id, types, loadDefaultValues);
        this.dispatchEvents();
        return simpleInstance;
    }

    @Override
    public Slot createSlot(FrameID id, Collection types, Collection superslots, boolean loadDefaults) {
        Slot slot = this.getDelegate().createSlot(id, types, superslots, loadDefaults);
        this.dispatchEvents();
        return slot;
    }

    @Override
    public void deleteCls(Cls cls) {
        this.getDelegate().deleteCls(cls);
        this.removeClsListeners(cls);
        this.dispatchEvents();
    }

    @Override
    public void deleteFacet(Facet facet) {
        this.getDelegate().deleteFacet(facet);
        this.removeFacetListeners(facet);
        this.dispatchEvents();
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.getDelegate().deleteSimpleInstance(simpleInstance);
        this.removeSimpleInstanceListeners(simpleInstance);
        this.dispatchEvents();
    }

    @Override
    public void deleteSlot(Slot slot) {
        this.getDelegate().deleteSlot(slot);
        this.removeSlotListeners(slot);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int from, int to) {
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, from, to);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        this.getDelegate().moveDirectSubclass(cls, subclass, index);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        this.getDelegate().moveDirectSubslot(slot, subslot, index);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int index) {
        this.getDelegate().moveDirectTemplateSlot(cls, slot, index);
        this.dispatchEvents();
    }

    @Override
    public void moveDirectType(Instance instance, Cls type, int index) {
        this.getDelegate().moveDirectType(instance, type, index);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls superclass) {
        this.getDelegate().removeDirectSuperclass(cls, superclass);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        this.getDelegate().removeDirectSuperslot(slot, superslot);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.dispatchEvents();
    }

    @Override
    public void removeDirectType(Instance instance, Cls type) {
        this.getDelegate().removeDirectType(instance, type);
        this.dispatchEvents();
    }

    @Override
    public boolean rollbackTransaction() {
        boolean succeeded = this.getDelegate().rollbackTransaction();
        this.dispatchEvents();
        return succeeded;
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        this.getDelegate().setDirectOwnSlotValues(frame, slot, values);
        this.dispatchEvents();
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, values);
        this.dispatchEvents();
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, values);
        this.dispatchEvents();
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        this.getDelegate().replaceFrame(original, replacement);
        this.dispatchEvents();
    }

    private void replaceListeners(Frame original, Frame replacement) {
        for (Map<Object, Collection<EventListener>> map : this._listeners.values()) {
            Collection<EventListener> listeners = map.remove(original);
            if (listeners == null) continue;
            Collection<EventListener> existingListeners = map.get(replacement);
            if (existingListeners != null) {
                listeners.addAll(existingListeners);
            }
            map.put(replacement, listeners);
        }
    }

    public void printListenersByHashCode(int hash) {
        System.out.println("Printing out FrameListeners that have hash code " + hash);
        for (Map.Entry<Object, Collection<EventListener>> entry : this._listeners.get(FrameListener.class).entrySet()) {
            Object o = entry.getKey();
            Collection<EventListener> listeners = entry.getValue();
            for (EventListener listener : listeners) {
                if (listener.hashCode() != hash) continue;
                System.out.println("Found listener " + listener + " at " + o);
            }
        }
    }

    public void dumpListeners(Level level) {
        if (!log.isLoggable(level)) {
            return;
        }
        log.log(level, "-----------------------printing listeners======================");
        for (Map<Object, Collection<EventListener>> map : this._listeners.values()) {
            for (Map.Entry<Object, Collection<EventListener>> entry : map.entrySet()) {
                log.log(level, "listeners for object " + entry.getKey());
                for (EventListener listener : entry.getValue()) {
                    log.log(level, "\t" + listener);
                }
            }
        }
    }
}

