/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.InstanceEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.event.SlotEvent;
import edu.stanford.smi.protege.event.TransactionEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventGeneratorFrameStore
extends ModificationFrameStore {
    private List<AbstractEvent> _events = new ArrayList<AbstractEvent>();
    private DefaultKnowledgeBase _kb;
    private SystemFrames _systemFrames;
    private boolean generateEventsOnDeletingFrames = false;
    private TransactionMonitor transactionMonitor;
    private boolean inReplaceFrameOperation = false;

    public EventGeneratorFrameStore(KnowledgeBase kb) {
        this._kb = (DefaultKnowledgeBase)kb;
        this._systemFrames = this._kb.getSystemFrames();
    }

    @Override
    public void setDelegate(FrameStore delegate) {
        super.setDelegate(delegate);
        if (delegate != null) {
            this.transactionMonitor = delegate.getTransactionStatusMonitor();
        }
    }

    @Override
    public void reinitialize() {
        this._events.clear();
    }

    @Override
    public void close() {
        super.close();
        this._events.clear();
        this._events = null;
        this._kb = null;
        this._systemFrames = null;
    }

    @Override
    public Frame getFrame(String name) {
        return this.getDelegate().getFrame(name);
    }

    @Override
    public Cls createCls(FrameID id, Collection directTypes, Collection superClasses, boolean loadDefaults) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        Cls cls = this.getDelegate().createCls(id, directTypes, superClasses, loadDefaults);
        this.generateCreateClsEvents(cls, directTypes, level);
        return cls;
    }

    @Override
    public Slot createSlot(FrameID id, Collection directTypes, Collection superslots, boolean loadDefaults) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        Slot slot = this.getDelegate().createSlot(id, directTypes, superslots, loadDefaults);
        this.generateCreateSlotEvents(slot, directTypes, level);
        return slot;
    }

    @Override
    public Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaults) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        Facet facet = this.getDelegate().createFacet(id, directTypes, loadDefaults);
        this.generateCreateFacetEvents(facet, directTypes, level);
        return facet;
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateSetDirectOwnSlotValuesEvents(frame, slot, values, level);
        this.getDelegate().setDirectOwnSlotValues(frame, slot, values);
    }

    private void generateSetDirectOwnSlotValuesEvents(Frame frame, Slot slot, Collection values, TransactionIsolationLevel level) {
        this.generateOwnSlotValuesChangedEvent(frame, slot, level);
        this.generateFrameEvent(105, frame, level);
        Slot inverseSlot = (Slot)CollectionUtilities.getFirstItem(this.getDirectOwnSlotValues(slot, this._systemFrames.getInverseSlotSlot()));
        if (inverseSlot != null) {
            List oldValues = this.getDirectOwnSlotValues(frame, slot);
            for (Frame newValue : values) {
                if (oldValues.contains(newValue)) continue;
                this.generateFrameEvent(110, newValue, inverseSlot, level);
            }
            for (Frame oldValue : oldValues) {
                if (values.contains(oldValue)) continue;
                this.generateFrameEvent(110, oldValue, inverseSlot, level);
            }
        }
    }

    private void generateDeleteFrameKbEvent(int type, Frame frame, TransactionIsolationLevel level) {
        this.generateKbEvent(type, frame, frame.getName(), level);
    }

    private void generateDeleteClsEvents(Cls cls, TransactionIsolationLevel level) {
        this.generateDeleteFrameKbEvent(602, cls, level);
        for (Cls superCls : this.getDirectSuperclasses(cls)) {
            this.generateClsEvent(304, superCls, cls, level);
        }
        this.generateDeleteInstanceEvents(cls, level);
    }

    private void generateDeleteSimpleInstanceEvents(SimpleInstance simpleInstance, TransactionIsolationLevel level) {
        this.generateDeleteFrameKbEvent(608, simpleInstance, level);
        this.generateDeleteInstanceEvents(simpleInstance, level);
    }

    private void generateDeleteSlotEvents(Slot slot, TransactionIsolationLevel level) {
        this.generateDeleteFrameKbEvent(604, slot, level);
        for (Frame o : this.getDelegate().getFramesWithDirectOwnSlotValue(this._systemFrames.getDirectTemplateSlotsSlot(), slot)) {
            if (!(o instanceof Cls)) continue;
            this.generateClsEvent(309, (Cls)o, slot, level);
        }
        for (Slot superSlot : this.getDirectSuperslots(slot)) {
            this.generateSlotEvent(408, slot, superSlot, level);
        }
        this.generateDeleteInstanceEvents(slot, level);
    }

    private void generateDeleteFacetEvents(Facet facet, TransactionIsolationLevel level) {
        this.generateDeleteFrameKbEvent(606, facet, level);
        this.generateDeleteInstanceEvents(facet, level);
    }

    private void generateDeleteInstanceEvents(Instance instance, TransactionIsolationLevel level) {
        this.generateRemoveDirectInstanceEvents(instance, level);
        for (Reference ref : this.getReferences(instance)) {
            this.removeReference(ref, instance, level);
        }
        this.generateFrameEvent(102, instance, instance.getName(), level);
    }

    private void generateRemoveDirectInstanceEvents(Instance instance, TransactionIsolationLevel level) {
        for (Cls type : this.getDirectTypes(instance)) {
            this.generateClsEvent(306, type, instance, level);
        }
    }

    private void removeReference(Reference ref, Instance instance, TransactionIsolationLevel level) {
        Frame frame = ref.getFrame();
        Slot slot = ref.getSlot();
        Facet facet = ref.getFacet();
        boolean isTemplate = ref.isTemplate();
        this.removeReference(frame, slot, facet, isTemplate, instance, level);
    }

    private void removeReference(Frame frame, Slot slot, Facet facet, boolean isTemplate, Instance instance, TransactionIsolationLevel level) {
        if (facet == null) {
            if (isTemplate) {
                this.removeTemplateSlotValueReference(frame, slot, instance, level);
            } else {
                this.removeOwnSlotValueReference(frame, slot, instance, level);
            }
        } else if (isTemplate) {
            this.removeTemplateFacetValueReference(frame, slot, facet, instance, level);
        }
    }

    private void removeOwnSlotValueReference(Frame frame, Slot slot, Instance instance, TransactionIsolationLevel level) {
        this.generateFrameEvent(110, frame, slot, level);
    }

    private void removeTemplateSlotValueReference(Frame frame, Slot slot, Instance instance, TransactionIsolationLevel level) {
    }

    private void removeTemplateFacetValueReference(Frame frame, Slot slot, Facet facet, Instance instance, TransactionIsolationLevel level) {
    }

    @Override
    public void deleteCls(Cls cls) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateDeleteClsEvents(cls, level);
        this.getDelegate().deleteCls(cls);
    }

    @Override
    public void deleteSlot(Slot slot) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateDeleteSlotEvents(slot, level);
        this.getDelegate().deleteSlot(slot);
    }

    @Override
    public void deleteFacet(Facet facet) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateDeleteFacetEvents(facet, level);
        this.getDelegate().deleteFacet(facet);
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateDeleteSimpleInstanceEvents(simpleInstance, level);
        this.getDelegate().deleteSimpleInstance(simpleInstance);
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes, boolean loadDefaults) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(id, directTypes, loadDefaults);
        this.generateCreateSimpleInstanceEvents(simpleInstance, directTypes, level);
        return simpleInstance;
    }

    private void generateCreateClsEvents(Cls newCls, Collection directTypes, TransactionIsolationLevel level) {
        this.generateCreateInstanceEvents(601, newCls, directTypes, level);
        for (Cls superclass : newCls.getDirectSuperclasses()) {
            this.generateClsEvent(303, superclass, newCls, level);
            this.generateOwnSlotValuesChangedEvent(superclass, this._systemFrames.getDirectSubclassesSlot(), level);
        }
    }

    private void generateCreateFacetEvents(Facet newFacet, Collection directTypes, TransactionIsolationLevel level) {
        this.generateCreateInstanceEvents(605, newFacet, directTypes, level);
    }

    private void generateCreateSlotEvents(Slot newSlot, Collection directTypes, TransactionIsolationLevel level) {
        this.generateCreateInstanceEvents(603, newSlot, directTypes, level);
        for (Frame o : this.getDelegate().getFramesWithDirectOwnSlotValue(this._systemFrames.getDirectTemplateSlotsSlot(), newSlot)) {
            if (!(o instanceof Cls)) continue;
            this.generateClsEvent(308, (Cls)o, newSlot, level);
        }
        for (Slot superslot : newSlot.getDirectSuperslots()) {
            this.generateSlotEvent(405, superslot, newSlot, level);
            this.generateOwnSlotValuesChangedEvent(superslot, this._systemFrames.getDirectSubslotsSlot(), level);
        }
    }

    private void generateCreateSimpleInstanceEvents(SimpleInstance newFrame, Collection directTypes, TransactionIsolationLevel level) {
        this.generateCreateInstanceEvents(607, newFrame, directTypes, level);
    }

    private void generateCreateInstanceEvents(int type, Frame newFrame, Collection directTypes, TransactionIsolationLevel level) {
        this.generateKbEvent(type, newFrame, level);
        for (Cls directType : directTypes) {
            this.generateClsEvent(305, directType, newFrame, level);
            this.generateOwnSlotValuesChangedEvent(directType, this._systemFrames.getDirectInstancesSlot(), level);
        }
    }

    private void generateReplacedFrameEvents(Frame original, Frame replacement, TransactionIsolationLevel level) {
        String oldName = original.getName();
        this.generateFrameEvent(101, original, oldName, replacement, level);
        this.generateKbEvent(101, original, oldName, replacement);
    }

    private void generateReplacingFrameEvents(Frame replacement, Frame original, TransactionIsolationLevel level) {
        this.generateReplacingFrameAsValueEvents(replacement, original, level);
        if (replacement instanceof Slot) {
            this.generateReplacingSlotEvents((Slot)replacement, level);
        }
    }

    private void generateReplacingFrameAsValueEvents(Frame replacement, Frame original, TransactionIsolationLevel level) {
        Set<Reference> references = this.getDelegate().getReferences(replacement);
        if (references == null) {
            return;
        }
        for (Reference reference : references) {
            if (reference.isTemplate()) continue;
            Frame sourceFrame = reference.getFrame();
            Slot sourceSlot = reference.getSlot();
            Collection values = this.getDelegate().getOwnSlotValues(sourceFrame, sourceSlot);
            if (values == null || !values.contains(replacement)) continue;
            ArrayList<Frame> oldValues = new ArrayList<Frame>(values);
            oldValues.remove(replacement);
            oldValues.add(original);
            this.generateFrameEvent(110, sourceFrame, sourceSlot, oldValues, level);
        }
    }

    private void generateReplacingSlotEvents(Slot replacement, TransactionIsolationLevel level) {
        Set<Frame> frames = this.getDelegate().getFramesWithAnyDirectOwnSlotValue(replacement);
        if (frames == null) {
            return;
        }
        for (Frame frame : frames) {
            this.generateFrameEvent(110, frame, replacement, level);
        }
    }

    private void generateKbEvent(int type, Frame frame, TransactionIsolationLevel level) {
        this.addEvent(new KnowledgeBaseEvent(this._kb, type, frame), level);
    }

    private void generateKbEvent(int type, Frame frame, String s, TransactionIsolationLevel level) {
        this.addEvent(new KnowledgeBaseEvent(this._kb, type, frame, (Object)s), level);
    }

    private void generateKbEvent(int type, Frame frame, String s, Frame oldFrame) {
        this.addEvent(new KnowledgeBaseEvent(this._kb, type, frame, (Object)s, (Object)oldFrame));
    }

    private boolean generateEvent(Frame frame) {
        return !frame.isBeingDeleted() || this.generateEventsOnDeletingFrames;
    }

    private void generateFrameEvent(int type, Frame frame, TransactionIsolationLevel level) {
        this.generateFrameEvent(type, frame, null, null, level);
    }

    private void generateFrameEvent(int type, Frame frame, Object o2, TransactionIsolationLevel level) {
        this.generateFrameEvent(type, frame, o2, null, level);
    }

    private void generateFrameEvent(int type, Frame frame, Object o2, Object o3, TransactionIsolationLevel level) {
        if (this.generateEvent(frame)) {
            this.addEvent(new FrameEvent(frame, type, o2, o3), level);
        }
    }

    private void generateClsEvent(int type, Cls cls, Frame frame1, Frame frame2, TransactionIsolationLevel level) {
        if (this.generateEvent(cls)) {
            this.addEvent(new ClsEvent(cls, type, (Object)frame1, (Object)frame2), level);
        }
    }

    private void generateClsEvent(int type, Cls cls, Frame frame, TransactionIsolationLevel level) {
        this.generateClsEvent(type, cls, frame, null, level);
    }

    private void generateSlotEvent(int type, Slot slot, Frame frame, TransactionIsolationLevel level) {
        if (this.generateEvent(slot)) {
            this.addEvent(new SlotEvent(slot, type, frame), level);
        }
    }

    private void generateInstanceEvent(int type, Instance instance, Frame frame, TransactionIsolationLevel level) {
        if (this.generateEvent(instance)) {
            this.addEvent(new InstanceEvent(instance, type, (Object)frame), level);
        }
    }

    @Override
    public List<AbstractEvent> getEvents() {
        List<AbstractEvent> events = this._events;
        this._events = new ArrayList<AbstractEvent>();
        return events;
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls superclass) {
        Collection addedSlots = this.getSlotsToBeAdded(cls, superclass);
        this.getDelegate().addDirectSuperclass(cls, superclass);
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateClsEvent(301, cls, superclass, level);
        this.generateClsEvent(303, superclass, cls, level);
        this.generateSuperclassTemplateSlotChangedEvents(cls, 308, addedSlots, level);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, superclass, this._systemFrames.getDirectSuperclassesSlot(), level);
    }

    private Collection getSlotsToBeAdded(Cls cls, Cls superclass) {
        HashSet slots = new HashSet(this.getTemplateSlots(superclass));
        slots.removeAll(this.getTemplateSlots(cls));
        return slots;
    }

    private void generateSuperclassTemplateSlotChangedEvents(Cls cls, int type, Collection addedSlots, TransactionIsolationLevel level) {
        for (Slot slot : addedSlots) {
            this.generateClsEvent(type, cls, slot, level);
        }
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame1, Frame frame2, Slot slot, TransactionIsolationLevel level) {
        this.generateOwnSlotValuesChangedEvent(frame1, slot, level);
        this.generateOwnSlotValuesChangedEvent(frame2, slot.getInverseSlot(), level);
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame, Slot slot, TransactionIsolationLevel level) {
        ArrayList oldValues = null;
        if (this.getValues(frame, slot)) {
            oldValues = new ArrayList(this.getDirectOwnSlotValues(frame, slot));
        }
        this.generateOwnSlotValuesChangedEvent(frame, slot, oldValues, level);
    }

    private boolean getValues(Frame frame, Slot slot) {
        return !slot.equals(this._systemFrames.getDirectSubclassesSlot()) && !slot.equals(this._systemFrames.getDirectInstancesSlot());
    }

    private void generateOwnSlotValuesChangedEvent(Frame frame, Slot slot, Collection oldValues, TransactionIsolationLevel level) {
        this.generateFrameEvent(110, frame, slot, oldValues, level);
        for (Slot superslot : slot.getSuperslots()) {
            this.generateFrameEvent(110, frame, superslot, oldValues, level);
        }
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls superclass) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        HashSet<Slot> removedSlots = new HashSet<Slot>(cls.getTemplateSlots());
        this.getDelegate().removeDirectSuperclass(cls, superclass);
        removedSlots.removeAll(cls.getTemplateSlots());
        this.generateClsEvent(302, cls, superclass, level);
        this.generateClsEvent(304, superclass, cls, level);
        this.generateSuperclassTemplateSlotChangedEvents(cls, 309, removedSlots, level);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, superclass, this._systemFrames.getDirectSuperclassesSlot(), level);
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int from, int to) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, from, to);
        this.generateOwnSlotValuesChangedEvent(frame, slot, level);
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectSubclass(cls, subclass, index);
        this.generateClsEvent(307, cls, subclass, level);
        this.generateOwnSlotValuesChangedEvent(cls, this._systemFrames.getDirectSubclassesSlot(), level);
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectSubslot(slot, subslot, index);
        this.generateSlotEvent(409, slot, subslot, level);
        this.generateOwnSlotValuesChangedEvent(slot, this._systemFrames.getDirectSubslotsSlot(), level);
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot superslot) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().addDirectSuperslot(slot, superslot);
        this.generateSlotEvent(407, slot, superslot, level);
        this.generateSlotEvent(405, superslot, slot, level);
        this.generateOwnSlotValuesChangedEvent((Frame)slot, (Frame)superslot, this._systemFrames.getDirectSuperslotsSlot(), level);
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().removeDirectSuperslot(slot, superslot);
        this.generateSlotEvent(408, slot, superslot, level);
        this.generateSlotEvent(406, superslot, slot, level);
        this.generateOwnSlotValuesChangedEvent((Frame)slot, (Frame)superslot, this._systemFrames.getDirectSuperslotsSlot(), level);
    }

    @Override
    public void addDirectType(Instance instance, Cls type) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().addDirectType(instance, type);
        this.generateInstanceEvent(202, instance, type, level);
        this.generateClsEvent(305, type, instance, level);
        this.generateOwnSlotValuesChangedEvent((Frame)instance, type, this._systemFrames.getDirectTypesSlot(), level);
    }

    @Override
    public void removeDirectType(Instance instance, Cls type) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().removeDirectType(instance, type);
        this.generateInstanceEvent(203, instance, type, level);
        this.generateClsEvent(306, type, instance, level);
        this.generateOwnSlotValuesChangedEvent((Frame)instance, type, this._systemFrames.getDirectTypesSlot(), level);
    }

    @Override
    public void moveDirectType(Instance instance, Cls cls, int index) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectType(instance, cls, index);
        this.generateOwnSlotValuesChangedEvent(instance, this._systemFrames.getDirectTypesSlot(), level);
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().addDirectTemplateSlot(cls, slot);
        this.generateClsEvent(308, cls, slot, level);
        this.generateSlotEvent(401, slot, cls, level);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, (Frame)slot, this._systemFrames.getDirectTemplateSlotsSlot(), level);
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.generateClsEvent(309, cls, slot, level);
        this.generateSlotEvent(402, slot, cls, level);
        this.generateOwnSlotValuesChangedEvent((Frame)cls, (Frame)slot, this._systemFrames.getDirectTemplateSlotsSlot(), level);
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int index) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().moveDirectTemplateSlot(cls, slot, index);
        this.generateOwnSlotValuesChangedEvent(cls, this._systemFrames.getDirectTemplateSlotsSlot(), level);
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, values);
        this.generateClsEvent(310, cls, slot, level);
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, values);
        this.generateClsEvent(313, cls, slot, facet, level);
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
        for (Facet facet : this.getTemplateFacets(cls, slot)) {
            this.generateClsEvent(313, cls, slot, facet, level);
        }
    }

    @Override
    public boolean beginTransaction(String name) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateTransactionEvent(701, name, Boolean.FALSE, level);
        boolean allowsTransactions = this.getDelegate().beginTransaction(name);
        return allowsTransactions;
    }

    private void generateTransactionEvent(int type, String name, Boolean commit, TransactionIsolationLevel level) {
        this.addEvent(new TransactionEvent(this._kb, type, name, commit), level);
    }

    @Override
    public boolean commitTransaction() {
        boolean commitTransaction = this.getDelegate().commitTransaction();
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateTransactionEvent(702, null, commitTransaction, level);
        return commitTransaction;
    }

    @Override
    public boolean rollbackTransaction() {
        boolean rollbackTransaction = this.getDelegate().rollbackTransaction();
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        this.generateTransactionEvent(702, null, Boolean.FALSE, level);
        return rollbackTransaction;
    }

    public boolean setDeletingFrameEventsEnabled(boolean b) {
        boolean oldValue = this.generateEventsOnDeletingFrames;
        this.generateEventsOnDeletingFrames = b;
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        String newName = replacement.getFrameID().getName();
        if (this.getFrame(newName) != null) {
            return;
        }
        try {
            this.generateReplacedFrameEvents(original, replacement, level);
        }
        finally {
            this.inReplaceFrameOperation = false;
            this.getDelegate().replaceFrame(original, replacement);
        }
    }

    public void addCustomEvent(AbstractEvent event) {
        TransactionIsolationLevel level = this.transactionMonitor == null ? null : this.transactionMonitor.getTransationIsolationLevel();
        boolean visible = TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, level);
        event.setHiddenByTransaction(!visible);
        this._events.add(event);
    }

    private void addEvent(AbstractEvent event, TransactionIsolationLevel level) {
        if (this.inReplaceFrameOperation) {
            event.setReplacementEvent(true);
        }
        this._events.add(event);
        boolean visible = TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, level);
        event.setHiddenByTransaction(!visible);
    }

    private void addEvent(AbstractEvent event) {
        this._events.add(event);
    }

    private TransactionIsolationLevel getTransactionIsolationLevel() {
        if (this.transactionMonitor == null) {
            return TransactionIsolationLevel.NONE;
        }
        return this.transactionMonitor.getTransationIsolationLevel();
    }
}

