/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import java.util.Collection;

public class FacetCheckingFrameStore
extends FrameStoreAdapter {
    private static void checkAbstract(Collection types) {
        for (Cls cls : types) {
            if (!cls.isAbstract()) continue;
            throw new AbstractClassException();
        }
    }

    public Cls createCls(FrameID id, Collection types, Collection superclasses, boolean loadDefaults) {
        FacetCheckingFrameStore.checkAbstract(types);
        return this.getDelegate().createCls(id, types, superclasses, loadDefaults);
    }

    public Slot createSlot(FrameID id, Collection types, Collection superslots, boolean loadDefaults) {
        FacetCheckingFrameStore.checkAbstract(types);
        return this.getDelegate().createSlot(id, types, superslots, loadDefaults);
    }

    public Facet createFacet(FrameID id, Collection types, boolean loadDefaults) {
        FacetCheckingFrameStore.checkAbstract(types);
        return this.getDelegate().createFacet(id, types, loadDefaults);
    }

    public SimpleInstance createSimpleInstance(FrameID id, Collection types, boolean loadDefaults) {
        FacetCheckingFrameStore.checkAbstract(types);
        return this.getDelegate().createSimpleInstance(id, types, loadDefaults);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        this.checkOwnSlotValues(frame, slot, values);
        this.getDelegate().setDirectOwnSlotValues(frame, slot, values);
    }

    private void checkOwnSlotValues(Frame frame, Slot slot, Collection values) {
        for (Facet facet : this.getOwnFacets(frame, slot)) {
            if (facet.areValidValues(frame, slot, values)) continue;
            throw new FacetException();
        }
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        this.checkTemplateSlotValues(cls, slot, values);
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, values);
    }

    private void checkTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        for (Facet facet : this.getTemplateFacets(cls, slot)) {
            if (facet.areValidValues(cls, slot, values)) continue;
            throw new FacetException();
        }
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        this.checkTemplateFacetValues(cls, slot, facet, values);
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, values);
    }

    private void checkTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        Slot associatedSlot = facet.getAssociatedSlot();
        if (associatedSlot == null) {
            throw new FacetException();
        }
        this.checkOwnSlotValues(slot, associatedSlot, values);
    }

    public static class FacetException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -2526457416740648312L;
    }

    public static class AbstractClassException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 6154760101118221711L;
    }
}

