/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.ArgumentCheckingFrameStore;
import edu.stanford.smi.protege.model.framestore.CallCachingFrameStore;
import edu.stanford.smi.protege.model.framestore.ChangeMonitorFrameStore;
import edu.stanford.smi.protege.model.framestore.DeleteSimplificationFrameStore;
import edu.stanford.smi.protege.model.framestore.EventDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.EventSinkFrameStore;
import edu.stanford.smi.protege.model.framestore.FacetCheckingFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.ImmutableNamesFrameStore;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import edu.stanford.smi.protege.model.framestore.JournalingFrameStoreHandler;
import edu.stanford.smi.protege.model.framestore.ModificationRecordFrameStore;
import edu.stanford.smi.protege.model.framestore.ReadOnlyFrameStoreHandler;
import edu.stanford.smi.protege.model.framestore.TraceFrameStoreHandler;
import edu.stanford.smi.protege.model.framestore.cleandispatch.CleanDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.undo.UndoFrameStore;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameStoreManager {
    private static transient Logger log = Log.getLogger(FrameStoreManager.class);
    private FrameStore immutableNamesFrameStore;
    private FrameStore deleteSimplificationFrameStore;
    private FrameStore argumentCheckingFrameStore;
    private FrameStore cachingFrameStore;
    private FrameStore cleanDispatchFrameStore;
    private EventDispatchFrameStore eventDispatchFrameStore;
    private EventGeneratorFrameStore eventGeneratorFrameStore;
    private FrameStore eventSinkFrameStore;
    private FrameStore facetCheckingFrameStore;
    private FrameStore journalingFrameStore;
    private ModificationRecordFrameStore modificationRecordFrameStore;
    private FrameStore readonlyFrameStore;
    private UndoFrameStore undoFrameStore;
    private ChangeMonitorFrameStore changeMonitorFrameStore;
    private FrameStore traceFrameStore;
    private FrameStore terminalFrameStore;
    private FrameStore headFrameStore;
    private List<FrameStore> frameStores = new LinkedList<FrameStore>();
    private KnowledgeBase kb;

    public FrameStoreManager(KnowledgeBase kb) {
        this.kb = kb;
        this.createSystemFrameStores();
        this.headFrameStore = this.terminalFrameStore = this.create(InMemoryFrameStore.class);
        this.addSystemFrameStores();
    }

    public FrameStore getHeadFrameStore() {
        return this.headFrameStore;
    }

    public <X> X getFrameStoreFromClass(Class<? extends X> clazz) {
        for (FrameStore fs = this.headFrameStore; fs != null; fs = fs.getDelegate()) {
            Object o = fs;
            Class<?> fsClass = fs.getClass();
            if (Proxy.isProxyClass(fsClass)) {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(fs);
                fsClass = invocationHandler.getClass();
                o = invocationHandler;
            }
            if (!clazz.isAssignableFrom(fsClass)) continue;
            return clazz.cast(o);
        }
        return null;
    }

    protected FrameStore create(Class clas) {
        FrameStore frameStore = null;
        try {
            frameStore = FrameStoreManager.isHandlerClass(clas) ? AbstractFrameStoreInvocationHandler.newInstance(clas, this.kb) : (FrameStore)AbstractFrameStoreInvocationHandler.getInstance(clas, this.kb);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return frameStore;
    }

    private static boolean isHandlerClass(Class clas) {
        return AbstractFrameStoreInvocationHandler.class.isAssignableFrom(clas);
    }

    private boolean isMultiUserClient() {
        return this.kb.getProject() != null && this.kb.getProject().isMultiUserClient();
    }

    private void addSystemFrameStores() {
        this.add(this.cachingFrameStore, false);
        this.add(this.eventGeneratorFrameStore, true);
        this.add(this.eventSinkFrameStore, false);
        this.add(this.journalingFrameStore, false);
        this.add(this.modificationRecordFrameStore, false);
        this.add(this.eventDispatchFrameStore, true);
        this.add(this.undoFrameStore, false);
        this.add(this.facetCheckingFrameStore, false);
        this.add(this.argumentCheckingFrameStore, true);
        this.add(this.readonlyFrameStore, false);
        this.add(this.changeMonitorFrameStore, true);
        this.add(this.cleanDispatchFrameStore, true);
        this.add(this.deleteSimplificationFrameStore, true);
        this.add(this.immutableNamesFrameStore, true);
        this.add(this.traceFrameStore, false);
    }

    private void add(FrameStore frameStore, boolean enable) {
        Assert.assertNotNull("frame store", frameStore);
        this.frameStores.add(0, frameStore);
        if (enable) {
            this.connect(null, frameStore);
        }
    }

    private FrameStore getPreceedingEnabledFrameStore(FrameStore frameStore) {
        int index = this.frameStores.indexOf(frameStore);
        return this.getPreceedingEnabledFrameStore(index);
    }

    private FrameStore getPreceedingEnabledFrameStore(int index) {
        FrameStore preceedingEnabled = null;
        ListIterator<FrameStore> i = this.frameStores.listIterator(index);
        while (i.hasPrevious()) {
            FrameStore prev = i.previous();
            if (!FrameStoreManager.isEnabled(prev)) continue;
            preceedingEnabled = prev;
            break;
        }
        return preceedingEnabled;
    }

    private boolean enable(FrameStore frameStore) {
        boolean wasEnabled;
        FrameStore preceeding = this.getPreceedingEnabledFrameStore(frameStore);
        boolean bl = wasEnabled = preceeding == null ? this.headFrameStore.equals(frameStore) : preceeding.getDelegate().equals(frameStore);
        if (!wasEnabled) {
            this.connect(preceeding, frameStore);
            frameStore.reinitialize();
        }
        return wasEnabled;
    }

    private boolean disable(FrameStore frameStore) {
        boolean wasEnabled = FrameStoreManager.isEnabled(frameStore);
        if (wasEnabled) {
            FrameStore preceeding = this.getPreceedingEnabledFrameStore(frameStore);
            if (preceeding == null) {
                this.headFrameStore = frameStore.getDelegate();
                frameStore.setDelegate(null);
            } else {
                this.disconnect(preceeding, frameStore);
            }
            frameStore.reinitialize();
        }
        return wasEnabled;
    }

    public static boolean isEnabled(FrameStore frameStore) {
        return frameStore.getDelegate() != null;
    }

    public void close() {
        this.eventDispatchFrameStore.clearListeners();
        this.closeFrameStores();
        this.frameStores = null;
        this.kb = null;
        this.immutableNamesFrameStore = null;
        this.deleteSimplificationFrameStore = null;
        this.argumentCheckingFrameStore = null;
        this.cachingFrameStore = null;
        this.cleanDispatchFrameStore = null;
        this.eventDispatchFrameStore = null;
        this.eventGeneratorFrameStore = null;
        this.eventSinkFrameStore = null;
        this.facetCheckingFrameStore = null;
        this.journalingFrameStore = null;
        this.modificationRecordFrameStore = null;
        this.readonlyFrameStore = null;
        this.undoFrameStore = null;
        this.changeMonitorFrameStore = null;
        this.traceFrameStore = null;
        this.terminalFrameStore = null;
        this.headFrameStore = null;
    }

    private void closeFrameStores() {
        for (FrameStore frameStore : this.frameStores) {
            frameStore.close();
        }
        this.frameStores.clear();
        this.terminalFrameStore.close();
    }

    public boolean getDispatchEventsEnabled() {
        return FrameStoreManager.isEnabled(this.eventDispatchFrameStore);
    }

    public boolean getGenerateEventsEnabled() {
        if (!this.isMultiUserClient()) {
            return FrameStoreManager.isEnabled(this.eventGeneratorFrameStore);
        }
        return !FrameStoreManager.isEnabled(this.eventSinkFrameStore);
    }

    public boolean getFacetCheckingEnabled() {
        return FrameStoreManager.isEnabled(this.facetCheckingFrameStore);
    }

    public UndoFrameStore getUndoFrameStore() {
        return this.undoFrameStore;
    }

    public void insertFrameStore(FrameStore newFrameStore, int position) {
        this.frameStores.add(position, newFrameStore);
        FrameStore fs = this.getPreceedingEnabledFrameStore(position);
        this.connect(fs, newFrameStore);
    }

    private void connect(FrameStore frameStore1, FrameStore frameStore2) {
        if (frameStore1 == null) {
            frameStore2.setDelegate(this.headFrameStore);
            this.headFrameStore = frameStore2;
        } else {
            frameStore2.setDelegate(frameStore1.getDelegate());
            frameStore1.setDelegate(frameStore2);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("connected " + frameStore2);
            this.dumpFrameStores();
        }
    }

    private void disconnect(FrameStore frameStore1, FrameStore frameStore2) {
        if (frameStore1 == null) {
            this.headFrameStore = frameStore2.getDelegate();
        } else {
            frameStore1.setDelegate(frameStore2.getDelegate());
        }
        frameStore2.setDelegate(null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("disconnected " + frameStore2);
            this.dumpFrameStores();
        }
    }

    public void removeFrameStore(FrameStore frameStore) {
        int position = this.frameStores.indexOf(frameStore);
        FrameStore preceeding = this.getPreceedingEnabledFrameStore(position);
        this.disconnect(preceeding, frameStore);
        frameStore.close();
        this.frameStores.remove(frameStore);
    }

    public void insertFrameStore(FrameStore newFrameStore) {
        this.insertFrameStore(newFrameStore, 0);
    }

    public boolean isUndoEnabled() {
        return FrameStoreManager.isEnabled(this.undoFrameStore);
    }

    public boolean isCallCachingEnabled() {
        return FrameStoreManager.isEnabled(this.cachingFrameStore);
    }

    public boolean setEnabled(FrameStore fs, boolean b) {
        return b ? this.enable(fs) : this.disable(fs);
    }

    public boolean setArgumentCheckingEnabled(boolean b) {
        return this.setEnabled(this.argumentCheckingFrameStore, b);
    }

    public boolean setCallCachingEnabled(boolean b) {
        return this.setEnabled(this.cachingFrameStore, b);
    }

    public boolean setCleanDispatchEnabled(boolean b) {
        return this.setEnabled(this.cleanDispatchFrameStore, b);
    }

    public boolean setEventDispatchEnabled(boolean b) {
        return this.setEnabled(this.eventDispatchFrameStore, b);
    }

    public boolean setChangeMonitorEnabled(boolean b) {
        return this.setEnabled(this.changeMonitorFrameStore, b);
    }

    public boolean setFacetCheckingEnabled(boolean enabled) {
        return this.setEnabled(this.facetCheckingFrameStore, enabled);
    }

    public boolean setGenerateEventsEnabled(boolean b) {
        if (!this.isMultiUserClient()) {
            return this.setEnabled(this.eventGeneratorFrameStore, b);
        }
        return !this.setEnabled(this.eventSinkFrameStore, !b);
    }

    public boolean setJournalingEnabled(boolean b) {
        return this.setEnabled(this.journalingFrameStore, b);
    }

    public boolean isJournalingEnabled() {
        return FrameStoreManager.isEnabled(this.journalingFrameStore);
    }

    public boolean setModificationRecordUpdatingEnabled(boolean enabled) {
        return this.setEnabled(this.modificationRecordFrameStore, enabled);
    }

    public boolean setUndoEnabled(boolean b) {
        return this.setEnabled(this.undoFrameStore, b);
    }

    public void setPollForEvents(boolean b) {
        this.eventDispatchFrameStore.setPollForEvents(b);
    }

    public void setDispatchEventsPassThrough(boolean b) {
        this.eventDispatchFrameStore.setPassThrough(b);
    }

    public void flushEvents() throws ProtegeException {
        try {
            this.eventDispatchFrameStore.flushEvents();
        }
        catch (InterruptedException e) {
            throw new ProtegeIOException(e);
        }
    }

    public void removeListener(Class c, Object o, EventListener listener) {
        this.eventDispatchFrameStore.removeListener(c, o, listener);
    }

    public void notifyInstancesOfBrowserTextChange(Cls cls) {
        this.eventDispatchFrameStore.notifyInstancesOfBrowserTextChange(cls);
    }

    public void addListener(Class c, Object o, EventListener listener) {
        this.eventDispatchFrameStore.addListener(c, o, listener);
    }

    public List<FrameStore> getFrameStores() {
        return Collections.unmodifiableList(this.frameStores);
    }

    private void createSystemFrameStores() {
        this.immutableNamesFrameStore = this.create(ImmutableNamesFrameStore.class);
        this.deleteSimplificationFrameStore = this.create(DeleteSimplificationFrameStore.class);
        this.argumentCheckingFrameStore = this.create(ArgumentCheckingFrameStore.class);
        this.cachingFrameStore = this.create(CallCachingFrameStore.class);
        this.cleanDispatchFrameStore = this.create(CleanDispatchFrameStore.class);
        this.eventDispatchFrameStore = (EventDispatchFrameStore)this.create(EventDispatchFrameStore.class);
        this.eventGeneratorFrameStore = (EventGeneratorFrameStore)this.create(EventGeneratorFrameStore.class);
        this.eventSinkFrameStore = this.create(EventSinkFrameStore.class);
        this.facetCheckingFrameStore = this.create(FacetCheckingFrameStore.class);
        this.journalingFrameStore = this.create(JournalingFrameStoreHandler.class);
        this.modificationRecordFrameStore = (ModificationRecordFrameStore)this.create(ModificationRecordFrameStore.class);
        this.readonlyFrameStore = this.create(ReadOnlyFrameStoreHandler.class);
        this.undoFrameStore = (UndoFrameStore)this.create(UndoFrameStore.class);
        this.changeMonitorFrameStore = (ChangeMonitorFrameStore)this.create(ChangeMonitorFrameStore.class);
        this.traceFrameStore = this.create(TraceFrameStoreHandler.class);
    }

    public void setTerminalFrameStore(FrameStore newTerminalFrameStore) {
        FrameStore preceedingFrameStore = this.getPreceedingEnabledFrameStore(this.frameStores.size());
        preceedingFrameStore.setDelegate(newTerminalFrameStore);
        if (this.terminalFrameStore != newTerminalFrameStore) {
            this.terminalFrameStore.close();
        }
        this.terminalFrameStore = newTerminalFrameStore;
    }

    public void reinitialize() {
        for (FrameStore store : this.frameStores) {
            store.reinitialize();
        }
        this.terminalFrameStore.reinitialize();
    }

    public boolean setCaching(RemoteSession session, boolean doCache) {
        return ((InMemoryFrameStore)this.terminalFrameStore).getHelper().setCaching(session, doCache);
    }

    public FrameStore getTerminalFrameStore() {
        return this.terminalFrameStore;
    }

    public void setAuthor(String userName) {
        this.modificationRecordFrameStore.setAuthor(userName);
    }

    public void clearAllListeners() {
        this.eventDispatchFrameStore.clearListeners();
    }

    public boolean hasChanged() {
        return this.changeMonitorFrameStore.isChanged();
    }

    public void setChanged(boolean changed) {
        this.changeMonitorFrameStore.setChanged(changed);
    }

    private static InvocationHandler getHandler(FrameStore fs) {
        return Proxy.getInvocationHandler(fs);
    }

    public void startJournaling(URI journal) {
        this.setJournalingEnabled(true);
        JournalingFrameStoreHandler handler = (JournalingFrameStoreHandler)FrameStoreManager.getHandler(this.journalingFrameStore);
        handler.start(journal);
    }

    public void stopJournaling() {
        JournalingFrameStoreHandler handler = (JournalingFrameStoreHandler)FrameStoreManager.getHandler(this.journalingFrameStore);
        handler.stop();
    }

    public boolean setGenerateDeletingFrameEventsEnabled(boolean b) {
        return this.eventGeneratorFrameStore.setDeletingFrameEventsEnabled(b);
    }

    public void dumpFrameStores() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("+-+-+-+-+-+-+-+-+-+-+-+-Dumping Frame Stores+-+-+-+-+-+-+-+-+-+-+-+-");
            log.fine("Knowledge base = " + this.kb);
        }
        if (log.isLoggable(Level.FINE)) {
            for (FrameStore fs = this.headFrameStore; fs != null; fs = fs.getDelegate()) {
                Class<?> clazz = fs.getClass();
                if (Proxy.isProxyClass(clazz)) {
                    clazz = Proxy.getInvocationHandler(fs).getClass();
                }
                log.fine("Frame store: " + clazz);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("+-+-+-+-+-+-+-+-+-+-+-+-End Frame Store Dump+-+-+-+-+-+-+-+-+-+-+-+-");
        }
    }
}

