/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FrameStoreMethodInvoker {
    private static Map methodNameToInvokerMap = new HashMap();

    private static void checkInvokers() {
        Method[] methods = FrameStore.class.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methodNameToInvokerMap.containsKey(methods[i].getName())) continue;
            Log.getLogger().severe("Missing method invoker: " + methods[i].getName());
        }
    }

    private static void addInvoker(String methodName, Invoker invoker) {
        Invoker previous = methodNameToInvokerMap.put(methodName, invoker);
        if (previous != null) {
            Log.getLogger().warning("replaced previous invoker: " + methodName);
        }
    }

    public static Object invoke(Method method, Object[] args, FrameStore frameStore) {
        Invoker invoker = (Invoker)methodNameToInvokerMap.get(method.getName());
        return invoker.invoke(frameStore, args);
    }

    private static int getInteger(Object o) {
        return (Integer)o;
    }

    private static boolean getBoolean(Object o) {
        return (Boolean)o;
    }

    private static void addInvokers() {
        FrameStoreMethodInvoker.addInvoker("getFrameName", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getFrameName((Frame)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getName", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getName();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getClsCount", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return new Integer(delegate.getClsCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSlotCount", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return new Integer(delegate.getSlotCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFacetCount", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return new Integer(delegate.getFacetCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSimpleInstanceCount", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return new Integer(delegate.getSimpleInstanceCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFrameCount", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return new Integer(delegate.getFrameCount());
            }
        });
        FrameStoreMethodInvoker.addInvoker("getClses", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getClses();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSlots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getSlots();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFacets", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getFacets();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFrames", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getFrames();
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFrame", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                Frame rval = args[0] instanceof String ? delegate.getFrame((String)args[0]) : delegate.getFrame((FrameID)args[0]);
                return rval;
            }
        });
        FrameStoreMethodInvoker.addInvoker("createCls", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.createCls((FrameID)args[0], (Collection)args[1], (Collection)args[2], FrameStoreMethodInvoker.getBoolean(args[3]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("createSlot", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.createSlot((FrameID)args[0], (Collection)args[1], (Collection)args[2], FrameStoreMethodInvoker.getBoolean(args[3]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("createFacet", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.createFacet((FrameID)args[0], (Collection)args[1], FrameStoreMethodInvoker.getBoolean(args[2]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("createSimpleInstance", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.createSimpleInstance((FrameID)args[0], (Collection)args[1], FrameStoreMethodInvoker.getBoolean(args[2]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("deleteCls", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.deleteCls((Cls)args[0]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("deleteSlot", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.deleteSlot((Slot)args[0]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("deleteFacet", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.deleteFacet((Facet)args[0]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("deleteSimpleInstance", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.deleteSimpleInstance((SimpleInstance)args[0]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOwnSlots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getOwnSlots((Frame)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOwnSlotValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getOwnSlotValues((Frame)args[0], (Slot)args[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectOwnSlotValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectOwnSlotValues((Frame)args[0], (Slot)args[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectOwnSlotValuesCount", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return new Integer(delegate.getDirectOwnSlotValuesCount((Frame)args[0], (Slot)args[1]));
            }
        });
        FrameStoreMethodInvoker.addInvoker("moveDirectOwnSlotValue", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.moveDirectOwnSlotValue((Frame)args[0], (Slot)args[1], FrameStoreMethodInvoker.getInteger(args[2]), FrameStoreMethodInvoker.getInteger(args[3]));
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("setDirectOwnSlotValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.setDirectOwnSlotValues((Frame)args[0], (Slot)args[1], (Collection)args[2]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOwnFacets", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getOwnFacets((Frame)args[0], (Slot)args[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOwnFacetValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getOwnFacetValues((Frame)args[0], (Slot)args[1], (Facet)args[2]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getTemplateSlots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getTemplateSlots((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectTemplateSlots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectTemplateSlots((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectDomain", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectDomain((Slot)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDomain", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDomain((Slot)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOverriddenTemplateSlots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getOverriddenTemplateSlots((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectlyOverriddenTemplateSlots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectlyOverriddenTemplateSlots((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("addDirectTemplateSlot", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.addDirectTemplateSlot((Cls)args[0], (Slot)args[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("removeDirectTemplateSlot", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.removeDirectTemplateSlot((Cls)args[0], (Slot)args[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("moveDirectTemplateSlot", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.moveDirectTemplateSlot((Cls)args[0], (Slot)args[1], FrameStoreMethodInvoker.getInteger(args[2]));
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getTemplateSlotValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getTemplateSlotValues((Cls)args[0], (Slot)args[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectTemplateSlotValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectTemplateSlotValues((Cls)args[0], (Slot)args[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("setDirectTemplateSlotValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.setDirectTemplateSlotValues((Cls)args[0], (Slot)args[1], (Collection)args[2]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getTemplateFacets", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getTemplateFacets((Cls)args[0], (Slot)args[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getOverriddenTemplateFacets", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getOverriddenTemplateFacets((Cls)args[0], (Slot)args[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectlyOverriddenTemplateFacets", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectlyOverriddenTemplateFacets((Cls)args[0], (Slot)args[1]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("removeDirectTemplateFacetOverrides", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.removeDirectTemplateFacetOverrides((Cls)args[0], (Slot)args[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getTemplateFacetValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getTemplateFacetValues((Cls)args[0], (Slot)args[1], (Facet)args[2]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectTemplateFacetValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectTemplateFacetValues((Cls)args[0], (Slot)args[1], (Facet)args[2]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("setDirectTemplateFacetValues", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.setDirectTemplateFacetValues((Cls)args[0], (Slot)args[1], (Facet)args[2], (Collection)args[3]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSuperclasses", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectSuperclasses((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSuperclasses", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getSuperclasses((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSuperclasses", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectSuperclasses((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSubclasses", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectSubclasses((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSubclasses", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getSubclasses((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSuperclasses", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectSuperclasses((Cls)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("addDirectSuperclass", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.addDirectSuperclass((Cls)args[0], (Cls)args[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("removeDirectSuperclass", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.removeDirectSuperclass((Cls)args[0], (Cls)args[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("moveDirectSubclass", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.moveDirectSubclass((Cls)args[0], (Cls)args[1], FrameStoreMethodInvoker.getInteger(args[2]));
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSuperslots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectSuperslots((Slot)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSuperslots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getSuperslots((Slot)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getDirectSubslots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getDirectSubslots((Slot)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("getSubslots", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getSubslots((Slot)args[0]);
            }
        });
        FrameStoreMethodInvoker.addInvoker("addDirectSuperslot", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.addDirectSuperslot((Slot)args[0], (Slot)args[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("removeDirectSuperslot", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.removeDirectSuperslot((Slot)args[0], (Slot)args[1]);
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("moveDirectSubslot", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                delegate.moveDirectSubslot((Slot)args[0], (Slot)args[1], FrameStoreMethodInvoker.getInteger(args[2]));
                return null;
            }
        });
        FrameStoreMethodInvoker.addInvoker("getFrameName", new Invoker(){

            public Object invoke(FrameStore delegate, Object[] args) {
                return delegate.getFrameName((Frame)args[0]);
            }
        });
    }

    static {
        FrameStoreMethodInvoker.addInvokers();
        FrameStoreMethodInvoker.checkInvokers();
    }

    static interface Invoker {
        public Object invoke(FrameStore var1, Object[] var2);
    }
}

