/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import java.util.Collection;

public class ImmutableNamesFrameStore
extends FrameStoreAdapter {
    private KnowledgeBase kb;
    private int nextName;

    public ImmutableNamesFrameStore(KnowledgeBase kb) {
        this.kb = kb;
    }

    public FrameID adjustFrameId(FrameID id) {
        if (id == null || id.getName() == null) {
            return new FrameID(this.generateUniqueName("Class"));
        }
        this.checkUniqueness(id.getName());
        return id;
    }

    protected void checkUniqueness(String name) {
        if (this.getFrame(name) != null) {
            throw new IllegalArgumentException(name + " not unique");
        }
    }

    protected String generateUniqueName(String baseName) {
        String uniqueName = null;
        baseName = this.kb.getName() + "_" + baseName;
        while (uniqueName == null) {
            String s = baseName + this.nextName;
            if (this.getFrame(s) == null) {
                uniqueName = s;
                ++this.nextName;
                continue;
            }
            this.nextName += 10000;
        }
        return uniqueName;
    }

    public String getFrameName(Frame frame) {
        return frame.getFrameID().getName();
    }

    public Cls createCls(FrameID id, Collection directTypes, Collection directSuperclasses, boolean loadDefaultValues) {
        id = this.adjustFrameId(id);
        Cls cls = this.getDelegate().createCls(id, directTypes, directSuperclasses, loadDefaultValues);
        return cls;
    }

    public Slot createSlot(FrameID id, Collection directTypes, Collection directSuperslots, boolean loadDefaultValues) {
        id = this.adjustFrameId(id);
        Slot slot = this.getDelegate().createSlot(id, directTypes, directSuperslots, loadDefaultValues);
        return slot;
    }

    public Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        id = this.adjustFrameId(id);
        Facet facet = this.getDelegate().createFacet(id, directTypes, loadDefaultValues);
        return facet;
    }

    public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        id = this.adjustFrameId(id);
        SimpleInstance instance = this.getDelegate().createSimpleInstance(id, directTypes, loadDefaultValues);
        return instance;
    }
}

