/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableNamesNarrowFrameStore
implements NarrowFrameStore {
    private String name;
    private NarrowFrameStore delegate;
    private final Slot nameSlot;

    public ImmutableNamesNarrowFrameStore(KnowledgeBase kb, NarrowFrameStore delegate) {
        this.delegate = delegate;
        this.nameSlot = new DefaultSlot(kb, Model.SlotID.NAME);
    }

    private boolean isNameSlot(Slot slot) {
        return slot != null && slot.getFrameID().equals(Model.SlotID.NAME);
    }

    private boolean isNameSft(Slot slot, Facet facet, boolean isTemplate) {
        return this.isNameSlot(slot) && facet == null && !isTemplate;
    }

    private void checkNotNameSft(Slot slot, Facet facet, boolean isTemplate) {
        if (this.isNameSft(slot, facet, isTemplate)) {
            throw new IllegalArgumentException("Should not be modifying name slot values");
        }
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        this.checkNotNameSft(slot, facet, isTemplate);
        this.delegate.addValues(frame, slot, facet, isTemplate, values);
    }

    @Override
    public boolean beginTransaction(String name) {
        return this.delegate.beginTransaction(name);
    }

    @Override
    public void close() {
        this.delegate.close();
        this.delegate = null;
    }

    @Override
    public boolean commitTransaction() {
        return this.delegate.commitTransaction();
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.delegate.deleteFrame(frame);
    }

    @Override
    public void executeQuery(Query query, QueryCallback callback) {
        this.delegate.executeQuery(query, callback);
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this.delegate.getClosure(frame, slot, facet, isTemplate);
    }

    @Override
    public int getClsCount() {
        return this.delegate.getClsCount();
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this.delegate;
    }

    @Override
    public int getFacetCount() {
        return this.delegate.getFacetCount();
    }

    @Override
    public Frame getFrame(FrameID id) {
        return this.delegate.getFrame(id);
    }

    @Override
    public int getFrameCount() {
        return this.delegate.getFrameCount();
    }

    @Override
    public Set<Frame> getFrames() {
        return this.delegate.getFrames();
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean isTemplate, Object value) {
        return this.delegate.getFrames(slot, facet, isTemplate, value);
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean isTemplate) {
        return this.delegate.getFramesWithAnyValue(slot, facet, isTemplate);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) {
        return this.delegate.getMatchingFrames(slot, facet, isTemplate, value, maxMatches);
    }

    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches) {
        return this.delegate.getMatchingReferences(value, maxMatches);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<Reference> getReferences(Object value) {
        return this.delegate.getReferences(value);
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.delegate.getSimpleInstanceCount();
    }

    @Override
    public int getSlotCount() {
        return this.delegate.getSlotCount();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.delegate.getTransactionStatusMonitor();
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this.delegate.getValues(frame, slot, facet, isTemplate);
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this.delegate.getValuesCount(frame, slot, facet, isTemplate);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int from, int to) {
        this.checkNotNameSft(slot, facet, isTemplate);
        this.delegate.moveValue(frame, slot, facet, isTemplate, from, to);
    }

    @Override
    public void reinitialize() {
        this.delegate.reinitialize();
    }

    @Override
    public boolean setCaching(RemoteSession session, boolean doCache) {
        return this.delegate.setCaching(session, doCache);
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        this.checkNotNameSft(slot, facet, isTemplate);
        this.delegate.removeValue(frame, slot, facet, isTemplate, value);
    }

    @Override
    public void replaceFrame(Frame frame) {
        this.delegate.replaceFrame(frame);
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        this.delegate.replaceFrame(original, replacement);
    }

    @Override
    public boolean rollbackTransaction() {
        return this.delegate.rollbackTransaction();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        if (this.isNameSft(slot, facet, isTemplate) && (values == null || values.size() != 1 || !frame.getName().equals(values.iterator().next()))) {
            throw new IllegalArgumentException("Attempt to change the name of a frame");
        }
        this.delegate.setValues(frame, slot, facet, isTemplate, values);
    }
}

