/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ClosureUtils;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Record;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryFrameDb
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(InMemoryFrameDb.class);
    private static final int INITIAL_MAP_SIZE = 32771;
    private final Map<FrameID, Frame> idToFrameMap = new HashMap<FrameID, Frame>(32771);
    private Map<Record, Record> referenceToRecordMap = new HashMap<Record, Record>(32771);
    private Map<Frame, Set<Record>> frameToRecordsMap = new HashMap<Frame, Set<Record>>(32771);
    private Map<Slot, Set<Record>> slotToRecordsMap = new HashMap<Slot, Set<Record>>(32771);
    private Map<Facet, Set<Record>> facetToRecordsMap = new HashMap<Facet, Set<Record>>(32771);
    private Map<Object, Set<Record>> valueToRecordsMap = new LinkedHashMap<Object, Set<Record>>(32771);
    private Record lookupRecord = new Record();
    private String frameDBName;
    private Slot cachedNameSlot;

    public InMemoryFrameDb(String name) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Constructing InMemoryFrameDb with name " + name + " No delegate...");
        }
        this.frameDBName = name;
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    private Slot getNameSlot() {
        Iterator<Record> i;
        if (this.cachedNameSlot == null && (i = this.referenceToRecordMap.keySet().iterator()).hasNext()) {
            Record record = i.next();
            Frame frame = record.getFrame();
            KnowledgeBase kb = frame.getKnowledgeBase();
            this.cachedNameSlot = kb.getSlot(":NAME");
        }
        return this.cachedNameSlot;
    }

    public String toString() {
        return StringUtilities.getClassName(this) + "(" + this.frameDBName + ")";
    }

    private Set<Record> getMatchingRecords(String value, int maxMatches) {
        if (maxMatches < 1) {
            maxMatches = Integer.MAX_VALUE;
        }
        SimpleStringMatcher matcher = new SimpleStringMatcher(value);
        HashSet<Record> matches = new HashSet<Record>();
        Iterator<Map.Entry<Object, Set<Record>>> i = this.valueToRecordsMap.entrySet().iterator();
        while (i.hasNext() && matches.size() < maxMatches) {
            Map.Entry<Object, Set<Record>> entry = i.next();
            Object o = entry.getKey();
            if (!(o instanceof String) || !matcher.isMatch((String)o)) continue;
            Set<Record> records = entry.getValue();
            matches.addAll(records);
        }
        return matches;
    }

    private static boolean matches(Record record, Slot slot, Facet facet, boolean isTemplate) {
        boolean matches = InMemoryFrameDb.equals(slot, record.getSlot()) && InMemoryFrameDb.equals(facet, record.getFacet()) && isTemplate == record.isTemplate();
        return matches;
    }

    private int countFrames(Class clas) {
        int frameCount = 0;
        Slot nameSlot = this.getNameSlot();
        if (nameSlot != null) {
            Collection records = this.slotToRecordsMap.get(nameSlot);
            for (Record record : records) {
                if (!clas.isInstance(record.getFrame())) continue;
                ++frameCount;
            }
        }
        return frameCount;
    }

    private Record lookup(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        this.lookupRecord.set(frame, slot, facet, isTemplate);
        return this.referenceToRecordMap.get(this.lookupRecord);
    }

    private static <X, Y> Set<Y> lookupRecords(Map<X, Set<Y>> map, Object value) {
        return map.get(value);
    }

    public void addValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        Record record = this.lookup(frame, slot, facet, isTemplate);
        if (record == null) {
            this.createRecord(frame, slot, facet, isTemplate, CollectionUtilities.createList(value));
        } else {
            record.addValue(value);
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, value, record);
        }
    }

    private static <X> void removeFrameValue(Map<X, Set<Record>> map, Frame frame) {
        Set<Record> records = InMemoryFrameDb.lookupRecords(map, frame);
        if (records != null) {
            for (Record record : records) {
                record.removeValue(frame);
            }
            map.remove(frame);
        }
    }

    private void addRecordValues(Record record) {
        for (Object value : record.getInternalValues()) {
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, value, record);
        }
    }

    private void removeRecordValues(Record record) {
        for (Object value : record.getInternalValues()) {
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, value, record);
        }
    }

    private void createRecord(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        Record record = new Record(frame, slot, facet, isTemplate, values);
        this.addRecord(record);
    }

    private void addRecord(Record record) {
        this.referenceToRecordMap.put(record, record);
        this.idToFrameMap.put(record.getFrame().getFrameID(), record.getFrame());
        InMemoryFrameDb.addRecord(this.frameToRecordsMap, record.getFrame(), record);
        InMemoryFrameDb.addRecord(this.slotToRecordsMap, record.getSlot(), record);
        InMemoryFrameDb.addRecord(this.facetToRecordsMap, record.getFacet(), record);
        for (Object value : record.getValues()) {
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, value, record);
        }
    }

    private static <X> void addRecord(Map<X, Set<Record>> map, X key, Record record) {
        if (key != null) {
            Set<Record> set = map.get(key);
            if (set == null) {
                set = new HashSet<Record>();
                map.put(key, set);
            }
            set.add(record);
        }
    }

    private void removeRecord(Record record) {
        this.referenceToRecordMap.remove(record);
        InMemoryFrameDb.removeRecord(this.frameToRecordsMap, record.getFrame(), record);
        InMemoryFrameDb.removeRecord(this.slotToRecordsMap, record.getSlot(), record);
        InMemoryFrameDb.removeRecord(this.facetToRecordsMap, record.getFacet(), record);
        for (Object value : record.getValues()) {
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, value, record);
        }
        Set<Record> records = InMemoryFrameDb.lookupRecords(this.frameToRecordsMap, record.getFrame());
        if (records == null || records.isEmpty()) {
            this.idToFrameMap.remove(record.getFrame().getFrameID());
        }
    }

    public static <X> void removeRecord(Map<X, Set<Record>> map, Object key, Record record) {
        Set<Record> set;
        if (key != null && (set = map.get(key)) != null) {
            set.remove(record);
        }
    }

    private <X> void removeRecords(Map<X, Set<Record>> map, Frame frame) {
        Collection<Record> records = InMemoryFrameDb.lookupRecords(map, frame);
        if (records != null) {
            records = new ArrayList<Record>(records);
            for (Record record : records) {
                this.removeRecord(record);
            }
            map.remove(frame);
        }
    }

    private <X> void replaceFrameKey(Map<X, Set<Record>> map, Frame frame) {
        Set<Record> records = map.remove(frame);
        if (records != null) {
            map.put(frame, records);
            for (Record record : records) {
                record.replaceFrameReference(frame);
                this.referenceToRecordMap.remove(record);
                this.referenceToRecordMap.put(record, record);
            }
        }
    }

    private void replaceRecords(Frame original, Frame replacement, Set<Record> records) {
        for (Record r : records) {
            Record newRecord = new Record(r.getFrame().equals(original) ? replacement : r.getFrame(), r.getSlot().equals(original) ? (Slot)replacement : r.getSlot(), r.getFacet() != null && r.getFacet().equals(original) ? (Facet)replacement : r.getFacet(), r.isTemplate(), r.getValues());
            if (newRecord.getFrame().equals(replacement) && newRecord.getSlot().getFrameID().equals(Model.SlotID.NAME) && newRecord.getFacet() == null && !newRecord.isTemplate()) {
                List<String> values = Collections.singletonList(replacement.getName());
                newRecord.setValues(values);
            }
            this.removeRecord(r);
            this.addRecord(newRecord);
        }
        original.markDeleted(true);
    }

    public Collection<Record> getRecords() {
        return new ArrayList<Record>(this.referenceToRecordMap.keySet());
    }

    private static Set<Reference> recordsToReferences(Set<Record> records) {
        HashSet<Reference> references;
        if (records == null) {
            references = Collections.EMPTY_SET;
        } else {
            references = new HashSet<Reference>(records.size());
            for (Record record : records) {
                references.add(InMemoryFrameDb.recordToReference(record));
            }
        }
        return references;
    }

    private static Reference recordToReference(Record record) {
        Frame frame = record.getFrame();
        Slot slot = record.getSlot();
        Facet facet = record.getFacet();
        boolean isTemplate = record.isTemplate();
        return new ReferenceImpl(frame, slot, facet, isTemplate);
    }

    @Override
    public String getName() {
        return this.frameDBName;
    }

    @Override
    public void setName(String name) {
        this.frameDBName = name;
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return null;
    }

    @Override
    public int getFrameCount() {
        Collection records;
        int count = 0;
        Slot slot = this.getNameSlot();
        if (slot != null && (records = (Collection)this.slotToRecordsMap.get(slot)) != null) {
            count = records.size();
        }
        return count;
    }

    @Override
    public int getClsCount() {
        return this.countFrames(Cls.class);
    }

    @Override
    public int getSlotCount() {
        return this.countFrames(Slot.class);
    }

    @Override
    public int getFacetCount() {
        return this.countFrames(Facet.class);
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.countFrames(SimpleInstance.class);
    }

    @Override
    public Set<Frame> getFrames() {
        return new HashSet<Frame>(this.frameToRecordsMap.keySet());
    }

    @Override
    public Frame getFrame(FrameID id) {
        return this.idToFrameMap.get(id);
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        List values = Collections.EMPTY_LIST;
        Record record = this.lookup(frame, slot, facet, isTemplate);
        if (record != null) {
            values = record.getValues();
        }
        return values;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        int count = 0;
        Record record = this.lookup(frame, slot, facet, isTemplate);
        if (record != null) {
            count = record.getValueCount();
        }
        return count;
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        for (Object value : values) {
            this.addValue(frame, slot, facet, isTemplate, value);
        }
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int from, int to) {
        Record record = this.lookup(frame, slot, facet, isTemplate);
        if (record != null) {
            record.moveValue(from, to);
        }
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        Record record = this.lookup(frame, slot, facet, isTemplate);
        if (record != null) {
            record.removeValue(value);
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, value, record);
            if (record.isEmpty()) {
                this.removeRecord(record);
            }
        }
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        Record record = this.lookup(frame, slot, facet, isTemplate);
        if (record == null) {
            this.createRecord(frame, slot, facet, isTemplate, values);
        } else {
            this.removeRecordValues(record);
            record.setValues(values);
            this.addRecordValues(record);
        }
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean isTemplate, Object value) {
        HashSet<Frame> frames = new HashSet<Frame>();
        Set<Record> records = InMemoryFrameDb.lookupRecords(this.valueToRecordsMap, value);
        if (records != null) {
            for (Record record : records) {
                if (!InMemoryFrameDb.matches(record, slot, facet, isTemplate)) continue;
                frames.add(record.getFrame());
            }
        }
        return frames;
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean isTemplate) {
        HashSet<Frame> frames = new HashSet<Frame>();
        Set<Record> records = facet != null ? InMemoryFrameDb.lookupRecords(this.facetToRecordsMap, facet) : InMemoryFrameDb.lookupRecords(this.slotToRecordsMap, slot);
        if (records != null) {
            for (Record record : records) {
                if (!InMemoryFrameDb.matches(record, slot, facet, isTemplate)) continue;
                frames.add(record.getFrame());
            }
        }
        return frames;
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) {
        if (maxMatches < 1) {
            maxMatches = Integer.MAX_VALUE;
        }
        HashSet<Frame> frames = new HashSet<Frame>();
        Iterator<Record> i = this.getMatchingRecords(value, -1).iterator();
        while (i.hasNext() && frames.size() < maxMatches) {
            Record record = i.next();
            if (!InMemoryFrameDb.matches(record, slot, facet, isTemplate)) continue;
            frames.add(record.getFrame());
        }
        return frames;
    }

    @Override
    public Set<Reference> getReferences(Object value) {
        Set<Record> records = InMemoryFrameDb.lookupRecords(this.valueToRecordsMap, value);
        return InMemoryFrameDb.recordsToReferences(records);
    }

    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches) {
        Set<Record> records = this.getMatchingRecords(value, maxMatches);
        return InMemoryFrameDb.recordsToReferences(records);
    }

    @Override
    public void executeQuery(Query query, final QueryCallback callback) {
        new Thread(new Runnable(){

            public void run() {
                callback.handleError(new ProtegeError("Not implemented yet"));
            }
        }, "Vacuous In MemoryDb callback thread");
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.removeRecords(this.frameToRecordsMap, frame);
        this.removeRecords(this.slotToRecordsMap, frame);
        this.removeRecords(this.facetToRecordsMap, frame);
        InMemoryFrameDb.removeFrameValue(this.valueToRecordsMap, frame);
    }

    @Override
    public void close() {
        this.referenceToRecordMap = null;
        this.frameToRecordsMap = null;
        this.slotToRecordsMap = null;
        this.facetToRecordsMap = null;
        this.valueToRecordsMap = null;
        this.lookupRecord = null;
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return ClosureUtils.calculateClosure(this, frame, slot, facet, isTemplate);
    }

    @Override
    public void replaceFrame(Frame frame) {
        if (this.idToFrameMap.get(frame.getFrameID()) != null) {
            this.idToFrameMap.put(frame.getFrameID(), frame);
        }
        this.replaceFrameKey(this.frameToRecordsMap, frame);
        this.replaceFrameKey(this.slotToRecordsMap, frame);
        this.replaceFrameKey(this.facetToRecordsMap, frame);
        this.replaceFrameKey(this.valueToRecordsMap, frame);
        Set<Record> records = this.valueToRecordsMap.get(frame);
        if (records != null) {
            for (Record record : records) {
                record.replaceFrameValue(frame);
            }
        }
    }

    @Override
    public boolean beginTransaction(String name) {
        return false;
    }

    @Override
    public boolean commitTransaction() {
        return true;
    }

    @Override
    public boolean rollbackTransaction() {
        return false;
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return null;
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public boolean setCaching(RemoteSession session, boolean doCache) {
        return false;
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        if (original.equals(replacement)) {
            return;
        }
        if (this.idToFrameMap.containsKey(original.getFrameID())) {
            this.idToFrameMap.remove(original.getFrameID());
            this.idToFrameMap.put(replacement.getFrameID(), replacement);
        }
        HashSet<Record> recordsToChange = new HashSet<Record>();
        if (this.frameToRecordsMap.get(original) != null) {
            for (Record r : this.frameToRecordsMap.get(original)) {
                recordsToChange.add(r);
            }
        }
        if (this.slotToRecordsMap.get(original) != null) {
            for (Record r : this.slotToRecordsMap.get(original)) {
                recordsToChange.add(r);
            }
        }
        if (this.facetToRecordsMap.get(original) != null) {
            for (Record r : this.facetToRecordsMap.get(original)) {
                recordsToChange.add(r);
            }
        }
        this.replaceRecords(original, replacement, recordsToChange);
        if (this.valueToRecordsMap.get(original) != null) {
            for (Record r : this.valueToRecordsMap.get(original)) {
                int index;
                List values = r.getValues();
                while ((index = values.indexOf(original)) != -1) {
                    values.remove(index);
                    values.add(index, replacement);
                }
                r.setValues(values);
            }
            this.valueToRecordsMap.put(replacement, this.valueToRecordsMap.get(original));
            this.valueToRecordsMap.remove(original);
        }
        this.deleteFrame(original);
    }
}

