/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.ClosureCachingBasicFrameStore;
import edu.stanford.smi.protege.model.framestore.ImmutableNamesNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.SimpleFrameStore;
import java.net.URI;

public class InMemoryFrameStore
extends SimpleFrameStore {
    public InMemoryFrameStore(KnowledgeBase kb) {
        super(kb, InMemoryFrameStore.buildNarrowFrameStore(kb));
        this.addSystemFrames();
        NarrowFrameStore mfs = this.getHelper();
        while (!(mfs instanceof MergingNarrowFrameStore)) {
            mfs = mfs.getDelegate();
        }
        ((MergingNarrowFrameStore)mfs).addActiveFrameStore(new InMemoryFrameDb(InMemoryFrameStore.getName(kb)));
    }

    private static NarrowFrameStore buildNarrowFrameStore(KnowledgeBase kb) {
        MergingNarrowFrameStore merging = new MergingNarrowFrameStore(kb);
        ClosureCachingBasicFrameStore closureCaching = new ClosureCachingBasicFrameStore(merging);
        ImmutableNamesNarrowFrameStore immutableNames = new ImmutableNamesNarrowFrameStore(kb, closureCaching);
        return immutableNames;
    }

    private static String getName(KnowledgeBase kb) {
        URI uri;
        String name = null;
        Project p = kb.getProject();
        if (p != null && (uri = p.getProjectURI()) != null) {
            name = uri.toString();
        }
        if (name == null) {
            name = kb.getName();
        }
        return name;
    }
}

