/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.util.AbstractFormatter;
import edu.stanford.smi.protege.util.ApplicationProperties;
import java.lang.reflect.Method;
import java.util.logging.LogRecord;

public class JournalFormater
extends AbstractFormatter {
    private final String appUsername = ApplicationProperties.getUserName();

    private String getUsername() {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        return session == null ? this.appUsername : session.getUserName();
    }

    public String format(LogRecord record) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(JournalFormater.getDateString());
        buffer.append(" ");
        buffer.append(this.getUsername());
        buffer.append(" - ");
        Object[] params = record.getParameters();
        Method method = (Method)params[0];
        buffer.append(method.getName());
        buffer.append("(");
        for (int i = 1; i < params.length - 1; ++i) {
            Object param = params[i];
            if (i != 1) {
                buffer.append(", ");
            }
            buffer.append(JournalFormater.toString(param));
        }
        buffer.append(") returns ");
        Object result = params[params.length - 1];
        buffer.append(JournalFormater.toString(result));
        buffer.append(JournalFormater.getLineSeparator());
        return buffer.toString();
    }
}

