/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.JournalFormater;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.model.query.QueryCallbackClone;
import edu.stanford.smi.protege.util.Log;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JournalingFrameStoreHandler
extends AbstractFrameStoreInvocationHandler {
    public static final String journaller_name = "protege.journal";
    private Logger journaler;
    private Handler handler;
    private boolean recordQueries = false;

    public void start(URI journalURI) {
        try {
            this.stop();
            this.handler = new FileHandler(new File(journalURI).getPath(), true);
            this.journaler = Logger.getLogger(journaller_name);
            this.journaler.setUseParentHandlers(false);
            this.journaler.addHandler(this.handler);
            this.journaler.setLevel(Level.ALL);
            this.handler.setFormatter(new JournalFormater());
            this.handler.setLevel(Level.ALL);
        }
        catch (IOException e) {
            Log.getLogger().throwing("JournalingFrameStoreHandler", "start", e);
        }
    }

    public void stop() {
        if (this.handler != null) {
            this.journaler.removeHandler(this.handler);
            this.handler.flush();
            this.handler.close();
            this.handler = null;
        }
        this.journaler = null;
    }

    public void handleClose() {
        this.stop();
    }

    public Object handleInvoke(Method method, Object[] args) {
        Object result = this.invoke(method, args);
        if (this.doRecord(method)) {
            this.record(method, args, result);
        }
        return result;
    }

    public void executeQuery(Query q, QueryCallback qc) {
        QueryCallback myCallback = qc;
        if (this.recordQueries) {
            myCallback = new QueryCallbackClone(qc){

                public void provideQueryResults(Set<Frame> results) {
                    JournalingFrameStoreHandler.this.journaler.info("Query Callback returning results");
                    super.provideQueryResults(results);
                }
            };
        }
        this.getDelegate().executeQuery(q, myCallback);
        if (this.recordQueries) {
            this.journaler.info("Executing query " + q + " (callback may log entry before this log)");
        }
    }

    protected void record(Method m, Object[] args, Object result) {
        int length = args == null ? 2 : args.length + 2;
        Object[] params = new Object[length];
        params[0] = m;
        if (args != null) {
            System.arraycopy(args, 0, params, 1, args.length);
        }
        params[length - 1] = result;
        this.journaler.log(Level.INFO, "entry", params);
    }

    protected boolean doRecord(Method method) {
        return this.journaler != null && (this.recordQueries || JournalingFrameStoreHandler.isModification(method));
    }
}

