/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.PlaceHolderNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.SimpleFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.Tree;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergingNarrowFrameStore
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(MergingNarrowFrameStore.class);
    private final Object kbLock;
    private static final NarrowFrameStore ROOT_NODE = new PlaceHolderNarrowFrameStore();
    private NarrowFrameStore activeFrameStore;
    private final Collection<NarrowFrameStore> removeFrameStores = new LinkedHashSet<NarrowFrameStore>();
    private final Collection<NarrowFrameStore> availableFrameStores = new LinkedHashSet<NarrowFrameStore>();
    private NarrowFrameStore topFrameStore;
    private final NarrowFrameStore systemFrameStore;
    private boolean queryAllFrameStores = false;
    private boolean suppressDuplicates = false;
    private final Tree<NarrowFrameStore> frameStoreTree = new Tree<NarrowFrameStore>(ROOT_NODE);

    public MergingNarrowFrameStore(Object kbLock) {
        this.systemFrameStore = new InMemoryFrameDb("system");
        this.addActiveFrameStore(this.systemFrameStore);
        this.kbLock = kbLock;
    }

    public static MergingNarrowFrameStore get(KnowledgeBase kb) {
        FrameStore terminalFrameStore;
        if (kb instanceof DefaultKnowledgeBase && (terminalFrameStore = ((DefaultKnowledgeBase)kb).getTerminalFrameStore()) instanceof SimpleFrameStore) {
            SimpleFrameStore store = (SimpleFrameStore)terminalFrameStore;
            for (NarrowFrameStore nfs = store.getHelper().getDelegate(); nfs != null; nfs = nfs.getDelegate()) {
                if (!(nfs instanceof MergingNarrowFrameStore)) continue;
                return (MergingNarrowFrameStore)nfs;
            }
        }
        return null;
    }

    public static NarrowFrameStore getSystemFrameStore(KnowledgeBase kb) {
        return MergingNarrowFrameStore.get(kb).getSystemFrameStore();
    }

    public static NarrowFrameStore getNarrowFrameStore(KnowledgeBase kb, Class clazz) {
        NarrowFrameStore nfs = MergingNarrowFrameStore.get(kb);
        while ((nfs = nfs.getDelegate()) != null) {
            if (!clazz.isAssignableFrom(nfs.getClass())) continue;
            return nfs;
        }
        return null;
    }

    public NarrowFrameStore getSystemFrameStore() {
        return this.systemFrameStore;
    }

    public Collection<NarrowFrameStore> getAvailableFrameStores() {
        return new ArrayList<NarrowFrameStore>(this.availableFrameStores);
    }

    public Collection<NarrowFrameStore> getAllFrameStores() {
        Set<NarrowFrameStore> frameStores = this.frameStoreTree.getNodes();
        frameStores.add(this.systemFrameStore);
        return frameStores;
    }

    @Override
    public String getName() {
        return StringUtilities.getClassName(this);
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    public NarrowFrameStore getActiveFrameStore() {
        return this.activeFrameStore;
    }

    public void setRemoveFrameStores(Collection<NarrowFrameStore> narrowFrameStores) {
        this.removeFrameStores.clear();
        this.removeFrameStores.addAll(narrowFrameStores);
    }

    public NarrowFrameStore getFrameStore(String name) {
        NarrowFrameStore frameStore = null;
        for (NarrowFrameStore testFrameStore : this.frameStoreTree.getDescendents(ROOT_NODE)) {
            if (!name.equals(testFrameStore.getName())) continue;
            frameStore = testFrameStore;
            break;
        }
        return frameStore;
    }

    public void addRelation(String parent, String child) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding frame store relation between " + parent + " and " + child);
        }
        NarrowFrameStore parentFs = this.getFrameStore(parent);
        NarrowFrameStore childFs = this.getFrameStore(child);
        if (parentFs == null || childFs == null) {
            String text = "Unable to add relation between " + parent + "(" + parentFs + ")";
            text = text + " and " + child + "(" + childFs + ")";
            Log.getLogger().warning(text);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("...Added");
                this.dumpFrameStores(Level.FINE);
            }
            this.frameStoreTree.addChild(parentFs, childFs);
            this.updateQueryableFrameStores();
        }
    }

    public void dumpFrameStores() {
        this.dumpFrameStores(Level.INFO);
    }

    public void dumpFrameStores(Level lev) {
        if (!log.isLoggable(lev)) {
            return;
        }
        log.log(lev, "------------Starting Merged Narrow Frame Store Dump");
        for (NarrowFrameStore nfs : this.frameStoreTree.getNodes()) {
            log.log(lev, "*" + nfs.getClass() + " " + nfs.getName() + " " + this.frameStoreTree.getChildren(nfs));
        }
        if (this.activeFrameStore != null) {
            log.log(lev, "Active frame store = " + this.activeFrameStore.getName());
        }
        log.log(lev, "------------Merged Narrow Frame Store Dump Completed");
    }

    public void addActiveFrameStore(NarrowFrameStore frameStore) {
        this.addActiveFrameStore(frameStore, CollectionUtilities.EMPTY_ARRAY_LIST);
    }

    public void addActiveChildFrameStore(NarrowFrameStore childFrameStore, String parentName) {
        if (childFrameStore == null) {
            throw new IllegalArgumentException("Null child");
        }
        NarrowFrameStore parentFrameStore = this.getFrameStore(parentName);
        if (parentFrameStore == null) {
            throw new IllegalArgumentException("Null parent: " + parentName);
        }
        this.frameStoreTree.addChild(parentFrameStore, childFrameStore);
        this.setActiveFrameStore(childFrameStore);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding child frame store (and making active?) " + childFrameStore);
            this.dumpFrameStores(Level.FINE);
        }
    }

    public void removeFrameStore(NarrowFrameStore frameStore) {
        this.frameStoreTree.removeNode(frameStore);
        this.availableFrameStores.remove(frameStore);
        this.removeFrameStores.remove(frameStore);
        if (log.isLoggable(Level.FINE)) {
            log.fine("removing frame store " + frameStore);
        }
    }

    public void addActiveFrameStore(NarrowFrameStore parent, Collection childNames) {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.frameStoreTree.addChild(ROOT_NODE, parent);
        Iterator i = childNames.iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            NarrowFrameStore child = this.getFrameStore(name);
            if (child == null) {
                Log.getLogger().warning("Unable to find child FrameStore: " + name);
                continue;
            }
            this.frameStoreTree.addChild(parent, child);
        }
        this.setActiveFrameStore(parent);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Added new active frame store");
            this.dumpFrameStores(Level.FINE);
        }
    }

    public Slot getNameSlot() {
        return (Slot)this.systemFrameStore.getFrame(Model.SlotID.NAME);
    }

    public void setTopFrameStore(String name) {
        this.topFrameStore = name == null ? null : this.getFrameStore(name);
        this.updateQueryableFrameStores();
    }

    public NarrowFrameStore getTopFrameStore() {
        return this.topFrameStore == null ? this.activeFrameStore : this.topFrameStore;
    }

    public NarrowFrameStore setActiveFrameStore(NarrowFrameStore nfs) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting the delegate for " + this + " to " + nfs);
        }
        NarrowFrameStore oldActiveFrameStore = this.activeFrameStore;
        if (nfs != null) {
            this.activeFrameStore = nfs;
            this.updateQueryableFrameStores();
        }
        return oldActiveFrameStore;
    }

    public void setQueryAllFrameStores(boolean b) {
        this.queryAllFrameStores = b;
        this.updateQueryableFrameStores();
    }

    public void setSuppressDuplicates(boolean suppressDuplicates) {
        this.suppressDuplicates = suppressDuplicates;
    }

    private void updateQueryableFrameStores() {
        this.availableFrameStores.clear();
        this.availableFrameStores.add(this.systemFrameStore);
        if (this.queryAllFrameStores) {
            this.availableFrameStores.addAll(this.frameStoreTree.getDescendents(ROOT_NODE));
        } else {
            this.availableFrameStores.addAll(this.frameStoreTree.getNodeAndDescendents(this.getTopFrameStore()));
        }
        this.checkAvailable();
    }

    private void checkAvailable() {
        Iterator<NarrowFrameStore> i = this.availableFrameStores.iterator();
        while (i.hasNext()) {
            NarrowFrameStore o = i.next();
            if (o != null) continue;
            Log.getLogger().severe("Null frame store found");
            i.remove();
        }
    }

    public NarrowFrameStore setActiveFrameStore(String name) {
        NarrowFrameStore nfs = this.getFrameStore(name);
        if (nfs == null) {
            Log.getLogger().severe("Missing frame store: " + name);
        }
        return this.setActiveFrameStore(nfs);
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this.activeFrameStore;
    }

    @Override
    public int getFrameCount() {
        int count = 0;
        for (NarrowFrameStore fs : this.availableFrameStores) {
            count += fs.getFrameCount();
        }
        return count;
    }

    public Set getFrames() {
        HashSet<Frame> frames = new HashSet<Frame>();
        for (NarrowFrameStore fs : this.availableFrameStores) {
            frames.addAll(fs.getFrames());
        }
        return frames;
    }

    @Override
    public int getClsCount() {
        int count = 0;
        for (NarrowFrameStore fs : this.availableFrameStores) {
            count += fs.getClsCount();
        }
        return count;
    }

    @Override
    public int getSlotCount() {
        int count = 0;
        for (NarrowFrameStore fs : this.availableFrameStores) {
            count += fs.getSlotCount();
        }
        return count;
    }

    @Override
    public int getFacetCount() {
        int count = 0;
        for (NarrowFrameStore fs : this.availableFrameStores) {
            count += fs.getFacetCount();
        }
        return count;
    }

    @Override
    public int getSimpleInstanceCount() {
        int count = 0;
        for (NarrowFrameStore fs : this.availableFrameStores) {
            count += fs.getSimpleInstanceCount();
        }
        return count;
    }

    @Override
    public Frame getFrame(FrameID id) {
        Frame frame = null;
        Iterator<NarrowFrameStore> i = this.availableFrameStores.iterator();
        while (i.hasNext() && frame == null) {
            NarrowFrameStore fs = i.next();
            frame = fs.getFrame(id);
        }
        return frame;
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this.getValues(frame, slot, facet, isTemplate, false);
    }

    private List getSecondaryValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this.getValues(frame, slot, facet, isTemplate, true);
    }

    private List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, boolean skipActive) {
        SequencedCollection values = null;
        for (NarrowFrameStore fs : this.availableFrameStores) {
            List fsValues;
            if (fs == this.activeFrameStore && skipActive || (fsValues = fs.getValues(frame, slot, facet, isTemplate)).isEmpty()) continue;
            if (values == null && !this.suppressDuplicates) {
                values = fsValues;
                continue;
            }
            if (values == null && this.suppressDuplicates) {
                values = new LinkedHashSet(fsValues);
                continue;
            }
            values.addAll(fsValues);
        }
        if (values == null) {
            values = Collections.EMPTY_LIST;
        }
        if (!(values instanceof List)) {
            values = new ArrayList(values);
        }
        return values;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        int count = 0;
        for (NarrowFrameStore fs : this.availableFrameStores) {
            count += fs.getValuesCount(frame, slot, facet, isTemplate);
        }
        return count;
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        this.getDelegate().addValues(frame, slot, facet, isTemplate, values);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int from, int to) {
        List secondaryValues = this.getSecondaryValues(frame, slot, facet, isTemplate);
        if (secondaryValues.isEmpty()) {
            this.getDelegate().moveValue(frame, slot, facet, isTemplate, from, to);
        } else {
            List values = this.getValues(frame, slot, facet, isTemplate);
            Object fromObject = values.get(from);
            Object toObject = values.get(to);
            if (!secondaryValues.contains(fromObject) && !secondaryValues.contains(toObject)) {
                this.getDelegate().moveValue(frame, slot, facet, isTemplate, from -= secondaryValues.size(), to -= secondaryValues.size());
            }
        }
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        this.getDelegate().removeValue(frame, slot, facet, isTemplate, value);
        if (!this.removeFrameStores.isEmpty()) {
            this.removeValueFromRemoveFrameStores(frame, slot, facet, isTemplate, value);
        }
    }

    private void removeValueFromRemoveFrameStores(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        for (NarrowFrameStore frameStore : this.removeFrameStores) {
            frameStore.removeValue(frame, slot, facet, isTemplate, value);
        }
    }

    private void removeValuesFromRemoveFrameStores(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection valuesToRemove) {
        for (Object value : valuesToRemove) {
            this.removeValueFromRemoveFrameStores(frame, slot, facet, isTemplate, value);
        }
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        List secondaryValues = this.getSecondaryValues(frame, slot, facet, isTemplate);
        if (!this.removeFrameStores.isEmpty()) {
            ArrayList valuesToRemove = new ArrayList(secondaryValues);
            valuesToRemove.removeAll(values);
            this.removeValuesFromRemoveFrameStores(frame, slot, facet, isTemplate, valuesToRemove);
        }
        ArrayList valuesToAdd = new ArrayList(values);
        valuesToAdd.removeAll(secondaryValues);
        this.getDelegate().setValues(frame, slot, facet, isTemplate, valuesToAdd);
    }

    public Set getFrames(Slot slot, Facet facet, boolean isTemplate, Object value) {
        HashSet<Frame> frames = new HashSet<Frame>();
        for (NarrowFrameStore fs : this.availableFrameStores) {
            frames.addAll(fs.getFrames(slot, facet, isTemplate, value));
        }
        return frames;
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean isTemplate) {
        HashSet<Frame> frames = new HashSet<Frame>();
        for (NarrowFrameStore fs : this.availableFrameStores) {
            frames.addAll(fs.getFramesWithAnyValue(slot, facet, isTemplate));
        }
        return frames;
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) {
        HashSet<Frame> frames = new HashSet<Frame>();
        Iterator<NarrowFrameStore> i = this.availableFrameStores.iterator();
        while (i.hasNext() && !MergingNarrowFrameStore.hasEnoughMatches(frames.size(), maxMatches)) {
            NarrowFrameStore fs = i.next();
            frames.addAll(fs.getMatchingFrames(slot, facet, isTemplate, value, maxMatches - frames.size()));
        }
        return frames;
    }

    private static boolean hasEnoughMatches(int size, int limit) {
        return limit != -1 && size >= limit;
    }

    @Override
    public Set<Reference> getReferences(Object value) {
        HashSet<Reference> references = new HashSet<Reference>();
        for (NarrowFrameStore fs : this.availableFrameStores) {
            references.addAll(fs.getReferences(value));
        }
        return references;
    }

    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches) {
        HashSet<Reference> references = new HashSet<Reference>();
        Iterator<NarrowFrameStore> i = this.availableFrameStores.iterator();
        while (i.hasNext() && !MergingNarrowFrameStore.hasEnoughMatches(references.size(), maxMatches)) {
            NarrowFrameStore fs = i.next();
            references.addAll(fs.getMatchingReferences(value, maxMatches - references.size()));
        }
        return references;
    }

    @Override
    public void executeQuery(final Query query, final QueryCallback callback) {
        new Thread(){

            public void run() {
                try {
                    SynchronizeQueryCallback sync = new SynchronizeQueryCallback(MergingNarrowFrameStore.this.kbLock);
                    HashSet<Frame> results = new HashSet<Frame>();
                    for (NarrowFrameStore fs : MergingNarrowFrameStore.this.availableFrameStores) {
                        fs.executeQuery(query, sync);
                        results.addAll(sync.waitForResults());
                    }
                    callback.provideQueryResults(results);
                }
                catch (OntologyException oe) {
                    callback.handleError(oe);
                }
                catch (ProtegeIOException ioe) {
                    callback.handleError(ioe);
                }
                catch (Throwable t) {
                    Log.getLogger().log(Level.WARNING, "Exception found during query", t);
                    callback.handleError(new ProtegeError(t));
                }
            }
        };
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        HashSet frames = new HashSet();
        for (NarrowFrameStore fs : this.availableFrameStores) {
            frames.addAll(fs.getClosure(frame, slot, facet, isTemplate));
        }
        return frames;
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.getDelegate().deleteFrame(frame);
    }

    @Override
    public void close() {
        for (NarrowFrameStore fs : this.availableFrameStores) {
            fs.close();
        }
        this.availableFrameStores.clear();
    }

    @Override
    public void replaceFrame(Frame frame) {
        for (NarrowFrameStore narrowFrameStore : this.getAllFrameStores()) {
            narrowFrameStore.replaceFrame(frame);
        }
    }

    @Override
    public boolean beginTransaction(String name) {
        return this.getDelegate().beginTransaction(name);
    }

    @Override
    public boolean commitTransaction() {
        return this.getDelegate().commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        return this.getDelegate().rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.getDelegate().getTransactionStatusMonitor();
    }

    @Override
    public void reinitialize() {
        for (NarrowFrameStore nfs : this.availableFrameStores) {
            nfs.reinitialize();
        }
    }

    @Override
    public boolean setCaching(RemoteSession session, boolean doCache) {
        boolean ret = false;
        for (NarrowFrameStore nfs : this.availableFrameStores) {
            ret |= nfs.setCaching(session, doCache);
        }
        return ret;
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        for (NarrowFrameStore nfs : this.availableFrameStores) {
            nfs.replaceFrame(original, replacement);
        }
    }
}

